/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.FeatureDescriptor;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TagLibraryCookie;
import org.netbeans.modules.web.taglibed.control.TldActionSupport;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.netbeans.modules.web.taglibed.view.TLDNode;
import org.netbeans.modules.web.taglibed.view.TaglibPanel;
import org.netbeans.modules.web.taglibed.view.TldCustomizer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TaglibCustomizer
extends TldCustomizer {
    TaglibPanel taglibPanel;
    private TagLibraryInfoData theTaglib;
    private TLDDataObject tldDo;
    static TaglibCustomizer sharedCustomizer;
    private static final boolean debug = false;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDLoader;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$control$TldActionSupport;

    public TaglibCustomizer(String title, Component component, boolean global, boolean isModal, int isCustomizerOrAddDialog) {
        super(title, component, global, isModal, isCustomizerOrAddDialog);
        this.taglibPanel = (TaglibPanel)component;
        this.initWindowListener();
    }

    public static TaglibCustomizer createCustomizerDialog(String title, TLDDataObject tldDo, TagLibraryInfoData taglib, boolean global, boolean modal) {
        if (taglib != null) {
            if (title == null) {
                title = IDEHelper.getString("TLD_TaglibCustomizer.title", taglib.getShortName());
            }
            TaglibPanel panel = new TaglibPanel(taglib);
            TaglibCustomizer cust = new TaglibCustomizer(title, panel, global, modal, 0);
            cust.taglibPanel.load(tldDo, taglib);
            cust.previousChangesDiscarded = false;
            cust.theTaglib = taglib;
            cust.tldDo = tldDo;
            ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TaglibCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader));
            Dialog dialog = cust.getDialog();
            dialog.getAccessibleContext().setAccessibleDescription(resBundle.getString("ACS_TLD_TaglibPanel.DialogA11yDesc"));
            dialog.getAccessibleContext().setAccessibleName(resBundle.getString("ACS_TLD_TaglibPanel.DialogA11yName"));
            return cust;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        String helpID = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TaglibCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TaglibCustomizer.Help_ID");
        return new HelpCtx(helpID);
    }

    void initWindowListener() {
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TaglibCustomizer.this.ensureNoUnappliedChanges();
                TaglibCustomizer.this.taglibPanel.unload();
                ((Component)TaglibCustomizer.this.dialog).setVisible(false);
                TaglibCustomizer.this.dialog.dispose();
            }

            public void windowClosed(WindowEvent e) {
                if (TaglibCustomizer.this.global) {
                    sharedCustomizer = null;
                }
            }
        });
    }

    public boolean load(TldActionSupport cookie, Node n) {
        if (cookie != null && cookie.getType() == 0) {
            TagLibraryInfoData newTaglib = cookie.getTaglib();
            TLDDataObject newTldDo = cookie.getTLDDataObject();
            if (this.theTaglib != newTaglib && (this.previousChangesDiscarded || this.ensureNoUnappliedChanges(this.theTaglib))) {
                this.taglibPanel.load(newTldDo, newTaglib);
                this.previousChangesDiscarded = false;
                this.theTaglib = newTaglib;
                this.tldDo = newTldDo;
                TLDNode tldn = cookie.getTldNode();
                if (tldn != null) {
                    this.updateTitle(tldn);
                } else {
                    this.updateTitle();
                }
            }
            return true;
        }
        return false;
    }

    public boolean ensureNoUnappliedChanges() {
        return this.ensureNoUnappliedChanges(this.theTaglib);
    }

    public boolean ensureNoUnappliedChanges(TagLibraryInfoData theTaglib) {
        Vector unappliedChangeList = this.taglibPanel.getUnappliedChangeList(theTaglib);
        if (unappliedChangeList == null) {
            return true;
        }
        String name = theTaglib.getShortName();
        String title = IDEHelper.getString("TLD_TaglibCustomizer.Apply_or_discard_title", name);
        String preamble = IDEHelper.getString("TLD_TaglibCustomizer.Apply_or_discard_preamble", name);
        boolean applyUnappliedChanges = IDEHelper.askWhetherToApplyUnappliedChanges(unappliedChangeList, preamble, title);
        if (applyUnappliedChanges) {
            if (this.validate()) {
                this.taglibPanel.apply();
                return true;
            }
            this.bringUpStaticCustomizer(theTaglib);
            return true;
        }
        this.previousChangesDiscarded = true;
        return true;
    }

    public void bringUpStaticCustomizer(TagLibraryInfoData taglib) {
        String title = IDEHelper.getString("TLD_TaglibCustomizer.UnappliedChange_Invalid_Title", taglib.getShortName());
        boolean isModal = true;
        boolean isGlobal = false;
        TaglibCustomizer staticCustomizer = TaglibCustomizer.createCustomizerDialog(title, this.tldDo, taglib, isGlobal, isModal);
        this.taglibPanel.transferValuesTo((TaglibPanel)staticCustomizer.getComponent());
        staticCustomizer.open(isModal);
    }

    public static TaglibCustomizer getDefault(TagLibraryCookie cookie) {
        TaglibCustomizer sharedCustomizer = TaglibCustomizer.getDefault(cookie.getTLDDataObject(), cookie.getTaglib());
        TLDNode n = ((TldActionSupport)cookie).getTldNode();
        if (n != null) {
            sharedCustomizer.updateTitle(n);
        } else {
            sharedCustomizer.updateTitle();
        }
        return sharedCustomizer;
    }

    public static TaglibCustomizer getDefault(TLDDataObject tldDo, TagLibraryInfoData taglib) {
        if (sharedCustomizer == null) {
            boolean global = true;
            boolean modal = false;
            sharedCustomizer = TaglibCustomizer.createCustomizerDialog(null, tldDo, taglib, global, modal);
        }
        TaglibPanel p = (TaglibPanel)sharedCustomizer.getComponent();
        TaglibCustomizer.sharedCustomizer.theTaglib = taglib;
        TaglibCustomizer.sharedCustomizer.tldDo = tldDo;
        p.load(tldDo, TaglibCustomizer.sharedCustomizer.theTaglib);
        TaglibCustomizer.sharedCustomizer.previousChangesDiscarded = false;
        sharedCustomizer.updateTitle(taglib);
        return sharedCustomizer;
    }

    private void updateTitle(TLDNode node) {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TaglibCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TaglibCustomizer.title"));
        if (node != null) {
            Object[] obj = new Object[]{((FeatureDescriptor)((Object)node)).getName()};
            this.dialog.setTitle(msgFormat.format(obj));
        }
    }

    private void updateTitle(TagLibraryInfoData taglib) {
        String title = IDEHelper.getString("TLD_TaglibCustomizer.title", taglib.getShortName());
        this.dialog.setTitle(title);
    }

    private void updateTitle() {
        MessageFormat msgFormat = new MessageFormat(NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDLoader == null ? (class$org$netbeans$modules$web$taglibed$TLDLoader = TaglibCustomizer.class$("org.netbeans.modules.web.taglibed.TLDLoader")) : class$org$netbeans$modules$web$taglibed$TLDLoader)).getString("TLD_TaglibCustomizer.title"));
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes != null && nodes.length > 0) {
            int i = 0;
            while (i < nodes.length) {
                TldActionSupport cookie = (TldActionSupport)nodes[i].getCookie(class$org$netbeans$modules$web$taglibed$control$TldActionSupport == null ? TaglibCustomizer.class$("org.netbeans.modules.web.taglibed.control.TldActionSupport") : class$org$netbeans$modules$web$taglibed$control$TldActionSupport);
                if (cookie != null && cookie.getType() == 0) {
                    Object[] obj = new Object[]{nodes[i].getName()};
                    this.dialog.setTitle(msgFormat.format(obj));
                    break;
                }
                ++i;
            }
        }
    }

    protected boolean validate() {
        TaglibPanel p = (TaglibPanel)this.getComponent();
        return p.validateProperties();
    }

    protected void notifyClosing() {
        if (this.global) {
            TaglibPanel p = (TaglibPanel)sharedCustomizer.getComponent();
            p.removePropertyChangeListener();
            this.removePropertyChangeListener();
            p.unload();
            sharedCustomizer = null;
        }
    }

    protected void createObject() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

