/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglibed.view;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.context.WebContextObject;
import org.netbeans.modules.web.context.WebInfObject;
import org.netbeans.modules.web.taglibed.TLDDataObject;
import org.netbeans.modules.web.taglibed.control.IDEHelper;
import org.netbeans.modules.web.taglibed.control.TaglibSupport;
import org.netbeans.modules.web.taglibed.model.TagLibraryInfoData;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public final class TaglibWizardIterator
implements TemplateWizard.Iterator {
    private static TaglibWizardIterator singletonInstance;
    private transient TemplateWizard templateWizard = null;
    private transient String[] panelNames = null;
    private ResourceBundle resBundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$web$taglibed$TLDDataObject == null ? (class$org$netbeans$modules$web$taglibed$TLDDataObject = TaglibWizardIterator.class$("org.netbeans.modules.web.taglibed.TLDDataObject")) : class$org$netbeans$modules$web$taglibed$TLDDataObject));
    private static final boolean debug = false;
    private WizardDescriptor.ArrayIterator arrayIterator = null;
    private String defaultTagLibraryName = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$taglibed$TLDDataObject;

    private TaglibWizardIterator() {
    }

    public void initialize(TemplateWizard tw) {
        this.templateWizard = tw;
        if (this.defaultTagLibraryName == null) {
            this.defaultTagLibraryName = IDEHelper.getString("TLDValidation_DefaultTagLibraryName");
        }
        if (this.arrayIterator == null) {
            this.initializePanelNames();
            WizardDescriptor.Panel targetChooser = this.templateWizard.targetChooser();
            Component panel = targetChooser.getComponent();
            if (panel instanceof JComponent) {
                ((JComponent)panel).putClientProperty("WizardPanel_contentData", this.panelNames);
            }
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{targetChooser};
            this.arrayIterator = new WizardDescriptor.ArrayIterator(panelArray);
        }
    }

    public void uninitialize(TemplateWizard tw) {
        this.templateWizard = null;
        this.arrayIterator = null;
    }

    public void initializePanelNames() {
        if (this.panelNames == null) {
            this.panelNames = new String[1];
            this.panelNames[0] = this.resBundle.getString("CTL_NewTaglibWizardPanel.ChooseTarget");
        }
    }

    public WizardDescriptor.Panel current() {
        return this.arrayIterator.current();
    }

    public boolean hasNext() {
        return this.arrayIterator.hasNext();
    }

    public boolean hasPrevious() {
        return this.arrayIterator.hasNext();
    }

    public synchronized void nextPanel() {
        this.arrayIterator.nextPanel();
    }

    public synchronized void previousPanel() {
        this.arrayIterator.previousPanel();
    }

    public void addChangeListener(ChangeListener l) {
        this.arrayIterator.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.arrayIterator.removeChangeListener(l);
    }

    public String name() {
        return this.resBundle.getString("NewTaglibWizardPanel.Title");
    }

    public boolean validateDocumentPath(String documentBasePath) {
        File file = new File(documentBasePath);
        if (file.exists()) {
            if (file.isDirectory()) {
                return true;
            }
            Object[] args = new Object[]{documentBasePath};
            String key = "MSG_NewTaglibWizard.InvalidMountDirectory";
            IDEHelper.showErrorMessageI18N(key, args, "NewTaglibWizard.ErrDialogTitle");
            return false;
        }
        boolean success = file.mkdirs();
        if (success) {
            return true;
        }
        Object[] args = new Object[]{documentBasePath};
        String key = "MSG_NewTaglibWizard.InvalidMountDirectory";
        IDEHelper.showErrorMessageI18N(key, args, "NewTaglibWizard.ErrDialogTitle");
        return false;
    }

    public Set instantiate(TemplateWizard wiz) throws IOException {
        String documentBasePath;
        boolean validName;
        DataFolder targetFolder = wiz.getTargetFolder();
        String targetName = wiz.getTargetName();
        if (targetName == null || targetName.equals("")) {
            targetName = this.defaultTagLibraryName;
        }
        if (!(validName = IDEHelper.validateTaglibName(targetName))) {
            if ((targetName = IDEHelper.stripJavaIdentifierInvalidChars(targetName)) == null) {
                IDEHelper.showWarningMessageI18N("MSG_NewTaglibWizard.InvalidTaglibName_AllCharsStripped");
                return Collections.singleton(null);
            }
            Object[] args = new Object[]{targetName};
            IDEHelper.showWarningMessageI18N("MSG_NewTaglibWizard.InvalidTaglibName_CharsStripped", args);
        }
        FileObject targetFolderFo = targetFolder.getPrimaryFile();
        targetName = TaglibSupport.ensureUniqueTagLibraryName(targetFolderFo, targetName);
        File targetFolderFile = targetFolderFo != null ? FileUtil.toFile((FileObject)targetFolderFo) : null;
        String string = documentBasePath = targetFolderFile != null ? targetFolderFile.getAbsolutePath() : null;
        if (documentBasePath == null || documentBasePath.length() <= 0) {
            FileSystem fs = targetFolderFo != null ? targetFolderFo.getFileSystem() : null;
            StringBuffer buf = new StringBuffer();
            if (fs != null) {
                buf.append(fs.getSystemName());
                buf.append("/");
            }
            buf.append(targetFolder.getName());
            Object[] args = new Object[]{buf.toString()};
            IDEHelper.showWarningMessageI18N("MSG_NewTaglibWizard.InvalidFilesystem", args);
            return Collections.singleton(null);
        }
        if (!this.validateDocumentPath(documentBasePath)) {
            return Collections.singleton(null);
        }
        DataObject obj = this.instantiateTemplate(wiz.getTemplate(), wiz.getTargetFolder(), targetName);
        TLDDataObject tldObj = (TLDDataObject)obj;
        TagLibraryInfoData taglib = tldObj.getTaglib();
        this.setTaglibDefaults(taglib, targetName, targetFolder);
        return Collections.singleton(obj);
    }

    public void setTaglibDefaults(TagLibraryInfoData taglib, String targetName, DataFolder targetFolder) {
        FileObject targetFo;
        if (taglib != null) {
            taglib.setShortName(targetName);
        }
        if (this.isWebModule(targetFo = targetFolder.getPrimaryFile())) {
            taglib.setTagHandlerGenerationRoot("WEB-INF/classes");
        } else if (this.isWebInf(targetFo)) {
            taglib.setTagHandlerGenerationRoot("classes");
        }
    }

    private boolean isWebModule(FileObject fo) {
        if (fo == null) {
            return false;
        }
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            if (dob instanceof WebContextObject) {
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private boolean isWebInf(FileObject fo) {
        if (fo == null) {
            return false;
        }
        try {
            DataObject dob = DataObject.find((FileObject)fo);
            if (dob instanceof WebInfObject) {
                return true;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private DataObject instantiateTemplate(DataObject tpl, DataFolder target, String name) throws IOException {
        return tpl.createFromTemplate(target, name);
    }

    public static TaglibWizardIterator singleton() {
        if (singletonInstance == null) {
            singletonInstance = new TaglibWizardIterator();
        }
        return singletonInstance;
    }

    public Object readResolve() throws ObjectStreamException {
        return TaglibWizardIterator.singleton();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

