/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.runtime;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.TldLocationsCache;

public class IDEEmbeddedOptions
implements Options {
    Options delegate;
    File scratchDir;

    public IDEEmbeddedOptions(Options delegate, ServletContext ctx) throws IOException {
        this.delegate = delegate;
        File scratchDel = delegate.getScratchDir();
        String path = scratchDel.getCanonicalPath();
        int ind = path.lastIndexOf(File.separatorChar);
        path = ind == -1 ? path + File.separator : path.substring(0, ind + 1);
        String realPath = ctx.getRealPath("/");
        if (realPath != null) {
            realPath = IDEEmbeddedOptions.mangleFullContextPath(realPath);
            path = path + realPath;
            this.scratchDir = new File(path);
        }
    }

    private static String mangleFullContextPath(String realPath) throws IOException {
        if (realPath == null) {
            throw new IllegalArgumentException();
        }
        realPath = new File(realPath).getCanonicalPath();
        realPath = URLEncoder.encode(realPath);
        if ((realPath = realPath.replace('%', '_')).length() > 100) {
            realPath = "" + realPath.hashCode();
        }
        return realPath;
    }

    public String getClassPath() {
        return this.delegate.getClassPath();
    }

    public String getIeClassId() {
        return this.delegate.getIeClassId();
    }

    public String getJavaEncoding() {
        return this.delegate.getJavaEncoding();
    }

    public String getJspCompilerPath() {
        return this.delegate.getJspCompilerPath();
    }

    public Class getJspCompilerPlugin() {
        return this.delegate.getJspCompilerPlugin();
    }

    public boolean getKeepGenerated() {
        return this.delegate.getKeepGenerated();
    }

    public boolean getLargeFile() {
        return this.delegate.getLargeFile();
    }

    public boolean getMappedFile() {
        return this.delegate.getMappedFile();
    }

    public File getScratchDir() {
        return this.scratchDir == null ? this.delegate.getScratchDir() : this.scratchDir;
    }

    public boolean getSendErrorToClient() {
        return this.delegate.getSendErrorToClient();
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.delegate.getTldLocationsCache();
    }

    public boolean getClassDebugInfo() {
        return true;
    }
}

