/*
 * Decompiled with CFR 0.152.
 */
package org.openide.debugger;

import java.util.Collections;
import java.util.Enumeration;
import org.openide.ServiceType;
import org.openide.cookies.ArgumentsCookie;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.execution.ExecInfo;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class DebuggerType
extends ServiceType {
    static final long serialVersionUID = -3659300496270314301L;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;
    static /* synthetic */ Class class$org$openide$ServiceType$Registry;

    public abstract void startDebugger(ExecInfo var1, boolean var2) throws DebuggerException;

    public void startDebugger(DataObject obj, boolean stopOnMain) throws DebuggerException {
        ArgumentsCookie ac = (ArgumentsCookie)obj.getCookie(this.getKlass("org.openide.cookies.ArgumentsCookie"));
        String[] params = ac != null ? ac.getArguments() : new String[]{};
        this.startDebugger(new ExecInfo(obj.getPrimaryFile().getPackageName('.'), params), stopOnMain);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = DebuggerType.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType);
    }

    public static Enumeration debuggerTypes() {
        return Collections.enumeration(Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = DebuggerType.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType)).allInstances());
    }

    public static DebuggerType find(Class clazz) {
        return (DebuggerType)((Object)Lookup.getDefault().lookup(clazz));
    }

    public static DebuggerType find(String name) {
        ServiceType.Registry r = (ServiceType.Registry)Lookup.getDefault().lookup(class$org$openide$ServiceType$Registry == null ? (class$org$openide$ServiceType$Registry = DebuggerType.class$("org.openide.ServiceType$Registry")) : class$org$openide$ServiceType$Registry);
        ServiceType t = r.find(name);
        if (t instanceof DebuggerType) {
            return (DebuggerType)t;
        }
        return null;
    }

    public static DebuggerType getDefault() {
        Enumeration en = DebuggerType.debuggerTypes();
        if (en.hasMoreElements()) {
            return (DebuggerType)((Object)en.nextElement());
        }
        return new Default();
    }

    private final Class getKlass(String name) {
        try {
            return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getLocalizedMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Default
    extends DebuggerType {
        static final long serialVersionUID = 6286540187114472027L;
        static /* synthetic */ Class class$org$openide$debugger$DebuggerType$Default;
        static /* synthetic */ Class class$org$openide$debugger$Debugger;

        public String displayName() {
            return NbBundle.getBundle((Class)(class$org$openide$debugger$DebuggerType$Default == null ? (class$org$openide$debugger$DebuggerType$Default = Default.class$("org.openide.debugger.DebuggerType$Default")) : class$org$openide$debugger$DebuggerType$Default)).getString("LAB_DefaultDebuggerType");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$debugger$DebuggerType$Default == null ? (class$org$openide$debugger$DebuggerType$Default = Default.class$("org.openide.debugger.DebuggerType$Default")) : class$org$openide$debugger$DebuggerType$Default);
        }

        public void startDebugger(ExecInfo info, boolean stopOnMain) throws DebuggerException {
            Debugger d = (Debugger)Lookup.getDefault().lookup(class$org$openide$debugger$Debugger == null ? (class$org$openide$debugger$Debugger = Default.class$("org.openide.debugger.Debugger")) : class$org$openide$debugger$Debugger);
            if (stopOnMain) {
                d.startDebugger(new DebuggerInfo(info.getClassName(), info.getArguments()));
            } else {
                d.startDebugger(new DebuggerInfo(info.getClassName(), info.getArguments(), null));
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

