/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.openide.ServiceType;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.cookies.DebuggerCookie;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerType;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class ExecSupport
extends ExecutionSupport
implements DebuggerCookie {
    private static final String EA_DEBUGGER_TYPE = "NetBeansAttrDebuggerType";
    public static final String PROP_DEBUGGER_TYPE = "debuggerType";
    protected MultiDataObject.Entry entry;
    protected boolean isReadOnly;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$org$openide$debugger$DebuggerType;

    public ExecSupport(MultiDataObject.Entry entry) {
        super(entry);
        this.entry = entry;
        Boolean ro = (Boolean)entry.getFile().getAttribute("readOnlyAttrs");
        this.isReadOnly = ro == null ? false : ro == false;
    }

    public void debug(final boolean stopOnMain) throws DebuggerException {
        DebuggerType t = ExecSupport.getDebuggerType(this.entry);
        if (t == null) {
            t = this.defaultDebuggerType();
        }
        try {
            t.startDebugger((DataObject)this.entry.getDataObject(), stopOnMain);
            return;
        }
        catch (DebuggerException ex) {
            try {
                Mutex.EVENT.readAccess(new Mutex.ExceptionAction(){

                    public Object run() throws DebuggerException {
                        if (ExecSupport.this.debugFailed(ex)) {
                            ExecSupport.this.debug(stopOnMain);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException mx) {
                if (mx.getException() instanceof DebuggerException) {
                    throw (DebuggerException)mx.getException();
                }
                throw new DebuggerException(mx.getException());
            }
            return;
        }
    }

    protected boolean checkCompiled() {
        MultiDataObject obj = this.entry.getDataObject();
        CompilerCookie c = (CompilerCookie)obj.getCookie(class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ExecSupport.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie);
        if (c != null) {
            CompilerJob job = new CompilerJob(Compiler.DEPTH_ZERO);
            job.setDisplayName(obj.getName());
            c.addToJob(job, Compiler.DEPTH_ZERO);
            if (!job.isUpToDate()) {
                CompilerTask t = job.start();
                return t.isSuccessful();
            }
        }
        return true;
    }

    protected boolean debugFailed(DebuggerException ex) {
        DebuggerType e;
        DebuggerType orig = ExecSupport.getDebuggerType(this.entry);
        if (orig == null) {
            orig = this.defaultDebuggerType();
        }
        if ((e = (DebuggerType)ExecutionSupport.choose((ServiceType)orig, (Class)(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType), (Exception)ex)) == null) {
            return false;
        }
        try {
            ExecSupport.setDebuggerType(this.entry, e);
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    protected DebuggerType defaultDebuggerType() {
        return DebuggerType.getDefault();
    }

    public static void setDebuggerType(MultiDataObject.Entry entry, DebuggerType type) throws IOException {
        entry.getFile().setAttribute(EA_DEBUGGER_TYPE, (Object)(type == null ? null : new ServiceType.Handle((ServiceType)type)));
    }

    public static DebuggerType getDebuggerType(MultiDataObject.Entry entry) {
        ServiceType dbg;
        Object handle = entry.getFile().getAttribute(EA_DEBUGGER_TYPE);
        if (handle != null && handle instanceof ServiceType.Handle && (dbg = ((ServiceType.Handle)handle).getServiceType()) instanceof DebuggerType) {
            return (DebuggerType)dbg;
        }
        Lookup l = Environment.find((DataObject)entry.getDataObject());
        DebuggerType dt = (DebuggerType)((Object)l.lookup(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType));
        if (dt != null) {
            return dt;
        }
        return null;
    }

    public void addProperties(Sheet.Set set) {
        super.addProperties(set);
        set.put((Node.Property)this.createDebuggerProperty());
    }

    private PropertySupport createDebuggerProperty() {
        return new PropertySupport.ReadWrite(PROP_DEBUGGER_TYPE, class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType, NbBundle.getMessage((Class)(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType), (String)"PROP_debuggerType"), NbBundle.getMessage((Class)(class$org$openide$debugger$DebuggerType == null ? (class$org$openide$debugger$DebuggerType = ExecSupport.class$("org.openide.debugger.DebuggerType")) : class$org$openide$debugger$DebuggerType), (String)"HINT_debuggerType")){

            public Object getValue() {
                DebuggerType dt = ExecSupport.getDebuggerType(ExecSupport.this.entry);
                if (dt == null) {
                    return ExecSupport.this.defaultDebuggerType();
                }
                return dt;
            }

            public void setValue(Object val) throws InvocationTargetException {
                try {
                    ExecSupport.setDebuggerType(ExecSupport.this.entry, (DebuggerType)((Object)val));
                }
                catch (IOException ex) {
                    throw new InvocationTargetException(ex);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                Boolean isReadOnly = (Boolean)ExecSupport.this.entry.getFile().getAttribute("readOnlyAttrs");
                return isReadOnly == null ? false : isReadOnly == false;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

