/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.io.SyncFailedException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.j2ee.impl.ExecPerformersStorage;
import org.netbeans.modules.j2ee.impl.ServerChangeSupport;
import org.netbeans.modules.j2ee.impl.ServerExecutor;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.Progress;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.AppChangeListener;
import org.netbeans.modules.j2ee.server.datamodel.ModuleChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.ModuleStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.WebChangeListener;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.tomcat.tomcat40.ServerOutputImpl;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40DataObject;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40ExecPerformer;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40WebServer;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Host;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.dd.DDDataObject;
import org.netbeans.modules.web.dd.model.WebApp;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.execution.ProcessExecutor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.Node;
import org.openide.util.HttpServer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Tomcat40Installation
implements Node.Cookie,
WebChangeListener,
AppChangeListener,
PropertyChangeListener {
    public static final int PRECONFIG_TOMCAT406 = 1;
    public static final int PRECONFIG_JWSDP10x = 2;
    private static final String TOMCAT_CONF_DIR = "conf";
    private static final String TOMCAT_WORK_DIR = "work";
    private static final String TOMCAT_TEMP_DIR = "temp";
    private static final String TOMCAT_WEBAPPS_DIR = "webapps";
    private static final String TOMCAT_SERVER_DIR = "server";
    private static final String TOMCAT_MANAGER_DIR = "manager";
    private static final String TOMCAT_ROOT_DIR = "ROOT";
    private static final String TOMCAT_WEBDAV_DIR = "webdav";
    private static final String TOMCAT_LOGS_DIR = "logs";
    private static final String WEB_INF_DIR = "WEB-INF";
    private static final String DEFAULT_SERVER_XML = "nbresloc:/org/netbeans/modules/tomcat/tomcat40/resources/default_server.xml";
    private static final String DEFAULT_WEB_XML = "nbresloc:/org/netbeans/modules/tomcat/tomcat40/resources/default_web.xml";
    private static final String MANAGER_WEB_XML = "nbresloc:/org/netbeans/modules/tomcat/tomcat40/resources/manager_web.xml";
    private static final String README_BASE_FILE_TOMCAT = "nbresloc:/org/netbeans/modules/tomcat/tomcat40/resources/IDE-README.txt";
    private static final String README_BASE_FILE_JWSDP = "nbresloc:/org/netbeans/modules/tomcat/tomcat40/resources/IDE-README-JWSDP.txt";
    private static final String SERVER_XML_NAME = "server";
    private static final String XML_EXT = "xml";
    private static final String SERVER_XML_NAME_EXT = "server.xml";
    private static Tomcat40Installation[] internalInstallations;
    private int installationType = 0;
    private FileSystem homeFileSystem;
    private FileSystem baseFileSystem;
    private File homeDir;
    private File baseDir;
    private Tomcat40DataObject tomcatDO;
    private List instances = new ArrayList(5);
    private ServerChangeSupport serverChangeSupport;
    private WebAppStandardData webApplication = null;
    private ServerStatus status = ServerStatus.STATUS_STOPPED;
    private List listenerList = new ArrayList(10);
    private static final int ABOUT_10_SECONDS = 14;
    private static final String DUMMY_RESOURCE = "/SOMENONSENSE_NONEXISTING_URL/xxxyyyzzz.nonexistingextension";
    private Phase lastPhase = new Phase();
    private Phase futurePhase = new Phase();
    private boolean restart = false;
    private Process tomcatProcess;
    private WaitingThread tomcatThread;
    private ServerOutput[] serverOutput;
    private Progress progressObject = null;
    private static final int PROGRESS_PROCESS_START = 0;
    private static final int PROGRESS_CONF_FILES = 1;
    private static final int PROGRESS_SERVER_STOPPING = 2;
    private static final int PROGRESS_SERVER_STARTING = 3;
    private static final int PROGRESS_SERVER_RUNS_OK = 4;
    private static final int PROGRESS_SERVER_RUNS_KO = 5;
    static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation;
    static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$Tomcat40DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$j2ee$server$datamodel$WebStandardData$WebDDData;

    private Tomcat40Installation(int installationType) {
        this.installationType = installationType;
        this.homeDir = Tomcat40Installation.getHomeInternalDir(installationType);
        this.baseDir = Tomcat40Installation.getBaseInternalDir(installationType);
    }

    protected Tomcat40Installation(File homeDirectory, File baseDirectory) {
        this.installationType = 0;
        this.homeDir = homeDirectory;
        this.baseDir = baseDirectory == null ? this.homeDir : baseDirectory;
    }

    private static File getHomeInternalDir(int installationType) {
        String homeDir;
        if (installationType == 1) {
            homeDir = "tomcat406";
        } else if (installationType == 2) {
            homeDir = "jwsdp";
        } else {
            throw new IllegalArgumentException("" + installationType);
        }
        File ret = InstalledFileLocator.getDefault().locate(homeDir + "/bin", null, false);
        return ret == null ? null : ret.getParentFile();
    }

    private static File getBaseInternalDir(int installationType) {
        String baseDir;
        if (installationType == 1) {
            baseDir = "tomcat406_base";
        } else if (installationType == 2) {
            baseDir = "jwsdp_base";
        } else {
            throw new IllegalArgumentException("" + installationType);
        }
        return new File(System.getProperty("netbeans.user") + System.getProperty("file.separator") + baseDir);
    }

    public FileSystem getHomeFileSystem() {
        return this.homeFileSystem;
    }

    public FileSystem getBaseFileSystem() {
        return this.baseFileSystem;
    }

    public String getDisplayName() {
        return this.getTomcatDataObject().getInstallationNodeShortName();
    }

    protected boolean getInternal() {
        return this.installationType != 0;
    }

    public boolean isInternalJWSDP() {
        return this.installationType == 2;
    }

    public File getHomeDirectory() {
        return this.homeDir;
    }

    public File getBaseDirectory() {
        return this.baseDir;
    }

    public Tomcat40DataObject getTomcatDataObject() {
        if (this.tomcatDO == null) {
            try {
                FileSystem fs;
                FileObject fo;
                TomcatFileSystem localFileSystem;
                Repository rep = Repository.getDefault();
                if (this.baseDir == null) {
                    this.homeFileSystem = Tomcat40Installation.findFileSystem(rep, this.homeDir);
                    if (this.homeFileSystem == null) {
                        localFileSystem = new TomcatFileSystem();
                        localFileSystem.setRootDirectory(this.homeDir);
                        localFileSystem.setHidden(true);
                        rep.addFileSystem((FileSystem)localFileSystem);
                        this.homeFileSystem = localFileSystem;
                    }
                } else {
                    this.baseFileSystem = Tomcat40Installation.findFileSystem(rep, this.baseDir);
                    if (this.baseFileSystem == null) {
                        localFileSystem = new TomcatFileSystem();
                        localFileSystem.setRootDirectory(this.baseDir);
                        localFileSystem.setHidden(true);
                        rep.addFileSystem((FileSystem)localFileSystem);
                        this.baseFileSystem = localFileSystem;
                    }
                }
                if ((fo = (fs = this.baseDir == null ? this.homeFileSystem : this.baseFileSystem).find(TOMCAT_CONF_DIR, "server", XML_EXT)) == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation), (String)"MSG_cannotFindServer.xml", (Object)fs.getDisplayName()), 0));
                    return null;
                }
                this.tomcatDO = this.findTomcatDataObject(fo);
                if (this.tomcatDO != null) {
                    ExecPerformersStorage performersStorage;
                    Class oldKey;
                    this.tomcatDO.addPropertyChangeListener(this);
                    if (this.instances.size() == 0) {
                        this.tomcatDO.addCookie(this);
                        this.updateInstances();
                    }
                    if (this.getInternal() && (oldKey = (performersStorage = ServerExecutor.getPerformersStorage()).getFactoryKey(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40DataObject == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40DataObject = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40DataObject")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40DataObject)) != null) {
                        performersStorage.removeFactory(oldKey);
                        performersStorage.addFactory(((Object)((Object)this.tomcatDO)).getClass(), Tomcat40ExecPerformer.Factory.getTomcatFactory(null, null));
                    }
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
        return this.tomcatDO;
    }

    private Tomcat40DataObject findTomcatDataObject(FileObject fo) throws DataObjectNotFoundException, IOException {
        DataObject dobj = DataObject.find((FileObject)fo);
        if (dobj instanceof Tomcat40DataObject) {
            return (Tomcat40DataObject)dobj;
        }
        if (dobj != null) {
            try {
                dobj.setValid(false);
            }
            catch (PropertyVetoException ve) {
                // empty catch block
            }
            dobj = DataObject.find((FileObject)fo);
        }
        if (dobj instanceof Tomcat40DataObject) {
            return (Tomcat40DataObject)dobj;
        }
        final String fsName = fo.getFileSystem().getDisplayName();
        RequestProcessor.getDefault().post(new Runnable(){
            static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation;

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = 1.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation), (String)"MSG_cannotRecognizeServer.xml", (Object)fsName), 0));
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        return null;
    }

    static FileSystem findFileSystem(Repository rep, File file) {
        String fileName = file.getAbsolutePath();
        Enumeration e = rep.getFileSystems();
        while (e.hasMoreElements()) {
            String fsFileName;
            FileSystem fs = (FileSystem)e.nextElement();
            File fsFile = NbClassPath.toFile((FileObject)fs.getRoot());
            if (fsFile == null || !fileName.equals(fsFileName = fsFile.getAbsolutePath())) continue;
            return fs;
        }
        return null;
    }

    public void updateInstances() {
        ArrayList oldInstances = new ArrayList();
        if (this.instances != null) {
            int i = 0;
            while (i < this.instances.size()) {
                oldInstances.add(this.instances.get(i));
                ++i;
            }
        }
        Host[] hosts = this.tomcatDO.getHosts();
        int i = 0;
        while (i < hosts.length) {
            Tomcat40Instance instance = new Tomcat40Instance(this, hosts[i]);
            boolean instanceExists = false;
            int j = 0;
            while (j < oldInstances.size()) {
                Tomcat40Instance oldInst = (Tomcat40Instance)oldInstances.get(j);
                if (oldInst.getID().equals(instance.getID())) {
                    oldInst.setHost(hosts[i]);
                    oldInstances.remove(oldInst);
                    instanceExists = true;
                    break;
                }
                ++j;
            }
            if (!instanceExists) {
                this.addServerInstance(instance);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < oldInstances.size()) {
            this.removeServerInstance((Tomcat40Instance)oldInstances.get(i2));
            ++i2;
        }
    }

    public Tomcat40Instance getInstance(String id) {
        this.getTomcatDataObject();
        Iterator i = this.instances.iterator();
        while (i.hasNext()) {
            Tomcat40Instance instance = (Tomcat40Instance)i.next();
            if (!instance.getID().equals(id)) continue;
            return instance;
        }
        return null;
    }

    public List getInstances() {
        this.getTomcatDataObject();
        return this.instances;
    }

    protected boolean addServerInstance(Tomcat40Instance si) {
        this.setRestart();
        return this.instances.add(si);
    }

    protected boolean removeServerInstance(Tomcat40Instance si) {
        this.setRestart();
        return this.instances.remove(si);
    }

    public static boolean sameAsOtherTomcatInstallation(File homeDir, File baseDir) {
        List installations = Tomcat40WebServer.getServer().getTomca40Installations();
        Iterator i = installations.iterator();
        while (i.hasNext()) {
            Tomcat40Installation installation = (Tomcat40Installation)i.next();
            File homeDirecotry = installation.getHomeDirectory();
            File baseDirecotry = installation.getBaseDirectory();
            if (!(homeDirecotry == null ? homeDir == null && (baseDirecotry == null ? baseDir == null : baseDirecotry.equals(baseDir)) : homeDirecotry.equals(homeDir) && (baseDirecotry == null ? baseDir == null : baseDirecotry.equals(baseDir)))) continue;
            return true;
        }
        return false;
    }

    public static boolean noBootStrapJar(File homeDir, File baseDir) {
        File[] subFolders = homeDir.listFiles();
        if (subFolders == null) {
            return true;
        }
        int i = 0;
        while (i < subFolders.length) {
            if (subFolders[i].getName().equals("bin") && subFolders[i].isDirectory()) {
                File[] subBinFolders = subFolders[i].listFiles();
                if (subBinFolders == null) {
                    return true;
                }
                int ii = 0;
                while (ii < subBinFolders.length) {
                    if (subBinFolders[ii].getName().equals("bootstrap.jar")) {
                        return false;
                    }
                    ++ii;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean noServerXML(File homeDir, File baseDir) {
        FileFilter filter;
        File testDir = baseDir != null ? baseDir : homeDir;
        File[] subFolders = testDir.listFiles(filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equals(Tomcat40Installation.TOMCAT_CONF_DIR);
            }
        });
        if (subFolders == null || subFolders.length == 0) {
            return true;
        }
        File[] serverFiles = subFolders[0].listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().equals(Tomcat40Installation.SERVER_XML_NAME_EXT);
            }
        });
        return serverFiles == null || serverFiles.length == 0;
    }

    public static boolean noTempDir(File homeDir) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equals(Tomcat40Installation.TOMCAT_TEMP_DIR);
            }
        };
        File[] subFolders = homeDir.listFiles(filter);
        return subFolders == null || subFolders.length == 0;
    }

    public static Tomcat40Installation createInternalInstallation(int installationType) {
        if (internalInstallations == null) {
            internalInstallations = new Tomcat40Installation[2];
        }
        if (internalInstallations[installationType - 1] == null) {
            if (Tomcat40Installation.noServerXML(Tomcat40Installation.getHomeInternalDir(installationType), Tomcat40Installation.getBaseInternalDir(installationType)) || Tomcat40Installation.noBootStrapJar(Tomcat40Installation.getHomeInternalDir(installationType), Tomcat40Installation.getBaseInternalDir(installationType))) {
                return null;
            }
            Tomcat40Installation.internalInstallations[installationType - 1] = new Tomcat40Installation(installationType);
        }
        return internalInstallations[installationType - 1];
    }

    public static Tomcat40Installation createExternalInstallation(File homeDir, File baseDir) {
        if (Tomcat40Installation.noServerXML(homeDir, baseDir) || Tomcat40Installation.noBootStrapJar(homeDir, baseDir)) {
            return null;
        }
        return new Tomcat40Installation(homeDir, baseDir);
    }

    public static void internalTomcatConfigurationFilesPreparing(int installationType) {
        File homeDir = Tomcat40Installation.getHomeInternalDir(installationType);
        if (homeDir != null && homeDir.exists() && homeDir.isDirectory()) {
            File baseDir = Tomcat40Installation.getBaseInternalDir(installationType);
            if (!baseDir.exists() ? !baseDir.mkdir() : !baseDir.isDirectory()) {
                return;
            }
            try {
                FileSystem homeFS = Tomcat40Installation.getHomeFS(homeDir);
                FileSystem baseFS = Tomcat40Installation.getBaseFS(baseDir);
                FileObject homeFSRoot = homeFS.getRoot();
                FileObject baseFSRoot = baseFS.getRoot();
                Tomcat40Installation.copyDir(homeFSRoot.getFileObject(TOMCAT_WORK_DIR), baseFSRoot, true, false);
                Tomcat40Installation.copyDir(homeFSRoot.getFileObject(TOMCAT_LOGS_DIR), baseFSRoot, true, false);
                Tomcat40Installation.copyDir(homeFSRoot.getFileObject(TOMCAT_CONF_DIR), baseFSRoot, true, false);
                FileObject sourceWebAppDir = homeFSRoot.getFileObject(TOMCAT_WEBAPPS_DIR);
                Tomcat40Installation.copyDir(sourceWebAppDir, baseFSRoot, true, false);
                FileObject targetWebAppDir = baseFSRoot.getFileObject(TOMCAT_WEBAPPS_DIR);
                if (installationType == 1) {
                    FileObject sourceManagerDir = sourceWebAppDir.getFileObject(TOMCAT_MANAGER_DIR);
                    Tomcat40Installation.copyDir(sourceManagerDir, targetWebAppDir, true, false);
                    FileObject sourceWebInfDir = sourceManagerDir.getFileObject(WEB_INF_DIR);
                    FileObject targetManagerDir = targetWebAppDir.getFileObject(TOMCAT_MANAGER_DIR);
                    Tomcat40Installation.copyDir(sourceWebInfDir, targetManagerDir, true, false);
                    Tomcat40Installation.copyDir(sourceWebAppDir.getFileObject(TOMCAT_ROOT_DIR), targetWebAppDir, false, false);
                    Tomcat40Installation.copyDir(sourceWebAppDir.getFileObject(TOMCAT_WEBDAV_DIR), targetWebAppDir, false, false);
                    FileObject targetConfDir = baseFSRoot.getFileObject(TOMCAT_CONF_DIR);
                    Tomcat40Installation.copyFileFromZip(DEFAULT_SERVER_XML, targetConfDir, "server", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(DEFAULT_WEB_XML, targetConfDir, "web", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(MANAGER_WEB_XML, targetWebAppDir.getFileObject(TOMCAT_MANAGER_DIR).getFileObject(WEB_INF_DIR), "web", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(README_BASE_FILE_TOMCAT, baseFSRoot, "IDE-README", "txt");
                } else {
                    FileObject[] files = sourceWebAppDir.getChildren();
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].isData() && Tomcat40Installation.shouldCopyWebAppFileJWSDP(files[i])) {
                            Tomcat40Installation.copyFile(files[i], targetWebAppDir);
                        }
                        ++i;
                    }
                    FileObject sourceServerDir = homeFSRoot.getFileObject("server");
                    FileObject sourceServerWebAppDir = sourceServerDir.getFileObject(TOMCAT_WEBAPPS_DIR);
                    FileObject sourceManagerDir = sourceServerWebAppDir.getFileObject(TOMCAT_MANAGER_DIR);
                    Tomcat40Installation.copyDir(sourceManagerDir, targetWebAppDir, true, false);
                    FileObject sourceWebInfDir = sourceManagerDir.getFileObject(WEB_INF_DIR);
                    FileObject targetManagerDir = targetWebAppDir.getFileObject(TOMCAT_MANAGER_DIR);
                    Tomcat40Installation.copyDir(sourceWebInfDir, targetManagerDir, true, false);
                    Tomcat40Installation.copyDir(sourceWebAppDir.getFileObject(TOMCAT_ROOT_DIR), targetWebAppDir, false, false);
                    FileObject targetConfDir = baseFSRoot.getFileObject(TOMCAT_CONF_DIR);
                    Tomcat40Installation.copyFileFromZip(DEFAULT_SERVER_XML, targetConfDir, "server", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(DEFAULT_WEB_XML, targetConfDir, "web", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(MANAGER_WEB_XML, targetWebAppDir.getFileObject(TOMCAT_MANAGER_DIR).getFileObject(WEB_INF_DIR), "web", XML_EXT);
                    Tomcat40Installation.copyFileFromZip(README_BASE_FILE_JWSDP, baseFSRoot, "IDE-README", "txt");
                }
                Tomcat40Installation.copyDir(homeFSRoot.getFileObject(TOMCAT_CONF_DIR), baseFSRoot, false, true);
            }
            catch (PropertyVetoException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
                return;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
                return;
            }
        } else {
            return;
        }
    }

    private static boolean shouldCopyWebAppFileJWSDP(FileObject webAppFile) {
        String waName = webAppFile.getNameExt().toLowerCase();
        if (waName.startsWith("jaxm")) {
            return false;
        }
        if ("jstl-examples.war".equals(waName)) {
            return false;
        }
        if ("registry-server.war".equals(waName)) {
            return false;
        }
        if ("saaj-simple.war".equals(waName)) {
            return false;
        }
        if ("manager.xml".equals(waName)) {
            return false;
        }
        return !"admin.xml".equals(waName);
    }

    private static FileSystem getHomeFS(File homeDir) throws PropertyVetoException, IOException {
        LocalFileSystem homeFS = new LocalFileSystem();
        homeFS.setRootDirectory(homeDir);
        return homeFS;
    }

    private static FileSystem getBaseFS(File baseDir) throws PropertyVetoException, IOException {
        LocalFileSystem baseFS = new LocalFileSystem();
        baseFS.setRootDirectory(baseDir);
        return baseFS;
    }

    private static void copyFile(FileObject sourceFile, FileObject targetDir) throws IOException {
        String ext;
        String name = sourceFile.getName();
        if (targetDir.getFileObject(name, ext = sourceFile.getExt()) == null) {
            FileUtil.copyFile((FileObject)sourceFile, (FileObject)targetDir, (String)name, (String)ext);
        }
    }

    private static void copyDir(FileObject sourceDir, FileObject targetDir, boolean createOnlyFolder, boolean ignoreRootFolderExistence) {
        if (sourceDir != null) {
            FileObject createdDir = targetDir.getFileObject(sourceDir.getName());
            if (createdDir != null) {
                if (!ignoreRootFolderExistence) {
                    return;
                }
            } else {
                try {
                    createdDir = targetDir.createFolder(sourceDir.getName());
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    return;
                }
            }
            if (createOnlyFolder) {
                return;
            }
            Enumeration all = sourceDir.getChildren(false);
            while (all.hasMoreElements()) {
                FileObject fo = (FileObject)all.nextElement();
                if (fo.isFolder()) {
                    Tomcat40Installation.copyDir(fo, createdDir, false, ignoreRootFolderExistence);
                    continue;
                }
                try {
                    FileUtil.copyFile((FileObject)fo, (FileObject)createdDir, (String)fo.getName(), (String)fo.getExt());
                }
                catch (SyncFailedException e) {
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void copyFileFromZip(String fileSource, FileObject targetDir, String newFileName, String newFileExt) {
        try {
            URL u = new URL(fileSource);
            File targetFile = new File(FileUtil.toFile((FileObject)targetDir), newFileName + "." + newFileExt);
            if (targetFile.exists()) {
                return;
            }
            FileOutputStream os = new FileOutputStream(targetFile);
            try {
                InputStream is = u.openStream();
                try {
                    int read;
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf, 0, buf.length)) != -1) {
                        void var9_10;
                        ((OutputStream)os).write(buf, 0, (int)var9_10);
                    }
                    Object var11_11 = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                ((OutputStream)os).close();
                throw throwable;
            }
            ((OutputStream)os).close();
            {
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public ServerStatus getServerStatus() {
        return this.status;
    }

    public void nonIncrementalDeploy(ModuleStandardData data, Progress obj, Tomcat40Instance instance) throws ServerException {
        this.setTestComponent((WebAppStandardData)data.getBaseStandardData(), instance);
        this.setRestart();
        this.synchronizeStart(obj, instance);
    }

    public void incrementalDeploy(ModuleStandardData data, ModuleChangeEvent[] events, Progress obj, Tomcat40Instance instance) throws ServerException {
        this.setTestComponent((WebAppStandardData)data.getBaseStandardData(), instance);
        if (instance.getInstallation().getInternal()) {
            this.dynamicWebModuleUpload(events, instance);
        } else {
            this.setRestart();
        }
        this.synchronizeStart(obj, instance);
    }

    /*
     * WARNING - void declaration
     */
    private void dynamicWebModuleUpload(ModuleChangeEvent[] events, Tomcat40Instance instance) {
        if (this.isTomcatRunning() && !this.restart) {
            String host = instance.getRealHostName();
            int port = instance.getPort();
            int i = 0;
            while (i < events.length) {
                StandardData webData = events[i].getData();
                if (webData instanceof ModuleStandardData) {
                    webData = ((ModuleStandardData)webData).getBaseStandardData();
                }
                if (webData instanceof WebAppStandardData) {
                    WebAppStandardData.WebMapping[] mappings = ((WebAppStandardData)webData).getWebModules();
                    int j = 0;
                    while (j < mappings.length) {
                        String prefix = mappings[j].getURLPrefix();
                        if (prefix.length() == 0) {
                            prefix = "/";
                        }
                        if (!prefix.startsWith("/")) {
                            prefix = "/" + prefix;
                        }
                        try {
                            int b;
                            URL url = new URL("http", host, port, "/manager/reload?path=" + prefix);
                            URLConnection con = url.openConnection();
                            con.connect();
                            InputStream is = con.getInputStream();
                            StringBuffer buf = new StringBuffer();
                            while ((b = is.read()) != -1) {
                                void var13_14;
                                buf.append((char)var13_14);
                            }
                            String httpOutput = buf.toString();
                            if (httpOutput.startsWith("OK")) {
                                return;
                            }
                            if (httpOutput.startsWith("FAIL")) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation") : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation), (String)"MSG_reloadFailed", (Object)httpOutput), 2));
                            }
                        }
                        catch (IOException ex) {
                            this.setRestart();
                            ErrorManager.getDefault().notify(1, (Throwable)ex);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void setTestComponent(WebAppStandardData web, Tomcat40Instance instance) throws ServerException {
        if (web != null) {
            this.webApplication = web;
            this.listenerRegistering();
        }
        this.getTomcatDataObject().setNewContext(instance.getHost(), web);
    }

    public boolean testPortAvailability(Tomcat40Instance instance) {
        Socket socket = null;
        String hostName = instance.getRealHostName();
        int port = instance.getPort();
        try {
            socket = new Socket(hostName, port);
            socket.close();
            String mes = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_portInUse_HTTP"), hostName, new Integer(port).toString());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes));
            return false;
        }
        catch (ConnectException ex) {
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return false;
        }
        try {
            String serverPort = this.getTomcatDataObject().getRoot().getAttributeValue("port");
            if (serverPort != null) {
                Integer portNumber = new Integer(serverPort);
                int port1 = portNumber;
                if (port1 == port) {
                    String mes = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_portInUse_Same"), "localhost", portNumber.toString());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes));
                    return false;
                }
                socket = new Socket("localhost", port1);
                socket.close();
                String mes = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_portInUse_Admin"), "localhost", portNumber.toString());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes));
                return false;
            }
            return false;
        }
        catch (ConnectException ex) {
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return false;
        }
        return true;
    }

    private void listenerRegistering() {
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof WebAppStandardData) {
                ((WebAppStandardData)o).removeAppChangeListener((AppChangeListener)this);
                continue;
            }
            if (!(o instanceof WebStandardData.WebModule)) continue;
            ((WebStandardData.WebModule)o).removeWebChangeListener((WebChangeListener)this);
        }
        this.webApplication.addAppChangeListener((AppChangeListener)this);
        WebAppStandardData.WebMapping[] mappings = this.webApplication.getWebModules();
        int a = 0;
        while (a < mappings.length) {
            mappings[a].getWebModule().addWebChangeListener((WebChangeListener)this);
            ++a;
        }
    }

    public void fireWebChangeEvent(WebChangeEvent wce) {
        if ((class$org$netbeans$modules$j2ee$server$datamodel$WebStandardData$WebDDData == null ? (class$org$netbeans$modules$j2ee$server$datamodel$WebStandardData$WebDDData = Tomcat40Installation.class$("org.netbeans.modules.j2ee.server.datamodel.WebStandardData$WebDDData")) : class$org$netbeans$modules$j2ee$server$datamodel$WebStandardData$WebDDData).isAssignableFrom(wce.getWebData().getClass())) {
            this.setRestart();
        }
    }

    public void fireAppChangeEvent(AppChangeEvent ace) {
    }

    public void propertyChange(PropertyChangeEvent pce) {
        if (pce.getSource().equals((Object)this.getTomcatDataObject())) {
            Object nv;
            Tomcat40DataObject tc = (Tomcat40DataObject)((Object)pce.getSource());
            if (tc.isValid() && "modified".equals(pce.getPropertyName()) && (nv = pce.getNewValue()) instanceof Boolean && !((Boolean)nv).booleanValue()) {
                this.setRestart();
            }
            if ("valid".equals(pce.getPropertyName()) && (nv = pce.getNewValue()) instanceof Boolean && !((Boolean)nv).booleanValue()) {
                tc.removePropertyChangeListener(this);
            }
        }
    }

    protected ServerOutput[] getServerOutput() {
        return this.serverOutput;
    }

    private void createServerOutput(InputStream sequenceInputStream) {
        try {
            this.serverOutput = new ServerOutput[]{new ServerOutputImpl("error", sequenceInputStream), new ServerOutputImpl("output", this.tomcatProcess.getInputStream())};
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            this.serverOutput = new ServerOutput[0];
        }
    }

    protected void setRestart() {
        this.setRestart(true);
    }

    protected void setRestart(boolean b) {
        this.restart = b;
    }

    protected void setDebug(boolean debug) {
        if (debug) {
            this.futurePhase.setDebugPhase();
        } else {
            this.futurePhase.setExecPhase();
        }
    }

    protected DebugInfo getDebugInfo(Tomcat40Instance instance) throws ServerException {
        String socketDebuggingType = NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("SEL_debuggingType_1");
        if (this.getTomcatDataObject().getDebuggingType().equals(socketDebuggingType)) {
            return new DebugInfo.SocketDebugInfo(Util.getLocalHost(), this.getDebuggingPort());
        }
        return new DebugInfo.SharedMemoryDebugInfo(Util.getLocalHost(), this.tomcatDO.getNameForSharedMemoryAccess());
    }

    private void startServerInExecMode(Tomcat40Instance instance) {
        if (this.lastPhase.isDebugPhase() || this.restart) {
            this.stopExecution();
            this.setRestart(false);
        }
        if (!this.isTomcatRunning()) {
            this.createNewTomcatProcess(false, instance);
        }
        this.lastPhase.setExecPhase();
    }

    private void startServerInDebugMode(Tomcat40Instance instance) {
        this.stopExecution();
        this.setRestart(false);
        this.createNewTomcatProcess(true, instance);
        this.lastPhase.setDebugPhase();
    }

    private void createNewTomcatProcess(boolean debug, Tomcat40Instance instance) {
        try {
            NbProcessDescriptor pd;
            if (!this.testPortAvailability(instance)) {
                return;
            }
            this.makeProgress(1);
            this.startInternalServer();
            this.manageConfiguration();
            ExecInfo execInfo = new ExecInfo("org.apache.catalina.startup.Bootstrap", new String[]{"start"});
            TomcatFormat tomcatFormat = new TomcatFormat(execInfo, this.isAssertEnabled(), this.getClassicSetting(), this.getDebugSetting(debug), this.getCatalinaHome(), this.getCatalinaBase(), this.getSortedFileSystemNames());
            this.makeProgress(3);
            this.setRestart(false);
            this.tomcatProcess = debug ? this.tomcatDO.getDebugProcessDescriptor().exec((Format)((Object)tomcatFormat)) : this.tomcatDO.getExecProcessDescriptor().exec((Format)((Object)tomcatFormat));
            this.tomcatThread = new WaitingThread(this.tomcatProcess);
            this.tomcatThread.start();
            String commandLine = null;
            if (debug) {
                pd = this.tomcatDO.getDebugProcessDescriptor();
                commandLine = pd.getProcessName() + " " + pd.getArguments();
            } else {
                pd = this.tomcatDO.getExecProcessDescriptor();
                commandLine = pd.getProcessName() + " " + pd.getArguments();
            }
            String expandedCommandLine = ((Format)((Object)tomcatFormat)).format(commandLine) + System.getProperty("line.separator");
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new StringBufferInputStream(expandedCommandLine), this.tomcatProcess.getErrorStream());
            this.createServerOutput(sequenceInputStream);
            this.fireStatus(ServerStatus.STATUS_RESTART);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    private void manageConfiguration() {
        WebApp webApp;
        DDDataObject dd;
        Tomcat40DataObject tdo = this.getTomcatDataObject();
        boolean monitorEnabled = Tomcat40WebServer.getServer().isMonitorEnabled();
        boolean ideMode = tdo.isIdeMode();
        FileObject fo = tdo.getPrimaryFile();
        Boolean monitorFilter = (Boolean)fo.getAttribute("monitor_filter");
        if (ideMode) {
            tdo.addCompilationJar();
            if (monitorEnabled) {
                if (!Boolean.TRUE.equals(monitorFilter)) {
                    dd = tdo.getDD();
                    if (dd == null) {
                        return;
                    }
                    webApp = dd.getWebApp();
                    if (webApp == null) {
                        return;
                    }
                    if (tdo.changeFilterMonitor(webApp, true)) {
                        dd.setNodeDirty(true);
                    }
                }
                tdo.addMonitorJars();
            }
            if (!monitorEnabled && !Boolean.FALSE.equals(monitorFilter)) {
                dd = tdo.getDD();
                if (dd == null) {
                    return;
                }
                webApp = dd.getWebApp();
                if (webApp == null) {
                    return;
                }
                if (tdo.changeFilterMonitor(webApp, false)) {
                    dd.setNodeDirty(true);
                }
                tdo.removeAllMonitorValves();
            }
        }
        tdo.addPointbaseJar();
        dd = tdo.getDD();
        if (dd == null) {
            return;
        }
        webApp = dd.getWebApp();
        if (webApp == null) {
            return;
        }
        if (tdo.specifyIDEServletParameter(webApp)) {
            dd.setNodeDirty(true);
        }
        if (tdo.specifyFilterPortParameter(webApp)) {
            dd.setNodeDirty(true);
        }
    }

    private void startInternalServer() {
        try {
            HttpServer.getRepositoryRoot();
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (UnknownHostException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    private void executeStoppingTomcatProcess() {
        try {
            this.getTomcatDataObject().stopLogThreads();
            ExecInfo execInfo = new ExecInfo("org.apache.catalina.startup.Bootstrap", new String[]{"stop"});
            TomcatFormat tomcatFormat = new TomcatFormat(execInfo, this.isAssertEnabled(), this.getClassicSetting(), this.getDebugSetting(false), this.getCatalinaHome(), this.getCatalinaBase(), this.getSortedFileSystemNames());
            this.getTomcatDataObject().getExecProcessDescriptor().exec((Format)((Object)tomcatFormat));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    protected synchronized void synchronizeStart(Progress progress, Tomcat40Instance instance) {
        this.progressObject = progress;
        this.makeProgress(0);
        if (this.futurePhase.isDebugPhase()) {
            this.startServerInDebugMode(instance);
        } else {
            this.startServerInExecMode(instance);
        }
    }

    protected synchronized void synchronizeWait(Progress progress, Tomcat40Instance instance) {
        try {
            URL url = new URL("http", instance.getRealHostName(), instance.getPort(), DUMMY_RESOURCE);
            if (Util.waitForURLConnection((URL)url, (int)40000, (int)1000)) {
                this.makeProgress(4);
            } else {
                this.makeProgress(5);
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    protected synchronized void stopExecution() {
        this.makeProgress(2);
        if (this.isTomcatRunning()) {
            this.executeStoppingTomcatProcess();
            this.getTomcatDataObject().stopLogThreads();
            this.waitsForTomcatDeath(14);
            if (this.isTomcatRunning()) {
                this.tomcatProcess.destroy();
                this.waitsForTomcatDeath(14);
                if (this.isTomcatRunning()) {
                    ErrorManager.getDefault().notify(4096, (Throwable)new Exception("tomcat is not stopped properly"));
                    this.tomcatThread.setFinished();
                    this.fireStatus(ServerStatus.STATUS_STOPPED);
                }
            }
        }
    }

    private void waitsForTomcatDeath(int numberOfCycles) {
        int i = 1;
        while (i < numberOfCycles) {
            if (this.isTomcatRunning()) {
                try {
                    Thread.sleep(i * 100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private boolean isTomcatRunning() {
        return this.tomcatThread != null && !this.tomcatThread.isTomcatProcessDead();
    }

    private String getSortedFileSystemNames() {
        StringBuffer buffer = new StringBuffer();
        this.addFirstPathPart(buffer, new String[]{this.homeDir.getAbsolutePath(), "bin", "bootstrap.jar"});
        this.addNextPathPart(buffer, new String[]{System.getProperty("jdk.home"), "lib", "tools.jar"});
        return buffer.toString();
    }

    private void addFirstPathPart(StringBuffer buffer, String[] names) {
        String fileSeparator = System.getProperty("file.separator");
        buffer.append("\"");
        int i = 0;
        while (true) {
            buffer.append(names[i]);
            if (i == names.length - 1) break;
            buffer.append(fileSeparator);
            ++i;
        }
        buffer.append("\"");
    }

    private void addNextPathPart(StringBuffer buffer, String[] names) {
        buffer.append(System.getProperty("path.separator"));
        this.addFirstPathPart(buffer, names);
    }

    protected int getDebuggingPort() {
        return this.getTomcatDataObject().getDebuggerPort();
    }

    private String getDebuggingPortString() {
        return new Integer(this.getDebuggingPort()).toString();
    }

    private String getDebugSetting(boolean debug) {
        if (!debug) {
            return "";
        }
        String socketDebuggingType = NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("SEL_debuggingType_1");
        if (this.getTomcatDataObject().getDebuggingType().equals(socketDebuggingType)) {
            return "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + this.getDebuggingPortString();
        }
        return "-Xdebug -Xnoagent -Xrunjdwp:transport=dt_shmem,server=y,suspend=n,address=" + this.getTomcatDataObject().getNameForSharedMemoryAccess();
    }

    private String getClassicSetting() {
        if (!this.tomcatDO.getClassic()) {
            return "";
        }
        return "-classic ";
    }

    private boolean isAssertEnabled() {
        return this.tomcatDO.isAssertEnabled();
    }

    private String getCatalinaHome() {
        return "-Dcatalina.home=\"" + this.homeDir.getAbsolutePath() + "\"";
    }

    private String getCatalinaBase() {
        if (this.baseDir == null) {
            return "";
        }
        return "-Dcatalina.base=\"" + this.baseDir.getAbsolutePath() + "\"";
    }

    private void fireStatus(ServerStatus status) {
        this.status = status;
        if (this.serverChangeSupport != null) {
            this.serverChangeSupport.fireStatus(status);
        }
        Iterator i = this.instances.iterator();
        while (i.hasNext()) {
            ((Tomcat40Instance)i.next()).fireStatus(status);
        }
    }

    void addServerChangeListener(ServerListener sl) {
        Tomcat40Installation tomcat40Installation = this;
        synchronized (tomcat40Installation) {
            if (this.serverChangeSupport == null) {
                ServerInstance first = null;
                Iterator it = this.instances.iterator();
                if (it.hasNext()) {
                    first = (ServerInstance)it.next();
                }
                this.serverChangeSupport = new ServerChangeSupport(first);
            }
        }
        this.serverChangeSupport.addServerChangeListener(sl);
    }

    void removeServerChangeListener(ServerListener sl) {
        if (this.serverChangeSupport != null) {
            this.serverChangeSupport.removeServerChangeListener(sl);
        }
    }

    void makeProgress(int a) {
        if (this.progressObject == null) {
            return;
        }
        switch (a) {
            case 0: {
                this.progressObject.startTask(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress0"), 100);
                break;
            }
            case 1: {
                this.progressObject.addMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress1"));
                this.progressObject.recordWork(50);
                break;
            }
            case 2: {
                this.progressObject.addMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress2"));
                this.progressObject.recordWork(30);
                break;
            }
            case 3: {
                String str = MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress3"), this.getDisplayName());
                this.progressObject.addMessage(str);
                this.progressObject.recordWork(70);
                break;
            }
            case 4: {
                this.progressObject.addMessage(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress4"));
                this.progressObject.recordWork(100);
                this.progressObject = null;
                break;
            }
            case 5: {
                this.progressObject.addError(NbBundle.getBundle((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation = Tomcat40Installation.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Installation)).getString("MSG_TomcatProgress5"));
                this.progressObject.recordWork(100);
                this.progressObject = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TomcatFileSystem
    extends LocalFileSystem {
        private static final long serialVersionUID = -9208838171921144809L;

        protected boolean isPersistent() {
            return true;
        }
    }

    private class WaitingThread
    extends Thread {
        private Process process = null;
        private boolean finished = false;
        private boolean tomcatDeath = false;

        private WaitingThread(Process process) {
            this.process = process;
            this.finished = false;
        }

        private void setFinished() {
            this.finished = true;
        }

        private boolean isTomcatProcessDead() {
            return this.tomcatDeath;
        }

        public void run() {
            while (true) {
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                    continue;
                }
                break;
            }
            this.tomcatDeath = true;
            if (!this.finished) {
                Tomcat40Installation.this.fireStatus(ServerStatus.STATUS_STOPPED);
            }
        }
    }

    private class Phase {
        protected static final int NULL_PHASE = 0;
        protected static final int EXEC_PHASE = 1;
        protected static final int DEBUG_PHASE = 2;
        protected int phase = 0;

        boolean isNullPhase() {
            return this.phase == 0;
        }

        boolean isExecPhase() {
            return this.phase == 1;
        }

        boolean isDebugPhase() {
            return this.phase == 2;
        }

        public void setExecPhase() {
            this.phase = 1;
        }

        public void setDebugPhase() {
            this.phase = 2;
        }
    }

    protected static class TomcatFormat
    extends ProcessExecutor.Format {
        public static final String TAG_CLASSIC = "classic";
        public static final String TAG_ASSERT_ENABLED = "assert_enabled";
        public static final String TAG_DEBUG = "debuggerOptions";
        public static final String TAG_CATALINA_HOME = "catalina_home";
        public static final String TAG_CATALINA_BASE = "catalina_base";
        public static final String TAG_TOMCAT_FILE_SYSTEMS = "tomcat_filesystems";
        private static final long serialVersionUID = 992972967554321415L;

        public TomcatFormat(ExecInfo info, boolean isAssertEnabled, String classicSetting, String debugSetting, String catalinaHome, String catalinaBase, String fileSystems) {
            super(info);
            Map map = this.getMap();
            map.put(TAG_ASSERT_ENABLED, isAssertEnabled ? "-ea " : "");
            map.put(TAG_CLASSIC, classicSetting);
            map.put(TAG_DEBUG, debugSetting);
            map.put(TAG_CATALINA_HOME, catalinaHome);
            map.put(TAG_CATALINA_BASE, catalinaBase);
            map.put(TAG_TOMCAT_FILE_SYSTEMS, fileSystems);
        }
    }
}

