/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.netbeans.modules.j2ee.impl.ServerChangeSupport;
import org.netbeans.modules.j2ee.server.DebugInfo;
import org.netbeans.modules.j2ee.server.Progress;
import org.netbeans.modules.j2ee.server.Server;
import org.netbeans.modules.j2ee.server.ServerException;
import org.netbeans.modules.j2ee.server.ServerInstance;
import org.netbeans.modules.j2ee.server.ServerInstanceNode;
import org.netbeans.modules.j2ee.server.ServerListener;
import org.netbeans.modules.j2ee.server.ServerOutput;
import org.netbeans.modules.j2ee.server.ServerStatus;
import org.netbeans.modules.j2ee.server.datamodel.FileArchiveResource;
import org.netbeans.modules.j2ee.server.datamodel.ModuleChangeEvent;
import org.netbeans.modules.j2ee.server.datamodel.ModuleStandardData;
import org.netbeans.modules.j2ee.server.datamodel.WebAppStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.URLInfo;
import org.netbeans.modules.j2ee.server.web.WebServerInstance;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40DataObject;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40WebServer;
import org.netbeans.modules.tomcat.tomcat40.compile.TomcatCompileContext;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Host;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Service;
import org.netbeans.modules.web.core.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Tomcat40Instance
implements WebServerInstance,
URLInfo {
    private static final String BASE_ID = "Tomcat_4.0_Instance";
    protected Tomcat40Installation installation;
    private ServerChangeSupport serverChangeSupport;
    protected WebAppStandardData webApplication;
    protected Host host;
    protected Service service;
    protected String ID;
    static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance;

    protected Tomcat40Instance(Tomcat40Installation i, Host h) {
        this.installation = i;
        this.host = h;
        this.service = (Service)this.host.parent().parent();
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host h) {
        this.host = h;
        this.service = (Service)this.host.parent().parent();
    }

    public String getHostName() {
        return this.host.getAttributeValue("name");
    }

    public String getRealHostName() {
        String hostName = this.getHostName();
        try {
            InetAddress.getByName(hostName);
            return hostName;
        }
        catch (UnknownHostException e) {
            return Util.getLocalHost();
        }
    }

    public int getPort() {
        String serviceName = this.service.getAttributeValue("name");
        String hostName = this.host.getAttributeValue("name");
        String defaultPort = this.getTomcatDataObject().getHostPort(serviceName, hostName);
        int portNumber = 8080;
        if (defaultPort == null) {
            defaultPort = this.getPortFromFileAttribute(serviceName, hostName);
        }
        try {
            portNumber = Integer.valueOf(defaultPort);
        }
        catch (NumberFormatException ex) {
            String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance = Tomcat40Instance.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance), (String)"ERR_wrongPortNumber"), ex.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes));
        }
        return portNumber;
    }

    private String getPortFromFileAttribute(String serviceName, String hostName) {
        FileObject fo = this.getTomcatDataObject().getPrimaryFile();
        Integer defConnector = (Integer)fo.getAttribute(serviceName + ":" + hostName + ":port");
        boolean[] connectors = this.service.getConnector();
        int defCon = -1;
        String port = "8080";
        if (defConnector != null) {
            try {
                defCon = defConnector;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (defCon != -1 && defCon < connectors.length) {
                port = this.service.getAttributeValue("Connector", defCon, "port");
                this.getTomcatDataObject().setHostPort(serviceName, hostName, port);
                return port;
            }
        }
        int i = 0;
        while (i < connectors.length) {
            String className = this.service.getAttributeValue("Connector", i, "className");
            String scheme = this.service.getAttributeValue("Connector", i, "scheme");
            if (className.endsWith("HttpConnector") && (scheme == null || scheme.equals("http"))) {
                defCon = i;
            }
            ++i;
        }
        if (defCon == -1 && connectors.length > 0) {
            defCon = 0;
        }
        if (defCon != -1) {
            try {
                fo.setAttribute(serviceName + ":" + this.getHostName() + ":port", (Object)new Integer(defCon));
            }
            catch (IOException ex) {
                // empty catch block
            }
            port = this.service.getAttributeValue("Connector", defCon, "port");
            this.getTomcatDataObject().setHostPort(serviceName, hostName, port);
        }
        return port;
    }

    public Tomcat40Installation getInstallation() {
        return this.installation;
    }

    public Server getServer() {
        return Tomcat40WebServer.getServer();
    }

    public ServerInstanceNode getInstanceNode() {
        return null;
    }

    public String getDisplayName() {
        String mes = null;
        if (this.getInstallation().getInternal()) {
            String key = this.getInstallation().isInternalJWSDP() ? "LBL_instanceNameInternalJWSDP" : "LBL_instanceNameInternal";
            mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance = Tomcat40Instance.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance), (String)key), this.getHostName(), "" + this.getPort());
        } else {
            mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance == null ? (class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance = Tomcat40Instance.class$("org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance")) : class$org$netbeans$modules$tomcat$tomcat40$Tomcat40Instance), (String)"LBL_instanceName"), this.installation.getDisplayName(), this.getHostName(), "" + this.getPort());
        }
        return mes;
    }

    public String getID() {
        if (this.ID == null) {
            StringBuffer sb = new StringBuffer(BASE_ID);
            sb.append("|");
            sb.append(this.installation.getHomeDirectory());
            sb.append("|");
            sb.append(this.installation.getBaseDirectory());
            sb.append("|");
            sb.append(this.service.getAttributeValue("name"));
            sb.append("|");
            sb.append(this.host.getAttributeValue("name"));
            sb.append("|");
            sb.append(String.valueOf(this.getPort()));
            this.ID = sb.toString();
        }
        return this.ID;
    }

    public Tomcat40DataObject getTomcatDataObject() {
        return this.installation.getTomcatDataObject();
    }

    public ServerStatus getServerStatus() {
        return this.installation.getServerStatus();
    }

    public void addServerChangeListener(ServerListener sl) {
        Tomcat40Instance tomcat40Instance = this;
        synchronized (tomcat40Instance) {
            if (this.serverChangeSupport == null) {
                this.serverChangeSupport = new ServerChangeSupport((ServerInstance)this);
            }
        }
        this.serverChangeSupport.addServerChangeListener(sl);
    }

    public void removeServerChangeListener(ServerListener sl) {
        if (this.serverChangeSupport != null) {
            this.serverChangeSupport.removeServerChangeListener(sl);
        }
    }

    protected void fireStatus(ServerStatus status) {
        if (this.serverChangeSupport != null) {
            this.serverChangeSupport.fireStatus(status);
        }
    }

    public FfjJspCompileContext getJspCompiler() {
        Tomcat40DataObject dobj = this.installation.getTomcatDataObject();
        if (dobj.isIdeMode()) {
            return new TomcatCompileContext(this);
        }
        return null;
    }

    public URLInfo getURLInfo() throws ServerException {
        return this;
    }

    public URL getURL() {
        try {
            URL url = new URL("http", this.getRealHostName(), this.getPort(), "");
            return url;
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    public ServerOutput[] getServerOutput() {
        return this.installation.getServerOutput();
    }

    public DebugInfo getDebugInfo() throws ServerException {
        return this.installation.getDebugInfo(this);
    }

    public void stopExecution() {
        this.installation.stopExecution();
    }

    public void deploy(FileArchiveResource jarFile) {
    }

    public void deploy(ModuleStandardData data, Progress obj) throws ServerException {
        this.installation.nonIncrementalDeploy(data, obj, this);
    }

    public void deploy(ModuleStandardData data, ModuleChangeEvent[] events, Progress obj) throws ServerException {
        this.installation.incrementalDeploy(data, events, obj, this);
    }

    public void ensureAvailable(Progress obj) throws ServerException {
        this.installation.synchronizeWait(obj, this);
    }

    public void setMode(int mode) {
        this.installation.setDebug(mode == 2);
    }

    public boolean supportsDebugging() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

