/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.actions;

import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Context;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Engine;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Host;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Server;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Service;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class LogUtils {
    private static final String ACCESS_VALVE_CLASS = "org.apache.catalina.valves.AccessLogValve";
    private static final String DEFAULT_VALVE_PREFIX = "access_log.";
    private static final String DEFAULT_LOG_PREFIX = "catalina.";
    private static final String DEFAULT_LOG_SUFFIX = ".log";
    private static final String DEFAULT_LOG_DIR = "logs";
    private static final String LOG_FORMAT = "yyyy-MM-dd";
    static /* synthetic */ Class class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public static void showContextLogFile(Tomcat40Installation inst, Context context) {
        String prefix;
        FileSystem fs = inst.getBaseFileSystem();
        if (fs == null) {
            return;
        }
        String logDir = context.getAttributeValue("Logger", "directory");
        if (logDir == null) {
            logDir = DEFAULT_LOG_DIR;
        }
        if ((prefix = context.getAttributeValue("Logger", "prefix")) == null) {
            String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_contextLoggerNotDefined"), context.getAttributeValue("path"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes, 2));
            return;
        }
        String suffix = context.getAttributeValue("Logger", "suffix");
        if (suffix == null) {
            suffix = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fs, logDir, prefix, suffix, true);
    }

    public static void showHostLogFile(Tomcat40Installation inst, Host host) {
        String prefix;
        FileSystem fs = inst.getBaseFileSystem();
        if (fs == null) {
            return;
        }
        String logDir = host.getAttributeValue("Logger", "directory");
        if (logDir == null) {
            logDir = DEFAULT_LOG_DIR;
        }
        if ((prefix = host.getAttributeValue("Logger", "prefix")) == null) {
            String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_hostLoggerNotDefined"), host.getAttributeValue("name"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes, 2));
            return;
        }
        String suffix = host.getAttributeValue("Logger", "suffix");
        if (suffix == null) {
            suffix = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fs, logDir, prefix, suffix, true);
    }

    public static void showAccessLogFile(Tomcat40Installation inst, Host host) {
        String suffix;
        String prefix;
        FileSystem fs = inst.getBaseFileSystem();
        if (fs == null) {
            return;
        }
        int accessValveIndex = -1;
        int i = 0;
        while (i < host.sizeValve()) {
            if (ACCESS_VALVE_CLASS.equals(host.getAttributeValue("Valve", i, "className"))) {
                accessValveIndex = i;
                break;
            }
            ++i;
        }
        if (accessValveIndex == -1) {
            String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_accessLoggerNotDefined"), host.getAttributeValue("name"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes, 2));
            return;
        }
        String logDir = host.getAttributeValue("Valve", accessValveIndex, "directory");
        if (logDir == null) {
            logDir = DEFAULT_LOG_DIR;
        }
        if ((prefix = host.getAttributeValue("Valve", accessValveIndex, "prefix")) == null) {
            prefix = DEFAULT_VALVE_PREFIX;
        }
        if ((suffix = host.getAttributeValue("Valve", accessValveIndex, "suffix")) == null) {
            suffix = DEFAULT_LOG_SUFFIX;
        }
        LogUtils.showLogFile(fs, logDir, prefix, suffix, true);
    }

    public static void showServerLogFiles(Tomcat40Installation inst, Server server) {
        FileSystem fs = inst.getBaseFileSystem();
        if (fs == null) {
            return;
        }
        Service[] services = server.getService();
        if (services == null) {
            return;
        }
        int undisplayedLogs = 0;
        int i = 0;
        while (i < services.length) {
            Engine engine = services[i].getEngine();
            if (engine == null) {
                ++undisplayedLogs;
            } else {
                boolean exist;
                String suffix;
                String prefix;
                String logDir = engine.getAttributeValue("Logger", "directory");
                if (logDir == null) {
                    logDir = DEFAULT_LOG_DIR;
                }
                if ((prefix = engine.getAttributeValue("Logger", "prefix")) == null) {
                    prefix = DEFAULT_LOG_PREFIX;
                }
                if ((suffix = engine.getAttributeValue("Logger", "suffix")) == null) {
                    suffix = DEFAULT_LOG_SUFFIX;
                }
                if (!(exist = LogUtils.showLogFile(fs, logDir, prefix, suffix, false))) {
                    ++undisplayedLogs;
                }
            }
            ++i;
        }
        if (undisplayedLogs == services.length) {
            String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_logFilesNotExist"), inst.getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes, 2));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean showLogFile(FileSystem fs, String log_dir, String log_prefix, String log_suffix, boolean showWarningMessage) {
        String ext = "";
        if (log_suffix.startsWith(".")) {
            ext = log_suffix.substring(1);
        }
        String date = new SimpleDateFormat(LOG_FORMAT).format(new Date());
        FileObject logFile = fs.find(log_dir, log_prefix + date, ext);
        if (logFile != null) {
            boolean written = false;
            if (ext.equals("txt")) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)logFile);
                    EditorCookie cookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LogUtils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (cookie != null) {
                        cookie.open();
                        return true;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (written) return true;
            try {
                InputOutput inOut = IOProvider.getDefault().getIO(logFile.getName(), false);
                OutputWriter writer = inOut.getOut();
                InputStreamReader isr = null;
                try {
                    int b;
                    isr = new InputStreamReader(logFile.getInputStream());
                    while ((b = isr.read()) != -1) {
                        void var11_20;
                        writer.write((int)var11_20);
                    }
                    Object var14_23 = null;
                    if (isr == null) return true;
                }
                catch (Throwable throwable) {
                    Object var14_24 = null;
                    if (isr == null) throw throwable;
                    isr.close();
                    throw throwable;
                }
                isr.close();
                return true;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return true;
        }
        FileObject logs = fs.find(log_dir, null, null);
        Enumeration en = logs.getChildren(false);
        FileObject lastLogFile = null;
        while (en.hasMoreElements()) {
            FileObject fo = (FileObject)en.nextElement();
            String fileName = fo.getName() + "." + fo.getExt();
            if (!fileName.startsWith(log_prefix) || !fileName.endsWith(ext)) continue;
            if (lastLogFile == null) {
                lastLogFile = fo;
                continue;
            }
            long d = fo.lastModified().getTime();
            if (lastLogFile.lastModified().getTime() >= d) continue;
            lastLogFile = fo;
        }
        if (lastLogFile != null) {
            boolean written = false;
            if (ext.equals("txt")) {
                try {
                    DataObject dataObject = DataObject.find(lastLogFile);
                    EditorCookie cookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = LogUtils.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                    if (cookie != null) {
                        cookie.open();
                        return true;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (written) return true;
            try {
                InputOutput inOut = IOProvider.getDefault().getIO(lastLogFile.getName(), false);
                OutputWriter writer = inOut.getOut();
                InputStreamReader isr = null;
                try {
                    int b;
                    isr = new InputStreamReader(lastLogFile.getInputStream());
                    while ((b = isr.read()) != -1) {
                        void var14_25;
                        writer.write((int)var14_25);
                    }
                    Object var17_31 = null;
                    if (isr == null) return true;
                }
                catch (Throwable throwable) {
                    Object var17_32 = null;
                    if (isr == null) throw throwable;
                    isr.close();
                    throw throwable;
                }
                isr.close();
                return true;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return true;
        }
        if (!showWarningMessage) return false;
        String mes = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils == null ? (class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils = LogUtils.class$("org.netbeans.modules.tomcat.tomcat40.actions.LogUtils")) : class$org$netbeans$modules$tomcat$tomcat40$actions$LogUtils), (String)"MSG_logFileNotExist"), log_prefix + LOG_FORMAT + "." + ext);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)mes, 2));
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

