/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.compile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.j2ee.server.web.FfjJspCompileContext;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance;
import org.netbeans.modules.tomcat.tomcat40.compile.InternalCompiler;
import org.netbeans.modules.tomcat.tomcat40.compile.InternalCompilerContext;
import org.netbeans.modules.tomcat.tomcat40.compile.NullWriter;
import org.netbeans.modules.tomcat.tomcat40.compile.TomcatOptionsImpl;
import org.netbeans.modules.tomcat.tomcat40.compile.TomcatSourceMapper;
import org.netbeans.modules.tomcat.tomcat40.compile.WDCompilationDescriptor;
import org.netbeans.modules.web.core.jsploader.CompilationClassLoader;
import org.netbeans.modules.web.core.jsploader.ErrorCompiler;
import org.netbeans.modules.web.core.jsploader.ExCompileContext;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class TomcatCompileContext
implements FfjJspCompileContext,
ExCompileContext {
    private static final boolean debug = false;
    private static final String TC406_PATH_TO_XERCES = "/common/lib/xerces.jar";
    private static final String TC406_PATH_TO_JASPER_RT = "/lib/jasper-runtime.jar";
    private static final String JWSDP_PATH_TO_JASPER_RT = "common/lib/jasper-runtime.jar";
    private Tomcat40Instance virtualHost;
    private static boolean loggerInitialized = false;

    static synchronized void initializeLogger() {
        if (!loggerInitialized) {
            DefaultLogger l = new DefaultLogger(null);
            Logger.setDefaultSink((Writer)new NullWriter());
            l.setName("JASPER_LOG");
            loggerInitialized = true;
        }
    }

    public TomcatCompileContext(Tomcat40Instance virtualHost) {
        this.virtualHost = virtualHost;
    }

    public JspSourceMapper createSourceMapper(WebStandardData.WebJsp jspPage) throws IOException {
        return this.createTomcatSourceMapper(jspPage);
    }

    public InputStream getServletSource(WebStandardData.WebJsp jspPage) {
        String source = this.getDevelopmentCompilation(jspPage).getServletFileName();
        if (source != null) {
            try {
                return new FileInputStream(source);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getServletClassName(WebStandardData.WebJsp jspPage) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(jspPage)).getFullClassName();
    }

    public String getRealClassName(WebStandardData.WebJsp jspPage) {
        return ((TomcatDevelopmentCompilation)this.getDevelopmentCompilation(jspPage)).getRealClassName();
    }

    public FfjJspCompileContext.DevelopmentCompilation getDevelopmentCompilation(WebStandardData.WebJsp jspPage) {
        return new TomcatDevelopmentCompilation(jspPage, this.virtualHost);
    }

    public static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor(WebStandardData.WebModule wmRoot, WebStandardData.WebJsp jspPage, Throwable ex) {
        FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor ed = TomcatCompileContext.constructJakartaErrorDescriptor0(wmRoot, jspPage, ex);
        if (ed == null) {
            ed = new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)jspPage, -1, -1, ErrorCompiler.getThrowableMessage((Throwable)ex, (boolean)true), "");
        }
        return ed;
    }

    public JspSourceMapper createTomcatSourceMapper(final WebStandardData.WebJsp jspPage) throws IOException {
        InputStream servletIs = this.getServletSource(jspPage);
        if (servletIs == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(servletIs));
        TomcatSourceMapper mapper = new TomcatSourceMapper(reader, new JspSourceMapper.NameConverter(){

            public String convert(String jspFileName) throws IOException {
                String result = jspFileName;
                FileObject ff = JspCompileUtil.findFileObjectForFile((FileSystem)JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)jspPage).getFileSystem(), (String)jspFileName);
                if (null != ff) {
                    result = ff.toString();
                }
                return result;
            }
        });
        if (mapper.isEmpty()) {
            mapper.setPrimaryJspFileName(JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)jspPage).getPackageNameExt('/', '.'));
        }
        if (mapper.size() == 0) {
            throw new IllegalArgumentException(" sourceMangler.size() == 0");
        }
        return mapper;
    }

    private static FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor constructJakartaErrorDescriptor0(WebStandardData.WebModule wmRoot, WebStandardData.WebJsp jspPage, Throwable ex) {
        while (!(ex instanceof ParseException) && !(ex instanceof CompileException)) {
            if (!(ex instanceof JasperException)) {
                return null;
            }
            ex = ((JasperException)ex).getRootCause();
        }
        String m1 = ex.getMessage();
        int lpar = m1.indexOf(40);
        if (lpar == -1) {
            return null;
        }
        int comma = m1.indexOf(44, lpar);
        if (comma == -1) {
            return null;
        }
        int rpar = m1.indexOf(41, comma);
        if (rpar == -1) {
            return null;
        }
        String line = m1.substring(lpar + 1, comma);
        String col = m1.substring(comma + 1, rpar);
        String fileName = m1.substring(0, lpar);
        File file = wmRoot.getDocumentBase();
        String wmFileName = file.getAbsolutePath();
        WebStandardData.WebJsp errorResource = jspPage;
        if (fileName.startsWith(wmFileName)) {
            WebStandardData.WebResource resTemp;
            String errorRes = fileName.substring(wmFileName.length());
            if ((errorRes = errorRes.replace(File.separatorChar, '/')).startsWith("/")) {
                errorRes = errorRes.substring(1);
            }
            if ((resTemp = wmRoot.findResource(errorRes)) != null) {
                errorResource = resTemp;
            }
        }
        try {
            return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor((WebStandardData.WebResource)errorResource, Integer.parseInt(line) + 1, Integer.parseInt(col), m1.substring(rpar + 1).trim(), "");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static class TomcatDevelopmentCompilation
    implements FfjJspCompileContext.DevelopmentCompilation {
        private transient String additionalClassPath;
        protected WebStandardData.WebJsp jspPage;
        protected Tomcat40Instance virtualHost;
        String className;
        String javaFileName;
        String classFileName;
        String realClassName;
        String currentServletFileName;
        String currentServletClassName;
        String currentClassFileName;
        private boolean outDated;

        TomcatDevelopmentCompilation(WebStandardData.WebJsp jspPage, Tomcat40Instance virtualHost) {
            this.jspPage = jspPage;
            this.virtualHost = virtualHost;
            this.initialize();
        }

        private void initialize() {
            String jspResource = "/" + this.jspPage.getResourceURI();
            boolean isErrorPage = false;
            this.outDated = true;
            try {
                TomcatOptionsImpl options = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
                WDCompilationDescriptor cd = new WDCompilationDescriptor(this.jspPage.getWebModule(), jspResource);
                InternalCompilerContext clctxt = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), jspResource, cd, isErrorPage, options);
                InternalCompiler comp = (InternalCompiler)clctxt.createCompiler();
                this.className = comp.getClassName();
                this.javaFileName = comp.getJavaFileName();
                this.classFileName = comp.getClassFileName();
                this.realClassName = clctxt.getRealClassName();
                File f1 = new File(this.javaFileName);
                this.currentServletFileName = f1.exists() ? this.javaFileName : null;
                this.currentServletClassName = f1.exists() ? this.className : null;
                File f2 = new File(this.classFileName);
                this.currentClassFileName = f2.exists() ? this.classFileName : null;
                File classFile = new File(this.classFileName);
                if (!classFile.exists()) {
                    this.outDated = true;
                } else {
                    FileObject fo = JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)this.jspPage);
                    if (fo == null) {
                        throw new IOException();
                    }
                    File jspReal = NbClassPath.toFile((FileObject)fo);
                    this.outDated = classFile.lastModified() < jspReal.lastModified();
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (JasperException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public boolean isOutDated() {
            return this.outDated;
        }

        public void cleanJSP() throws IOException {
            FileObject fo;
            if (this.currentServletFileName != null) {
                fo = JspCompileUtil.findFileObjectForFile((String)this.currentServletFileName);
                if (fo == null) {
                    new File(this.currentServletFileName).delete();
                } else {
                    fo.delete();
                }
            }
            if (this.currentClassFileName != null) {
                fo = JspCompileUtil.findFileObjectForFile((String)this.currentClassFileName);
                if (fo == null) {
                    new File(this.currentClassFileName).delete();
                } else {
                    fo.delete();
                }
            }
        }

        public String getAdditionalClassPath() {
            if (this.additionalClassPath == null) {
                if (this.virtualHost.getInstallation().isInternalJWSDP()) {
                    StringBuffer cp = new StringBuffer();
                    cp.append(this.getClassPathItemFromInstallation(TomcatCompileContext.JWSDP_PATH_TO_JASPER_RT));
                    this.additionalClassPath = cp.toString();
                } else {
                    StringBuffer cp = new StringBuffer();
                    cp.append(this.getClassPathItemFromInstallation(TomcatCompileContext.TC406_PATH_TO_XERCES));
                    cp.append(File.pathSeparatorChar);
                    cp.append(this.getClassPathItemFromInstallation(TomcatCompileContext.TC406_PATH_TO_JASPER_RT));
                    this.additionalClassPath = cp.toString();
                }
            }
            return this.additionalClassPath;
        }

        private String getClassPathItemFromInstallation(String relativeResource) {
            File home = this.virtualHost.getInstallation().getHomeDirectory();
            File resource = new File(home, relativeResource);
            return resource.getAbsolutePath();
        }

        public void compilePreDeploy() throws IOException {
        }

        public String getServletFileName() {
            return this.currentServletFileName;
        }

        String getFullClassName() {
            return this.currentServletClassName;
        }

        String getRealClassName() {
            return this.realClassName;
        }

        public String getServletEncoding() {
            return "UTF8";
        }

        public FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[] compileJspToServlet(boolean isErrorPage, String compilationURI, String encoding, ClassLoader cl) throws IOException {
            TomcatCompileContext.initializeLogger();
            TomcatOptionsImpl options = new TomcatOptionsImpl(this.jspPage, this.virtualHost);
            try {
                WDCompilationDescriptor cd = new WDCompilationDescriptor(this.jspPage.getWebModule(), compilationURI);
                String jspResource = "/" + this.jspPage.getResourceURI();
                InternalCompilerContext clctxt = new InternalCompilerContext((ClassLoader)new CompilationClassLoader(this.getClass().getClassLoader()), jspResource, cd, isErrorPage, options);
                Compiler comp = clctxt.createCompiler();
                boolean wasOutDated = comp.compile();
                return null;
            }
            catch (Exception e) {
                FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor ed = TomcatCompileContext.constructJakartaErrorDescriptor(this.jspPage.getWebModule(), this.jspPage, e);
                return new FfjJspCompileContext.DevelopmentCompilation.ErrorDescriptor[]{ed};
            }
        }
    }
}

