/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.compile;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.TldLocationsCache;
import org.netbeans.modules.j2ee.server.datamodel.WebStandardData;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Installation;
import org.netbeans.modules.tomcat.tomcat40.Tomcat40Instance;
import org.netbeans.modules.tomcat.tomcat40.compile.CompilationServletContext;
import org.netbeans.modules.tomcat.tomcat40.compile.WMDataCache;
import org.netbeans.modules.tomcat.tomcat40.serverconf.Engine;
import org.netbeans.modules.web.core.jsploader.ContextDescriptor;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.execution.WebResourceExecPerformer;
import org.openide.ErrorManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;

public class TomcatOptionsImpl
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private File scratchDir;
    private WebStandardData.WebJsp jsp;
    private Tomcat40Instance virtualHost;
    private TldLocationsCache tldLocationsCache = null;
    static /* synthetic */ Class class$org$netbeans$modules$web$execution$WebDefaultExecPerformer;

    public TomcatOptionsImpl(WebStandardData.WebJsp jsp, Tomcat40Instance virtualHost) throws IOException {
        this.virtualHost = virtualHost;
        this.jsp = jsp;
        this.initialize(TomcatOptionsImpl.findDO(jsp));
    }

    private void initialize(DataObject dobj) throws IOException {
        BaseBean bb;
        File contextDocumentBase;
        FileObject root = JspCompileUtil.getContextRoot((FileObject)dobj.getPrimaryFile());
        FileSystem myFs = root.getFileSystem();
        ContextDescriptor cd = new ContextDescriptor(myFs);
        CompilationServletContext psc = new CompilationServletContext(null, cd);
        this.tldLocationsCache = WMDataCache.getDefault().getTldLocationsCache(root, psc);
        File tomcatInstDir = this.virtualHost.getInstallation().getBaseDirectory();
        if (tomcatInstDir == null) {
            tomcatInstDir = this.virtualHost.getInstallation().getHomeDirectory();
        }
        if ((contextDocumentBase = NbClassPath.toFile((FileObject)root)) == null && myFs instanceof JarFileSystem) {
            contextDocumentBase = ((JarFileSystem)myFs).getJarFile();
        }
        boolean isTomcat404OrHigher = this.isTomcat404OrHigher(this.virtualHost.getInstallation());
        String engineName = null;
        if (isTomcat404OrHigher && (bb = this.virtualHost.getHost().parent()) instanceof Engine) {
            Engine eng = (Engine)bb;
            engineName = eng.getAttributeValue("name");
        }
        File baseScratchDir = this.computeWorkDirectory(tomcatInstDir.getAbsolutePath(), engineName, this.virtualHost.getHostName(), this.findWebContextURI(dobj), contextDocumentBase, isTomcat404OrHigher);
        this.scratchDir = this.getScratchDirWithSubpackages(baseScratchDir, "/" + this.jsp.getResourceURI());
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    private boolean isTomcat404OrHigher(Tomcat40Installation inst) {
        File f = inst.getHomeDirectory();
        File relNotes = new File(f, "RELEASE-NOTES-4.0.4.txt");
        if (relNotes.exists()) {
            return true;
        }
        relNotes = new File(f, "RELEASE-NOTES-4.1.txt");
        if (relNotes.exists()) {
            return true;
        }
        relNotes = new File(f, "jwsdp-common-lib");
        return relNotes.exists();
    }

    private static DataObject findDO(WebStandardData.WebJsp jsp) throws IOException {
        FileObject fo = JspCompileUtil.getFOForWebResource((WebStandardData.WebResource)jsp);
        if (fo == null) {
            throw new IOException();
        }
        return DataObject.find((FileObject)fo);
    }

    public boolean getKeepGenerated() {
        throw new UnsupportedOperationException();
    }

    public boolean getMappedFile() {
        return true;
    }

    public boolean getLargeFile() {
        return false;
    }

    public boolean getSendErrorToClient() {
        throw new UnsupportedOperationException();
    }

    public String getIeClassId() {
        return DEFAULT_IE_CLASS_ID;
    }

    public String getClassPath() {
        throw new UnsupportedOperationException();
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        throw new UnsupportedOperationException();
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public String getJavaEncoding() {
        return "UTF-8";
    }

    private File computeWorkDirectory(String installationDir, String engine, String host, String contextPath, File contextDocumentBase, boolean isTomcat404OrHigher) throws IOException {
        String enginePart = "";
        if (isTomcat404OrHigher) {
            enginePart = engine == null || engine.length() < 1 ? "_" : engine;
            enginePart = enginePart + File.separator;
        }
        if (host == null || host.length() < 1) {
            host = "_";
        }
        String temp = this.computeDocumentBasePart(contextDocumentBase);
        String workDir = "work" + File.separator + enginePart + host + File.separator + temp;
        File dir = new File(workDir);
        if (!dir.isAbsolute()) {
            File catalinaHome = new File(installationDir);
            String catalinaHomePath = null;
            try {
                catalinaHomePath = catalinaHome.getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        dir.mkdirs();
        return dir;
    }

    private String computeContextPart(String contextPath) {
        String temp = contextPath;
        if (temp.startsWith("/")) {
            temp = temp.substring(1);
        }
        temp = temp.replace('/', '_');
        if ((temp = temp.replace('\\', '_')).length() < 1) {
            temp = "_";
        }
        return temp;
    }

    private String computeDocumentBasePart(File contextDocumentBase) throws IOException {
        if (contextDocumentBase == null) {
            return "_null_documentbase";
        }
        return TomcatOptionsImpl.mangleFullContextPath(contextDocumentBase);
    }

    private static String mangleFullContextPath(File contextDocumentBase) throws IOException {
        String realPath = contextDocumentBase.getCanonicalPath();
        realPath = URLEncoder.encode(realPath);
        if ((realPath = realPath.replace('%', '_')).length() > 100) {
            realPath = "" + realPath.hashCode();
        }
        return realPath;
    }

    private String findWebContextURI(DataObject jspObject) {
        WebResourceExecPerformer perf = new WebResourceExecPerformer(jspObject);
        try {
            Method m = (class$org$netbeans$modules$web$execution$WebDefaultExecPerformer == null ? (class$org$netbeans$modules$web$execution$WebDefaultExecPerformer = TomcatOptionsImpl.class$("org.netbeans.modules.web.execution.WebDefaultExecPerformer")) : class$org$netbeans$modules$web$execution$WebDefaultExecPerformer).getDeclaredMethod("getWebModuleURI", new Class[0]);
            ((AccessibleObject)m).setAccessible(true);
            return (String)m.invoke((Object)perf, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private File getScratchDirWithSubpackages(File baseScratchDir, String jspUri) throws IOException {
        File outDir = null;
        URL outURL = baseScratchDir.toURL();
        String outURI = outURL.toString();
        outURI = outURI.endsWith("/") ? outURI + jspUri.substring(1, jspUri.lastIndexOf("/") + 1) : outURI + jspUri.substring(0, jspUri.lastIndexOf("/") + 1);
        outURL = new URL(outURI);
        outDir = new File(outURL.getFile());
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        return outDir;
    }

    public boolean getClassDebugInfo() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

