/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat.tomcat40.compile;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.netbeans.modules.j2ee.server.web.JspSourceMapper;

public class TomcatSourceMapper
implements JspSourceMapper,
Serializable {
    private static final boolean findDynamicRange = true;
    private transient JspSourceMapper.NameConverter converter;
    public static final String ARTIFICIAL_SUFFIX = ".:\\/,.";
    private static final boolean debug = false;
    private static final boolean verbose = true;
    private static final boolean haveOneOffBug = true;
    private int size = 0;
    private int MAX_SIZE = 500;
    private boolean ready = false;
    private transient Reader reader = null;
    private static final int JSP_CODE = 0;
    private static final int JAVA_CODE = 1;
    private Range[][] map;
    private Map fileNames = new Hashtable(5);
    private String primaryJspFileName;
    private transient Hashtable privateMaps;
    private transient String currentDir;
    private int debugLine = -1;
    private static final String PROLOG = ":START:";
    private static final String EPILOG = ":END:";
    private static final String GLUE = ":GLUE:";
    private static final String GLUE_SAME_LINE = ":GLUE_SAME_LINE:";
    private static final String EMPTY_JSP_FILE_NAME = "@@@EMPTY@@@";
    private static final int EMPTY_JAVA_LINE = 33;
    private boolean isEmptyJspPage = true;
    private static final long serialVersionUID = -3350248224506807258L;

    public TomcatSourceMapper() {
    }

    public TomcatSourceMapper(Reader reader, JspSourceMapper.NameConverter converter) throws IOException {
        if (null == converter) {
            throw new IllegalArgumentException("null == converter");
        }
        this.converter = converter;
        this.init(reader);
    }

    private Hashtable getPrivateMaps() {
        if (null == this.privateMaps) {
            this.privateMaps = new Hashtable(11);
        }
        return this.privateMaps;
    }

    private void init(Reader reader) throws IOException {
        if (null == reader) {
            throw new IllegalArgumentException("null == reader");
        }
        this.size = 0;
        this.reader = reader;
        this.readAll();
        this.compress();
        this.reader.close();
        this.ready = true;
        this.reader = null;
    }

    public String getPrimaryJspFileName() {
        if (null != this.primaryJspFileName) {
            return this.primaryJspFileName;
        }
        if (this.isEmpty()) {
            return EMPTY_JSP_FILE_NAME;
        }
        return null;
    }

    public void setPrimaryJspFileName(String v) {
        this.primaryJspFileName = v;
    }

    Range javaToJsp(String jspFile, Range range) {
        return this.mapRange(jspFile, 1, range, 0);
    }

    Range javaToJsp(String jspFile, Position position) {
        Range range = new Range(position);
        return this.mapRange(jspFile, 1, range, 0);
    }

    public String toString() {
        String s = this.getClass().getName() + "\tsource\ttarget\n";
        int i = 0;
        while (i < this.size) {
            s = s + "\t" + this.map[0][i] + "\t" + this.map[1][i] + "\n";
            ++i;
        }
        return s;
    }

    Range jspToJava(String jspFile, Range range) {
        return this.mapRange(jspFile, 0, range, 1);
    }

    public int size() {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: Not ready");
        }
        if (this.isEmpty()) {
            return 1;
        }
        return this.size;
    }

    Range jspToJava(String jspFile, Position position) {
        Range range = new Range(position);
        return this.mapRange(jspFile, 0, range, 1);
    }

    private String adjustJspFileName(String jspFileName) throws IOException {
        String result = jspFileName;
        if (null != this.converter) {
            result = this.converter.convert(jspFileName);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.isEmptyJspPage;
    }

    private synchronized void readAll() {
        String SSTART = "// begin [file=\"/";
        int LSTART = SSTART.length();
        String SEND = "// end";
        int LEND = SEND.length();
        String SFROM = "from=(";
        int LFROM = SFROM.length();
        String STO = ";to=(";
        int LTO = STO.length();
        String SHTML = "// HTML ";
        int LHTML = SHTML.length();
        boolean htmlCode = false;
        boolean offset = true;
        boolean addFakeRange = false;
        Hashtable<String, Integer> sameComment = new Hashtable<String, Integer>();
        Stack<String> fileStack = new Stack<String>();
        int oldRepeatCounterValue = 1;
        this.map = new Range[2][this.MAX_SIZE];
        int i = 0;
        while (i < this.MAX_SIZE) {
            this.map[0][i] = new Range();
            this.map[1][i] = new Range();
            ++i;
        }
        try {
            String s;
            LineNumberReader lineReader = new LineNumberReader(this.reader);
            while (null != (s = lineReader.readLine())) {
                String endComment;
                Object o;
                String startComment = s.trim();
                if (startComment.startsWith(SHTML)) {
                    htmlCode = true;
                    startComment = startComment.substring(LHTML);
                } else {
                    htmlCode = false;
                }
                if (!startComment.startsWith(SSTART)) continue;
                this.isEmptyJspPage = false;
                int beg = LSTART;
                int end = startComment.indexOf(59, beg);
                if (end < 0) continue;
                String file = startComment.substring(beg, end - 1);
                file = this.adjustJspFileName(file);
                Integer repeatCounter = (Integer)sameComment.get(startComment);
                int newRepeatCounterValue = 1;
                if (null != repeatCounter) {
                    newRepeatCounterValue = repeatCounter;
                }
                if (fileStack.empty()) {
                    fileStack.push(file);
                } else {
                    String parent = (String)fileStack.peek();
                    if (!file.equals(parent)) {
                        fileStack.pop();
                        if (fileStack.empty() || !file.equals(fileStack.peek())) {
                            fileStack.push(parent);
                            fileStack.push(file);
                            if (null != repeatCounter && null != this.getPrimaryJspFileName() && !this.getPrimaryJspFileName().equals(file)) {
                                newRepeatCounterValue = repeatCounter + 1;
                            }
                        }
                        oldRepeatCounterValue = newRepeatCounterValue;
                    } else {
                        newRepeatCounterValue = oldRepeatCounterValue;
                    }
                }
                if (newRepeatCounterValue > 1) {
                    file = file + ARTIFICIAL_SUFFIX + newRepeatCounterValue;
                }
                if (null == (o = this.fileNames.get(file))) {
                    this.fileNames.put(file, file);
                } else {
                    file = (String)o;
                }
                if (null == this.getPrimaryJspFileName()) {
                    this.setPrimaryJspFileName(file);
                }
                if (this.size >= this.map[0].length) {
                    this.realloc();
                }
                this.map[0][this.size].start.fileName = file;
                this.map[0][this.size].stop.fileName = file;
                beg = end + LFROM;
                if ((end = startComment.indexOf(44, beg)) < 0) continue;
                String me = startComment.substring(beg + 1, end);
                this.map[0][this.size].start.line = 1 + Integer.parseInt(me);
                this.map[1][this.size].start.line = lineReader.getLineNumber() + 1;
                beg = end + 1;
                if ((end = startComment.indexOf(41, beg)) < 0) continue;
                me = startComment.substring(beg, end);
                this.map[0][this.size].start.column = 1 + Integer.parseInt(me);
                this.map[1][this.size].start.column = 1;
                beg = end + LTO;
                if ((end = startComment.indexOf(44, beg)) < 0) continue;
                me = startComment.substring(beg + 1, end);
                this.map[0][this.size].stop.line = 1 + Integer.parseInt(me);
                beg = end + 1;
                if ((end = startComment.indexOf(41, beg)) < 0) continue;
                me = startComment.substring(beg, end);
                this.map[0][this.size].stop.column = 1 + Integer.parseInt(me);
                String type = htmlCode ? "MappedCharData" : "";
                this.map[0][this.size].start.type = type;
                this.map[0][this.size].stop.type = type;
                this.map[1][this.size].start.type = type;
                this.map[1][this.size].stop.type = type;
                if (this.size > 1 && this.map[0][this.size].start.line == this.map[0][this.size - 1].start.line && this.map[0][this.size].start.column == this.map[0][this.size - 1].start.column && this.map[0][this.size].start.fileName.equals(this.map[0][this.size - 1].start.fileName)) {
                    --this.size;
                }
                int startLineNumber = lineReader.getLineNumber();
                do {
                    if (this.size < this.map[0].length) continue;
                    this.realloc();
                } while (null != (s = lineReader.readLine()) && !(endComment = s.trim()).equals(SEND));
                if (null != s) {
                    if (lineReader.getLineNumber() == startLineNumber + 1) continue;
                    this.map[1][this.size].stop.line = lineReader.getLineNumber() - 1;
                    this.map[1][this.size].stop.column = s.length();
                    this.map[1][this.size].htmlCode = htmlCode;
                    this.map[0][this.size].htmlCode = htmlCode;
                    sameComment.put(startComment, new Integer(newRepeatCounterValue));
                    ++this.size;
                    continue;
                }
                break;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        if (null == this.getPrimaryJspFileName()) {
            // empty if block
        }
        this.sanityCheck();
        this.postprocess();
    }

    private void postprocess() {
        int i = 0;
        while (i < this.size - 1) {
            String type = this.map[1][i].start.type;
            if ("TagBegin".equals(type)) {
                ++this.map[1][i].start.line;
            }
            ++i;
        }
    }

    private void sanityCheck() {
        int i = 0;
        while (i < this.size - 1) {
            if (!this.map[1][i].start.before(this.map[1][i + 1].start)) {
                throw new Error("FATAL ERROR: JAVA_CODE index is not sorted: i=" + i);
            }
            ++i;
        }
        if (!this.isEmpty() && null == this.getPrimaryJspFileName()) {
            throw new Error("FATAL ERROR: null == getPrimaryJspFileName()");
        }
    }

    public int mangle(int line) {
        return this.mangle(null, line, 1);
    }

    public int mangle(int line, int col) {
        return this.mangle(null, line, col);
    }

    public int mangle(String jspFile, int line) {
        return this.mangle(jspFile, line, 1);
    }

    public synchronized int mangle(String jspFileName, int line, int col) {
        if (this.isEmpty()) {
            return 33;
        }
        if (null == jspFileName) {
            jspFileName = this.primaryJspFileName;
        }
        Range result = this.jspToJava(jspFileName, new Position(line, col));
        int res = result.start.line;
        return res;
    }

    public int unmangle(int line) {
        return this.unmangle(line, 1);
    }

    public int unmangle(int line, int col) {
        return this.unmangle(null, line, col);
    }

    public synchronized int unmangle(String jspFileName, int line, int col) {
        if (this.isEmpty()) {
            return 1;
        }
        Range result = this.javaToJsp(jspFileName, new Position(line, col));
        int res = result.start.line;
        return res;
    }

    public String getJavaLineType(int line, int col) {
        if (this.isEmpty()) {
            return PROLOG;
        }
        Range result = this.findRangeOfPosition(this.getPrimaryJspFileName(), 1, new Position(line, col), 0);
        return result.start.type;
    }

    public String getJspFileName(int line, int col) throws IOException {
        if (this.isEmpty()) {
            return EMPTY_JSP_FILE_NAME;
        }
        Range r = this.javaToJsp(null, new Position(line, col));
        String jspFileName = this.getRealJspFileName(r.start.fileName);
        return jspFileName;
    }

    public boolean isProperJspFileName(String name) {
        if (null == name) {
            throw new IllegalArgumentException("null == name");
        }
        return name.indexOf(ARTIFICIAL_SUFFIX) < 0;
    }

    private String getRealJspFileName(String name) {
        String original = name;
        int i = name.indexOf(ARTIFICIAL_SUFFIX);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    private boolean isDynamicType(String type) {
        return PROLOG != type && EPILOG != type && GLUE != type && GLUE_SAME_LINE != type && type.indexOf("CharData") < 0;
    }

    public boolean isJavaCodeInJspPage(int line, int col) {
        if (this.isEmpty()) {
            return false;
        }
        String type = this.getJavaLineType(line, col);
        return this.isDynamicType(type);
    }

    private synchronized Range mapRange(String jspFileName, int in, Range source, int out) {
        if (!this.ready) {
            throw new IllegalArgumentException("SourceMapper: not ready yet");
        }
        if (source.stop.line < source.start.line || source.start.line == source.stop.line && source.stop.column < source.start.column) {
            throw new IllegalArgumentException("Illegal source Range" + source);
        }
        Range startRange = this.findRangeOfPosition(jspFileName, in, source.start, out);
        if (source.start.line == source.stop.line && source.start.column == source.stop.column) {
            return startRange;
        }
        Range result = new Range();
        result.start.line = startRange.start.line;
        result.start.column = startRange.start.column;
        result.start.fileName = startRange.start.fileName;
        result.start.type = startRange.start.type;
        Range stopRange = this.findRangeOfPosition(jspFileName, in, source.stop, out);
        if (startRange.stop.line > stopRange.stop.line || startRange.stop.line == stopRange.stop.line && startRange.stop.column > stopRange.stop.column) {
            result.stop.line = startRange.stop.line;
            result.stop.column = startRange.stop.column;
            result.stop.fileName = startRange.stop.fileName;
            result.stop.type = startRange.stop.type;
        } else {
            result.stop.line = stopRange.stop.line;
            result.stop.column = stopRange.stop.column;
            result.stop.fileName = stopRange.stop.fileName;
            result.stop.type = stopRange.stop.type;
        }
        return result;
    }

    public Map getFileNames() {
        if (null == this.fileNames) {
            throw new IllegalArgumentException("null == fileNames");
        }
        return this.fileNames;
    }

    public boolean hasIncludeFiles() {
        return this.getFileNames().size() > 1;
    }

    private void sort(Range[][] theMap) {
        if (null == theMap) {
            throw new IllegalArgumentException("null == theMap");
        }
        boolean low = false;
        int high = theMap[0].length;
        int i = 0;
        while (i < high) {
            int j = i;
            while (j > 0) {
                if (theMap[0][j - 1].start.before(theMap[0][j].start)) break;
                Range r = theMap[0][j];
                theMap[0][j] = theMap[0][j - 1];
                theMap[0][j - 1] = r;
                r = theMap[1][j];
                theMap[1][j] = theMap[1][j - 1];
                theMap[1][j - 1] = r;
                --j;
            }
            ++i;
        }
    }

    private Range[][] getMap(String jspFileName) {
        int i;
        if (null == jspFileName) {
            throw new IllegalArgumentException("null == jspFileName");
        }
        Range[][] mymap = (Range[][])this.getPrivateMaps().get(jspFileName);
        if (null != mymap) {
            if (mymap.length > 0 && mymap[0].length > 0) {
                mymap[0][0].start.column = 1;
            }
            return mymap;
        }
        int newSize = 0;
        int i2 = 0;
        while (i2 < this.size) {
            if (jspFileName.equals(this.map[0][i2].start.fileName)) {
                ++newSize;
            }
            ++i2;
        }
        if (0 == newSize) {
            String origJspFileName = jspFileName;
            jspFileName = '/' == jspFileName.charAt(0) ? jspFileName.substring(1) : "/" + jspFileName;
            i = 0;
            while (i < this.size) {
                if (jspFileName.equals(this.map[0][i].start.fileName)) {
                    ++newSize;
                }
                ++i;
            }
        }
        if (0 == newSize) {
            throw new IllegalArgumentException("No mappings found for jspFileName=" + jspFileName);
        }
        mymap = new Range[2][newSize];
        int index = 0;
        i = 0;
        while (i < this.size) {
            if (jspFileName.equals(this.map[0][i].start.fileName)) {
                mymap[0][index] = this.map[0][i];
                mymap[1][index] = this.map[1][i];
                ++index;
            }
            ++i;
        }
        this.sort(mymap);
        this.getPrivateMaps().put(jspFileName, mymap);
        if (mymap.length > 0 && mymap[0].length > 0) {
            mymap[0][0].start.column = 1;
        }
        return mymap;
    }

    private int findPositionIndexOfJspFile(String jspFileName, Position position) {
        if (null == jspFileName) {
            throw new IllegalArgumentException("null == jspFileName");
        }
        if (null == position) {
            throw new IllegalArgumentException("null == position");
        }
        Range[][] mymap = this.getMap(jspFileName);
        return this.findPositionIndex(jspFileName, 0, position, mymap, mymap[0].length);
    }

    private int findPositionIndex(String jspFileName, int javaOrJsp, Position position) {
        if (0 == javaOrJsp && null != jspFileName) {
            return this.findPositionIndexOfJspFile(jspFileName, position);
        }
        return this.findPositionIndex(jspFileName, javaOrJsp, position, this.map, this.size);
    }

    private int findPositionIndex(String jspFileName, int javaOrJsp, Position position, Range[][] theMap, int theSize) {
        int first = 0;
        int last = theSize - 1;
        int line = position.line;
        int column = position.column;
        int index = first;
        while (index < last) {
            int stopMapLine = theMap[javaOrJsp][index].stop.line;
            int stopMapColumn = theMap[javaOrJsp][index].stop.column;
            if ((line < stopMapLine || stopMapLine == line && column <= stopMapColumn) && index < last) {
                if (stopMapLine == theMap[javaOrJsp][index + 1].start.line && stopMapColumn == theMap[javaOrJsp][index + 1].start.column && stopMapLine == line && stopMapColumn == column) {
                    return index + 1;
                }
                return index;
            }
            ++index;
        }
        return last;
    }

    private Range findRangeOfPosition(String jspFileName, int in, Position position, int out) {
        String myType;
        boolean dynamic;
        if (null == position) {
            throw new IllegalArgumentException("null == position");
        }
        Range result = new Range();
        int line = position.line;
        int col = position.column;
        Range[][] theMap = this.map;
        int theSize = this.size;
        if (0 == in && null != jspFileName) {
            theMap = this.getMap(jspFileName);
            theSize = theMap[0].length;
        }
        if (theSize == 0 || line < theMap[in][0].start.line || line == theMap[in][0].start.line && col < theMap[in][0].start.column) {
            result.start.fileName = this.getPrimaryJspFileName();
            result.start.type = PROLOG;
            result.stop.fileName = result.start.fileName;
            result.stop.type = result.start.type;
            return result;
        }
        if (line > theMap[in][theSize - 1].stop.line) {
            result.start.line = line - theMap[in][theSize - 1].stop.line + theMap[out][theSize - 1].stop.line;
            result.start.column = col;
            result.start.fileName = this.getPrimaryJspFileName();
            result.start.type = EPILOG;
            result.stop.line = result.start.line;
            result.stop.column = result.start.column;
            result.stop.fileName = this.getPrimaryJspFileName();
            result.stop.type = EPILOG;
            return result;
        }
        if (line == theMap[in][theSize - 1].stop.line && col > theMap[in][theSize - 1].stop.column) {
            result.start.line = theMap[out][theSize - 1].stop.line;
            result.start.column = col - theMap[in][theSize - 1].stop.column + theMap[out][theSize - 1].stop.column;
            result.start.fileName = this.getPrimaryJspFileName();
            result.start.type = EPILOG;
            result.stop.line = result.start.line;
            result.stop.column = result.start.column;
            result.stop.fileName = this.getPrimaryJspFileName();
            result.stop.type = EPILOG;
            return result;
        }
        int idx = this.findPositionIndex(jspFileName, in, position);
        if (0 == in && idx < theSize - 1 && !(dynamic = this.isDynamicType(myType = theMap[out][idx].start.type))) {
            int backLine;
            int dynamicIndex = idx + 1;
            myType = theMap[out][dynamicIndex].start.type;
            dynamic = this.isDynamicType(myType);
            if (dynamic && (backLine = this.unmangle(jspFileName, theMap[out][dynamicIndex].start.line, theMap[out][dynamicIndex].start.column)) == line) {
                idx = dynamicIndex;
            }
        }
        if (idx < 0 || idx >= theSize) {
            String sss = this.getClass().getName() + "\tsource\ttarget============================================\n";
            int iii = 0;
            while (iii < theSize) {
                sss = sss + "\t" + theMap[0][iii] + "\t" + theMap[1][iii] + "\n";
                ++iii;
            }
            throw new IllegalArgumentException("Internal error: line/col not found:" + line + "/" + col + " idx=" + idx);
        }
        if (line < theMap[in][idx].stop.line || line == theMap[in][idx].stop.line && col <= theMap[in][idx].stop.column) {
            result.start.line = theMap[out][idx].start.line;
            result.start.column = theMap[out][idx].start.column;
            result.start.fileName = theMap[out][idx].start.fileName;
            result.start.type = theMap[out][idx].start.type;
            result.stop.line = theMap[out][idx].stop.line;
            result.stop.column = theMap[out][idx].stop.column;
            result.stop.fileName = theMap[out][idx].stop.fileName;
            result.stop.type = theMap[out][idx].stop.type;
            if (theMap[out][idx].stop.line - theMap[out][idx].start.line < theMap[in][idx].stop.line - theMap[in][idx].start.line) {
                return result;
            }
            int addition = line - theMap[in][idx].start.line;
            if (addition > 0) {
                result.start.line += addition;
            }
            if (result.start.line > result.stop.line) {
                result.start.line = result.stop.line;
            }
            return result;
        }
        if (theMap[in][idx].stop.line < line) {
            result.start.line = line - theMap[in][idx].stop.line + theMap[out][idx].stop.line;
            result.start.column = col;
            result.start.fileName = this.getPrimaryJspFileName();
            result.start.type = GLUE;
            result.stop.line = result.start.line;
            result.stop.column = result.start.column;
            result.stop.fileName = result.start.fileName;
            result.stop.type = result.start.type;
            if (1 == in && theMap[in][idx].start.type.equals("Declaration")) {
                result.start.line = 1;
                result.start.column = 1;
                result.stop.line = 1;
                result.stop.column = 1;
            }
            return result;
        }
        result.start.line = theMap[out][idx].stop.line;
        result.start.column = col - theMap[in][idx].stop.column + theMap[out][idx].stop.column;
        result.start.fileName = this.getPrimaryJspFileName();
        result.start.type = GLUE_SAME_LINE;
        result.stop.line = result.start.line;
        result.stop.column = result.start.column;
        result.stop.fileName = result.start.fileName;
        result.stop.type = result.start.type;
        return result;
    }

    private void realloc() {
        int new_size = (int)((double)this.MAX_SIZE * 1.2);
        Range[][] newMap = new Range[2][new_size];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < this.MAX_SIZE) {
                newMap[i][j] = this.map[i][j];
                ++j;
            }
            ++i;
        }
        this.map = newMap;
        int i2 = this.MAX_SIZE;
        while (i2 < new_size) {
            this.map[0][i2] = new Range();
            this.map[1][i2] = new Range();
            ++i2;
        }
        this.MAX_SIZE = new_size;
    }

    private void compress() {
        Range[][] newMap = new Range[2][this.size];
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < this.size) {
                newMap[i][j] = this.map[i][j];
                ++j;
            }
            ++i;
        }
        this.map = newMap;
        this.MAX_SIZE = this.size;
    }

    static class Range
    implements Serializable {
        Position start;
        Position stop;
        boolean htmlCode;
        private static final long serialVersionUID = -4237269746376603367L;

        Range() {
            this.start = new Position();
            this.stop = new Position();
        }

        Range(Position source) {
            this(source, source);
        }

        Range(Position start, Position stop) {
            this.start = new Position(start);
            this.stop = new Position(stop);
        }

        Range(Range other) {
            this.start = new Position(other.start);
            this.stop = new Position(other.stop);
            this.htmlCode = other.htmlCode;
        }

        Position getStart() {
            return this.start;
        }

        Position getStop() {
            return this.stop;
        }

        public String toString() {
            return "'" + this.start.fileName + "' " + "[(" + this.start.line + "," + this.start.column + (this.htmlCode ? ") +++ (" : ") --- (") + this.stop.line + "," + this.stop.column + ")] " + this.start.type;
        }
    }

    static class Position
    implements Serializable {
        int line = 1;
        int column = 1;
        String fileName = "";
        String type = ":START:";
        private static final long serialVersionUID = -143684026717085250L;

        Position() {
        }

        Position(Position source) {
            this(source.line, source.column, source.fileName, source.type);
        }

        Position(int line, int column) {
            this.line = line;
            this.column = column;
        }

        Position(int line, int column, String fileName, String type) {
            this.line = line;
            this.column = column;
            this.fileName = fileName;
            this.type = type;
        }

        boolean before(Position other) {
            return this.line < other.line || this.line == other.line && this.column <= other.column;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Position)) {
                return false;
            }
            Position other = (Position)o;
            return other == this || this.line == other.line && this.column == other.column && this.type == other.type && this.fileName == other.fileName;
        }

        public String toString() {
            return "[" + this.fileName + ":" + this.type + "-" + this.line + "." + this.column + "]";
        }
    }
}

