/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.EmptyEnumeration;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

abstract class CopyUtil {
    private static final int timeDev = 100000;
    private int items;
    private int maxItems;
    private static final String DIRTYPE_INST = "Installation Directory";
    private static final String DIRTYPE_USER = "User Directory";
    private static String[] versions;
    private static String ffj20IE;
    private static String ffj30EE;
    private static String[] nonCpFiles;
    private static String userdirNonCpFiles;
    private static String[] nonCopiedModules;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$FileCopy;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$CopyUtil;

    CopyUtil() {
    }

    protected abstract void message(String var1);

    protected abstract void progress(int var1, int var2);

    protected final void upgradeIde(String ver, File src, File trg) throws Exception {
        int version = CopyUtil.getIdeVersion(ver);
        if (version < 0 || version >= versions.length) {
            this.message(CopyUtil.getString("MSG_BAD_IDE"));
            int i = 0;
            while (i < versions.length) {
                this.message(versions[i]);
                ++i;
            }
            throw new Exception("Invalid IDE version");
        }
        this.message(CopyUtil.getString("MSG_UPDATE_FROM", versions[version]));
        FileSystem srcFS = null;
        FileSystem trgFS = null;
        FileSystem tmpFS = null;
        Object[] filter = null;
        if (-1 != ver.indexOf(DIRTYPE_INST)) {
            File srcFile = new File(src, "system");
            File trgFile = new File(trg, "system");
            srcFS = this.createFileSystem(srcFile);
            trgFS = this.createFileSystem(trgFile);
            if (srcFS == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", srcFile.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + srcFile.getAbsolutePath());
            }
            if (trgFS == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", trgFile.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + trgFile.getAbsolutePath());
            }
            File tmpRoot = new File(trg, "system_backup");
            if (!tmpRoot.exists()) {
                tmpRoot.mkdirs();
            }
            tmpFS = this.createFileSystem(tmpRoot);
            filter = this.originalFiles(nonCpFiles[version]);
        } else {
            srcFS = this.createFileSystem(src);
            trgFS = this.createFileSystem(trg);
            if (srcFS == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", src.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + src.getAbsolutePath());
            }
            if (trgFS == null) {
                this.message(CopyUtil.getString("MSG_directory_not_exist", trg.getAbsolutePath()));
                throw new Exception("Directory doesn't exist - " + trg.getAbsolutePath());
            }
            File tmpRoot = new File(trg.getParentFile(), "userdir_backup");
            if (!tmpRoot.exists()) {
                tmpRoot.mkdirs();
            }
            tmpFS = this.createFileSystem(tmpRoot);
            filter = this.originalFiles(userdirNonCpFiles);
        }
        if (tmpFS != null) {
            FileObject[] ch = tmpFS.getRoot().getChildren();
            int i = 0;
            while (i < ch.length) {
                this.deleteAll(ch[i]);
                ++i;
            }
            CopyUtil.copyAttributes(trgFS.getRoot(), tmpFS.getRoot());
            this.recursiveCopy(trgFS.getRoot(), tmpFS.getRoot());
        }
        try {
            this.update(srcFS, trgFS, this.getLastModified(src), filter);
        }
        catch (Exception e) {
            if (tmpFS != null) {
                this.message(CopyUtil.getString("MSG_recovery_started"));
                this.deleteAll(trgFS.getRoot());
                CopyUtil.copyAttributes(tmpFS.getRoot(), trgFS.getRoot());
                this.recursiveCopy(tmpFS.getRoot(), trgFS.getRoot());
                this.message(CopyUtil.getString("MSG_recovery_finished"));
            }
            throw e;
        }
    }

    private FileSystem createFileSystem(File root) {
        LocalFileSystem lfs = null;
        if (root.exists() && root.isDirectory()) {
            try {
                lfs = new LocalFileSystem();
                lfs.setRootDirectory(root);
            }
            catch (Exception e) {
                lfs = null;
            }
        }
        return lfs == null ? null : new AttrslessLocalFileSystem(lfs);
    }

    private void update(FileSystem src, FileSystem trg, long sourceBaseTime, Object[] filter) throws IOException {
        this.items = 0;
        this.maxItems = 0;
        CopyUtil.copyAttributes(src.getRoot(), trg.getRoot());
        this.recursiveCopyWithFilter(src.getRoot(), trg.getRoot(), filter, sourceBaseTime);
    }

    private void recursiveCopy(FileObject sourceFolder, FileObject destFolder) throws IOException {
        FileObject[] childrens = sourceFolder.getChildren();
        int i = 0;
        while (i < childrens.length) {
            FileObject subSourceFo = childrens[i];
            FileObject subTargetFo = null;
            if (subSourceFo.isFolder()) {
                subTargetFo = destFolder.getFileObject(subSourceFo.getName());
                if (subTargetFo == null) {
                    subTargetFo = destFolder.createFolder(subSourceFo.getName());
                }
                CopyUtil.copyAttributes(subSourceFo, subTargetFo);
                this.recursiveCopy(subSourceFo, subTargetFo);
            } else {
                subTargetFo = destFolder.getFileObject(subSourceFo.getNameExt());
                if (subTargetFo == null) {
                    subTargetFo = Utilities.getOperatingSystem() == 8192 && subSourceFo.getNameExt().equalsIgnoreCase("_nbattrs.") ? FileUtil.copyFile((FileObject)subSourceFo, (FileObject)destFolder, (String)subSourceFo.getNameExt(), (String)subSourceFo.getExt()) : FileUtil.copyFile((FileObject)subSourceFo, (FileObject)destFolder, (String)subSourceFo.getName(), (String)subSourceFo.getExt());
                }
                CopyUtil.copyAttributes(subSourceFo, subTargetFo);
            }
            ++i;
        }
    }

    private void recursiveCopyWithFilter(FileObject source, FileObject dest, Object[] filter, long basicTime) throws IOException {
        FileObject[] childrens = source.getChildren();
        if (!source.isFolder()) {
            this.message(CopyUtil.getString("MSG_IS_NOT_FOLDER", source.getName()));
        }
        this.maxItems += childrens.length;
        int i = 0;
        while (i < childrens.length) {
            FileObject subSourceFo = childrens[i];
            ++this.items;
            this.progress(this.items, this.maxItems);
            if (this.canCopy(subSourceFo, filter, basicTime)) {
                FileObject subTargetFo = null;
                if (subSourceFo.isFolder()) {
                    subTargetFo = dest.getFileObject(subSourceFo.getNameExt());
                    if (subTargetFo == null) {
                        subTargetFo = dest.createFolder(subSourceFo.getNameExt());
                    }
                    CopyUtil.copyAttributes(subSourceFo, subTargetFo);
                    this.recursiveCopyWithFilter(subSourceFo, subTargetFo, filter, basicTime);
                } else {
                    subTargetFo = dest.getFileObject(subSourceFo.getName(), subSourceFo.getExt());
                    if (subTargetFo != null) {
                        FileLock lock = subTargetFo.lock();
                        subTargetFo.delete(lock);
                        lock.releaseLock();
                    }
                    subTargetFo = Utilities.getOperatingSystem() == 8192 && subSourceFo.getNameExt().equalsIgnoreCase("_nbattrs.") ? this.copyFile(subSourceFo, dest, subSourceFo.getNameExt()) : this.copyFile(subSourceFo, dest, subSourceFo.getName());
                    CopyUtil.copyAttributes(subSourceFo, subTargetFo);
                }
            }
            ++i;
        }
    }

    private FileObject copyFile(FileObject src, FileObject trg, String newName) throws IOException {
        if (src.getPath().endsWith("modules/installedModules.xml")) {
            Document doc = null;
            InputStream is = src.getInputStream();
            try {
                try {
                    doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, null, null);
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                is.close();
                throw throwable;
            }
            is.close();
            FileObject f = FileUtil.copyFile((FileObject)src, (FileObject)trg, (String)newName);
            FileLock lock = f.lock();
            try {
                NodeList children = doc.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    String codebase;
                    Node n = children.item(i);
                    if (n.getNodeType() == 1 && this.removeModule(codebase = n.getAttributes().getNamedItem("codenamebase").getNodeValue())) {
                        doc.getDocumentElement().removeChild(n);
                    }
                    ++i;
                }
                OutputStream os = f.getOutputStream(lock);
                try {
                    XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                    Object var13_15 = null;
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    os.close();
                    throw throwable;
                }
                os.close();
                Object var15_18 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                lock.releaseLock();
                throw throwable;
            }
            lock.releaseLock();
            return f;
        }
        return FileUtil.copyFile((FileObject)src, (FileObject)trg, (String)newName);
    }

    private boolean removeModule(String codebase) {
        int i = 0;
        while (i < nonCopiedModules.length) {
            if (codebase.equals(nonCopiedModules[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void copyAttributes(FileObject source, FileObject dest) throws IOException {
        Enumeration attrKeys = source.getAttributes();
        while (attrKeys.hasMoreElements()) {
            String key = (String)attrKeys.nextElement();
            Object value = source.getAttribute(key);
            if (value == null) continue;
            dest.setAttribute(key, value);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canCopy(FileObject fo, Object[] filter, long basicTime) throws IOException {
        boolean tag2;
        boolean tag1;
        block12: {
            Object[] nonCopiedFiles = (String[])filter[0];
            String[] wildcards = (String[])filter[1];
            String name = fo.getPath();
            if (fo.isFolder()) {
                if (Arrays.binarySearch(nonCopiedFiles, name + "/*") >= 0) return false;
                return true;
            }
            int i = 0;
            while (true) {
                if (i >= wildcards.length) break;
                if (name.endsWith(wildcards[i])) {
                    return false;
                }
                ++i;
            }
            long time = fo.lastModified().getTime();
            if (Arrays.binarySearch(nonCopiedFiles, name) >= 0) return false;
            if (basicTime + 100000L > time) return false;
            boolean bl = true;
            boolean canCopy = bl;
            if (!canCopy) {
                return false;
            }
            if (!fo.getExt().equals("settings")) return true;
            tag1 = false;
            tag2 = false;
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                    while (null != (line = reader.readLine())) {
                        void var15_13;
                        if (var15_13.indexOf("<module name=") != -1) {
                            if (var15_13.indexOf("<module name=\"org.netbeans.modules.java/1\"") == -1) break;
                            tag1 = true;
                        }
                        if (var15_13.indexOf("<serialdata class=") == -1) continue;
                        if (var15_13.indexOf("<serialdata class=\"org.netbeans.modules.java.FastJavacCompilerType\">") == -1) break;
                        tag2 = true;
                        if (!tag1) continue;
                        break;
                    }
                }
                catch (IOException ex) {
                    Object var17_16 = null;
                    if (reader != null) {
                        reader.close();
                    }
                    break block12;
                }
                Object var17_15 = null;
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
        }
        if (!tag1) return true;
        if (!tag2) return true;
        return false;
    }

    private long getLastModified(File sourceDirFile) {
        long basicTime = sourceDirFile.lastModified();
        long lastModified = 0L;
        File f = new File(sourceDirFile, CopyUtil.getString("CTL_README"));
        if (f.exists()) {
            lastModified = f.lastModified();
            if (lastModified < basicTime) {
                basicTime = lastModified;
            }
        } else {
            this.message(CopyUtil.getString("MSG_NOT_FOUNDED", f.getPath()));
        }
        if ((f = new File(new File(sourceDirFile, "beans"), "TimerBean.jar")).exists()) {
            lastModified = f.lastModified();
            if (lastModified < basicTime) {
                basicTime = lastModified;
            }
        } else {
            this.message(CopyUtil.getString("MSG_NOT_FOUNDED", f.getPath()));
        }
        return lastModified;
    }

    private Object[] originalFiles(String filterCfg) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader((class$org$netbeans$core$upgrade$FileCopy == null ? (class$org$netbeans$core$upgrade$FileCopy = CopyUtil.class$("org.netbeans.core.upgrade.FileCopy")) : class$org$netbeans$core$upgrade$FileCopy).getResourceAsStream(filterCfg)));
        String line = null;
        Vector<String> fileNames = new Vector<String>();
        Vector<String> fileWildcards = new Vector<String>();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("./")) {
                line = line.substring(2);
            } else if (line.startsWith("**/")) {
                fileWildcards.add(line.substring(3));
                continue;
            }
            fileNames.add(line);
        }
        String[] wildcards = fileWildcards.toArray(new String[fileWildcards.size()]);
        Object[] files = new String[fileNames.size()];
        fileNames.copyInto(files);
        Arrays.sort(files);
        return new Object[]{files, wildcards};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteAll(FileObject root) {
        FileObject[] children = root.getChildren();
        int i = 0;
        while (true) {
            block10: {
                if (i >= children.length) {
                    return;
                }
                FileObject fo = children[i];
                FileLock lock = null;
                if (!fo.getNameExt().equals("ide.log")) {
                    Object var8_7;
                    if (fo.isFolder()) {
                        this.deleteAll(fo);
                    }
                    try {
                        try {
                            lock = fo.lock();
                            fo.delete(lock);
                        }
                        catch (IOException e) {
                            System.out.println("FileObject " + fo.getPath() + " couldn't be deleted.");
                            var8_7 = null;
                            if (null != lock) {
                                lock.releaseLock();
                            }
                            break block10;
                        }
                        var8_7 = null;
                        if (null == lock) break block10;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        if (null != lock) {
                            lock.releaseLock();
                        }
                        throw throwable;
                    }
                    lock.releaseLock();
                }
            }
            ++i;
        }
    }

    public static String getIdeVersion(File dir) {
        String version = null;
        String dirType = null;
        String branding = null;
        File libDir = new File(dir, "lib");
        File coreJar = new File(libDir, "core.jar");
        if (!coreJar.exists()) {
            coreJar = new File(libDir, "developer.jar");
        } else {
            branding = CopyUtil.getBranding(coreJar);
            if (null != branding) {
                File tmp = new File(libDir, "locale/core_" + branding + ".jar");
                coreJar = tmp.exists() ? tmp : coreJar;
            }
        }
        try {
            if (coreJar.exists()) {
                dirType = DIRTYPE_INST;
                String bundleName = branding == null ? "org/netbeans/core/Bundle.properties" : "org/netbeans/core/Bundle_" + branding + ".properties";
                JarFile jar = new JarFile(coreJar);
                JarEntry entry = jar.getJarEntry(bundleName);
                BufferedReader r = new BufferedReader(new InputStreamReader(jar.getInputStream(entry)));
                version = CopyUtil.readIdeVersion(r, "currentVersion", false);
                r.close();
            } else {
                File ideLog = new File(dir, "system/ide.log");
                if (ideLog.exists()) {
                    dirType = DIRTYPE_USER;
                    BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(ideLog)));
                    version = CopyUtil.readIdeVersion(r, "Product Version", true);
                    r.close();
                }
            }
        }
        catch (IOException e) {
            version = null;
        }
        if (version != null) {
            int ver = CopyUtil.getIdeVersion(version);
            version = ver == -1 ? null : versions[ver] + " - " + dirType;
        }
        return version;
    }

    public static boolean canUpgradeFrom(String versionDescription) {
        return !ffj20IE.equals(versionDescription) || CopyUtil.isForte();
    }

    private static String readIdeVersion(BufferedReader reader, String key, boolean useLast) throws IOException {
        String line = null;
        String version = null;
        while ((line = reader.readLine()) != null) {
            String k;
            int idx = line.indexOf(61);
            if (idx == -1 || !(k = line.substring(0, idx).trim()).equals(key)) continue;
            version = line.substring(idx + 1).trim();
            if (!useLast) break;
        }
        return version;
    }

    private static String getBranding(File orig) {
        File brandingFile = new File(orig.getParentFile(), "branding");
        String branding = null;
        if (brandingFile.exists()) {
            try {
                BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(brandingFile)));
                branding = r.readLine();
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return branding;
    }

    private static int getIdeVersion(String versionDescription) {
        int i = 0;
        while (i < versions.length) {
            if (versionDescription.startsWith(versions[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean isForte() {
        String b = NbBundle.getBranding();
        return b != null && b.startsWith("f4j_");
    }

    protected static String getString(String key) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$CopyUtil == null ? (class$org$netbeans$core$upgrade$CopyUtil = CopyUtil.class$("org.netbeans.core.upgrade.CopyUtil")) : class$org$netbeans$core$upgrade$CopyUtil), (String)key);
    }

    protected static String getString(String key, String param) {
        return NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$CopyUtil == null ? (class$org$netbeans$core$upgrade$CopyUtil = CopyUtil.class$("org.netbeans.core.upgrade.CopyUtil")) : class$org$netbeans$core$upgrade$CopyUtil), (String)key, (Object)param);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ffj20IE = "Forte(tm) for Java(tm), release 2.0, Internet Edition";
        ffj30EE = "Forte for Java, EE v. 3.0";
        userdirNonCpFiles = "userdir.cfg";
        nonCopiedModules = new String[]{"org.netbeans.modules.corba", "org.netbeans.modules.corba.idl.editor"};
        if (CopyUtil.isForte()) {
            versions = new String[]{"NetBeans IDE v3.0", "Forte(tm) for Java(tm), release 2.0, Community Edition", "Forte for Java, CE v. 3.0", ffj20IE, ffj30EE, "Forte for Java 4, Community Edition", "Forte for Java 4, Enterprise Edition", "Sun ONE Studio 4 update 1, Community Edition", "Sun ONE Studio 4 update 1, Enterprise Edition", "NetBeans IDE 3.1", "NetBeans IDE 3.2", "NetBeans IDE, Release 3.3", "NetBeans IDE Version 3.3", "NetBeans IDE 3.3", "NetBeans IDE 3.4", "NetBeans IDE, Development Version", "NetBeans IDE Development Version"};
            nonCpFiles = new String[]{"netbeans30.cfg", "forte4j20CE.cfg", "nbdev.cfg", "forte4j20IE.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "netbeans31.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg"};
        } else {
            versions = new String[]{"NetBeans IDE v3.0", "Forte(tm) for Java(tm), release 2.0, Community Edition", "Forte for Java, CE v. 3.0", "Forte for Java 4, Community Edition", "Sun ONE Studio 4 update 1, Community Edition", "NetBeans IDE 3.1", "NetBeans IDE 3.2", "NetBeans IDE, Release 3.3", "NetBeans IDE Version 3.3", "NetBeans IDE 3.3", "NetBeans IDE 3.4", "NetBeans IDE, Development Version", "NetBeans IDE Development Version"};
            nonCpFiles = new String[]{"netbeans30.cfg", "forte4j20CE.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "netbeans31.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg", "nbdev.cfg"};
        }
    }

    private static class AttrslessLocalFileSystem
    extends AbstractFileSystem
    implements AbstractFileSystem.Attr {
        public AttrslessLocalFileSystem(LocalFileSystem fs) {
            this.change = new LocalFileSystem.Impl(fs);
            this.info = (AbstractFileSystem.Info)this.change;
            this.list = (AbstractFileSystem.List)this.change;
            this.attr = this;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getDisplayName() {
            return ((Object)((Object)this)).getClass().toString();
        }

        public void deleteAttributes(String name) {
        }

        public Enumeration attributes(String name) {
            return EmptyEnumeration.EMPTY;
        }

        public void renameAttributes(String oldName, String newName) {
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
        }

        public Object readAttribute(String name, String attrName) {
            return null;
        }
    }
}

