/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import org.netbeans.core.upgrade.CopyUtil;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;

final class FileCopy
extends CopyUtil {
    FileCopy() {
    }

    protected void message(String msg) {
        System.out.println(msg);
    }

    protected void progress(int current, int max) {
        System.out.print(".");
        if (current == max) {
            System.out.println();
        }
    }

    private static FileSystem getBackup(String backupDir) throws IOException, PropertyVetoException {
        File backupFile = new File(backupDir);
        if (backupFile.exists()) {
            if (!backupFile.isDirectory()) {
                System.out.println(CopyUtil.getString("MSG_BACKUP_EXISTS"));
                return null;
            }
            if (backupFile.list().length > 0) {
                System.out.println(CopyUtil.getString("MSG_NO_BACKUP_EMPTY"));
                return null;
            }
        } else if (!backupFile.mkdirs()) {
            System.out.println(CopyUtil.getString("MSG_NO_BACKUP_CREATED"));
            return null;
        }
        LocalFileSystem fs = new LocalFileSystem();
        fs.setRootDirectory(backupFile);
        return fs;
    }

    public static void main(String[] args) {
        System.out.println(CopyUtil.getString("MSG_TITLE"));
        try {
            if (args.length >= 2) {
                File targetDir;
                File sourceDir;
                if (args.length == 2) {
                    sourceDir = new File(args[0]);
                    targetDir = new File(args[1]);
                } else {
                    File backupDir = new File(args[0]);
                    sourceDir = new File(args[1]);
                    targetDir = new File(args[2]);
                }
                FileCopy copy = new FileCopy();
                copy.upgradeIde(CopyUtil.getIdeVersion(sourceDir), sourceDir, targetDir);
            } else {
                String scriptName = System.getProperty("os.name").startsWith("Windows") ? "CTL_WINDOWS_SCRIPT" : "CTL_UNIX_SCRIPT";
                scriptName = CopyUtil.getString(scriptName);
                System.out.println(CopyUtil.getString("MSG_COMMAND_LINE", scriptName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

