/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.upgrade.InternalCopy;
import org.netbeans.core.upgrade.TransferSettingsWizardPanel;
import org.netbeans.core.upgrade.UpgradeProcessListener;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

final class TransferSettingsPanel
extends JPanel
implements UpgradeProcessListener,
PropertyChangeListener {
    private Object lock = new Object();
    private JTextArea txtStatusSummary;
    private JProgressBar pbarProgress;
    private JLabel jLabel1;
    private JLabel lblStatus;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_FINISHED = 2;
    public static final int STATUS_ERRORS = 3;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$upgrade$TransferSettingsPanel == null ? (class$org$netbeans$core$upgrade$TransferSettingsPanel = TransferSettingsPanel.class$("org.netbeans.core.upgrade.TransferSettingsPanel")) : class$org$netbeans$core$upgrade$TransferSettingsPanel));
    private ArrayList changeListeners = new ArrayList(1);
    private LinkedList log = new LinkedList();
    private int progress = 0;
    private InternalCopy upgrader = null;
    private UpgradeWizardSettings settings = new UpgradeWizardSettings();
    private Timer tmr;
    private int status = 0;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$TransferSettingsPanel;

    public TransferSettingsPanel() {
        this.initComponents();
        this.pbarProgress.setMinimum(0);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TransferSettingsPanel"));
        this.txtStatusSummary.getAccessibleContext().setAccessibleName(bundle.getString("ACS_txtUpgrade2_Bottom_Name"));
        this.txtStatusSummary.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtUpgrade2_Bottom_Desc"));
        this.upgrader = new InternalCopy();
        this.upgrader.addUpgradeProcessListener(this);
    }

    public int getStatus() {
        int ret;
        Object object = this.lock;
        synchronized (object) {
            ret = this.status;
        }
        return ret;
    }

    private void setStatus(int status) {
        Object object = this.lock;
        synchronized (object) {
            this.status = status;
        }
    }

    public void start() {
        this.setStatus(1);
        this.log.clear();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferSettingsPanel.this.progress = 0;
                TransferSettingsPanel.this.pbarProgress.setMaximum(1000);
                TransferSettingsPanel.this.lblStatus.setText(bundle.getString("MSG_Upgrade_Started"));
            }
        });
    }

    public void message(String msg) {
        this.log.add(msg);
    }

    public void done(final boolean status) {
        this.setStatus(status ? 2 : 3);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StringBuffer sum = new StringBuffer();
                TransferSettingsPanel.this.pbarProgress.setValue(1000);
                TransferSettingsPanel.this.lblStatus.setText(bundle.getString("MSG_Upgrade_Finished"));
                if (status) {
                    sum.append(bundle.getString("MSG_Upgrade_Succeeded"));
                } else {
                    Iterator i = TransferSettingsPanel.this.log.iterator();
                    while (i.hasNext()) {
                        String s = (String)i.next();
                        sum.append(s);
                        sum.append("\n");
                    }
                    sum.append("\n\n");
                    sum.append(bundle.getString("MSG_Upgrade_Failed"));
                }
                TransferSettingsPanel.this.txtStatusSummary.setText(sum.toString());
                TransferSettingsPanel.this.fireStateChanged();
            }
        });
    }

    public void progress(int current, int max) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferSettingsPanel.this.progress++;
                TransferSettingsPanel.this.pbarProgress.setValue((int)(980.0 - 980.0 / (double)TransferSettingsPanel.this.progress));
            }
        });
    }

    boolean isValidForFinish() {
        return 2 == this.getStatus() || 3 == this.getStatus();
    }

    void storeSettings(Object settings) {
        ((UpgradeWizardSettings)settings).read(this.settings);
    }

    void readSettings(Object settings) {
        this.settings.read((UpgradeWizardSettings)settings);
    }

    void removeChangeListener(ChangeListener l) {
        ((AbstractCollection)this.changeListeners).remove(l);
    }

    void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if ("WizardPanel_selected".equals(ev.getPropertyName()) && ev.getNewValue() instanceof TransferSettingsWizardPanel) {
            this.tmr = new Timer();
            this.tmr.schedule((TimerTask)new UpgradeStarter(this), 200L);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.lblStatus = new JLabel();
        this.pbarProgress = new JProgressBar();
        this.txtStatusSummary = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(550, 350));
        this.setName(bundle.getString("LBL_TransferSettingsPanel_Name"));
        this.setMinimumSize(new Dimension(500, 279));
        this.jLabel1.setText(bundle.getString("LBL_lblUpgradeStatus"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.lblStatus.setText("...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.lblStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pbarProgress, gridBagConstraints);
        this.txtStatusSummary.setWrapStyleWord(true);
        this.txtStatusSummary.setToolTipText(bundle.getString("ACS_txtUpgrade2_Bottom_Desc"));
        this.txtStatusSummary.setLineWrap(true);
        this.txtStatusSummary.setEditable(false);
        this.txtStatusSummary.setForeground(this.lblStatus.getForeground());
        this.txtStatusSummary.setBackground(this.lblStatus.getBackground());
        this.txtStatusSummary.setDisabledTextColor(this.lblStatus.getForeground());
        this.txtStatusSummary.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.txtStatusSummary, gridBagConstraints);
    }

    private void fireStateChanged() {
        int i = 0;
        while (i < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.get(i)).stateChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void notify(String message, int type) {
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)message, type);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ UpgradeWizardSettings access$900(TransferSettingsPanel x0) {
        return x0.settings;
    }

    static /* synthetic */ InternalCopy access$1000(TransferSettingsPanel x0) {
        return x0.upgrader;
    }

    private class UpgradeStarter
    extends TimerTask {
        private TransferSettingsPanel panel;

        public UpgradeStarter(TransferSettingsPanel p) {
            this.panel = p;
        }

        public void run() {
            TransferSettingsPanel.this.tmr.cancel();
            TransferSettingsPanel.this.tmr = null;
            Thread t = new Thread(this){
                private final /* synthetic */ UpgradeStarter this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    File userdir = new File(System.getProperty("netbeans.user", ""));
                    TransferSettingsPanel.access$1000(UpgradeStarter.access$800(this.this$1)).upgrade(TransferSettingsPanel.access$900(UpgradeStarter.access$800(this.this$1)).getIDEVersion(), TransferSettingsPanel.access$900(UpgradeStarter.access$800(this.this$1)).getIDELocation(), userdir);
                    Repository.getDefault().getDefaultFileSystem().refresh(false);
                }
            };
            t.start();
        }

        static /* synthetic */ TransferSettingsPanel access$800(UpgradeStarter x0) {
            return x0.TransferSettingsPanel.this;
        }
    }
}

