/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.upgrade.CopyUtil;
import org.netbeans.core.upgrade.FSChooser;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class UpgradePanel
extends JPanel {
    private JTextArea txtVersions;
    private JButton cmdSelectDir;
    private JTextArea txtLabelTop;
    private JPanel pnlUpgrade;
    private JLabel lblLocation;
    private JTextField txtVersion;
    private JTextField txtLocation;
    private JTextArea txtNote;
    private JLabel lblVersion;
    private File lastLocation = null;
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$upgrade$UpgradePanel == null ? (class$org$netbeans$core$upgrade$UpgradePanel = UpgradePanel.class$("org.netbeans.core.upgrade.UpgradePanel")) : class$org$netbeans$core$upgrade$UpgradePanel));
    private ArrayList changeListeners = new ArrayList(1);
    private UpgradeWizardSettings settings = new UpgradeWizardSettings();
    static /* synthetic */ Class class$org$netbeans$core$upgrade$UpgradePanel;

    public static void main(String[] args) {
        DialogDescriptor descriptor = new DialogDescriptor((Object)new UpgradePanel(), bundle.getString("LBL_UpgradePanel_Name"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.show();
        dialog.dispose();
    }

    public UpgradePanel() {
        this.initComponents();
        this.initAccessibility();
    }

    boolean isValidForFinish() {
        return null != this.settings.getIDELocation();
    }

    void storeSettings(Object settings) {
        ((UpgradeWizardSettings)settings).read(this.settings);
    }

    void readSettings(Object settings) {
        this.settings.read((UpgradeWizardSettings)settings);
    }

    void removeChangeListener(ChangeListener l) {
        ((AbstractCollection)this.changeListeners).remove(l);
    }

    void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    private void initAccessibility() {
        this.txtVersion.selectAll();
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Upgrade_Description_Top"));
        this.lblLocation.setDisplayedMnemonic(bundle.getString("LBL_lblLocation_Mnem").charAt(0));
        this.txtLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtLocation"));
        this.txtVersion.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_txtVersion"));
        this.cmdSelectDir.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_cmdSelectDir"));
        this.cmdSelectDir.setMnemonic(bundle.getString("LBL_cmdSelectDir_Mnem").charAt(0));
    }

    private void initComponents() {
        this.pnlUpgrade = new JPanel();
        this.lblLocation = new JLabel();
        this.txtLocation = new JTextField();
        this.cmdSelectDir = new JButton();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.txtLabelTop = new JTextArea();
        this.txtVersions = new JTextArea();
        this.txtNote = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(123456, 123456));
        this.setMinimumSize(new Dimension(500, 279));
        this.setName(bundle.getString("LBL_UpgradePanel_Name"));
        this.setPreferredSize(new Dimension(580, 380));
        this.pnlUpgrade.setLayout(new GridBagLayout());
        this.lblLocation.setLabelFor(this.txtLocation);
        this.lblLocation.setText(bundle.getString("LBL_lblLocation"));
        this.lblLocation.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.pnlUpgrade.add((Component)this.lblLocation, gridBagConstraints);
        this.txtLocation.setDisabledTextColor(Color.black);
        this.txtLocation.setBorder(new EtchedBorder());
        this.txtLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpgradePanel.this.txtLocationActionPerformed(evt);
            }
        });
        this.txtLocation.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                UpgradePanel.this.txtLocationKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.txtLocation, gridBagConstraints);
        this.cmdSelectDir.setText(bundle.getString("LBL_cmdSelectDir"));
        this.cmdSelectDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                UpgradePanel.this.cmdSelectDirActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.cmdSelectDir, gridBagConstraints);
        this.lblVersion.setLabelFor(this.txtVersion);
        this.lblVersion.setText(bundle.getString("LBL_lblVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.pnlUpgrade.add((Component)this.lblVersion, gridBagConstraints);
        this.txtVersion.setEditable(false);
        this.txtVersion.setDisabledTextColor(Color.black);
        this.txtVersion.setBorder(new EtchedBorder());
        this.txtVersion.setEnabled(false);
        this.txtVersion.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                UpgradePanel.this.txtVersionFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.pnlUpgrade.add((Component)this.txtVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlUpgrade, gridBagConstraints);
        this.txtLabelTop.setWrapStyleWord(true);
        this.txtLabelTop.setLineWrap(true);
        this.txtLabelTop.setFont(this.lblLocation.getFont());
        this.txtLabelTop.setText(bundle.getString("LBL_Upgrade_Description_Top"));
        this.txtLabelTop.setDisabledTextColor(this.lblLocation.getForeground());
        this.txtLabelTop.setDoubleBuffered(true);
        this.txtLabelTop.setEnabled(false);
        this.txtLabelTop.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.txtLabelTop, gridBagConstraints);
        this.txtVersions.setFont(this.lblLocation.getFont());
        this.txtVersions.setLineWrap(true);
        this.txtVersions.setText(bundle.getString("LBL_Upgrade_Description_Versions"));
        this.txtVersions.setWrapStyleWord(true);
        this.txtVersions.setDisabledTextColor(this.lblLocation.getForeground());
        this.txtVersions.setDoubleBuffered(true);
        this.txtVersions.setEnabled(false);
        this.txtVersions.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 24, 12, 0);
        this.add((Component)this.txtVersions, gridBagConstraints);
        this.txtNote.setFont(this.lblLocation.getFont());
        this.txtNote.setLineWrap(true);
        this.txtNote.setText(bundle.getString("LBL_Upgrade_Description_Note"));
        this.txtNote.setWrapStyleWord(true);
        this.txtNote.setDisabledTextColor(this.lblLocation.getForeground());
        this.txtNote.setDoubleBuffered(true);
        this.txtNote.setEnabled(false);
        this.txtNote.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.txtNote, gridBagConstraints);
    }

    private void txtVersionFocusGained(FocusEvent evt) {
        this.txtVersion.selectAll();
    }

    private void txtLocationKeyTyped(KeyEvent evt) {
        final UpgradePanel panel = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UpgradePanel.this.lastLocation = new File(UpgradePanel.this.txtLocation.getText());
                panel.checkLocation(UpgradePanel.this.lastLocation);
            }
        });
    }

    private void txtLocationActionPerformed(ActionEvent evt) {
        this.lastLocation = new File(this.txtLocation.getText());
        this.checkLocation(this.lastLocation);
    }

    private void cmdSelectDirActionPerformed(ActionEvent evt) {
        FSChooser chooser = new FSChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(bundle.getString("LBL_SelectDir_Dialog_Title"));
        chooser.setFileHidingEnabled(false);
        if (this.lastLocation != null) {
            chooser.setCurrentDirectory(this.lastLocation);
        }
        if (Utilities.showJFileChooser((JFileChooser)chooser, (Component)this, (String)bundle.getString("LBL_Open_Button")) == 0) {
            this.lastLocation = chooser.getSelectedFile();
            this.txtLocation.setText(this.lastLocation.getAbsolutePath());
            if (!this.checkLocation(this.lastLocation)) {
                this.notify(bundle.getString("MSG_Old_IDE_Location_Invalid"), 0);
            }
        }
    }

    private boolean checkLocation(File oldIde) {
        String ideVer = CopyUtil.getIdeVersion(oldIde);
        if (null != ideVer) {
            this.settings.setIDELocation(oldIde);
            this.settings.setIDEVersion(ideVer);
            this.txtVersion.setText(ideVer);
        } else {
            this.settings.setIDELocation(null);
            this.settings.setIDEVersion(null);
            this.txtVersion.setText("");
        }
        this.fireStateChanged();
        return null != ideVer;
    }

    private void fireStateChanged() {
        int i = 0;
        while (i < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.get(i)).stateChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void notify(String message, int type) {
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)message, type);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    UpgradeWizardSettings getSettings() {
        return this.settings;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

