/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.JButton;
import org.netbeans.core.Splash;
import org.netbeans.core.upgrade.CopyUtil;
import org.netbeans.core.upgrade.NewUserWizardPanel;
import org.netbeans.core.upgrade.PreUpgradeWizardPanel;
import org.netbeans.core.upgrade.TransferSettingsWizardPanel;
import org.netbeans.core.upgrade.UpgradeWizardPanel;
import org.netbeans.core.upgrade.UpgradeWizardSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.NbBundle;

public final class UpgradeWizard
implements PropertyChangeListener {
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    static final String PROP_CONTENT_PANEL_SELECTED = "WizardPanel_selected";
    private JButton startIdeButton = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Start_IDE"));
    private JButton exitIdeButton;
    private JButton importButton;
    private FinalNoBackIterator it = null;
    private PrivateWizardDescriptor wd = null;
    private boolean cancelOnClose = true;
    private UpgradeWizardSettings uwSettings = null;
    static /* synthetic */ Class class$org$netbeans$core$upgrade$UpgradeWizard;

    private UpgradeWizard() {
        this.startIdeButton.setDefaultCapable(true);
        this.startIdeButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Start_IDE_Mnem").toCharArray()[0]);
        this.exitIdeButton = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Exit_IDE"));
        this.exitIdeButton.setDefaultCapable(false);
        this.exitIdeButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Exit_IDE_Mnem").toCharArray()[0]);
        this.importButton = new JButton(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Import"));
        this.importButton.setDefaultCapable(true);
        this.importButton.setMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"BTN_Import_Mnem").toCharArray()[0]);
    }

    private boolean show(Splash.SplashOutput splash) {
        boolean result;
        this.uwSettings = UpgradeWizardSettings.getInstance();
        if (null == this.uwSettings.getIDEVersion() || null == this.uwSettings.getIDELocation()) {
            if (splash != null) {
                Splash.hideSplash((Splash.SplashOutput)splash);
            }
            result = this.showInteractive();
        } else {
            result = CopyUtil.canUpgradeFrom(this.uwSettings.getIDEVersion()) ? this.showAutomatic() : false;
        }
        return result;
    }

    private boolean showInteractive() {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new NewUserWizardPanel(), new PreUpgradeWizardPanel(), new UpgradeWizardPanel(), new TransferSettingsWizardPanel()};
        Object[] options = new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, this.startIdeButton, this.exitIdeButton};
        return this.show_internal(options, panels);
    }

    private boolean showAutomatic() {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new TransferSettingsWizardPanel()};
        Object[] options = new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, this.startIdeButton};
        return this.show_internal(options, panels);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean show_internal(Object[] options, WizardDescriptor.Panel[] panels) {
        TransferSettingsWizardPanel transPanel = (TransferSettingsWizardPanel)panels[panels.length - 1];
        boolean hidden = 1 == panels.length;
        this.it = new FinalNoBackIterator(panels);
        this.wd = new PrivateWizardDescriptor((WizardDescriptor.Iterator)this.it, this.uwSettings);
        this.it.addPropertyChangeListener(this);
        this.it.addPropertyChangeListener(transPanel.getPanelUI());
        this.wd.putProperty(PROP_AUTO_WIZARD_STYLE, Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_DISPLAYED, Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_NUMBERED, Boolean.TRUE);
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"LBL_UpgradeWizard_Title"));
        this.wd.putProperty(PROP_CONTENT_DATA, this.it.getContentData());
        this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.it.getContentSelectedIndex()));
        this.wd.setOptions(options);
        this.wd.setClosingOptions(new Object[]{this.startIdeButton, this.exitIdeButton});
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UpgradeWizard.this.it.nextPanel();
                UpgradeWizard.this.wd.updateState();
            }
        };
        this.importButton.addActionListener(al);
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
        if (hidden) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$core$upgrade$UpgradeWizard == null ? (class$org$netbeans$core$upgrade$UpgradeWizard = UpgradeWizard.class$("org.netbeans.core.upgrade.UpgradeWizard")) : class$org$netbeans$core$upgrade$UpgradeWizard), (String)"MSG_SplashScreen_status"));
            this.it.hasNext();
            try {
                while (0 == transPanel.getPanelUI().getStatus() || 1 == transPanel.getPanelUI().getStatus()) {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                hidden = 2 == transPanel.getPanelUI().getStatus();
            }
            catch (InterruptedException e) {
                hidden = false;
            }
        }
        if (!hidden) {
            d.show();
        }
        d.dispose();
        this.importButton.removeActionListener(al);
        this.it.removePropertyChangeListener(this);
        this.it.removePropertyChangeListener(transPanel.getPanelUI());
        if (this.wd.getValue() == NotifyDescriptor.CANCEL_OPTION) return true;
        if (this.wd.getValue() == this.exitIdeButton) return true;
        if (!this.cancelOnClose) return false;
        if (this.wd.getValue() != NotifyDescriptor.CLOSED_OPTION) return false;
        return true;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (PROP_CONTENT_SELECTED_INDEX.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(this.it.getContentSelectedIndex()));
        } else if (PROP_CONTENT_DATA.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_DATA, this.it.getContentData());
        } else if (PROP_CONTENT_PANEL_SELECTED.equals(ev.getPropertyName())) {
            if (ev.getNewValue() instanceof TransferSettingsWizardPanel) {
                this.cancelOnClose = false;
                this.wd.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, this.startIdeButton});
            } else if (ev.getNewValue() instanceof UpgradeWizardPanel) {
                this.cancelOnClose = true;
                this.wd.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, this.importButton, this.startIdeButton, this.exitIdeButton});
            } else {
                this.cancelOnClose = true;
                this.wd.setOptions(new Object[]{WizardDescriptor.PREVIOUS_OPTION, WizardDescriptor.NEXT_OPTION, this.startIdeButton, this.exitIdeButton});
            }
        }
    }

    public static boolean showWizard(Splash.SplashOutput splash) {
        UpgradeWizard f;
        boolean status = false;
        LocalFileSystem fs = new LocalFileSystem();
        try {
            fs.setRootDirectory(new File(System.getProperty("netbeans.user", "")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FileObject foProjectLast = fs.findResource("system/project.last");
        FileObject foImported = fs.findResource("system/.imported");
        if (null == foProjectLast && foImported == null && !(status = (f = new UpgradeWizard()).show(splash))) {
            try {
                fs.findResource("system").createData(".imported");
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return status;
    }

    public static void main(String[] args) {
        UpgradeWizard uw = new UpgradeWizard();
        uw.show(null);
        System.out.println("exit");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PrivateWizardDescriptor
    extends WizardDescriptor {
        WizardDescriptor.Iterator it;

        public PrivateWizardDescriptor(WizardDescriptor.Iterator panels, Object settings) {
            super(panels, settings);
            this.it = panels;
        }

        protected void updateState() {
            super.updateState();
            if (this.it.hasNext()) {
                UpgradeWizard.this.startIdeButton.setEnabled(false);
            } else {
                UpgradeWizard.this.startIdeButton.setEnabled(this.it.current().isValid());
            }
            UpgradeWizard.this.importButton.setEnabled(this.it.current().isValid());
        }
    }

    public static interface ExtendedPanel {
        public boolean hasNext();

        public boolean hasPrevious();
    }

    private class FinalNoBackIterator
    extends WizardDescriptor.ArrayIterator {
        private WizardDescriptor.Panel[] panels;
        private PropertyChangeSupport changeSupport;
        private boolean first = true;

        public FinalNoBackIterator(WizardDescriptor.Panel[] list) {
            super(list);
            this.panels = list;
        }

        public boolean hasPrevious() {
            this.checkFirst();
            int index = this.getContentSelectedIndex();
            boolean hasPrev = super.hasPrevious();
            if (hasPrev) {
                boolean bl = hasPrev = index < this.panels.length - 1;
            }
            if (hasPrev && this.panels[index] instanceof ExtendedPanel) {
                hasPrev = ((ExtendedPanel)this.panels[index]).hasPrevious();
            }
            return hasPrev;
        }

        public boolean hasNext() {
            this.checkFirst();
            int index = this.getContentSelectedIndex();
            boolean hasNext = super.hasNext();
            if (hasNext && this.panels[index] instanceof ExtendedPanel) {
                hasNext = ((ExtendedPanel)this.panels[index]).hasNext();
            }
            return hasNext;
        }

        public void previousPanel() {
            super.previousPanel();
            this.firePanelChangedEvent();
        }

        public void nextPanel() {
            super.nextPanel();
            this.firePanelChangedEvent();
        }

        public String[] getContentData() {
            String[] cData = new String[this.panels.length];
            int i = 0;
            while (i < this.panels.length) {
                cData[i] = this.panels[i].getComponent().getName();
                ++i;
            }
            return cData;
        }

        public int getContentSelectedIndex() {
            int i = 0;
            while (i < this.panels.length) {
                if (this.current() == this.panels[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            FinalNoBackIterator finalNoBackIterator = this;
            synchronized (finalNoBackIterator) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport((Object)this);
                }
            }
            this.changeSupport.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.changeSupport != null) {
                this.changeSupport.removePropertyChangeListener(l);
            }
        }

        private void checkFirst() {
            if (this.first) {
                this.first = false;
                this.firePanelChangedEvent();
            }
        }

        private void firePanelChangedEvent() {
            if (this.changeSupport == null) {
                return;
            }
            this.changeSupport.firePropertyChange(UpgradeWizard.PROP_CONTENT_SELECTED_INDEX, null, new Integer(this.getContentSelectedIndex()));
            this.changeSupport.firePropertyChange(UpgradeWizard.PROP_CONTENT_PANEL_SELECTED, null, this.current());
        }
    }
}

