/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.upgrade;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

final class UpgradeWizardSettings {
    private static final String UPGRADE_PROPERTIES = "upgrade.properties";
    private static final String PROP_VERSION = "VERSION";
    private static final String PROP_IDEDIR = "BACKUP_FOLDER";
    private File ideLocation = null;
    private String ideVersion = null;

    public UpgradeWizardSettings() {
    }

    public UpgradeWizardSettings(UpgradeWizardSettings settings) {
        this.read(settings);
    }

    public void read(UpgradeWizardSettings settings) {
        this.ideLocation = settings.getIDELocation();
        this.ideVersion = settings.getIDEVersion();
    }

    public File getIDELocation() {
        return this.ideLocation;
    }

    public void setIDELocation(File location) {
        this.ideLocation = location;
    }

    public String getIDEVersion() {
        return this.ideVersion;
    }

    public void setIDEVersion(String version) {
        this.ideVersion = version;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpgradeWizardSettings getInstance() {
        File upgProps = UpgradeWizardSettings.getUpgradeProperties();
        UpgradeWizardSettings sett = new UpgradeWizardSettings();
        if (null == upgProps) {
            return sett;
        }
        FileInputStream fis = null;
        Properties prop = new Properties();
        fis = new FileInputStream(upgProps);
        prop.load(fis);
        sett.setIDELocation(new File(prop.getProperty(PROP_IDEDIR, "")));
        sett.setIDEVersion(prop.getProperty(PROP_VERSION, ""));
        Object var5_5 = null;
        if (null == fis) return sett;
        try {
            fis.close();
            return sett;
        }
        catch (IOException e2) {}
        return sett;
        {
            catch (IOException e) {
                sett.setIDELocation(null);
                sett.setIDEVersion(null);
                Object var5_6 = null;
                if (null == fis) return sett;
                try {
                    fis.close();
                    return sett;
                }
                catch (IOException e2) {}
                return sett;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (null == fis) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static File getUpgradeProperties() {
        String nbhome = System.getProperty("netbeans.home");
        if (null == nbhome) {
            return null;
        }
        File upgProp = new File(nbhome, UPGRADE_PROPERTIES);
        if (!upgProp.exists()) {
            return null;
        }
        return upgProp;
    }
}

