/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JavaCompletion;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.modules.web.core.jsploader.CompilationClassLoader;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.core.jsploader.JspInfo;
import org.netbeans.modules.web.core.syntax.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.CompletionItem;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;

public class AttrSupports {

    public static class FilenameSupport
    extends AttributeValueSupport.Default {
        private int itemOffset;
        private int itemLength;

        public FilenameSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return new ArrayList();
        }

        public CompletionQuery.Result getResult(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            List res = this.completionResults(offset, sup, item, valuePart);
            return new CompletionQuery.DefaultResult(component, this.completionTitle(), res, this.itemOffset, this.itemLength);
        }

        private List completionResults(int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            List<CompletionItem.AttributeValue> res = new ArrayList();
            String path = "";
            String fileNamePart = valuePart;
            int lastSlash = valuePart.lastIndexOf(47);
            if (lastSlash == 0) {
                path = "/";
                fileNamePart = valuePart.substring(1);
            } else if (lastSlash > 0) {
                path = valuePart.substring(0, lastSlash);
                fileNamePart = lastSlash == valuePart.length() ? "" : valuePart.substring(lastSlash + 1);
            }
            try {
                FileObject orig = sup.getDataObject().getPrimaryFile();
                String ctxPath = JspCompileUtil.resolveRelativeURL((String)("/" + orig.getPath()), (String)path);
                ctxPath = ctxPath.substring(1);
                FileSystem fs = orig.getFileSystem();
                if (ctxPath.length() == 0) {
                    FileObject folder = fs.getRoot();
                    res = this.files(folder, fileNamePart);
                } else {
                    FileObject folder = fs.findResource(ctxPath);
                    if (folder != null) {
                        res = this.files(folder, fileNamePart);
                        if (!folder.isRoot()) {
                            res.add(new CompletionItem.AttributeValue(".."));
                        }
                    }
                }
            }
            catch (FileStateInvalidException ex) {
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            this.itemOffset = offset - valuePart.length() + lastSlash + 1;
            this.itemLength = fileNamePart.length();
            return res;
        }

        private List files(FileObject folder, String prefix) {
            ArrayList<CompletionItem.AttributeValue> res = new ArrayList<CompletionItem.AttributeValue>();
            Enumeration files = folder.getChildren(false);
            while (files.hasMoreElements()) {
                FileObject file = (FileObject)files.nextElement();
                String fname = file.getNameExt();
                if (!fname.startsWith(prefix)) continue;
                res.add(new CompletionItem.AttributeValue(file.getNameExt()));
            }
            return res;
        }
    }

    public static class TaglibURI
    extends AttributeValueSupport.Default {
        public TaglibURI() {
            super(false, "taglib", "uri");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> l = new ArrayList<String>();
            Map m = sup.getTagLibraryMappings();
            if (m != null) {
                Iterator it = m.keySet().iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    l.add(s);
                }
            }
            return l;
        }
    }

    public static class SetPropertyProperty
    extends GetSetPropertyProperty {
        public SetPropertyProperty() {
            super(true, "jsp:setProperty", "property");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            List l = this.possibleValues(sup, item, true);
            l.add(0, "*");
            return l;
        }
    }

    public static class GetPropertyProperty
    extends GetSetPropertyProperty {
        public GetPropertyProperty() {
            super(true, "jsp:getProperty", "property");
        }

        public List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return this.possibleValues(sup, item, false);
        }
    }

    public static abstract class GetSetPropertyProperty
    extends AttributeValueSupport.Default {
        public GetSetPropertyProperty(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item, boolean setter) {
            ArrayList<String> list = new ArrayList<String>();
            String namePropertyValue = (String)item.getAttributes().get("name");
            if (namePropertyValue != null) {
                String className = null;
                JspInfo.BeanData[] beanData = sup.getBeanData();
                int i = 0;
                while (i < beanData.length) {
                    if (beanData[i] != null && beanData[i].getId() != null && beanData[i].getId().equals(namePropertyValue)) {
                        className = beanData[i].getClassName();
                        break;
                    }
                    ++i;
                }
                if (className != null) {
                    try {
                        CompilationClassLoader cld = new CompilationClassLoader();
                        Class<?> beanClass = Class.forName(className, false, (ClassLoader)cld);
                        Introspector.flushFromCaches(beanClass);
                        BeanInfo benInfo = Introspector.getBeanInfo(beanClass);
                        PropertyDescriptor[] properties = benInfo.getPropertyDescriptors();
                        int j = 0;
                        while (j < properties.length) {
                            if (setter && properties[j].getWriteMethod() != null) {
                                list.add(properties[j].getName());
                            }
                            if (!setter && properties[j].getReadMethod() != null) {
                                list.add(properties[j].getName());
                            }
                            ++j;
                        }
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (IntrospectionException e) {
                        // empty catch block
                    }
                }
            }
            return list;
        }
    }

    public static class SetPropertyName
    extends GetSetPropertyName {
        public SetPropertyName() {
            super(true, "jsp:setProperty", "name");
        }
    }

    public static class GetPropertyName
    extends GetSetPropertyName {
        public GetPropertyName() {
            super(true, "jsp:getProperty", "name");
        }
    }

    public static class GetSetPropertyName
    extends AttributeValueSupport.Default {
        public GetSetPropertyName(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            JspInfo.BeanData[] beanData = sup.getBeanData();
            int i = 0;
            while (i < beanData.length) {
                list.add(beanData[i].getId());
                ++i;
            }
            return list;
        }
    }

    public static class PageImport
    extends PackageClassSupport {
        public PageImport() {
            super(false, "page", "import");
        }
    }

    public static class UseBeanClass
    extends PackageClassSupport {
        public UseBeanClass() {
            super(true, "jsp:useBean", "class");
        }
    }

    private static class PackageClassSupport
    extends AttributeValueSupport.Default {
        private int itemOffset;
        private int itemLength;

        public PackageClassSupport(boolean tag, String longName, String attrName) {
            super(tag, longName, attrName);
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            return new ArrayList();
        }

        public CompletionQuery.Result getResult(JTextComponent component, int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            List res = this.completionResults(offset, sup, item, valuePart);
            return new JavaCompletionQuery.JavaResult(component, res, this.completionTitle(), null, this.itemOffset, this.itemLength, 0);
        }

        private List completionResults(int offset, JspSyntaxSupport sup, SyntaxElement.TagDirective item, String valuePart) {
            JCFinder finder = JavaCompletion.getFinder();
            String pkgName = "";
            JCPackage pkg = null;
            String clsNamePart = valuePart;
            int lastDot = valuePart.lastIndexOf(46);
            if (lastDot >= 0) {
                pkgName = valuePart.substring(0, lastDot);
                pkg = finder.getExactPackage(pkgName);
                clsNamePart = lastDot == valuePart.length() ? "" : valuePart.substring(lastDot + 1);
            }
            this.itemOffset = offset - valuePart.length() + lastDot + 1;
            this.itemLength = clsNamePart.length();
            List res = finder.findPackages(valuePart, false, false);
            res.addAll(finder.findClasses(pkg, clsNamePart, false));
            return res;
        }
    }

    public static class UseBeanScope
    extends AttributeValueSupport.Default {
        public UseBeanScope() {
            super(true, "jsp:useBean", "scope");
        }

        protected List possibleValues(JspSyntaxSupport sup, SyntaxElement.TagDirective item) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("application");
            list.add("page");
            list.add("request");
            list.add("session");
            return list;
        }
    }
}

