/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;

class CompletionItem {
    CompletionItem() {
    }

    static class AttributeValue
    extends JspResultItem {
        AttributeValue(String text) {
            super(text, Color.red);
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText(), 0);
        }
    }

    static class Attribute
    extends JspResultItem {
        Attribute(String text) {
            super(text, Color.green.darker());
        }

        Attribute(TagAttributeInfo tai) {
            super(tai.getName(), tai.isRequired() ? Color.red : Color.green.darker());
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            if (shift) {
                return this.substituteText(c, offset, len, this.getItemText() + "=\"\"", 1);
            }
            return this.substituteText(c, offset, len, this.getItemText(), 0);
        }
    }

    static class Directive
    extends TagDirective {
        Directive(String text) {
            super(text);
        }

        public String getPaintText() {
            return "@" + this.getItemText();
        }
    }

    static class Tag
    extends TagDirective {
        Tag(String text) {
            super(text);
        }

        public String getPaintText() {
            return "<" + this.getItemText() + ">";
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(c, offset, len, this.getItemText() + " ", 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1) + ">", 0);
        }

        public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
            if (!this.getItemText().startsWith("/")) {
                return this.substituteText(c, offset, len, this.getItemText().substring(subLen), 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1, subLen), 0);
        }
    }

    static abstract class TagDirective
    extends JspResultItem {
        TagDirective(String text) {
            super(text, Color.blue);
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.substituteText(c, offset, len, this.getItemText() + " ", 0);
        }
    }

    static class PrefixTag
    extends JspResultItem {
        private TagInfo tagInfo;
        private boolean isEmpty = false;

        PrefixTag(String text) {
            super(text, Color.blue);
        }

        PrefixTag(String prefix, TagInfo ti) {
            super(prefix + ":" + ti.getTagName(), Color.blue);
            this.tagInfo = ti;
            if (this.tagInfo != null && this.tagInfo.getBodyContent().equalsIgnoreCase("EMPTY")) {
                this.isEmpty = true;
            }
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }

        public String getPaintText() {
            return "<" + this.getItemText() + (this.isEmpty ? "/>" : ">");
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            String suffix;
            String string = suffix = this.isEmpty ? "/>" : ">";
            if (!this.getItemText().startsWith("/")) {
                if (!shift) {
                    return this.substituteText(c, offset, len, this.getItemText(), 0);
                }
                boolean hasAttrs = true;
                if (this.tagInfo != null) {
                    TagAttributeInfo[] tAttrs = this.tagInfo.getAttributes();
                    boolean bl = tAttrs != null ? tAttrs.length > 0 : (hasAttrs = true);
                }
                if (hasAttrs) {
                    return this.substituteText(c, offset, len, this.getItemText() + " " + suffix, suffix.length());
                }
                return this.substituteText(c, offset, len, this.getItemText() + suffix, 0);
            }
            return this.substituteText(c, offset, len, this.getItemText().substring(1) + ">", 0);
        }
    }

    static class JspResultItem
    extends CompletionQuery.DefaultResultItem {
        static JLabel rubberStamp1 = new JLabel();

        public JspResultItem(String text, Color foreColor) {
            super(text, foreColor);
        }

        protected boolean substituteText(JTextComponent c, int offset, int len, String fill, int moveBack) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            try {
                doc.atomicLock();
                try {
                    doc.remove(offset, len);
                    doc.insertString(offset, fill, null);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    doc.atomicUnlock();
                    throw throwable;
                }
                doc.atomicUnlock();
                if (moveBack != 0) {
                    Caret caret = c.getCaret();
                    int dot = caret.getDot();
                    caret.setDot(dot - moveBack);
                }
            }
            catch (BadLocationException exc) {
                return false;
            }
            return true;
        }

        public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
            rubberStamp1.setText(" " + this.getPaintText());
            if (isSelected) {
                rubberStamp1.setBackground(list.getSelectionBackground());
                rubberStamp1.setForeground(list.getSelectionForeground());
            } else {
                rubberStamp1.setBackground(list.getBackground());
                rubberStamp1.setForeground(this.foreColor);
            }
            return rubberStamp1;
        }

        public String getPaintText() {
            return this.getItemText();
        }

        static {
            rubberStamp1.setOpaque(true);
        }
    }

    static class DelegatingResultItem
    implements CompletionQuery.ResultItem {
        CompletionQuery.Result result;
        int index;
        CompletionQuery.ResultItem resultItem;

        public DelegatingResultItem(CompletionQuery.Result result, int index) {
            this.result = result;
            this.index = index;
            this.resultItem = (CompletionQuery.ResultItem)result.getData().get(index);
        }

        public CompletionQuery.Result getResult() {
            return this.result;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
            return this.resultItem.substituteCommonText(c, offset, len, subLen);
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            return this.resultItem.substituteText(c, offset, len, shift);
        }

        public String getItemText() {
            return this.resultItem.getItemText();
        }

        public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
            return this.resultItem.getPaintComponent(list, isSelected, cellHasFocus);
        }

        public String toString() {
            if (this.resultItem instanceof JspResultItem) {
                return this.resultItem.toString();
            }
            return this.resultItem.getItemText();
        }
    }

    public static class DelegatingResult
    implements CompletionQuery.Result {
        private List data = new ArrayList();
        private String title;

        public DelegatingResult(String title) {
            this.title = title;
        }

        public void addResult(CompletionQuery.Result result) {
            if (result == null) {
                return;
            }
            List newData = result.getData();
            int i = 0;
            while (i < newData.size()) {
                this.data.add(new DelegatingResultItem(result, i));
                ++i;
            }
        }

        public List getData() {
            return this.data;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean substituteText(int dataIndex, boolean shift) {
            DelegatingResultItem item = (DelegatingResultItem)this.getData().get(dataIndex);
            return item.getResult().substituteText(item.getIndex(), shift);
        }

        public boolean substituteCommonText(int dataIndex) {
            DelegatingResultItem item = (DelegatingResultItem)this.getData().get(dataIndex);
            return item.getResult().substituteCommonText(item.getIndex());
        }
    }
}

