/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.Introspector;
import java.text.MessageFormat;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

class BeanPatternGenerator {
    private static final String THIS_QUALIFIER = "this.";
    private static final String TAB = "  ";
    private static final String TABx2 = "    ";
    private static final String TABx3 = "      ";

    BeanPatternGenerator() {
    }

    static String createFieldName(String base, boolean adjustName, boolean paramClash) {
        if (!adjustName) {
            if (!paramClash) {
                return base;
            }
            return THIS_QUALIFIER + base;
        }
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        return propertyStyle + base;
    }

    static String propertySetterBody(String name, Type type, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName) {
        return BeanPatternGenerator.propertySetterBody(name, type, bound, constrained, withSet, withSupport, supportName, vetoSupportName, true);
    }

    static String propertySetterBody(String name, Type type, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName, boolean adjustName) {
        StringBuffer setterBody = new StringBuffer(200);
        String decoratedName = BeanPatternGenerator.createFieldName(name, adjustName, true);
        setterBody.append("\n");
        if (withSupport) {
            setterBody.append(TAB + type.toString());
            setterBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            setterBody.append(" = ").append(decoratedName).append(";\n");
            if (constrained) {
                setterBody.append(TAB + vetoSupportName).append(".fireVetoableChange(\"").append(name).append("\", ");
                if (type.isPrimitive()) {
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append("), ");
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append(name).append("));\n");
                } else {
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append(", ").append(name).append(");\n");
                }
                if (!bound) {
                    setterBody.append(TAB).append(decoratedName);
                    setterBody.append(" = ").append(name).append(";\n");
                }
            }
            if (bound) {
                setterBody.append(TAB).append(decoratedName);
                setterBody.append(" = ").append(name).append(";\n");
                setterBody.append(TAB + supportName).append(".firePropertyChange (\"").append(name).append("\", ");
                if (type.isPrimitive()) {
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append("), ");
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append(name).append("));\n");
                } else {
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append(", ").append(name).append(");\n");
                }
            }
        } else if (withSet) {
            setterBody.append(TAB).append(decoratedName);
            setterBody.append(" = ").append(name).append(";\n");
        }
        return setterBody.toString();
    }

    static String idxPropertySetterBody(String name, Type indexedType, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName) {
        return BeanPatternGenerator.idxPropertySetterBody(name, indexedType, bound, constrained, withSet, withSupport, supportName, vetoSupportName, true);
    }

    static String idxPropertySetterBody(String name, Type indexedType, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName, boolean adjustName) {
        StringBuffer setterBody = new StringBuffer(200);
        String decoratedName = BeanPatternGenerator.createFieldName(name, adjustName, true);
        setterBody.append("\n");
        if (withSupport && constrained) {
            setterBody.append(TAB + indexedType.toString());
            setterBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            setterBody.append(" = ").append(decoratedName);
            setterBody.append("[index];\n");
        }
        if (withSet || withSupport) {
            setterBody.append(TAB).append(decoratedName);
            setterBody.append("[index] = ").append(name).append(";\n");
        }
        if (withSupport && constrained) {
            setterBody.append("  try {\n");
            setterBody.append(TABx2 + vetoSupportName).append(".fireVetoableChange (\"").append(name).append("\", ");
            setterBody.append("null, null );\n");
            setterBody.append("  }\n");
            setterBody.append("  catch(java.beans.PropertyVetoException vetoException ) {\n");
            setterBody.append(TABx2).append(decoratedName);
            setterBody.append("[index] = old").append(Pattern.capitalizeFirstLetter(name)).append(";\n");
            setterBody.append("    throw vetoException;\n");
            setterBody.append("  }\n");
        }
        if (withSupport && bound) {
            setterBody.append(TAB + supportName).append(".firePropertyChange (\"").append(name).append("\", ");
            setterBody.append("null, null );\n");
        }
        return setterBody.toString();
    }

    static String propertyGetterBody(String name, boolean withReturn) {
        return BeanPatternGenerator.propertyGetterBody(name, withReturn, true);
    }

    static String propertyGetterBody(String name, boolean withReturn, boolean adjustName) {
        StringBuffer getterBody = new StringBuffer(50);
        String decorated = BeanPatternGenerator.createFieldName(name, adjustName, false);
        getterBody.append("\n");
        if (withReturn) {
            getterBody.append("  return ");
            getterBody.append(decorated).append(";\n");
        }
        return getterBody.toString();
    }

    static String idxPropertyGetterBody(String name, boolean withReturn) {
        return BeanPatternGenerator.idxPropertyGetterBody(name, withReturn, true);
    }

    static String idxPropertyGetterBody(String name, boolean withReturn, boolean adjustName) {
        StringBuffer getterBody = new StringBuffer(50);
        String decorated = BeanPatternGenerator.createFieldName(name, adjustName, false);
        getterBody.append("\n");
        if (withReturn) {
            getterBody.append("  return ");
            getterBody.append(decorated).append("[index];\n");
        }
        return getterBody.toString();
    }

    static String supportField(ClassElement ce) throws SourceException {
        String supportName = null;
        Identifier supportId = Identifier.create((String)"java.beans.PropertyChangeSupport");
        FieldElement[] fields = ce.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isClass() && fields[i].getType().getClassName().compareTo(supportId, false)) {
                supportName = fields[i].getName().getName();
                break;
            }
            ++i;
        }
        if (supportName == null) {
            supportName = "propertyChangeSupport";
            FieldElement supportField = new FieldElement();
            supportField.setName(Identifier.create((String)supportName));
            supportField.setType(Type.createClass((Identifier)supportId));
            supportField.setModifiers(2);
            supportField.setInitValue(" new java.beans.PropertyChangeSupport (this)");
            supportField.getJavaDoc().setRawText(PatternNode.getString("COMMENT_PropertyChangeSupport"));
            ce.addField(supportField);
        }
        return supportName;
    }

    static String vetoSupportField(ClassElement ce) throws SourceException {
        String vetoSupportName = null;
        Identifier vetoSupportId = Identifier.create((String)"java.beans.VetoableChangeSupport");
        FieldElement[] fields = ce.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isClass() && fields[i].getType().getClassName().compareTo(vetoSupportId, false)) {
                vetoSupportName = fields[i].getName().getName();
                break;
            }
            ++i;
        }
        if (vetoSupportName == null) {
            vetoSupportName = "vetoableChangeSupport";
            FieldElement supportField = new FieldElement();
            supportField.setName(Identifier.create((String)vetoSupportName));
            supportField.setType(Type.createClass((Identifier)vetoSupportId));
            supportField.setModifiers(2);
            supportField.setInitValue(" new java.beans.VetoableChangeSupport (this)");
            supportField.getJavaDoc().setRawText(PatternNode.getString("COMMENT_VetoableChangeSupport"));
            ce.addField(supportField);
        }
        return vetoSupportName;
    }

    static void supportListenerMethods(ClassElement classElement, String supportName) throws SourceException {
        StringBuffer body;
        Identifier addMethodId = Identifier.create((String)"addPropertyChangeListener");
        MethodElement addMethod = null;
        Identifier removeMethodId = Identifier.create((String)"removePropertyChangeListener");
        MethodElement removeMethod = null;
        Identifier listenerTypeId = Identifier.create((String)"java.beans.PropertyChangeListener");
        Type listenerType = Type.createClass((Identifier)listenerTypeId);
        addMethod = classElement.getMethod(addMethodId, new Type[]{listenerType});
        if (addMethod == null) {
            addMethod = new MethodElement();
            addMethod.setName(addMethodId);
            addMethod.setReturn(Type.VOID);
            addMethod.setModifiers(1);
            addMethod.setParameters(new MethodParameter[]{new MethodParameter("l", listenerType, false)});
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".addPropertyChangeListener (l);\n");
            addMethod.setBody(body.toString());
            addMethod.getJavaDoc().setRawText(PatternNode.getString("COMMENT_AddPropertyChangeListener"));
            classElement.addMethod(addMethod);
        }
        if ((removeMethod = classElement.getMethod(removeMethodId, new Type[]{listenerType})) == null) {
            removeMethod = new MethodElement();
            removeMethod.setName(removeMethodId);
            removeMethod.setReturn(Type.VOID);
            removeMethod.setModifiers(1);
            removeMethod.setParameters(new MethodParameter[]{new MethodParameter("l", listenerType, false)});
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".removePropertyChangeListener (l);\n");
            removeMethod.setBody(body.toString());
            removeMethod.getJavaDoc().setRawText(PatternNode.getString("COMMENT_RemovePropertyChangeListener"));
            classElement.addMethod(removeMethod);
        }
    }

    static void vetoSupportListenerMethods(ClassElement classElement, String supportName) throws SourceException {
        StringBuffer body;
        Identifier addMethodId = Identifier.create((String)"addVetoableChangeListener");
        MethodElement addMethod = null;
        Identifier removeMethodId = Identifier.create((String)"removeVetoableChangeListener");
        MethodElement removeMethod = null;
        Identifier listenerTypeId = Identifier.create((String)"java.beans.VetoableChangeListener");
        Type listenerType = Type.createClass((Identifier)listenerTypeId);
        addMethod = classElement.getMethod(addMethodId, new Type[]{listenerType});
        if (addMethod == null) {
            addMethod = new MethodElement();
            addMethod.setName(addMethodId);
            addMethod.setReturn(Type.VOID);
            addMethod.setModifiers(1);
            addMethod.setParameters(new MethodParameter[]{new MethodParameter("l", listenerType, false)});
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".addVetoableChangeListener (l);\n");
            addMethod.setBody(body.toString());
            addMethod.getJavaDoc().setRawText(PatternNode.getString("COMMENT_AddVetoableChangeListener"));
            classElement.addMethod(addMethod);
        }
        if ((removeMethod = classElement.getMethod(removeMethodId, new Type[]{listenerType})) == null) {
            removeMethod = new MethodElement();
            removeMethod.setName(removeMethodId);
            removeMethod.setReturn(Type.VOID);
            removeMethod.setModifiers(1);
            removeMethod.setParameters(new MethodParameter[]{new MethodParameter("l", listenerType, false)});
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".removeVetoableChangeListener (l);\n");
            removeMethod.setBody(body.toString());
            removeMethod.getJavaDoc().setRawText(PatternNode.getString("COMMENT_RemoveVetoableChangeListener"));
            classElement.addMethod(removeMethod);
        }
    }

    static String listenersArrayListField(ClassElement ce, Type type) throws SourceException {
        String fieldName = null;
        String fieldNameToFind = Introspector.decapitalize(type.getClassName().getName()) + "List";
        Identifier fieldTypeId = Identifier.create((String)"java.util.ArrayList");
        FieldElement[] fields = ce.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isClass() && fields[i].getType().getClassName().compareTo(fieldTypeId, false) && fields[i].getName().getName().equals(fieldNameToFind)) {
                fieldName = fields[i].getName().getName();
                break;
            }
            ++i;
        }
        if (fieldName == null) {
            fieldName = fieldNameToFind;
            FieldElement field = new FieldElement();
            field.setName(Identifier.create((String)fieldName));
            field.setType(Type.createClass((Identifier)fieldTypeId));
            field.setModifiers(130);
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_ListenerArrayList"), type.getClassName().getName());
            field.getJavaDoc().setRawText(comment);
            ce.addField(field);
        }
        return fieldName;
    }

    static String eventListenerListField(ClassElement ce, Type type) throws SourceException {
        String fieldName = null;
        Identifier fieldTypeId = Identifier.create((String)"javax.swing.event.EventListenerList");
        FieldElement[] fields = ce.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isClass() && fields[i].getType().getClassName().compareTo(fieldTypeId, false)) {
                fieldName = fields[i].getName().getName();
                break;
            }
            ++i;
        }
        if (fieldName == null) {
            fieldName = "listenerList";
            FieldElement field = new FieldElement();
            field.setName(Identifier.create((String)fieldName));
            field.setType(Type.createClass((Identifier)fieldTypeId));
            field.setModifiers(2);
            field.setInitValue(" null");
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_EventListenerList"), type.getClassName().getName());
            field.getJavaDoc().setRawText(comment);
            ce.addField(field);
        }
        return fieldName;
    }

    static void unicastListenerField(ClassElement ce, Type type) throws SourceException {
        String fieldName = null;
        String fieldNameToFind = Introspector.decapitalize(type.getClassName().getName());
        if (fieldNameToFind.equals(type.getClassName().getName())) {
            fieldNameToFind = new String("listener" + fieldNameToFind);
        }
        FieldElement[] fields = ce.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType().isClass() && fields[i].getType().getClassName().compareTo(type.getClassName(), false) && fields[i].getName().getName().equals(fieldNameToFind)) {
                fieldName = fields[i].getName().getName();
                break;
            }
            ++i;
        }
        if (fieldName == null) {
            fieldName = fieldNameToFind;
            FieldElement field = new FieldElement();
            field.setName(Identifier.create((String)fieldName));
            field.setType(type);
            field.setModifiers(130);
            field.setInitValue(" null");
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_UnicastEventListener"), type.getClassName().getName());
            field.getJavaDoc().setRawText(comment);
            ce.addField(field);
        }
    }

    static String mcAddBody(Type type, int implementation, String listenerList) {
        String fieldName = Introspector.decapitalize(type.getClassName().getName()) + "List";
        StringBuffer body = new StringBuffer(50);
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" == null ) {\n");
            body.append(TABx2).append(fieldName).append(" = new java.util.ArrayList ();\n");
            body.append(TAB).append("}\n");
            body.append(TAB + fieldName).append(".add (listener);\n");
        } else if (implementation == 2) {
            body.append("  if (").append(listenerList).append(" == null ) {\n");
            body.append(TABx2).append(listenerList).append(" = new javax.swing.event.EventListenerList();\n");
            body.append(TAB).append("}\n");
            body.append(TAB + listenerList).append(".add (");
            body.append(type.toString()).append(".class, listener);\n");
        }
        return body.toString();
    }

    static String mcRemoveBody(Type type, int implementation, String listenerList) {
        String fieldName = Introspector.decapitalize(type.getClassName().getName()) + "List";
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" != null ) {\n");
            body.append(TABx2 + fieldName).append(".remove (listener);\n");
            body.append(TAB).append("}\n");
        } else if (implementation == 2) {
            body.append(TAB + listenerList).append(".remove (");
            body.append(type.toString()).append(".class, listener);\n");
        }
        return body.toString();
    }

    static String ucAddBody(Type type, int implementation) {
        String fieldName = Introspector.decapitalize(type.getClassName().getName());
        if (fieldName.equals(type.getClassName().getName())) {
            fieldName = new String("listener" + fieldName);
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" != null) {\n");
            body.append("    throw new java.util.TooManyListenersException ();\n");
            body.append("  }\n");
            body.append(TAB + fieldName).append(" = listener;\n");
        }
        return body.toString();
    }

    static String ucRemoveBody(Type type, int implementation) {
        String fieldName = Introspector.decapitalize(type.getClassName().getName());
        if (fieldName.equals(type.getClassName().getName())) {
            fieldName = new String("listener" + fieldName);
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append(TAB + fieldName).append(" = null;\n");
        }
        return body.toString();
    }

    static void fireMethod(ClassElement classElement, Type type, MethodElement method, int implementation, String listenerList, boolean passEvent) throws SourceException {
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        Identifier methodId = Identifier.create((String)("fire" + Pattern.capitalizeFirstLetter(type.getClassName().getName()) + Pattern.capitalizeFirstLetter(method.getName().getName())));
        MethodElement newMethod = null;
        Type eventType = null;
        MethodParameter[] params = method.getParameters();
        eventType = params.length > 0 ? params[0].getType() : Type.createClass((Identifier)Identifier.create((String)"java.util.EventObject"));
        ClassElement eventClass = ClassElement.forName((String)eventType.toString());
        newMethod = new MethodElement();
        newMethod.setName(methodId);
        newMethod.setReturn(Type.VOID);
        newMethod.setModifiers(2);
        MethodParameter[] newMethodParams = BeanPatternGenerator.generateFireParameters(eventType, eventClass, passEvent);
        newMethod.setParameters(newMethodParams);
        StringBuffer body = new StringBuffer(80);
        body.append("\n");
        if (implementation == 1) {
            String fieldName = Introspector.decapitalize(type.getClassName().getName()) + "List";
            body.append("  java.util.ArrayList list;\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.toString()).append(" e = new ");
                body.append(eventType.toString()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append("  synchronized (this) {\n");
            body.append("    if (" + fieldName + " == null) return;\n");
            body.append("    list = (java.util.ArrayList)");
            body.append(fieldName).append(".clone ();\n  }\n");
            body.append("  for (int i = 0; i < list.size (); i++) {\n");
            body.append("    ((").append(type.toString());
            body.append(")list.get (i)).").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n  }\n");
        } else if (implementation == 2) {
            String fooEvent = "theEvent";
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.toString()).append(" e = null;\n ");
            }
            body.append("  if (" + listenerList + " == null) return;\n");
            body.append("  Object[] listeners = ").append(listenerList).append(".getListenerList ();\n");
            body.append("  for (int i = listeners.length-2; i>=0; i-=2) {\n");
            body.append("    if (listeners[i]==").append(type.toString()).append(".class) {\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("      if (e == null)\n");
                body.append("        e = new ").append(eventType.toString()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append("      ((").append(type.toString()).append(")listeners[i+1]).").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n    }\n  }\n");
        }
        newMethod.setBody(body.toString());
        StringBuffer comment = new StringBuffer(PatternNode.getString("COMMENT_FireMethodMC"));
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            comment.append("\n@param event The event to be fired\n");
        } else {
            comment.append(BeanPatternGenerator.fireParametersComment(newMethodParams, eventType.getClassName().getName()));
        }
        newMethod.getJavaDoc().setRawText(comment.toString());
        classElement.addMethod(newMethod);
    }

    static void unicastFireMethod(ClassElement classElement, Type type, MethodElement method, int implementation, boolean passEvent) throws SourceException {
        Identifier methodId = Identifier.create((String)("fire" + Pattern.capitalizeFirstLetter(type.getClassName().getName()) + Pattern.capitalizeFirstLetter(method.getName().getName())));
        MethodElement newMethod = null;
        Type eventType = null;
        MethodParameter[] params = method.getParameters();
        eventType = params.length > 0 ? params[0].getType() : Type.createClass((Identifier)Identifier.create((String)"java.util.EventObject"));
        ClassElement eventClass = ClassElement.forName((String)eventType.toString());
        newMethod = new MethodElement();
        newMethod.setName(methodId);
        newMethod.setReturn(Type.VOID);
        newMethod.setModifiers(2);
        MethodParameter[] newMethodParams = BeanPatternGenerator.generateFireParameters(eventType, eventClass, passEvent);
        newMethod.setParameters(newMethodParams);
        StringBuffer body = new StringBuffer(80);
        body.append("\n");
        if (implementation == 1) {
            String fieldName = Introspector.decapitalize(type.getClassName().getName());
            if (fieldName.equals(type.getClassName().getName())) {
                fieldName = new String("listener" + fieldName);
            }
            body.append("  if (" + fieldName + " == null) return;\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.toString()).append(" e = new ");
                body.append(eventType.toString()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append(TAB + fieldName).append(".").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n");
        }
        newMethod.setBody(body.toString());
        StringBuffer comment = new StringBuffer(PatternNode.getString("COMMENT_FireMethodUC"));
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            comment.append("\n@param event The event to be fired\n");
        } else {
            comment.append(BeanPatternGenerator.fireParametersComment(newMethodParams, eventType.getClassName().getName()));
        }
        newMethod.getJavaDoc().setRawText(comment.toString());
        classElement.addMethod(newMethod);
    }

    static boolean usesConstructorParameters(ClassElement eventClass, boolean passEvent) {
        return !passEvent && eventClass != null && eventClass.getConstructors().length <= 1;
    }

    static MethodParameter[] generateFireParameters(Type eventType, ClassElement eventClass, boolean passEvent) {
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            return new MethodParameter[]{new MethodParameter("event", BeanPatternGenerator.getFQNType(eventType), false)};
        }
        ConstructorElement constructor = eventClass.getConstructors()[0];
        MethodParameter[] params = constructor.getParameters();
        MethodParameter[] result = new MethodParameter[params.length];
        int i = 0;
        while (i < params.length) {
            result[i] = new MethodParameter("param" + (i + 1), BeanPatternGenerator.getFQNType(params[i].getType()), false);
            ++i;
        }
        return result;
    }

    static String fireParameterstoString(MethodParameter[] params) {
        StringBuffer buffer = new StringBuffer(60);
        int i = 0;
        while (i < params.length) {
            buffer.append(params[i].getName());
            if (i < params.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        return buffer.toString();
    }

    static String fireParametersComment(MethodParameter[] params, String evntType) {
        StringBuffer buffer = new StringBuffer(60);
        int i = 0;
        while (i < params.length) {
            buffer.append("\n@param ").append(params[i].getName());
            buffer.append(" Parameter #").append(i + 1).append(" of the <CODE>");
            buffer.append(evntType).append("<CODE> constructor.");
            ++i;
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public static String getWrapperClassName(Type type) {
        if (type.isClass()) {
            return type.getClassName().getName();
        }
        if (type == Type.BOOLEAN) {
            return "Boolean";
        }
        if (type == Type.BYTE) {
            return "Byte";
        }
        if (type == Type.DOUBLE) {
            return "Double";
        }
        if (type == Type.FLOAT) {
            return "Float";
        }
        if (type == Type.CHAR) {
            return "Character";
        }
        if (type == Type.INT) {
            return "Integer";
        }
        if (type == Type.LONG) {
            return "Long";
        }
        if (type == Type.SHORT) {
            return "Short";
        }
        return "Object";
    }

    private static Type getFQNType(Type t) {
        if (t.isArray()) {
            return Type.createArray((Type)BeanPatternGenerator.getFQNType(t.getElementType()));
        }
        if (t.isClass()) {
            Identifier id = t.getClassName();
            String fqnName = id.getFullName();
            if (fqnName == id.getSourceName()) {
                return t;
            }
            return Type.createClass((Identifier)Identifier.create((String)fqnName));
        }
        return t;
    }
}

