/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import org.netbeans.modules.beans.PatternNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.MethodElement;

class EventSetInheritanceAnalyser {
    EventSetInheritanceAnalyser() {
    }

    static MemberElement detectPropertyChangeSupport(ClassElement clazz) {
        return EventSetInheritanceAnalyser.findSupport(clazz, "java.beans.PropertyChangeSupport");
    }

    static MemberElement detectVetoableChangeSupport(ClassElement clazz) {
        return EventSetInheritanceAnalyser.findSupport(clazz, "java.beans.VetoableChangeSupport");
    }

    private static MemberElement findSupport(ClassElement clazz, String supportName) {
        Identifier propertyChangeField = null;
        if (clazz == null || clazz.getName().getFullName().equals("java.lang.Object")) {
            return null;
        }
        Identifier superClass = clazz.getSuperclass();
        if (superClass == null) {
            return null;
        }
        ClassElement parent = ClassElement.forName((String)superClass.getFullName());
        if (parent == null) {
            return parent;
        }
        if (propertyChangeField == null) {
            propertyChangeField = Identifier.create((String)supportName);
        }
        MethodElement[] methods = parent.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (!Modifier.isPrivate(methods[i].getModifiers()) && methods[i].getParameters().length == 0 && !methods[i].getReturn().isPrimitive() && !methods[i].getReturn().isArray() && methods[i].getReturn().getClassName().compareTo(propertyChangeField, false)) {
                return methods[i];
            }
            ++i;
        }
        FieldElement[] fields = parent.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            if (!Modifier.isPrivate(fields[i2].getModifiers()) && !fields[i2].getType().isPrimitive() && !fields[i2].getType().isArray() && fields[i2].getType().getClassName().compareTo(propertyChangeField, false)) {
                return fields[i2];
            }
            ++i2;
        }
        return EventSetInheritanceAnalyser.findSupport(parent, supportName);
    }

    static String showInheritanceEventDialog(MemberElement me, String supportTypeName) {
        String supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(me, supportTypeName);
        if (me != null) {
            Object[] msgfields = new Object[]{me.getDeclaringClass().getName().getFullName(), supportTypeName};
            String msg = MessageFormat.format(PatternNode.getString("MSG_Inheritance_Found"), msgfields);
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                return supportName;
            }
        }
        return null;
    }

    static String getInheritanceEventSupportName(MemberElement me, String supportTypeName) {
        ElementFormat format = new ElementFormat("{n}({p})");
        String supportName = null;
        if (me != null) {
            supportName = me instanceof MethodElement ? format.format((Element)((MethodElement)me)) : me.getName().getFullName();
        }
        return supportName;
    }
}

