/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.Utilities;

public class EventSetPattern
extends Pattern {
    static final String[] WELL_KNOWN_LISTENERS = new String[]{"java.awt.event.ActionListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.WindowListener", "java.beans.PropertyChangeListener", "java.beans.VetoableChangeListener", "javax.swing.event.CaretListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeModelListener", "javax.swing.event.UndoableEditListener"};
    protected MethodElement addListenerMethod = null;
    protected MethodElement removeListenerMethod = null;
    private Type type;
    private boolean isUnicast = false;
    private ClassElement typeElement;
    protected String name;

    public EventSetPattern(PatternAnalyser patternAnalyser, MethodElement addListenerMethod, MethodElement removeListenerMethod) throws IntrospectionException {
        super(patternAnalyser);
        if (addListenerMethod == null || removeListenerMethod == null) {
            throw new InternalError();
        }
        this.addListenerMethod = addListenerMethod;
        this.removeListenerMethod = removeListenerMethod;
        this.isUnicast = this.testUnicast();
        this.findEventSetType();
        this.name = this.findEventSetName();
        this.typeElement = ClassElement.forName((String)this.type.getClassName().getFullName());
    }

    private EventSetPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String name, String type, boolean isUnicast) throws SourceException {
        EventSetPattern esp = new EventSetPattern(patternAnalyser);
        esp.name = name;
        esp.type = Type.parse((String)type);
        esp.isUnicast = isUnicast;
        esp.generateAddListenerMethod();
        esp.generateRemoveListenerMethod();
        return esp;
    }

    static EventSetPattern create(PatternAnalyser patternAnalyser, String type, int implementation, boolean fire, boolean passEvent, boolean isUnicast) throws SourceException {
        ClassElement listener;
        EventSetPattern esp = new EventSetPattern(patternAnalyser);
        esp.type = Type.parse((String)type);
        if (esp.type == null || !esp.type.isClass()) {
            return null;
        }
        esp.name = Introspector.decapitalize(esp.type.getClassName().getName());
        esp.isUnicast = isUnicast;
        String listenerList = null;
        if (implementation == 1) {
            if (isUnicast) {
                BeanPatternGenerator.unicastListenerField(esp.getDeclaringClass(), esp.type);
            } else {
                BeanPatternGenerator.listenersArrayListField(esp.getDeclaringClass(), esp.type);
            }
        } else if (implementation == 2 && !isUnicast) {
            listenerList = BeanPatternGenerator.eventListenerListField(esp.getDeclaringClass(), esp.type);
        }
        if (isUnicast) {
            esp.generateAddListenerMethod(BeanPatternGenerator.ucAddBody(esp.type, implementation), true);
            esp.generateRemoveListenerMethod(BeanPatternGenerator.ucRemoveBody(esp.type, implementation), true);
        } else {
            esp.generateAddListenerMethod(BeanPatternGenerator.mcAddBody(esp.type, implementation, listenerList), true);
            esp.generateRemoveListenerMethod(BeanPatternGenerator.mcRemoveBody(esp.type, implementation, listenerList), true);
        }
        if (fire && (listener = ClassElement.forName((String)type.toString())) != null) {
            MethodElement[] methods = listener.getMethods();
            boolean isInterface = !listener.isClassOrInterface();
            int i = 0;
            while (i < methods.length) {
                if ((methods[i].getModifiers() & 1) != 0 || isInterface && (methods[i].getModifiers() & 6) == 0) {
                    if (isUnicast) {
                        BeanPatternGenerator.unicastFireMethod(esp.getDeclaringClass(), esp.type, methods[i], implementation, passEvent);
                    } else {
                        BeanPatternGenerator.fireMethod(esp.getDeclaringClass(), esp.type, methods[i], implementation, listenerList, passEvent);
                    }
                }
                ++i;
            }
        }
        return esp;
    }

    public ClassElement getTypeElement() {
        return this.typeElement;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SourceException {
        if (!Utilities.isJavaIdentifier((String)name) || name.indexOf("Listener") <= 0) {
            throw new SourceException("Invalid event source name");
        }
        name = Pattern.capitalizeFirstLetter(name);
        Identifier addMethodID = Identifier.create((String)("add" + name));
        Identifier removeMethodID = Identifier.create((String)("remove" + name));
        this.addListenerMethod.setName(addMethodID);
        this.removeListenerMethod.setName(removeMethodID);
        this.name = Introspector.decapitalize(name);
    }

    protected static boolean isValidName(String str) {
        if (!Utilities.isJavaIdentifier((String)str)) {
            return false;
        }
        return str.indexOf("Listener") > 0;
    }

    public boolean isUnicast() {
        return this.isUnicast;
    }

    public void setIsUnicast(boolean b) throws SourceException {
        if (b != this.isUnicast) {
            Identifier tooMany = Identifier.create((String)"java.util.TooManyListenersException");
            Identifier[] exs = this.addListenerMethod.getExceptions();
            if (b) {
                Identifier[] nexs = new Identifier[exs.length + 1];
                System.arraycopy(exs, 0, nexs, 0, exs.length);
                nexs[exs.length] = tooMany;
                this.addListenerMethod.setExceptions(nexs);
            } else {
                Identifier[] nexs = new Identifier[exs.length - 1];
                int found = 0;
                int i = 0;
                while (i < exs.length) {
                    if (!exs[i].compareTo(tooMany, false)) {
                        nexs[i - found] = exs[i];
                    } else {
                        found = 1;
                    }
                    ++i;
                }
                this.addListenerMethod.setExceptions(nexs);
            }
        }
        this.isUnicast = b;
    }

    public MethodElement getAddListenerMethod() {
        return this.addListenerMethod;
    }

    public MethodElement getRemoveListenerMethod() {
        return this.removeListenerMethod;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type newType) throws SourceException {
        if (newType.compareTo(this.type, true)) {
            return;
        }
        if (!PatternAnalyser.isSubclass(ClassElement.forName((String)newType.getClassName().getFullName()), ClassElement.forName((String)"java.util.EventListener"))) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
            return;
        }
        MethodParameter[] params = this.addListenerMethod.getParameters();
        if (params.length > 0) {
            params[0].setType(newType);
            this.addListenerMethod.setParameters(params);
        }
        if ((params = this.removeListenerMethod.getParameters()).length > 0) {
            params[0].setType(newType);
            this.removeListenerMethod.setParameters(params);
        }
        String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeEventSourceName"), Pattern.capitalizeFirstLetter(newType.getClassName().getName()));
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
            this.setName(newType.getClassName().getName());
        }
        this.type = newType;
    }

    public Node.Cookie getCookie(Class cookieType) {
        if (this.addListenerMethod != null) {
            return this.addListenerMethod.getCookie(cookieType);
        }
        if (this.removeListenerMethod != null) {
            return this.removeListenerMethod.getCookie(cookieType);
        }
        return null;
    }

    public void destroy() throws SourceException {
        ClassElement declaringClass;
        if (this.addListenerMethod != null) {
            declaringClass = this.addListenerMethod.getDeclaringClass();
            if (declaringClass == null) {
                throw new SourceException();
            }
            declaringClass.removeMethod(this.addListenerMethod);
        }
        if (this.removeListenerMethod != null) {
            declaringClass = this.removeListenerMethod.getDeclaringClass();
            if (declaringClass == null) {
                throw new SourceException();
            }
            declaringClass.removeMethod(this.removeListenerMethod);
        }
        declaringClass = this.getDeclaringClass();
        ClassElement listener = ClassElement.forName((String)this.type.toString());
        boolean canDelete = false;
        if (listener != null) {
            MethodElement[] methods = listener.getMethods();
            MethodElement[] sourceMethods = declaringClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                String method = "fire" + Pattern.capitalizeFirstLetter(this.type.getClassName().getName()) + Pattern.capitalizeFirstLetter(methods[i].getName().getName());
                if ((methods[i].getModifiers() & 1) != 0) {
                    int j = 0;
                    while (j < sourceMethods.length) {
                        if (sourceMethods[j].getName().getName().equals(method)) {
                            if (!canDelete) {
                                String mssg = MessageFormat.format(PatternNode.getString("FMT_DeleteFire"), new Object[0]);
                                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.NO_OPTION)) {
                                    return;
                                }
                                canDelete = true;
                            }
                            declaringClass.removeMethod(sourceMethods[j]);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    EventSetPattern(EventSetPattern x, EventSetPattern y) {
        super(y.patternAnalyser);
        this.addListenerMethod = y.addListenerMethod;
        this.removeListenerMethod = y.removeListenerMethod;
        this.isUnicast = y.isUnicast;
        this.type = y.type;
        this.name = y.name;
    }

    private void findEventSetType() throws IntrospectionException {
        if (this.addListenerMethod == null) {
            throw new InternalError("add method == nul in event set pattern");
        }
        this.type = this.addListenerMethod.getParameters()[0].getType();
    }

    private String findEventSetName() {
        String compound = this.addListenerMethod.getName().getName().substring(3);
        this.name = Introspector.decapitalize(compound);
        return this.name;
    }

    private boolean testUnicast() {
        return this.findTooManyListenersException() != null;
    }

    Identifier findTooManyListenersException() {
        Identifier tooMany = Identifier.create((String)"java.util.TooManyListenersException");
        Identifier[] exs = this.addListenerMethod.getExceptions();
        int i = 0;
        while (i < exs.length) {
            if (exs[i].compareTo(tooMany, false)) {
                return exs[i];
            }
            ++i;
        }
        return null;
    }

    void generateAddListenerMethod() throws SourceException {
        this.generateAddListenerMethod(null, false);
    }

    void generateAddListenerMethod(String body, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newMethod = new MethodElement();
        MethodParameter[] newParameters = new MethodParameter[]{new MethodParameter("listener", this.type, false)};
        newMethod.setName(Identifier.create((String)("add" + Pattern.capitalizeFirstLetter(this.getName()))));
        newMethod.setReturn(Type.VOID);
        newMethod.setModifiers(33);
        newMethod.setParameters(newParameters);
        if (declaringClass.isInterface()) {
            newMethod.setBody(null);
        } else if (body != null) {
            newMethod.setBody(body);
        }
        if (this.isUnicast) {
            newMethod.setExceptions(new Identifier[]{Identifier.create((String)"java.util.TooManyListenersException")});
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_AddListenerMethod"), this.type.getClassName().getName());
            newMethod.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newMethod);
        this.addListenerMethod = newMethod;
    }

    void generateRemoveListenerMethod() throws SourceException {
        this.generateRemoveListenerMethod(null, false);
    }

    void generateRemoveListenerMethod(String body, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newMethod = new MethodElement();
        MethodParameter[] newParameters = new MethodParameter[]{new MethodParameter("listener", this.type, false)};
        newMethod.setName(Identifier.create((String)("remove" + Pattern.capitalizeFirstLetter(this.getName()))));
        newMethod.setReturn(Type.VOID);
        newMethod.setModifiers(33);
        newMethod.setParameters(newParameters);
        if (declaringClass.isInterface()) {
            newMethod.setBody(null);
        } else if (body != null) {
            newMethod.setBody(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_RemoveListenerMethod"), this.type.getClassName().getName());
            newMethod.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newMethod);
        this.removeListenerMethod = newMethod;
    }

    void copyProperties(EventSetPattern src) {
        boolean changed;
        boolean bl = changed = !src.getType().equals((Object)this.getType()) || !src.getName().equals(this.getName()) || src.isUnicast() != this.isUnicast();
        if (src.getAddListenerMethod() != this.addListenerMethod) {
            this.addListenerMethod = src.getAddListenerMethod();
        }
        if (src.getRemoveListenerMethod() != this.removeListenerMethod) {
            this.removeListenerMethod = src.getRemoveListenerMethod();
        }
        if (changed) {
            this.isUnicast = this.testUnicast();
            try {
                this.findEventSetType();
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
            this.isUnicast = this.testUnicast();
            this.name = this.findEventSetName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

