/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class IdxPropertyPattern
extends PropertyPattern {
    protected MethodElement indexedGetterMethod = null;
    protected MethodElement indexedSetterMethod = null;
    protected Type indexedType;

    public IdxPropertyPattern(PatternAnalyser patternAnalyser, MethodElement getterMethod, MethodElement setterMethod, MethodElement indexedGetterMethod, MethodElement indexedSetterMethod) throws IntrospectionException {
        super(patternAnalyser, getterMethod, setterMethod);
        this.indexedGetterMethod = indexedGetterMethod;
        this.indexedSetterMethod = indexedSetterMethod;
        this.findIndexedPropertyType();
        this.name = this.findIndexedPropertyName();
    }

    private IdxPropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, String indexedType) throws SourceException {
        IdxPropertyPattern ipp = new IdxPropertyPattern(patternAnalyser);
        ipp.name = name;
        ipp.type = Type.parse((String)type);
        ipp.indexedType = Type.parse((String)indexedType);
        ipp.generateGetterMethod();
        ipp.generateSetterMethod();
        ipp.generateIndexedGetterMethod();
        ipp.generateIndexedSetterMethod();
        return ipp;
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean niGetter, boolean niWithReturn, boolean niSetter, boolean niWithSet) throws SourceException {
        return IdxPropertyPattern.create(patternAnalyser, name, type, mode, bound, constrained, withField, withReturn, withSet, withSupport, niGetter, niWithReturn, niSetter, niWithSet, false, false);
    }

    static IdxPropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean niGetter, boolean niWithReturn, boolean niSetter, boolean niWithSet, boolean useSupport, boolean fromField) throws SourceException {
        IdxPropertyPattern ipp = new IdxPropertyPattern(patternAnalyser);
        ipp.name = name;
        ipp.type = null;
        ipp.indexedType = Type.parse((String)type);
        if (withField || withSupport || niGetter || niSetter) {
            ipp.type = Type.createArray((Type)ipp.indexedType);
        }
        if ((withField || withSupport) && !fromField && ipp.type != null) {
            try {
                ipp.generateField(true);
            }
            catch (SourceException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String supportName = null;
        String vetoSupportName = null;
        if (withSupport) {
            boolean boundSupport = bound;
            boolean constrainedSupport = constrained;
            if (!useSupport) {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(ipp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(ipp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            } else {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(ipp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(ipp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            }
            if (boundSupport) {
                supportName = BeanPatternGenerator.supportField(ipp.getDeclaringClass());
            }
            if (constrainedSupport) {
                vetoSupportName = BeanPatternGenerator.vetoSupportField(ipp.getDeclaringClass());
            }
            if (boundSupport) {
                BeanPatternGenerator.supportListenerMethods(ipp.getDeclaringClass(), supportName);
            }
            if (constrainedSupport) {
                BeanPatternGenerator.vetoSupportListenerMethods(ipp.getDeclaringClass(), vetoSupportName);
            }
        }
        if (mode == 1 || mode == 2) {
            if (fromField && withReturn || !fromField) {
                ipp.generateIndexedGetterMethod(BeanPatternGenerator.idxPropertyGetterBody(name, withReturn), true);
            }
            if (ipp.type != null && niGetter) {
                ipp.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(name, niWithReturn), true);
            }
        }
        if (mode == 1 || mode == 4) {
            if (fromField && withSet || !fromField) {
                ipp.generateIndexedSetterMethod(BeanPatternGenerator.idxPropertySetterBody(name, ipp.getIndexedType(), bound, constrained, withSet, withSupport, supportName, vetoSupportName), constrained, true);
            }
            if (ipp.type != null && niSetter) {
                ipp.generateSetterMethod(BeanPatternGenerator.propertySetterBody(name, ipp.getType(), bound, constrained, niWithSet, withSupport, supportName, vetoSupportName), constrained, true);
            }
        }
        return ipp;
    }

    public Type getIndexedType() {
        return this.indexedType;
    }

    public void setName(String name) throws SourceException {
        String oldName = this.name;
        super.setName(name);
        name = Pattern.capitalizeFirstLetter(name);
        if (this.indexedGetterMethod != null) {
            Identifier idxGetterMethodID = Identifier.create((String)((this.indexedGetterMethod.getName().getName().startsWith("get") ? "get" : "is") + name));
            this.indexedGetterMethod.setName(idxGetterMethodID);
            String oldGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), oldName);
            String newGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), this.getName());
            if (!this.indexedGetterMethod.getJavaDoc().isEmpty() && oldGetterComment.trim().equals(this.indexedGetterMethod.getJavaDoc().getRawText().trim())) {
                this.indexedGetterMethod.getJavaDoc().setRawText(newGetterComment);
            }
        }
        if (this.indexedSetterMethod != null) {
            Identifier idxSetterMethodID = Identifier.create((String)("set" + name));
            this.indexedSetterMethod.setName(idxSetterMethodID);
            String oldSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), oldName, oldName);
            String newSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), this.getName(), this.getName());
            if (!this.indexedSetterMethod.getJavaDoc().isEmpty() && oldSetterComment.trim().equals(this.indexedSetterMethod.getJavaDoc().getRawText().trim())) {
                this.indexedSetterMethod.getJavaDoc().setRawText(newSetterComment);
            }
        }
        if (this.estimatedField != null && this.estimatedField.getName().getName().equals(this.getName())) {
            String oldSetterBody;
            String existingSetterBody;
            int mode = this.getMode();
            if (mode == 1 || mode == 2) {
                String existingGetterBody = this.indexedGetterMethod.getBody().trim();
                String oldGetterBody1 = BeanPatternGenerator.idxPropertyGetterBody(oldName, true, true).trim();
                String oldGetterBody2 = BeanPatternGenerator.idxPropertyGetterBody(oldName, true, false).trim();
                if (existingGetterBody.equals(oldGetterBody1)) {
                    this.indexedGetterMethod.setBody(BeanPatternGenerator.idxPropertyGetterBody(this.getName(), true, true));
                } else if (existingGetterBody.equals(oldGetterBody2)) {
                    this.indexedGetterMethod.setBody(BeanPatternGenerator.idxPropertyGetterBody(this.getName(), true, false));
                }
            }
            if ((mode == 1 || mode == 4) && (existingSetterBody = this.indexedSetterMethod.getBody().trim()).equals(oldSetterBody = BeanPatternGenerator.idxPropertySetterBody(oldName, this.type, false, false, true, false, null, null).trim())) {
                this.indexedSetterMethod.setBody(BeanPatternGenerator.idxPropertySetterBody(this.getName(), this.getType(), false, false, true, false, null, null));
                if (this.indexedSetterMethod != null) {
                    MethodParameter[] params = this.indexedSetterMethod.getParameters();
                    params[1].setName(Introspector.decapitalize(name));
                    this.indexedSetterMethod.setParameters(params);
                }
            }
        }
    }

    public MethodElement getIndexedGetterMethod() {
        return this.indexedGetterMethod;
    }

    public MethodElement getIndexedSetterMethod() {
        return this.indexedSetterMethod;
    }

    public void setType(Type type) throws SourceException {
        if (this.type != null && this.type.compareTo(type, true)) {
            return;
        }
        Type oldIndexedType = this.indexedType;
        Type oldType = this.type;
        if (oldType == null) {
            this.type = type;
            oldType = type;
            int mode = this.getMode();
            if (mode == 1 || mode == 2) {
                this.generateGetterMethod();
            }
            if (mode == 1 || mode == 4) {
                this.generateSetterMethod();
            }
        } else {
            super.setType(type);
        }
        if (type.isArray() && oldType.isArray() && oldType.getElementType().compareTo(oldIndexedType, false)) {
            MethodParameter[] params;
            Type newType = type.getElementType();
            if (this.indexedGetterMethod != null) {
                this.indexedGetterMethod.setReturn(newType);
            }
            if (this.indexedSetterMethod != null && (params = this.indexedSetterMethod.getParameters()).length > 1) {
                params[1].setType(newType);
                this.indexedSetterMethod.setParameters(params);
            }
            this.setIndexedType(newType);
        }
    }

    public void setIndexedType(Type type) throws SourceException {
        MethodParameter[] params;
        if (this.indexedType.compareTo(type, true)) {
            return;
        }
        Type oldIndexedType = this.indexedType;
        Type oldType = this.type;
        if (this.indexedGetterMethod != null) {
            this.indexedGetterMethod.setReturn(type);
        }
        if (this.indexedSetterMethod != null && (params = this.indexedSetterMethod.getParameters()).length > 1) {
            params[1].setType(type);
            this.indexedSetterMethod.setParameters(params);
            String body = this.indexedSetterMethod.getBody();
            if (body != null && (body.indexOf("firePropertyChange") != -1 || body.indexOf("fireVetoableChange") != -1)) {
                String newBody;
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName().getName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION) && (newBody = this.regeneratePropertySupport(this.indexedSetterMethod.getBody(), null, params[1].getName(), type, oldType)) != null) {
                    this.indexedSetterMethod.setBody(newBody);
                }
            }
        }
        if (oldType != null && oldType.isArray() && oldType.getElementType().compareTo(oldIndexedType, false)) {
            Type newArrayType = Type.createArray((Type)type);
            super.setType(newArrayType);
        }
        this.indexedType = type;
    }

    private String regenerateIdxPropertySupport(String methodBody, String name, Type type, Type oldType) {
        if (methodBody == null) {
            return null;
        }
        int first = -1;
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        String oldVarLine = oldType.toString() + " old" + Pattern.capitalizeFirstLetter(name) + " = " + propertyStyle + name;
        first = methodBody.indexOf(oldVarLine);
        if (first == -1) {
            return null;
        }
        if (first == -1) {
            return null;
        }
        int last = methodBody.indexOf(59, first);
        if (first >= last) {
            return null;
        }
        StringBuffer newBody = new StringBuffer(100);
        newBody.append(type.toString());
        newBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
        newBody.append(" = ").append(propertyStyle).append(name);
        StringBuffer sb = new StringBuffer(methodBody);
        sb.delete(first, last);
        sb.insert(first, (Object)newBody);
        return sb.toString();
    }

    public int getMode() {
        if (this.indexedSetterMethod != null && this.indexedGetterMethod != null) {
            return 1;
        }
        if (this.indexedGetterMethod != null && this.indexedSetterMethod == null) {
            return 2;
        }
        if (this.indexedSetterMethod != null && this.indexedGetterMethod == null) {
            return 4;
        }
        return super.getMode();
    }

    public void setMode(int mode) throws SourceException {
        if (this.getMode() == mode) {
            return;
        }
        switch (mode) {
            case 1: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod();
                }
                if (this.setterMethod == null) {
                    this.generateSetterMethod();
                }
                if (this.indexedGetterMethod == null) {
                    this.generateIndexedGetterMethod();
                }
                if (this.indexedSetterMethod != null) break;
                this.generateIndexedSetterMethod();
                break;
            }
            case 2: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod();
                }
                if (this.indexedGetterMethod == null) {
                    this.generateIndexedGetterMethod();
                }
                if (this.setterMethod == null && this.indexedSetterMethod == null) break;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                if (this.setterMethod != null) {
                    this.deleteSetterMethod();
                }
                if (this.indexedSetterMethod == null) break;
                this.deleteIndexedSetterMethod();
                break;
            }
            case 4: {
                if (this.setterMethod == null) {
                    this.generateSetterMethod();
                }
                if (this.indexedSetterMethod == null) {
                    this.generateIndexedSetterMethod();
                }
                if (this.getterMethod == null && this.indexedGetterMethod == null) break;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getters") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                if (this.getterMethod != null) {
                    this.deleteGetterMethod();
                }
                if (this.indexedGetterMethod == null) break;
                this.deleteIndexedGetterMethod();
            }
        }
    }

    public Node.Cookie getCookie(Class cookieType) {
        if (this.indexedGetterMethod != null) {
            return this.indexedGetterMethod.getCookie(cookieType);
        }
        if (this.indexedSetterMethod != null) {
            return this.indexedSetterMethod.getCookie(cookieType);
        }
        return super.getCookie(cookieType);
    }

    public void destroy() throws SourceException {
        this.deleteIndexedSetterMethod();
        this.deleteIndexedGetterMethod();
        super.destroy();
    }

    IdxPropertyPattern(PropertyPattern x, PropertyPattern y) {
        super(x, y);
        if (x instanceof IdxPropertyPattern) {
            IdxPropertyPattern ix = (IdxPropertyPattern)x;
            this.indexedGetterMethod = ix.indexedGetterMethod;
            this.indexedSetterMethod = ix.indexedSetterMethod;
            this.indexedType = ix.indexedType;
        }
        if (y instanceof IdxPropertyPattern) {
            IdxPropertyPattern iy = (IdxPropertyPattern)y;
            if (iy.indexedGetterMethod != null) {
                this.indexedGetterMethod = iy.indexedGetterMethod;
            }
            if (iy.indexedSetterMethod != null) {
                this.indexedSetterMethod = iy.indexedSetterMethod;
            }
            this.indexedType = iy.indexedType;
        }
        this.name = this.findIndexedPropertyName();
    }

    private void findIndexedPropertyType() throws IntrospectionException {
        Type propType;
        MethodParameter[] params;
        this.indexedType = null;
        if (this.indexedGetterMethod != null) {
            params = this.indexedGetterMethod.getParameters();
            if (params.length != 1) {
                throw new IntrospectionException("bad indexed read method arg count");
            }
            if (!params[0].getType().compareTo(Type.INT, false)) {
                throw new IntrospectionException("not int index to indexed read method");
            }
            this.indexedType = this.indexedGetterMethod.getReturn();
            if (this.indexedType.compareTo(Type.VOID, false)) {
                throw new IntrospectionException("indexed read method return void");
            }
        }
        if (this.indexedSetterMethod != null) {
            params = this.indexedSetterMethod.getParameters();
            if (params.length != 2) {
                throw new IntrospectionException("bad indexed write method arg count");
            }
            if (!params[0].getType().compareTo(Type.INT, false)) {
                throw new IntrospectionException("non int index to indexed write method");
            }
            if (this.indexedType != null && !this.indexedType.compareTo(params[1].getType(), false)) {
                throw new IntrospectionException("type mismatch between indexed read and write methods");
            }
            this.indexedType = params[1].getType();
        }
        if (!((propType = this.getType()) == null || propType.isArray() && propType.getElementType().compareTo(this.indexedType, false))) {
            throw new IntrospectionException("type mismatch between property type and indexed type");
        }
    }

    String findIndexedPropertyName() {
        String superName = this.findPropertyName();
        if (superName == null) {
            String methodName = null;
            if (this.indexedGetterMethod != null) {
                methodName = this.indexedGetterMethod.getName().getName();
            } else if (this.indexedSetterMethod != null) {
                methodName = this.indexedSetterMethod.getName().getName();
            } else {
                throw new InternalError("Indexed property with all methods == null");
            }
            return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
        }
        return superName;
    }

    void generateGetterMethod() throws SourceException {
        if (this.type != null) {
            super.generateGetterMethod();
        }
    }

    void generateSetterMethod() throws SourceException {
        if (this.type != null) {
            super.generateSetterMethod();
        }
    }

    void generateIndexedGetterMethod() throws SourceException {
        this.generateIndexedGetterMethod(null, false);
    }

    void generateIndexedGetterMethod(String body, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newGetter = new MethodElement();
        MethodParameter[] newParameters = new MethodParameter[]{new MethodParameter("index", Type.INT, false)};
        newGetter.setName(Identifier.create((String)("get" + Pattern.capitalizeFirstLetter(this.getName()))));
        newGetter.setReturn(this.indexedType);
        newGetter.setModifiers(1);
        newGetter.setParameters(newParameters);
        if (declaringClass.isInterface()) {
            newGetter.setBody(null);
        } else if (body != null) {
            newGetter.setBody(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertyGetter"), this.getName());
            newGetter.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newGetter);
        this.indexedGetterMethod = declaringClass.getMethod(newGetter.getName(), PropertyPattern.getParameterTypes(newGetter));
    }

    void generateIndexedSetterMethod() throws SourceException {
        this.generateIndexedSetterMethod(null, false, false);
    }

    void generateIndexedSetterMethod(String body, boolean constrained, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newSetter = new MethodElement();
        MethodParameter[] newParameters = new MethodParameter[]{new MethodParameter("index", Type.INT, false), new MethodParameter(this.name, this.indexedType, false)};
        newSetter.setName(Identifier.create((String)("set" + Pattern.capitalizeFirstLetter(this.getName()))));
        newSetter.setReturn(Type.VOID);
        newSetter.setModifiers(1);
        newSetter.setParameters(newParameters);
        if (constrained) {
            newSetter.setExceptions(new Identifier[]{Identifier.create((String)"java.beans.PropertyVetoException")});
        }
        if (declaringClass.isInterface()) {
            newSetter.setBody(null);
        } else if (body != null) {
            newSetter.setBody(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_IdxPropertySetter"), this.getName(), this.name);
            if (constrained) {
                comment = comment + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            newSetter.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newSetter);
        this.indexedSetterMethod = declaringClass.getMethod(newSetter.getName(), PropertyPattern.getParameterTypes(newSetter));
    }

    void deleteIndexedGetterMethod() throws SourceException {
        if (this.indexedGetterMethod == null) {
            return;
        }
        ClassElement declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.removeMethod(this.indexedGetterMethod);
        this.indexedGetterMethod = null;
    }

    void deleteIndexedSetterMethod() throws SourceException {
        if (this.indexedSetterMethod == null) {
            return;
        }
        ClassElement declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.removeMethod(this.indexedSetterMethod);
        this.indexedSetterMethod = null;
    }

    /*
     * Unable to fully structure code
     */
    void copyProperties(IdxPropertyPattern src) {
        if (!src.getIndexedType().equals((Object)this.getIndexedType())) ** GOTO lbl-1000
        v0 = src.getType() == null ? this.getType() == null : src.getType().equals((Object)this.getType());
        if (!v0 || !src.getName().equals(this.getName()) || src.getMode() != this.getMode()) ** GOTO lbl-1000
        if (!(src.getEstimatedField() == null ? this.estimatedField == null : src.getEstimatedField().equals(this.estimatedField))) lbl-1000:
        // 3 sources

        {
            v1 = true;
        } else {
            v1 = changed = false;
        }
        if (src.getIndexedGetterMethod() != this.indexedGetterMethod) {
            this.indexedGetterMethod = src.getIndexedGetterMethod();
        }
        if (src.getIndexedSetterMethod() != this.indexedSetterMethod) {
            this.indexedSetterMethod = src.getIndexedSetterMethod();
        }
        if (src.getGetterMethod() != this.getterMethod) {
            changed = true;
            this.getterMethod = src.getGetterMethod();
        }
        if (src.getSetterMethod() != this.setterMethod) {
            changed = true;
            this.setterMethod = src.getSetterMethod();
        }
        if (src.getEstimatedField() != this.estimatedField) {
            this.estimatedField = src.getEstimatedField();
        }
        if (changed) {
            try {
                this.type = this.findPropertyType();
                this.findIndexedPropertyType();
            }
            catch (IntrospectionException var3_3) {
                // empty catch block
            }
            this.name = this.findIndexedPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

