/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public class PatternAnalyser
implements Node.Cookie {
    private static final int PROPERTIES_RESERVE = 11;
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private ArrayList currentPropertyPatterns = new ArrayList();
    private ArrayList currentIdxPropertyPatterns = new ArrayList();
    private ArrayList currentEventSetPatterns = new ArrayList();
    private HashMap propertyPatterns;
    private HashMap idxPropertyPatterns;
    private HashMap eventSetPatterns;
    private ClassElement classElement;
    private boolean analyzed = false;
    private boolean ignore;

    public PatternAnalyser(ClassElement classElement) {
        this.classElement = classElement;
    }

    public void analyzeAll() {
        if (this.ignore) {
            return;
        }
        this.analyzed = true;
        int methodCount = this.classElement.getMethods().length;
        this.propertyPatterns = new HashMap(methodCount / 2 + 11);
        this.idxPropertyPatterns = new HashMap();
        this.eventSetPatterns = new HashMap();
        this.resolveMethods();
        this.resolveFields();
        this.resolveChangesOfProperties();
        this.resolveChangesOfIdxProperties();
        this.resolveChangesOfEventSets();
    }

    boolean isAnalyzed() {
        return this.analyzed;
    }

    void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public Collection getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public Collection getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public Collection getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public ClassElement getClassElement() {
        return this.classElement;
    }

    public void resolveMethods() {
        MethodElement[] methods = this.classElement.getMethods();
        Hashtable adds = new Hashtable();
        Hashtable removes = new Hashtable();
        int i = 0;
        while (i < methods.length) {
            PropertyPattern pp;
            MethodElement method = methods[i];
            String name = method.getName().getName();
            if ((name.startsWith(GET_PREFIX) || name.startsWith(SET_PREFIX) || name.startsWith(IS_PREFIX)) && (pp = this.analyseMethodForProperties(method)) != null) {
                this.addProperty(pp);
            }
            if (name.startsWith(ADD_PREFIX) || name.startsWith(REMOVE_PREFIX)) {
                this.analyseMethodForEventSets(method, adds, removes);
            }
            ++i;
        }
        Enumeration keys = adds.keys();
        while (keys.hasMoreElements()) {
            EventSetPattern esp;
            String compound = (String)keys.nextElement();
            if (removes.get(compound) == null || compound.indexOf("Listener:") <= 0) continue;
            MethodElement addMethod = (MethodElement)adds.get(compound);
            MethodElement removeMethod = (MethodElement)removes.get(compound);
            Type argType = addMethod.getParameters()[0].getType();
            if (!PatternAnalyser.isSubclass(ClassElement.forName((String)argType.getClassName().getFullName()), ClassElement.forName((String)"java.util.EventListener"))) continue;
            try {
                esp = new EventSetPattern(this, addMethod, removeMethod);
            }
            catch (IntrospectionException ex) {
                esp = null;
            }
            if (esp == null) continue;
            this.addEventSet(esp);
        }
    }

    void resolveFields() {
        FieldElement[] fields = this.classElement.getFields();
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        int i = 0;
        while (i < fields.length) {
            FieldElement field = fields[i];
            if ((field.getModifiers() & 8) == 0) {
                Type ppType;
                PropertyPattern pp;
                String fieldName = field.getName().getName();
                if (fieldName.startsWith(propertyStyle)) {
                    fieldName = fieldName.substring(1);
                }
                if ((pp = (PropertyPattern)this.propertyPatterns.get(fieldName)) == null) {
                    pp = (PropertyPattern)this.idxPropertyPatterns.get(fieldName);
                }
                if (pp != null && (ppType = pp.getType()) != null && pp.getType().compareTo(field.getType(), false)) {
                    pp.setEstimatedField(field);
                }
            }
            ++i;
        }
    }

    private void resolveChangesOfProperties() {
        this.currentPropertyPatterns = PatternAnalyser.resolveChanges(this.currentPropertyPatterns, this.propertyPatterns, LevelComparator.PROPERTY);
    }

    private void resolveChangesOfIdxProperties() {
        this.currentIdxPropertyPatterns = PatternAnalyser.resolveChanges(this.currentIdxPropertyPatterns, this.idxPropertyPatterns, LevelComparator.IDX_PROPERTY);
    }

    private void resolveChangesOfEventSets() {
        this.currentEventSetPatterns = PatternAnalyser.resolveChanges(this.currentEventSetPatterns, this.eventSetPatterns, LevelComparator.EVENT_SET);
    }

    static ArrayList resolveChanges(Collection current, Map created, LevelComparator comparator) {
        ArrayList old = new ArrayList(current);
        ArrayList cre = new ArrayList(created.size());
        cre.addAll(created.values());
        ArrayList<Pattern> result = new ArrayList<Pattern>(created.size() + 5);
        int level = 0;
        while (level <= comparator.getLevels()) {
            Iterator itCre = ((AbstractList)cre).iterator();
            block1: while (itCre.hasNext()) {
                Pattern crePattern = (Pattern)itCre.next();
                Iterator itOld = ((AbstractList)old).iterator();
                while (itOld.hasNext()) {
                    Pattern oldPattern = (Pattern)itOld.next();
                    if (!comparator.compare(level, oldPattern, crePattern)) continue;
                    itOld.remove();
                    itCre.remove();
                    comparator.copyProperties(oldPattern, crePattern);
                    result.add(oldPattern);
                    continue block1;
                }
            }
            ++level;
        }
        result.addAll(cre);
        return result;
    }

    PropertyPattern analyseMethodForProperties(MethodElement method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return null;
        }
        String name = method.getName().getName();
        MethodParameter[] params = method.getParameters();
        int paramCount = params == null ? 0 : params.length;
        Type returnType = method.getReturn();
        PropertyPattern pp = null;
        try {
            if (paramCount == 0) {
                if (name.startsWith(GET_PREFIX)) {
                    pp = new PropertyPattern(this, method, null);
                } else if (returnType.compareTo(Type.BOOLEAN, false) && name.startsWith(IS_PREFIX)) {
                    pp = new PropertyPattern(this, method, null);
                }
            } else if (paramCount == 1) {
                if (params[0].getType().compareTo(Type.INT, false) && name.startsWith(GET_PREFIX)) {
                    pp = new IdxPropertyPattern(this, null, null, method, null);
                } else if (returnType.compareTo(Type.VOID, false) && name.startsWith(SET_PREFIX)) {
                    pp = new PropertyPattern(this, null, method);
                }
            } else if (paramCount == 2 && params[0].getType().compareTo(Type.INT, false) && name.startsWith(SET_PREFIX)) {
                pp = new IdxPropertyPattern(this, null, null, null, method);
            }
        }
        catch (IntrospectionException ex) {
            pp = null;
        }
        return pp;
    }

    void analyseMethodForEventSets(MethodElement method, Map adds, Map removes) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return;
        }
        String name = method.getName().getName();
        MethodParameter[] params = method.getParameters();
        Type returnType = method.getReturn();
        if (name.startsWith(ADD_PREFIX) && params.length == 1 && returnType == Type.VOID) {
            String compound = name.substring(3) + ":" + params[0].getType();
            adds.put(compound, method);
        } else if (name.startsWith(REMOVE_PREFIX) && params.length == 1 && returnType == Type.VOID) {
            String compound = name.substring(6) + ":" + params[0].getType();
            removes.put(compound, method);
        }
    }

    private void addProperty(PropertyPattern pp) {
        boolean isIndexed = pp instanceof IdxPropertyPattern;
        HashMap hm = isIndexed ? this.idxPropertyPatterns : this.propertyPatterns;
        String name = pp.getName();
        PropertyPattern old = (PropertyPattern)this.propertyPatterns.get(name);
        if (old == null) {
            old = (PropertyPattern)this.idxPropertyPatterns.get(name);
        }
        if (old == null) {
            hm.put(name, pp);
            return;
        }
        Type opt = old.getType();
        Type npt = pp.getType();
        if (opt != null && npt != null && !opt.compareTo(npt, false)) {
            hm.put(name, pp);
            return;
        }
        boolean isOldIndexed = old instanceof IdxPropertyPattern;
        if (isIndexed || isOldIndexed) {
            if (isIndexed && !isOldIndexed) {
                this.propertyPatterns.remove(old.getName());
            } else if (!isIndexed && isOldIndexed) {
                this.idxPropertyPatterns.remove(old.getName());
            }
            IdxPropertyPattern composite = new IdxPropertyPattern(old, pp);
            this.idxPropertyPatterns.put(name, composite);
        } else {
            PropertyPattern composite = new PropertyPattern(old, pp);
            this.propertyPatterns.put(name, composite);
        }
    }

    void addEventSet(EventSetPattern esp) {
        String key = esp.getName() + esp.getType();
        EventSetPattern old = (EventSetPattern)this.eventSetPatterns.get(key);
        if (old == null) {
            this.eventSetPatterns.put(key, esp);
            return;
        }
        EventSetPattern composite = new EventSetPattern(old, esp);
        this.eventSetPatterns.put(key, composite);
    }

    static boolean isSubclass(ClassElement a, ClassElement b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getName().compareTo(b.getName(), false)) {
            return true;
        }
        ClassElement x = a;
        while (x != null) {
            if (x.getName().compareTo(b.getName(), false)) {
                return true;
            }
            if (b.isInterface()) {
                Identifier[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    ClassElement interfaceElement = ClassElement.forName((String)interfaces[i].getFullName());
                    if (PatternAnalyser.isSubclass(interfaceElement, b)) {
                        return true;
                    }
                    ++i;
                }
            }
            ClassElement classElement = x = x.getSuperclass() == null ? null : ClassElement.forName((String)x.getSuperclass().getFullName());
        }
        return false;
    }

    static abstract class LevelComparator {
        static LevelComparator PROPERTY = new Property();
        static LevelComparator IDX_PROPERTY = new IdxProperty();
        static LevelComparator EVENT_SET = new EventSet();

        LevelComparator() {
        }

        abstract boolean compare(int var1, Pattern var2, Pattern var3);

        abstract int getLevels();

        abstract void copyProperties(Pattern var1, Pattern var2);

        static class EventSet
        extends LevelComparator {
            EventSet() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((EventSetPattern)p1).getAddListenerMethod() == ((EventSetPattern)p2).getAddListenerMethod() || ((EventSetPattern)p1).getRemoveListenerMethod() == ((EventSetPattern)p2).getRemoveListenerMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 0;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((EventSetPattern)p1).copyProperties((EventSetPattern)p2);
            }
        }

        static class IdxProperty
        extends LevelComparator {
            IdxProperty() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((IdxPropertyPattern)p1).getIndexedGetterMethod() == ((IdxPropertyPattern)p2).getIndexedGetterMethod() && ((IdxPropertyPattern)p1).getIndexedSetterMethod() == ((IdxPropertyPattern)p2).getIndexedSetterMethod();
                    }
                    case 1: {
                        return ((IdxPropertyPattern)p1).getIndexedGetterMethod() == ((IdxPropertyPattern)p2).getIndexedGetterMethod();
                    }
                    case 2: {
                        return ((IdxPropertyPattern)p1).getIndexedSetterMethod() == ((IdxPropertyPattern)p2).getIndexedSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((IdxPropertyPattern)p1).copyProperties((IdxPropertyPattern)p2);
            }
        }

        static class Property
        extends LevelComparator {
            Property() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((PropertyPattern)p1).getGetterMethod() == ((PropertyPattern)p2).getGetterMethod() && ((PropertyPattern)p1).getSetterMethod() == ((PropertyPattern)p2).getSetterMethod();
                    }
                    case 1: {
                        return ((PropertyPattern)p1).getGetterMethod() == ((PropertyPattern)p2).getGetterMethod();
                    }
                    case 2: {
                        return ((PropertyPattern)p1).getSetterMethod() == ((PropertyPattern)p2).getSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((PropertyPattern)p1).copyProperties((PropertyPattern)p2);
            }
        }
    }
}

