/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import org.netbeans.modules.beans.BeanPatternGenerator;
import org.netbeans.modules.beans.EventSetInheritanceAnalyser;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.Utilities;

public class PropertyPattern
extends Pattern {
    public static final int READ_WRITE = 1;
    public static final int READ_ONLY = 2;
    public static final int WRITE_ONLY = 4;
    static final String PROPERTY_CHANGE = "firePropertyChange";
    static final String VETOABLE_CHANGE = "fireVetoableChange";
    protected MethodElement getterMethod = null;
    protected MethodElement setterMethod = null;
    protected FieldElement estimatedField = null;
    protected Type type;
    protected String name;

    public PropertyPattern(PatternAnalyser patternAnalyser, MethodElement getterMethod, MethodElement setterMethod) throws IntrospectionException {
        super(patternAnalyser);
        this.getterMethod = getterMethod;
        this.setterMethod = setterMethod;
        this.type = this.findPropertyType();
        this.name = this.findPropertyName();
    }

    PropertyPattern(PatternAnalyser patternAnalyser) {
        super(patternAnalyser);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String name, String type) throws SourceException {
        PropertyPattern pp = new PropertyPattern(patternAnalyser);
        pp.name = name;
        pp.type = Type.parse((String)type);
        pp.generateGetterMethod();
        pp.generateSetterMethod();
        return pp;
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport) throws SourceException {
        return PropertyPattern.create(patternAnalyser, name, type, mode, bound, constrained, withField, withReturn, withSet, withSupport, false, false);
    }

    static PropertyPattern create(PatternAnalyser patternAnalyser, String name, String type, int mode, boolean bound, boolean constrained, boolean withField, boolean withReturn, boolean withSet, boolean withSupport, boolean useSupport, boolean fromField) throws SourceException {
        PropertyPattern pp = new PropertyPattern(patternAnalyser);
        pp.name = name;
        pp.type = Type.parse((String)type);
        if ((withField || withSupport) && !fromField) {
            try {
                pp.generateField(true);
            }
            catch (SourceException e) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Cannot_Create_Field"), 2));
            }
        }
        String supportName = null;
        String vetoSupportName = null;
        if (withSupport) {
            boolean boundSupport = bound;
            boolean constrainedSupport = constrained;
            if (!useSupport) {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectPropertyChangeSupport(pp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.showInheritanceEventDialog(EventSetInheritanceAnalyser.detectVetoableChangeSupport(pp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            } else {
                if (boundSupport && (supportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectPropertyChangeSupport(pp.getDeclaringClass()), "PropertyChangeSupport")) != null) {
                    boundSupport = false;
                }
                if (constrainedSupport && (vetoSupportName = EventSetInheritanceAnalyser.getInheritanceEventSupportName(EventSetInheritanceAnalyser.detectVetoableChangeSupport(pp.getDeclaringClass()), "VetoableChangeSupport")) != null) {
                    constrainedSupport = false;
                }
            }
            if (boundSupport) {
                supportName = BeanPatternGenerator.supportField(pp.getDeclaringClass());
            }
            if (constrainedSupport) {
                vetoSupportName = BeanPatternGenerator.vetoSupportField(pp.getDeclaringClass());
            }
            if (boundSupport) {
                BeanPatternGenerator.supportListenerMethods(pp.getDeclaringClass(), supportName);
            }
            if (constrainedSupport) {
                BeanPatternGenerator.vetoSupportListenerMethods(pp.getDeclaringClass(), vetoSupportName);
            }
        }
        if (mode == 1 || mode == 2) {
            pp.generateGetterMethod(BeanPatternGenerator.propertyGetterBody(name, withReturn, !fromField), true);
        }
        if (mode == 1 || mode == 4) {
            pp.generateSetterMethod(BeanPatternGenerator.propertySetterBody(name, pp.getType(), bound, constrained, withSet, withSupport, supportName, vetoSupportName, !fromField), constrained, true);
        }
        return pp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SourceException {
        String oldName = this.name;
        if (!Utilities.isJavaIdentifier((String)name)) {
            throw new SourceException("Invalid event source name");
        }
        this.name = name;
        name = Pattern.capitalizeFirstLetter(name);
        if (this.getterMethod != null) {
            Identifier getterMethodID = Identifier.create((String)((this.getterMethod.getName().getName().startsWith("get") ? "get" : "is") + name));
            this.getterMethod.setName(getterMethodID);
            String oldGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), oldName);
            String newGetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), this.getName());
            if (!this.getterMethod.getJavaDoc().isEmpty() && oldGetterComment.trim().equals(this.getterMethod.getJavaDoc().getRawText().trim())) {
                this.getterMethod.getJavaDoc().setRawText(newGetterComment);
            }
        }
        if (this.setterMethod != null) {
            Identifier setterMethodID = Identifier.create((String)("set" + name));
            this.setterMethod.setName(setterMethodID);
            String oldSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), oldName, oldName);
            String newSetterComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), this.getName(), this.getName());
            if (!this.setterMethod.getJavaDoc().isEmpty() && oldSetterComment.trim().equals(this.setterMethod.getJavaDoc().getRawText().trim())) {
                this.setterMethod.getJavaDoc().setRawText(newSetterComment);
            }
        }
        if (this.estimatedField != null) {
            String oldFieldComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), oldName);
            String newFieldComment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), this.getName());
            if (!this.estimatedField.getJavaDoc().isEmpty() && oldFieldComment.trim().equals(this.estimatedField.getJavaDoc().getRawText().trim())) {
                this.estimatedField.getJavaDoc().setRawText(newFieldComment);
            }
            int mode = this.getMode();
            ElementFormat fmt = new ElementFormat("{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldName"), fmt.format((Element)this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                String oldSetterBody;
                String existingSetterBody;
                this.estimatedField.setName(Identifier.create((String)Introspector.decapitalize(name)));
                if (mode == 1 || mode == 2) {
                    String existingGetterBody = this.getterMethod.getBody().trim();
                    String oldGetterBody1 = BeanPatternGenerator.propertyGetterBody(oldName, true, true).trim();
                    String oldGetterBody2 = BeanPatternGenerator.propertyGetterBody(oldName, true, false).trim();
                    if (existingGetterBody.equals(oldGetterBody1)) {
                        this.getterMethod.setBody(BeanPatternGenerator.propertyGetterBody(this.getName(), true, true));
                    } else if (existingGetterBody.equals(oldGetterBody2)) {
                        this.getterMethod.setBody(BeanPatternGenerator.propertyGetterBody(this.getName(), true, false));
                    }
                }
                if ((mode == 1 || mode == 4) && (existingSetterBody = this.setterMethod.getBody().trim()).equals(oldSetterBody = BeanPatternGenerator.propertySetterBody(oldName, this.type, false, false, true, false, null, null).trim())) {
                    this.setterMethod.setBody(BeanPatternGenerator.propertySetterBody(this.getName(), this.getType(), false, false, true, false, null, null));
                    if (this.setterMethod != null) {
                        MethodParameter[] params = this.setterMethod.getParameters();
                        params[0].setName(Introspector.decapitalize(name));
                        this.setterMethod.setParameters(params);
                    }
                }
            }
        }
    }

    public int getMode() {
        if (this.setterMethod != null && this.getterMethod != null) {
            return 1;
        }
        if (this.getterMethod != null && this.setterMethod == null) {
            return 2;
        }
        if (this.setterMethod != null && this.getterMethod == null) {
            return 4;
        }
        return 0;
    }

    public void setMode(int mode) throws SourceException {
        if (this.getMode() == mode) {
            return;
        }
        switch (mode) {
            case 1: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod(null, true);
                }
                if (this.setterMethod != null) break;
                this.generateSetterMethod(null, false, true);
                break;
            }
            case 2: {
                if (this.getterMethod == null) {
                    this.generateGetterMethod(null, true);
                }
                if (this.setterMethod == null) break;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Setter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                this.deleteSetterMethod();
                break;
            }
            case 4: {
                if (this.setterMethod == null) {
                    this.generateSetterMethod(null, false, true);
                }
                if (this.getterMethod == null) break;
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)(PatternNode.getString("MSG_Delete_Getter") + PatternNode.getString("MSG_Continue_Confirm")), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) break;
                this.deleteGetterMethod();
            }
        }
    }

    public MethodElement getGetterMethod() {
        return this.getterMethod;
    }

    public MethodElement getSetterMethod() {
        return this.setterMethod;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) throws SourceException {
        MethodParameter[] params;
        if (this.type.compareTo(type, true)) {
            return;
        }
        if (this.getterMethod != null) {
            if (this.type.compareTo(Type.BOOLEAN, false)) {
                this.getterMethod.setName(Identifier.create((String)("get" + Pattern.capitalizeFirstLetter(this.getName()))));
            } else if (type.compareTo(Type.BOOLEAN, false)) {
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeToIs"), Pattern.capitalizeFirstLetter(this.getName()));
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    this.getterMethod.setName(Identifier.create((String)("is" + Pattern.capitalizeFirstLetter(this.getName()))));
                }
            }
            this.getterMethod.setReturn(type);
        }
        if (this.setterMethod != null && (params = this.setterMethod.getParameters()).length > 0) {
            Type oldType = params[0].getType();
            params[0].setType(type);
            this.setterMethod.setParameters(params);
            String body = this.setterMethod.getBody();
            if (body != null && (body.indexOf(PROPERTY_CHANGE) != -1 || body.indexOf(VETOABLE_CHANGE) != -1)) {
                String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeMethodBody"), this.setterMethod.getName().getName());
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    String newBody = this.regeneratePropertySupport(this.setterMethod.getBody(), null, params[0].getName(), type, oldType);
                    if (newBody != null) {
                        this.setterMethod.setBody(newBody);
                    }
                    if ((newBody = this.regeneratePropertySupport(this.setterMethod.getBody(), PROPERTY_CHANGE, params[0].getName(), type, oldType)) != null) {
                        this.setterMethod.setBody(newBody);
                    }
                    if ((newBody = this.regeneratePropertySupport(this.setterMethod.getBody(), VETOABLE_CHANGE, params[0].getName(), type, oldType)) != null) {
                        this.setterMethod.setBody(newBody);
                    }
                }
            }
        }
        this.type = type;
        if (this.estimatedField != null) {
            ElementFormat fmt = new ElementFormat("{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_ChangeFieldType"), fmt.format((Element)this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                this.estimatedField.setType(type);
            } else {
                this.estimatedField = null;
            }
        }
    }

    protected String regeneratePropertySupport(String methodBody, String changeType, String name, Type type, Type oldType) {
        if (methodBody == null) {
            return null;
        }
        int first = -1;
        boolean post_index = false;
        boolean pre_index = false;
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        if (oldType.isArray()) {
            oldType = PropertyPattern.getPrimitiveType(oldType);
        }
        if (changeType != null) {
            first = methodBody.indexOf(changeType);
            if (first == -1) {
                return null;
            }
        } else {
            String oldVarLine = " old" + Pattern.capitalizeFirstLetter(name) + " = " + propertyStyle + name;
            first = methodBody.indexOf(oldType.toString() + oldVarLine + ";");
            if (first == -1) {
                first = methodBody.indexOf(oldType.toString() + oldVarLine + "[index];");
                if (first == -1) {
                    first = methodBody.indexOf(oldType.toString() + "[]" + oldVarLine + ";");
                    if (first == -1) {
                        return null;
                    }
                    pre_index = true;
                } else {
                    post_index = true;
                }
            }
        }
        if (first == -1) {
            return null;
        }
        int last = methodBody.indexOf(59, first);
        if (first >= last) {
            return null;
        }
        StringBuffer newBody = new StringBuffer(100);
        if (changeType != null) {
            newBody.append(changeType + " (\"").append(name).append("\", ");
            if (type.isPrimitive()) {
                newBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                newBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                newBody.append("), ");
                newBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                newBody.append(name).append("))");
            } else {
                newBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                newBody.append(", ").append(name).append(")");
            }
        } else {
            newBody.append(type.toString());
            newBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            newBody.append(" = ").append(propertyStyle).append(name);
            if (post_index) {
                newBody.append("[index]");
            }
        }
        StringBuffer sb = new StringBuffer(methodBody);
        sb.delete(first, last);
        sb.insert(first, (Object)newBody);
        return sb.toString();
    }

    private static Type getPrimitiveType(Type type) {
        if (type.isArray()) {
            return PropertyPattern.getPrimitiveType(type.getElementType());
        }
        return type;
    }

    public Node.Cookie getCookie(Class cookieType) {
        if (this.getterMethod != null) {
            return this.getterMethod.getCookie(cookieType);
        }
        if (this.setterMethod != null) {
            return this.setterMethod.getCookie(cookieType);
        }
        return null;
    }

    public FieldElement getEstimatedField() {
        return this.estimatedField;
    }

    void setEstimatedField(FieldElement field) {
        this.estimatedField = field;
    }

    public void destroy() throws SourceException {
        if (this.estimatedField != null) {
            ElementFormat fmt = new ElementFormat("{m} {t} {n}");
            String mssg = MessageFormat.format(PatternNode.getString("FMT_DeleteField"), fmt.format((Element)this.estimatedField));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                this.deleteEstimatedField();
            }
        }
        this.deleteGetterMethod();
        this.deleteSetterMethod();
    }

    PropertyPattern(PropertyPattern x, PropertyPattern y) {
        super(y.patternAnalyser);
        MethodElement xr = x.getterMethod;
        MethodElement yr = y.getterMethod;
        this.getterMethod = xr;
        if (yr != null) {
            this.getterMethod = yr;
        }
        if (xr != null && yr != null && xr.getDeclaringClass() == yr.getDeclaringClass() && xr.getReturn().compareTo(Type.BOOLEAN, false) && yr.getReturn().compareTo(Type.BOOLEAN, false) && xr.getName().getName().indexOf("is") == 0 && yr.getName().getName().indexOf("get") == 0) {
            this.getterMethod = xr;
        }
        this.setterMethod = x.getSetterMethod();
        if (y.getSetterMethod() != null) {
            this.setterMethod = y.getSetterMethod();
        }
        try {
            this.type = this.findPropertyType();
        }
        catch (IntrospectionException ex) {
            throw new InternalError("Mixing invalid PropertyPattrens" + ex);
        }
        this.name = this.findPropertyName();
    }

    Type findPropertyType() throws IntrospectionException {
        Type resolvedType = null;
        if (this.getterMethod != null) {
            if (this.getterMethod.getParameters().length != 0) {
                throw new IntrospectionException("bad read method arg count");
            }
            resolvedType = this.getterMethod.getReturn();
            if (resolvedType.compareTo(Type.VOID, false)) {
                throw new IntrospectionException("read method " + this.getterMethod.getName().getName() + " returns void");
            }
        }
        if (this.setterMethod != null) {
            MethodParameter[] params = this.setterMethod.getParameters();
            if (params.length != 1) {
                throw new IntrospectionException("bad write method arg count");
            }
            if (resolvedType != null && !resolvedType.compareTo(params[0].getType(), false)) {
                throw new IntrospectionException("type mismatch between read and write methods");
            }
            resolvedType = params[0].getType();
        }
        return resolvedType;
    }

    String findPropertyName() {
        String methodName = null;
        if (this.getterMethod != null) {
            methodName = this.getterMethod.getName().getName();
        } else if (this.setterMethod != null) {
            methodName = this.setterMethod.getName().getName();
        } else {
            return null;
        }
        return methodName.startsWith("is") ? Introspector.decapitalize(methodName.substring(2)) : Introspector.decapitalize(methodName.substring(3));
    }

    void generateGetterMethod() throws SourceException {
        this.generateGetterMethod(null, false);
    }

    void generateGetterMethod(String body, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newGetter = new MethodElement();
        newGetter.setName(Identifier.create((String)((this.type == Type.BOOLEAN ? "is" : "get") + Pattern.capitalizeFirstLetter(this.getName()))));
        newGetter.setReturn(this.type);
        newGetter.setModifiers(1);
        if (declaringClass.isInterface()) {
            newGetter.setBody(null);
        } else if (body != null) {
            newGetter.setBody(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyGetter"), this.getName());
            newGetter.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newGetter);
        this.getterMethod = declaringClass.getMethod(newGetter.getName(), PropertyPattern.getParameterTypes(newGetter));
    }

    void generateSetterMethod() throws SourceException {
        this.generateSetterMethod(null, false, false);
    }

    void generateSetterMethod(String body, boolean constrained, boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        MethodElement newSetter = new MethodElement();
        newSetter.setName(Identifier.create((String)("set" + Pattern.capitalizeFirstLetter(this.getName()))));
        newSetter.setReturn(Type.VOID);
        newSetter.setModifiers(1);
        newSetter.setParameters(new MethodParameter[]{new MethodParameter(this.name, this.type, false)});
        if (constrained) {
            newSetter.setExceptions(new Identifier[]{Identifier.create((String)"java.beans.PropertyVetoException")});
        }
        if (declaringClass.isInterface()) {
            newSetter.setBody(null);
        } else if (body != null) {
            newSetter.setBody(body);
        }
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertySetter"), this.getName(), this.name);
            if (constrained) {
                comment = comment + PatternNode.getString("COMMENT_Tag_ThrowsPropertyVeto");
            }
            newSetter.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.addMethod(newSetter);
        this.setterMethod = declaringClass.getMethod(newSetter.getName(), PropertyPattern.getParameterTypes(newSetter));
    }

    void generateField() throws SourceException {
        this.generateField(false);
    }

    void generateField(boolean javadoc) throws SourceException {
        ClassElement declaringClass = this.getDeclaringClass();
        FieldElement newField = new FieldElement();
        String name = this.getName();
        if (PropertyActionSettings.getDefault().getPropStyle().equals("_")) {
            name = "_" + name;
        }
        newField.setName(Identifier.create((String)Introspector.decapitalize(name)));
        newField.setType(this.type);
        newField.setModifiers(2);
        if (javadoc) {
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_PropertyField"), name);
            newField.getJavaDoc().setRawText(comment);
        }
        if (declaringClass == null) {
            throw new SourceException();
        }
        if (declaringClass.getField(newField.getName()) == null) {
            declaringClass.addField(newField);
            this.estimatedField = declaringClass.getField(newField.getName());
        } else {
            FieldElement fe = declaringClass.getField(newField.getName());
            if ((fe.getModifiers() & 8) != 0) {
                throw new SourceException();
            }
            if (!fe.getType().getFullString().equals(newField.getType().getFullString())) {
                throw new SourceException();
            }
        }
    }

    void deleteEstimatedField() throws SourceException {
        if (this.estimatedField == null) {
            return;
        }
        ClassElement declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.removeField(this.estimatedField);
        this.estimatedField = null;
    }

    void deleteGetterMethod() throws SourceException {
        if (this.getterMethod == null) {
            return;
        }
        ClassElement declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.removeMethod(this.getterMethod);
        this.getterMethod = null;
    }

    void deleteSetterMethod() throws SourceException {
        if (this.setterMethod == null) {
            return;
        }
        ClassElement declaringClass = this.getDeclaringClass();
        if (declaringClass == null) {
            throw new SourceException();
        }
        declaringClass.removeMethod(this.setterMethod);
        this.setterMethod = null;
    }

    static Type[] getParameterTypes(MethodElement methodElement) {
        MethodParameter[] params = methodElement.getParameters();
        Type[] types = new Type[params == null ? 0 : params.length];
        int i = 0;
        while (i < params.length) {
            types[i] = params[i].getType();
            ++i;
        }
        return types;
    }

    /*
     * Unable to fully structure code
     */
    void copyProperties(PropertyPattern src) {
        if (!src.getType().equals((Object)this.getType()) || !src.getName().equals(this.getName()) || src.getMode() != this.getMode()) ** GOTO lbl-1000
        if (!(src.getEstimatedField() == null ? this.estimatedField == null : src.getEstimatedField().equals(this.estimatedField))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = changed = false;
        }
        if (src.getGetterMethod() != this.getterMethod) {
            this.getterMethod = src.getGetterMethod();
        }
        if (src.getSetterMethod() != this.setterMethod) {
            this.setterMethod = src.getSetterMethod();
        }
        if (src.getEstimatedField() != this.estimatedField) {
            this.estimatedField = src.getEstimatedField();
        }
        if (changed) {
            try {
                this.type = this.findPropertyType();
            }
            catch (IntrospectionException var3_3) {
                // empty catch block
            }
            this.name = this.findPropertyName();
            this.firePropertyChange(new PropertyChangeEvent(this, null, null, null));
        }
    }
}

