/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.ModePropertyEditor;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyTypeEditor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.FieldElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class PropertyPatternNode
extends PatternNode
implements IconBases {
    static /* synthetic */ Class class$org$netbeans$modules$beans$PropertyPatternNode;
    static /* synthetic */ Class class$org$openide$src$Type;
    static /* synthetic */ Class class$java$lang$String;

    public PropertyPatternNode(PropertyPattern pattern, boolean writeable) {
        super(pattern, Children.LEAF, writeable);
        this.superSetName(pattern.getName());
    }

    protected String resolveIconBase() {
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                return "org/netbeans/modules/beans/resources/propertyRW";
            }
            case 2: {
                return "org/netbeans/modules/beans/resources/propertyRO";
            }
            case 4: {
                return "org/netbeans/modules/beans/resources/propertyWO";
            }
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$beans$PropertyPatternNode == null ? (class$org$netbeans$modules$beans$PropertyPatternNode = PropertyPatternNode.class$("org.netbeans.modules.beans.PropertyPatternNode")) : class$org$netbeans$modules$beans$PropertyPatternNode);
    }

    String getTypeForHint() {
        return PatternNode.getString("HINT_Property");
    }

    public String getShortDescription() {
        String mode;
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                mode = PatternNode.getString("HINT_ReadWriteProperty");
                break;
            }
            case 2: {
                mode = PatternNode.getString("HINT_ReadOnlyProperty");
                break;
            }
            case 4: {
                mode = PatternNode.getString("HINT_WriteOnlyProperty");
                break;
            }
            default: {
                mode = "";
            }
        }
        return mode + " " + this.getTypeForHint() + " : " + ((FeatureDescriptor)((Object)this)).getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createTypeProperty(this.writeable));
        ps.put(this.createModeProperty(this.writeable));
        ps.put(this.createGetterProperty(false));
        ps.put(this.createSetterProperty(false));
        ps.put(this.createFieldProperty(false));
        return sheet;
    }

    public Node cloneNode() {
        return new PropertyPatternNode((PropertyPattern)this.pattern, this.writeable);
    }

    protected void setPatternName(String name) throws SourceException {
        if (this.pattern.getName().equals(name)) {
            return;
        }
        if (this.testNameValidity(name)) {
            ((PropertyPattern)this.pattern).setName(name);
            this.superSetName(name);
        }
    }

    public void setName(String name) {
        try {
            this.pattern.patternAnalyser.setIgnore(true);
            this.setPatternName(name);
            this.pattern.patternAnalyser.setIgnore(false);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
    }

    boolean testNameValidity(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        return true;
    }

    protected Node.Property createTypeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("type", class$org$openide$src$Type == null ? (class$org$openide$src$Type = PropertyPatternNode.class$("org.openide.src.Type")) : class$org$openide$src$Type, canW){

            public Object getValue() {
                return ((PropertyPattern)PropertyPatternNode.this.pattern).getType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setType((Type)val);
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
                catch (SourceException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new PropertyTypeEditor();
            }
        };
    }

    void fire() {
        this.firePropertyChange(null, null, null);
    }

    protected Node.Property createModeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("mode", Integer.TYPE, canW){

            public Object getValue() {
                return new Integer(((PropertyPattern)PropertyPatternNode.this.pattern).getMode());
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                try {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setMode((Integer)val);
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                    PropertyPatternNode.this.setIconBase(PropertyPatternNode.this.resolveIconBase());
                }
                catch (SourceException e) {
                    throw new InvocationTargetException(e);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ModePropertyEditor();
            }
        };
    }

    protected Node.Property createGetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("getter", class$java$lang$String == null ? (class$java$lang$String = PropertyPatternNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                ElementFormat fmt = new ElementFormat("{n} ({p})");
                MethodElement method = ((PropertyPattern)PropertyPatternNode.this.pattern).getGetterMethod();
                if (method == null) {
                    return PatternNode.getString("LAB_NoMethod");
                }
                return fmt.format((Element)method);
            }
        };
    }

    protected Node.Property createSetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("setter", class$java$lang$String == null ? (class$java$lang$String = PropertyPatternNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                ElementFormat fmt = new ElementFormat("{n} ({p})");
                MethodElement method = ((PropertyPattern)PropertyPatternNode.this.pattern).getSetterMethod();
                if (method == null) {
                    return PatternNode.getString("LAB_NoMethod");
                }
                return fmt.format((Element)method);
            }
        };
    }

    protected Node.Property createFieldProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("estimatedField", class$java$lang$String == null ? (class$java$lang$String = PropertyPatternNode.class$("java.lang.String")) : class$java$lang$String, canW){

            public Object getValue() {
                ElementFormat fmt = new ElementFormat("{t} {n}");
                FieldElement field = ((PropertyPattern)PropertyPatternNode.this.pattern).getEstimatedField();
                if (field == null) {
                    return PatternNode.getString("LAB_NoField");
                }
                return fmt.format((Element)field);
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

