/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BeanInfoSource;
import org.netbeans.modules.beans.beaninfo.BiFeature;
import org.netbeans.modules.beans.beaninfo.GenerateBeanInfoAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;

public class BiAnalyser
implements Node.Cookie {
    private static final String TAB = "    ";
    private static final String TABx2 = "        ";
    private static final String TABx3 = "            ";
    private static final String TABx4 = "                ";
    private static final String ICONNAME_C16 = "iconNameC16";
    private static final String ICONNAME_C32 = "iconNameC32";
    private static final String ICONNAME_M16 = "iconNameM16";
    private static final String ICONNAME_M32 = "iconNameM32";
    private static final String DEFAULT_PROPERTY_INDEX = "defaultPropertyIndex";
    private static final String DEFAULT_EVENT_INDEX = "defaultEventIndex";
    List descriptor;
    List properties;
    List idxProperties;
    List eventSets;
    List methods;
    BeanInfoSource bis;
    private boolean nullDescriptor = false;
    private boolean nullProperties = false;
    private boolean nullEventSets = false;
    private boolean nullMethods = false;
    private boolean lazyDescriptor = true;
    private boolean lazyProperties = true;
    private boolean lazyEventSets = true;
    private boolean lazyMethods = true;
    private final boolean olderVersion;
    private boolean superClassVersion = true;
    ClassElement classElement;
    private String iconC16;
    private String iconM16;
    private String iconC32;
    private String iconM32;
    private int defaultPropertyIndex = -1;
    private int defaultEventIndex = -1;
    private boolean useSuperClass = false;

    private int getIndexOfMethod(List al, MethodElement method) {
        if (method == null) {
            return -1;
        }
        MethodParameter[] parameters = method.getParameters();
        int i = 0;
        while (i < al.size()) {
            MethodParameter[] parameters2;
            MethodElement method2 = ((BiFeature.Method)al.get(i)).getElement();
            if (method2.getDeclaringClass().getName().getFullName().equals(method.getDeclaringClass().getName().getFullName()) && method2.getName().getFullName().equals(method.getName().getFullName()) && parameters.length == (parameters2 = method2.getParameters()).length) {
                int j = 0;
                while (j < parameters.length && parameters[j].getFullString().equals(parameters2[j].getFullString())) {
                    ++j;
                }
                if (j == parameters.length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    BiAnalyser(PatternAnalyser pa, ClassElement classElement) {
        int index;
        this.classElement = classElement;
        this.bis = new BeanInfoSource(classElement);
        this.olderVersion = this.bis.isNbBeanInfo() && this.bis.getMethodsSection() == null;
        this.superClassVersion = this.bis.isNbSuperclass() || !this.bis.exists();
        this.descriptor = new ArrayList();
        this.descriptor.add(new BiFeature.Descriptor(pa.getClassElement()));
        this.methods = new ArrayList();
        if (!this.olderVersion) {
            ClassElement superClass = pa.getClassElement();
            MethodElement[] meMethods = superClass.getMethods();
            int i = 0;
            while (i < meMethods.length) {
                this.methods.add(new BiFeature.Method(meMethods[i]));
                ++i;
            }
        }
        Collection col = pa.getPropertyPatterns();
        this.properties = new ArrayList(col.size());
        Iterator it = col.iterator();
        while (it.hasNext()) {
            PropertyPattern pp = (PropertyPattern)it.next();
            this.properties.add(new BiFeature.Property(pp));
            int i = 0;
            while (i < this.methods.size()) {
                index = this.getIndexOfMethod(this.methods, pp.getGetterMethod());
                if (index != -1) {
                    this.methods.remove(index);
                }
                if ((index = this.getIndexOfMethod(this.methods, pp.getSetterMethod())) != -1) {
                    this.methods.remove(index);
                }
                ++i;
            }
        }
        col = pa.getIdxPropertyPatterns();
        this.idxProperties = new ArrayList(col.size());
        it = col.iterator();
        while (it.hasNext()) {
            IdxPropertyPattern ipp = (IdxPropertyPattern)it.next();
            if (ipp.getType() != null && (!ipp.getType().isArray() || !ipp.getType().getElementType().equals((Object)ipp.getIndexedType()))) continue;
            this.idxProperties.add(new BiFeature.IdxProperty(ipp));
            index = this.getIndexOfMethod(this.methods, ipp.getGetterMethod());
            if (index != -1) {
                this.methods.remove(index);
            }
            if ((index = this.getIndexOfMethod(this.methods, ipp.getSetterMethod())) != -1) {
                this.methods.remove(index);
            }
            if ((index = this.getIndexOfMethod(this.methods, ipp.getIndexedGetterMethod())) != -1) {
                this.methods.remove(index);
            }
            if ((index = this.getIndexOfMethod(this.methods, ipp.getIndexedSetterMethod())) == -1) continue;
            this.methods.remove(index);
        }
        col = pa.getEventSetPatterns();
        this.eventSets = new ArrayList(col.size());
        it = col.iterator();
        while (it.hasNext()) {
            EventSetPattern esp = (EventSetPattern)it.next();
            this.eventSets.add(new BiFeature.EventSet(esp));
            index = this.getIndexOfMethod(this.methods, esp.getRemoveListenerMethod());
            if (index != -1) {
                this.methods.remove(index);
            }
            if ((index = this.getIndexOfMethod(this.methods, esp.getAddListenerMethod())) == -1) continue;
            this.methods.remove(index);
        }
        this.analyzeBeanInfoSource();
    }

    Collection getDescriptor() {
        return this.descriptor;
    }

    Collection getProperties() {
        return this.properties;
    }

    Collection getIdxProperties() {
        return this.idxProperties;
    }

    Collection getEventSets() {
        return this.eventSets;
    }

    Collection getMethods() {
        return this.methods;
    }

    public boolean isOlderVersion() {
        return this.olderVersion;
    }

    public boolean isSuperclassVersion() {
        return this.superClassVersion;
    }

    public String getIconC16() {
        return this.iconC16;
    }

    public void setIconC16(String iconC16) {
        this.iconC16 = iconC16;
    }

    public String getIconM16() {
        return this.iconM16;
    }

    public void setIconM16(String iconM16) {
        this.iconM16 = iconM16;
    }

    public String getIconC32() {
        return this.iconC32;
    }

    public void setIconC32(String iconC32) {
        this.iconC32 = iconC32;
    }

    public String getIconM32() {
        return this.iconM32;
    }

    public void setIconM32(String iconM32) {
        this.iconM32 = iconM32;
    }

    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    public void setDefaultPropertyIndex(int defaultPropertyIndex) {
        this.defaultPropertyIndex = defaultPropertyIndex;
    }

    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    public void setDefaultEventIndex(int defaultEventIndex) {
        this.defaultEventIndex = defaultEventIndex;
    }

    public boolean isUseSuperClass() {
        return this.useSuperClass;
    }

    public void setUseSuperClass(boolean useSuperClass) {
        this.useSuperClass = useSuperClass;
    }

    boolean isNullDescriptor() {
        return this.nullDescriptor;
    }

    boolean isNullProperties() {
        return this.nullProperties;
    }

    boolean isNullMethods() {
        return this.nullMethods;
    }

    void setNullDescriptor(boolean nullDescriptor) {
        this.nullDescriptor = nullDescriptor;
    }

    void setNullProperties(boolean nullProperties) {
        this.nullProperties = nullProperties;
    }

    void setNullMethods(boolean nullMethods) {
        this.nullMethods = nullMethods;
    }

    boolean isNullEventSets() {
        return this.nullEventSets;
    }

    void setNullEventSets(boolean nullEventSets) {
        this.nullEventSets = nullEventSets;
    }

    public boolean isLazyDescriptor() {
        return this.lazyDescriptor;
    }

    public boolean isLazyProperties() {
        return this.lazyProperties;
    }

    public boolean isLazyMethods() {
        return this.lazyMethods;
    }

    public void setLazyDescriptor(boolean lazyDescriptor) {
        this.lazyDescriptor = lazyDescriptor;
    }

    public void setLazyProperties(boolean lazyProperties) {
        this.lazyProperties = lazyProperties;
    }

    public void setLazyMethods(boolean lazyMethods) {
        this.lazyMethods = lazyMethods;
    }

    public boolean isLazyEventSets() {
        return this.lazyEventSets;
    }

    public void setLazyEventSets(boolean lazyEventSets) {
        this.lazyEventSets = lazyEventSets;
    }

    void regenerateSource() {
        if (this.bis.exists()) {
            if (!this.bis.isNbBeanInfo()) {
                String mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoExists");
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (!nd.getValue().equals(NotifyDescriptor.YES_OPTION)) {
                    return;
                }
                try {
                    this.bis.delete();
                }
                catch (IOException e) {
                    mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    nd = new NotifyDescriptor.Message((Object)mssg);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            } else if (!this.bis.isNbBeanInfoDescriptor()) {
                try {
                    this.bis.delete();
                }
                catch (IOException e) {
                    String mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                    nd = new NotifyDescriptor.Message((Object)mssg);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    return;
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            } else {
                if (!this.iconBlockRequired() && this.bis.hasIconInfo() || this.iconBlockRequired() && !this.bis.hasIconInfo()) {
                    try {
                        this.bis.delete();
                    }
                    catch (IOException e) {
                        String mssg = GenerateBeanInfoAction.getString("MSG_BeanInfoCantDelete");
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)mssg, 0);
                        nd = new NotifyDescriptor.Message((Object)mssg);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        return;
                    }
                }
                this.bis.createFromTemplate(this.iconBlockRequired());
            }
        } else {
            this.bis.createFromTemplate(this.iconBlockRequired());
            if (!this.bis.isNbBeanInfo()) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BiAnalyser.this.bis.open();
                BiAnalyser.this.regenerateBeanDescriptor();
                BiAnalyser.this.regenerateProperties();
                BiAnalyser.this.regenerateEvents();
                if (!BiAnalyser.this.olderVersion) {
                    BiAnalyser.this.regenerateMethods();
                }
                BiAnalyser.this.regenerateIcons();
                BiAnalyser.this.regenerateDefaultIdx();
                BiAnalyser.this.regenerateSuperclass();
            }
        });
    }

    private void regenerateBeanDescriptor() {
        StringBuffer sb = new StringBuffer(512);
        boolean methodCount = false;
        if (this.nullDescriptor) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullDescriptor"));
            sb.append("    private static BeanDescriptor beanDescriptor = null;\n");
            sb.append("    private static BeanDescriptor getBdescriptor(){\n\n");
            this.bis.setDescriptorSection(sb.toString(), "\n        return beanDescriptor;\n    }\n\n");
            return;
        }
        ArrayList allDescriptor = new ArrayList(this.getMethods().size());
        allDescriptor.addAll(this.getDescriptor());
        Iterator it = ((AbstractList)allDescriptor).iterator();
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (!bif.isIncluded()) continue;
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_BeanDescriptor"));
            if (!this.lazyDescriptor) {
                sb.append("    private static BeanDescriptor beanDescriptor = ");
                sb.append(bif.getCreationString());
                sb.append(";\n\n");
                sb.append("    private static BeanDescriptor getBdescriptor(){\n");
                sb.append("        return beanDescriptor;\n    }\n\n");
                sb.append("    static {\n");
            } else {
                sb.append("    /*lazy BeanDescriptor*/\n");
                sb.append("    private static BeanDescriptor getBdescriptor(){\n");
                sb.append("        BeanDescriptor beanDescriptor = ");
                sb.append(bif.getCreationString());
                sb.append(";\n");
            }
            Collection cs = bif.getCustomizationStrings();
            Iterator csit = cs.iterator();
            while (csit.hasNext()) {
                sb.append("        beanDescriptor.");
                sb.append((String)csit.next()).append(";\n");
            }
            if (!this.lazyDescriptor) {
                this.bis.setDescriptorSection(sb.toString(), "}\n");
                continue;
            }
            this.bis.setDescriptorSection(sb.toString(), "        return beanDescriptor;\n        }\n");
        }
    }

    private void regenerateProperties() {
        StringBuffer sb = new StringBuffer(512);
        int propertyCount = 0;
        if (this.nullProperties) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullProperties"));
            sb.append("    private static PropertyDescriptor[] properties = null;\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            this.bis.setPropertiesSection(sb.toString(), "        return properties;\n    }\n\n");
            return;
        }
        TreeSet allProperties = new TreeSet(this.getProperties());
        allProperties.addAll(this.getIdxProperties());
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_PropertyIdentifiers"));
        Iterator it = allProperties.iterator();
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("PROPERTY_" + bif.getName());
            sb.append(" = " + propertyCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_PropertyArray"));
        if (!this.lazyProperties) {
            sb.append("    private static PropertyDescriptor[] properties = new PropertyDescriptor[" + propertyCount + "];\n\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            sb.append("        return properties;\n    }\n\n");
        } else {
            sb.append("    /*lazy PropertyDescriptor*/\n");
            sb.append("    private static PropertyDescriptor[] getPdescriptor(){\n");
            sb.append("        PropertyDescriptor[] properties = new PropertyDescriptor[");
            sb.append(propertyCount);
            sb.append("];\n");
        }
        if (propertyCount > 0) {
            if (!this.lazyProperties) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n        try {\n");
            }
        }
        it = allProperties.iterator();
        int i = 0;
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (bif.isIncluded()) {
                sb.append("            properties[PROPERTY_").append(bif.getName()).append("] = ");
                sb.append(bif.getCreationString()).append(";\n");
                Collection cs = bif.getCustomizationStrings();
                Iterator csit = cs.iterator();
                while (csit.hasNext()) {
                    sb.append("            properties[PROPERTY_").append(bif.getName()).append("].");
                    sb.append((String)csit.next()).append(";\n");
                }
            }
            ++i;
        }
        if (propertyCount > 0) {
            sb.append("        }\n        catch( IntrospectionException e) {}");
        }
        if (!this.lazyProperties) {
            this.bis.setPropertiesSection(sb.toString(), propertyCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setPropertiesSection(sb.toString(), "        return properties;\n        }\n");
        }
    }

    private void regenerateMethods() {
        StringBuffer sb = new StringBuffer(512);
        int methodCount = 0;
        if (this.nullMethods) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullMethods"));
            sb.append("    private static MethodDescriptor[] methods = null;\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            this.bis.setMethodsSection(sb.toString(), "        return methods;\n    }\n\n");
            return;
        }
        TreeSet allMethods = new TreeSet(this.getMethods());
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_MethodIdentifiers"));
        Iterator it = allMethods.iterator();
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("METHOD_" + bif.getName() + methodCount);
            sb.append(" = " + methodCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_MethodArray"));
        if (!this.lazyMethods) {
            sb.append("    private static MethodDescriptor[] methods = new MethodDescriptor[" + methodCount + "];\n\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            sb.append("        return methods;\n    }\n\n");
        } else {
            sb.append("    /*lazy MethodDescriptor*/\n");
            sb.append("    private static MethodDescriptor[] getMdescriptor(){\n");
            sb.append("        MethodDescriptor[] methods = new MethodDescriptor[");
            sb.append(methodCount);
            sb.append("];\n");
        }
        if (methodCount > 0) {
            if (!this.lazyMethods) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n        try {\n");
            }
        }
        it = allMethods.iterator();
        int i = 0;
        int lCurMethodCount = 0;
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (!bif.isIncluded()) continue;
            sb.append("            methods[METHOD_").append(bif.getName()).append(lCurMethodCount++ + "] = ");
            sb.append(bif.getCreationString()).append(";\n");
            Collection cs = bif.getCustomizationStrings();
            Iterator csit = cs.iterator();
            while (csit.hasNext()) {
                sb.append("            methods[METHOD_").append(bif.getName()).append(i + "].");
                sb.append((String)csit.next()).append(";\n");
            }
            ++i;
        }
        if (methodCount > 0) {
            sb.append("        }\n        catch( Exception e) {}");
        }
        if (!this.lazyMethods) {
            this.bis.setMethodsSection(sb.toString(), methodCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setMethodsSection(sb.toString(), "        return methods;\n        }\n");
        }
    }

    private void regenerateEvents() {
        StringBuffer sb = new StringBuffer(512);
        int eventCount = 0;
        if (this.nullEventSets) {
            sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_NullEventSets"));
            sb.append("    private static EventSetDescriptor[] eventSets = null;\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            this.bis.setEventSetsSection(sb.toString(), "        return eventSets;\n    }\n\n");
            return;
        }
        sb.append(TAB + GenerateBeanInfoAction.getString("COMMENT_EventSetsIdentifiers"));
        TreeSet events = new TreeSet(this.eventSets);
        Iterator it = events.iterator();
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (!bif.isIncluded()) continue;
            sb.append("    private static final int ");
            sb.append("EVENT_" + bif.getName());
            sb.append(" = " + eventCount++ + ";");
            sb.append("\n");
        }
        sb.append("\n    " + GenerateBeanInfoAction.getString("COMMENT_EventSetsArray"));
        if (!this.lazyEventSets) {
            sb.append("    private static EventSetDescriptor[] eventSets = new EventSetDescriptor[" + eventCount + "];\n\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            sb.append("        return eventSets;\n    }\n\n");
        } else {
            sb.append("    /*lazy EventSetDescriptor*/\n");
            sb.append("    private static EventSetDescriptor[] getEdescriptor(){\n");
            sb.append("        EventSetDescriptor[] eventSets = new EventSetDescriptor[");
            sb.append(eventCount);
            sb.append("];\n");
        }
        if (eventCount > 0) {
            if (!this.lazyEventSets) {
                sb.append("    static {\n        try {\n");
            } else {
                sb.append("    \n            try {\n");
            }
        }
        it = events.iterator();
        int i = 0;
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            if (bif.isIncluded()) {
                sb.append("            eventSets[EVENT_").append(bif.getName()).append("] = ");
                sb.append(bif.getCreationString()).append(";\n");
                Collection cs = bif.getCustomizationStrings();
                Iterator csit = cs.iterator();
                while (csit.hasNext()) {
                    sb.append("            eventSets[EVENT_").append(bif.getName()).append("].");
                    sb.append((String)csit.next()).append(";\n");
                }
            }
            ++i;
        }
        if (eventCount > 0) {
            sb.append("        }\n        catch( IntrospectionException e) {}");
        }
        if (!this.lazyEventSets) {
            this.bis.setEventSetsSection(sb.toString(), eventCount > 0 ? "}\n" : "  \n");
        } else {
            this.bis.setEventSetsSection(sb.toString(), "        return eventSets;\n        }\n");
        }
    }

    private void regenerateIcons() {
        if (this.iconBlockRequired()) {
            StringBuffer sb = new StringBuffer(200);
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_C16, this.iconC16));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_C32, this.iconC32));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_M16, this.iconM16));
            sb.append(BiAnalyser.getIconDeclaration(ICONNAME_M32, this.iconM32));
            this.bis.setIconsSection(sb.toString());
        }
    }

    private boolean iconBlockRequired() {
        return this.iconC16 != null | this.iconC32 != null | this.iconM16 != null | this.iconM32 != null;
    }

    private static String getIconDeclaration(String name, String resource) {
        StringBuffer sb = new StringBuffer(80);
        sb.append("    private static String ").append(name).append(" = ");
        if (resource == null || resource.trim().length() == 0) {
            sb.append("null;\n");
        } else {
            sb.append("\"").append(resource.trim()).append("\";\n");
        }
        return sb.toString();
    }

    private void regenerateDefaultIdx() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("    private static final int defaultPropertyIndex = ").append(this.defaultPropertyIndex).append(";\n");
        sb.append("    private static final int defaultEventIndex = ").append(this.defaultEventIndex).append(";\n");
        this.bis.setDefaultIdxSection(sb.toString());
    }

    private void regenerateSuperclass() {
        StringBuffer sb = new StringBuffer(100);
        if (this.isUseSuperClass()) {
            sb.append("    public BeanInfo[] getAdditionalBeanInfo() {\n");
            sb.append("        Class superclass = " + this.classElement.getName().getName() + ".class.getSuperclass();\n");
            sb.append("        BeanInfo sbi = null;\n");
            sb.append("        try {\n");
            sb.append("            sbi = Introspector.getBeanInfo(superclass);\n");
            this.bis.setSuperclassSection(sb.toString(), "            }\ncatch(IntrospectionException ex) {\n}\n\nreturn new BeanInfo[] { sbi };\n}\n");
        } else {
            this.bis.setSuperclassSection("\n", "\n");
        }
    }

    private void analyzeBeanInfoSource() {
        if (!this.bis.isNbBeanInfo()) {
            return;
        }
        String section = this.bis.getIconsSection();
        Collection code = BiAnalyser.normalizeText(section);
        this.setIconsFromBeanInfo(code);
        section = this.bis.getDefaultIdxSection();
        code = BiAnalyser.normalizeText(section);
        this.setDefaultIdxFromBeanInfo(code);
        section = this.bis.getDescriptorSection();
        code = BiAnalyser.normalizeText(section);
        this.nullDescriptor = this.setPropertiesFromBeanInfo(this.descriptor, code, "BeanDescriptor");
        if (!this.nullDescriptor) {
            this.setLazyDescriptor(BiAnalyser.isLazy(code, "BeanDescriptor"));
        }
        section = this.bis.getPropertiesSection();
        code = BiAnalyser.normalizeText(section);
        this.nullProperties = this.setPropertiesFromBeanInfo(this.properties, code, "PropertyDescriptor[]");
        if (!this.nullProperties) {
            this.setLazyProperties(BiAnalyser.isLazy(code, "PropertyDescriptor"));
            this.setPropertiesFromBeanInfo(this.idxProperties, code, "PropertyDescriptor[]");
        }
        if ((section = this.bis.getMethodsSection()) == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)GenerateBeanInfoAction.getString("MSG_Old_Version"), 2));
            this.nullMethods = true;
        } else {
            code = BiAnalyser.normalizeText(section);
            this.nullMethods = this.setPropertiesFromBeanInfo(this.methods, code, "MethodDescriptor[]");
            if (!this.nullMethods) {
                this.setLazyMethods(BiAnalyser.isLazy(code, "MethodDescriptor"));
            }
        }
        section = this.bis.getEventSetsSection();
        code = BiAnalyser.normalizeText(section);
        this.nullEventSets = this.setPropertiesFromBeanInfo(this.eventSets, code, "EventSetDescriptor[]");
        if (!this.nullEventSets) {
            this.setLazyEventSets(BiAnalyser.isLazy(code, "EventSetDescriptor"));
        }
        section = this.bis.getSuperclassSection();
        code = BiAnalyser.normalizeText(section);
        this.setUseSuperClass(BiAnalyser.hasSuperClass(code));
    }

    static Collection normalizeText(String code) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(100);
        boolean IN_TEXT = false;
        boolean IN_WHITE = true;
        int mode = 1;
        boolean eo_javaid = false;
        boolean guarded = false;
        boolean escape = false;
        int i = 0;
        while (code != null && i < code.length()) {
            char ch = code.charAt(i);
            if (ch != '\"') {
                escape = false;
            }
            switch (mode) {
                case 0: {
                    if (!Character.isWhitespace(ch)) {
                        if (ch == ';') {
                            sb.append(ch);
                            result.add(sb.toString());
                            sb.setLength(0);
                            mode = 1;
                            eo_javaid = false;
                            break;
                        }
                        if (ch == '\\') {
                            escape = true;
                            sb.append(ch);
                            break;
                        }
                        if (ch == '\"') {
                            if (!escape) {
                                guarded = !guarded;
                            }
                            escape = false;
                            sb.append(ch);
                            break;
                        }
                        sb.append(ch);
                        break;
                    }
                    if (guarded) {
                        sb.append(ch);
                        break;
                    }
                    eo_javaid = Character.isJavaIdentifierPart(code.charAt(i - 1));
                    mode = 1;
                    break;
                }
                case 1: {
                    if (Character.isWhitespace(ch)) break;
                    if (eo_javaid && Character.isJavaIdentifierStart(ch)) {
                        sb.append(' ');
                    } else if (ch == '\\') {
                        escape = true;
                        sb.append(ch);
                    } else if (ch == '\"') {
                        if (!escape) {
                            guarded = !guarded;
                        }
                        escape = false;
                    }
                    sb.append(ch);
                    mode = 0;
                }
            }
            ++i;
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }

    static String[] getParameters(String command) {
        int beg = command.indexOf(40);
        int end = command.lastIndexOf(41);
        if (beg == -1 || end == -1 || ++beg >= end) {
            return new String[0];
        }
        String paramString = command.substring(beg, end);
        StringTokenizer strTok = new StringTokenizer(paramString, ",");
        String[] resultStrs = new String[strTok.countTokens()];
        int i = 0;
        while (strTok.hasMoreTokens()) {
            resultStrs[i] = strTok.nextToken();
            ++i;
        }
        return resultStrs;
    }

    static String getArgumentParameter(String command) {
        int beg = command.indexOf(40);
        int end = command.lastIndexOf(41);
        if (beg != -1 && end != -1 && ++beg < end) {
            return command.substring(beg, end);
        }
        return null;
    }

    static String getInitializer(String command) {
        int beg = command.lastIndexOf(61);
        int end = command.lastIndexOf(59);
        if (beg != -1 && end != -1 && ++beg < end) {
            return command.substring(beg, end).trim();
        }
        return null;
    }

    static boolean isLazy(Collection code, String name) {
        Iterator it = code.iterator();
        while (it.hasNext()) {
            String statement = (String)it.next();
            if (statement.indexOf(name) == -1 || statement.indexOf("/*lazy " + name + "*/") == -1) continue;
            return true;
        }
        return false;
    }

    static boolean hasSuperClass(Collection code) {
        Iterator it = code.iterator();
        while (it.hasNext()) {
            String statement = (String)it.next();
            if (statement.indexOf("public BeanInfo[]getAdditionalBeanInfo()") == -1) continue;
            return true;
        }
        return false;
    }

    static String removeQuotation(String text) {
        int beg = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (beg != -1 && end != -1 && ++beg < end) {
            return text.substring(beg, end);
        }
        return null;
    }

    boolean setPropertiesFromBeanInfo(Collection features, Collection code, String name) {
        Iterator it = code.iterator();
        while (it.hasNext()) {
            String statement = (String)it.next();
            if (statement.indexOf(name) == -1) continue;
            if (!"null".equals(BiAnalyser.getInitializer(statement))) break;
            return true;
        }
        it = features.iterator();
        while (it.hasNext()) {
            BiFeature bif = (BiFeature)it.next();
            bif.setBrackets(bif.getBrackets());
            bif.analyzeCustomization(code);
        }
        return false;
    }

    void setIconsFromBeanInfo(Collection code) {
        Iterator it = code.iterator();
        while (it.hasNext()) {
            String statement = (String)it.next();
            if (statement.indexOf(ICONNAME_C16) != -1) {
                this.iconC16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_C32) != -1) {
                this.iconC32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_M16) != -1) {
                this.iconM16 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
                continue;
            }
            if (statement.indexOf(ICONNAME_M32) == -1) continue;
            this.iconM32 = BiAnalyser.removeQuotation(BiAnalyser.getInitializer(statement));
        }
    }

    void setDefaultIdxFromBeanInfo(Collection code) {
        Iterator it = code.iterator();
        while (it.hasNext()) {
            String statement = (String)it.next();
            if (statement.indexOf(DEFAULT_PROPERTY_INDEX) != -1) {
                try {
                    this.defaultPropertyIndex = Integer.parseInt(BiAnalyser.getInitializer(statement));
                }
                catch (NumberFormatException e) {
                    this.defaultPropertyIndex = -1;
                }
                continue;
            }
            if (statement.indexOf(DEFAULT_EVENT_INDEX) == -1) continue;
            try {
                this.defaultEventIndex = Integer.parseInt(BiAnalyser.getInitializer(statement));
            }
            catch (NumberFormatException e) {
                this.defaultEventIndex = -1;
            }
        }
    }
}

