/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public abstract class BiFeature
implements IconBases,
Node.Cookie,
Comparable {
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";

    public BiFeature(Pattern pattern) {
        this.name = pattern.getName();
    }

    public BiFeature(MethodElement me) {
        this.displayName = "\"\"";
        this.name = me.getName().getName();
    }

    public BiFeature(ClassElement ce) {
        this.name = "beanDescriptor";
    }

    abstract String getCreationString();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    abstract String getBracketedName();

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String brackets) {
        this.brackets = brackets;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getToolTip() {
        return this.getName();
    }

    Collection getCustomizationStrings() {
        ArrayList<String> col = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(100);
        if (this.expert) {
            sb.setLength(0);
            sb.append(TEXT_EXPERT).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.hidden) {
            sb.setLength(0);
            sb.append(TEXT_HIDDEN).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.preferred) {
            sb.setLength(0);
            sb.append(TEXT_PREFERRED).append(" ( true )");
            col.add(sb.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_DISPLAY_NAME).append(" ( ");
            sb.append(this.displayName).append(" )");
            col.add(sb.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            sb.setLength(0);
            sb.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            sb.append(this.shortDescription).append(" )");
            col.add(sb.toString());
        }
        return col;
    }

    void analyzeCustomization(Collection code) {
        this.setIncluded(false);
        Iterator it = code.iterator();
        String n = this.getBracketedName();
        String stNew = new String(n + "=new");
        String stExpert = new String(n + "." + TEXT_EXPERT);
        String stHidden = new String(n + "." + TEXT_HIDDEN);
        String stPreferred = new String(n + "." + TEXT_PREFERRED);
        String stDisplayName = new String(n + "." + TEXT_DISPLAY_NAME);
        String stShortDescription = new String(n + "." + TEXT_SHORT_DESCRIPTION);
        while (it.hasNext()) {
            String param;
            String statement = (String)it.next();
            if (statement.indexOf(stNew) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(statement);
                continue;
            }
            if (statement.indexOf(stExpert) != -1) {
                this.setExpert(true);
                continue;
            }
            if (statement.indexOf(stHidden) != -1) {
                this.setHidden(true);
                continue;
            }
            if (statement.indexOf(stPreferred) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (statement.indexOf(stDisplayName) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setDisplayName(param);
                continue;
            }
            if (statement.indexOf(stShortDescription) != -1) {
                param = BiAnalyser.getArgumentParameter(statement);
                if (param == null) continue;
                this.setShortDescription(param);
                continue;
            }
            this.analyzeCustomizationString(statement);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    public int compareTo(Object other) {
        if (!(other instanceof BiFeature)) {
            return -1;
        }
        BiFeature bf = (BiFeature)other;
        return this.getName().compareToIgnoreCase(bf.getName());
    }

    public static class Method
    extends BiFeature {
        MethodElement element;
        private String varName;
        private MethodElement me;

        Method(MethodElement me) {
            super(me);
            this.element = me;
            this.me = me;
        }

        String getBracketedName() {
            return "[METHOD_" + this.getName() + "]";
        }

        private static String getSignature(ClassElement cls) {
            Identifier n = cls.getName();
            if (!cls.isInner()) {
                return n.getFullName();
            }
            StringBuffer sb = new StringBuffer(n.getFullName());
            ClassElement c = cls;
            int index = sb.length();
            while (true) {
                sb.setCharAt(index -= n.getSourceName().length() + 1, '$');
                c = c.getDeclaringClass();
                if (!c.isInner()) break;
                n = c.getName();
            }
            return sb.toString();
        }

        private static String getVMClassName(Type type) {
            try {
                if (!type.isArray()) {
                    String fqn = type.getClassName().getFullName();
                    ClassElement cls = ClassElement.forName((String)fqn);
                    if (cls == null) {
                        return fqn;
                    }
                    return Method.getSignature(cls);
                }
                int depth = 0;
                Type t = type;
                do {
                    ++depth;
                } while ((t = t.getElementType()).isArray());
                StringBuffer sb = new StringBuffer(depth + 1);
                int i = 0;
                while (i < depth) {
                    sb.append('[');
                    ++i;
                }
                if (t.isPrimitive()) {
                    sb.append(Method.getPrimitiveCode(t));
                } else {
                    sb.append('L');
                    sb.append(Method.getVMClassName(t));
                    sb.append(';');
                }
                return sb.toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return "";
            }
        }

        private static String getPrimitiveCode(Type type) {
            if (type.equals((Object)Type.INT)) {
                return "I";
            }
            if (type.equals((Object)Type.BOOLEAN)) {
                return "Z";
            }
            if (type.equals((Object)Type.CHAR)) {
                return "C";
            }
            if (type.equals((Object)Type.LONG)) {
                return "J";
            }
            if (type.equals((Object)Type.SHORT)) {
                return "S";
            }
            if (type.equals((Object)Type.BYTE)) {
                return "B";
            }
            if (type.equals((Object)Type.FLOAT)) {
                return "F";
            }
            if (type.equals((Object)Type.DOUBLE)) {
                return "D";
            }
            return "V";
        }

        private static String getTypeClass(Type type) {
            if (type.isPrimitive()) {
                if (type.equals((Object)Type.INT)) {
                    return "Integer.TYPE";
                }
                if (type.equals((Object)Type.BOOLEAN)) {
                    return "Boolean.TYPE";
                }
                if (type.equals((Object)Type.CHAR)) {
                    return "Character.TYPE";
                }
                if (type.equals((Object)Type.LONG)) {
                    return "Long.TYPE";
                }
                if (type.equals((Object)Type.SHORT)) {
                    return "Short.TYPE";
                }
                if (type.equals((Object)Type.BYTE)) {
                    return "Byte.TYPE";
                }
                if (type.equals((Object)Type.FLOAT)) {
                    return "Float.TYPE";
                }
                return "Double.TYPE";
            }
            if (type.isClass()) {
                try {
                    return type.getClassName().getFullName() + ".class";
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return type.toString() + ".class";
                }
            }
            return "Class.forName(\"" + Method.getVMClassName(type) + "\")";
        }

        public String getToolTip() {
            StringBuffer sb = new StringBuffer(100);
            sb.append(this.element.getName().getFullName() + "(");
            MethodParameter[] parameters = this.element.getParameters();
            int i = 0;
            while (i < parameters.length) {
                sb.append(parameters[i].getType().getFullString());
                if (i < parameters.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(")");
            return sb.toString();
        }

        MethodElement getElement() {
            return this.element;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new MethodDescriptor ( ");
            sb.append(this.element.getDeclaringClass().getName().getFullName() + ".class.getMethod(\"" + this.element.getName().getFullName() + "\", ");
            sb.append("new Class[] {");
            MethodParameter[] parameters = this.element.getParameters();
            int i = 0;
            while (i < parameters.length) {
                try {
                    sb.append(Method.getTypeClass(parameters[i].getType()));
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                if (i < parameters.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append("}))");
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCustomizationString(String statement) {
        }

        void analyzeCreationString(String statement) {
        }

        void analyzeCustomization(Collection code) {
            if (this.me != null) {
                String creation = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                Iterator it = code.iterator();
                while (it.hasNext()) {
                    String statement = (String)it.next();
                    int index = statement.indexOf(creation);
                    if (index <= -1) continue;
                    this.varName = statement.substring(statement.indexOf("methods[METHOD_") + 15, index - 2);
                    break;
                }
                this.me = null;
            }
            String realName = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(code);
            this.setName(realName);
        }
    }

    public static class EventSet
    extends BiFeature
    implements Comparator {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;

        EventSet(EventSetPattern esp) {
            super(esp);
            this.pattern = esp;
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean isInDefaultEventSet) {
            this.isInDefaultEventSet = isInDefaultEventSet;
        }

        String getBracketedName() {
            return "[EVENT_" + this.getName() + "]";
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof MethodElement) || !(o2 instanceof MethodElement)) {
                throw new IllegalArgumentException();
            }
            MethodElement m1 = (MethodElement)o1;
            MethodElement m2 = (MethodElement)o2;
            return m1.getName().getName().compareTo(m2.getName().getName());
        }

        String getCreationString() {
            MethodElement[] listenerMethods;
            StringBuffer sb = new StringBuffer(100);
            try {
                Type listenerType = this.pattern.getType();
                ClassElement listener = ClassElement.forName((String)listenerType.getClassName().getFullName());
                listenerMethods = listener.getMethods();
                Arrays.sort(listenerMethods, this);
            }
            catch (IllegalStateException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                listenerMethods = new MethodElement[]{};
            }
            sb.append("new EventSetDescriptor ( ");
            sb.append(this.pattern.getDeclaringClass().getName().getFullName() + ".class, ");
            sb.append("\"" + this.getName() + "\", ");
            try {
                sb.append(this.pattern.getType().getClassName().getFullName() + ".class, ");
            }
            catch (IllegalStateException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                listenerMethods = new MethodElement[]{};
            }
            sb.append("new String[] {");
            int i = 0;
            while (i < listenerMethods.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"" + listenerMethods[i].getName() + "\"");
                ++i;
            }
            sb.append("}, ");
            sb.append("\"" + this.pattern.getAddListenerMethod().getName().getName() + "\", ");
            sb.append("\"" + this.pattern.getRemoveListenerMethod().getName().getName() + "\" )");
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                if (this.isUnicast()) {
                    return "org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            StringBuffer sb = new StringBuffer(100);
            if (this.isUnicast()) {
                sb.setLength(0);
                sb.append(TEXT_UNICAST).append(" ( true )");
                col.add(sb.toString());
            }
            if (!this.isInDefaultEventSet) {
                sb.setLength(0);
                sb.append(TEXT_IN_DEFAULT).append(" ( false )");
                col.add(sb.toString());
            }
            return col;
        }

        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stUnicast = new String(n + "." + TEXT_UNICAST);
            String stInDefault = new String(n + "." + TEXT_IN_DEFAULT);
            if (statement.indexOf(stInDefault) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        void analyzeCreationString(String statement) {
        }
    }

    public static class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;

        IdxProperty(IdxPropertyPattern pp) {
            super(pp);
            this.pattern = pp;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean niGetter) {
            this.niGetter = this.hasNiGetter() ? niGetter : false;
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean niSetter) {
            this.niGetter = this.hasNiSetter() ? niSetter : false;
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getGetterMethod() != null;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new IndexedPropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.pattern.getDeclaringClass().getName().getName() + ".class, ");
            if (this.pattern.getGetterMethod() != null && this.niGetter) {
                sb.append("\"" + this.pattern.getGetterMethod().getName().getName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.pattern.getSetterMethod() != null && this.niSetter) {
                sb.append("\"" + this.pattern.getSetterMethod().getName().getName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.pattern.getIndexedGetterMethod() != null && this.getMode() != 4) {
                sb.append("\"" + this.pattern.getIndexedGetterMethod().getName().getName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.pattern.getIndexedSetterMethod() != null && this.getMode() != 2) {
                sb.append("\"" + this.pattern.getIndexedSetterMethod().getName().getName() + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 6 && this.getMode() == 1) {
                if (params[4].equals("null")) {
                    this.setMode(4);
                } else if (params[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && params[2].equals(null)) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && params[3].equals(null)) {
                    this.niSetter = false;
                }
            }
        }
    }

    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;

        Property(PropertyPattern pp) {
            super(pp);
            this.mode = pp.getMode();
            this.pattern = pp;
        }

        public boolean isBound() {
            return this.bound;
        }

        String getBracketedName() {
            return "[PROPERTY_" + this.getName() + "]";
        }

        public void setBound(boolean bound) {
            this.bound = bound;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean constrained) {
            this.constrained = constrained;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String propertyEditorClass) {
            this.propertyEditorClass = propertyEditorClass;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new PropertyDescriptor ( ");
            sb.append("\"" + this.getName() + "\", ");
            sb.append(this.pattern.getDeclaringClass().getName().getName() + ".class, ");
            if (this.pattern.getGetterMethod() != null && this.getMode() != 4) {
                sb.append("\"" + this.pattern.getGetterMethod().getName().getName() + "\", ");
            } else {
                sb.append("null, ");
            }
            if (this.pattern.getSetterMethod() != null && this.getMode() != 2) {
                sb.append("\"" + this.pattern.getSetterMethod().getName().getName() + "\" )");
            } else {
                sb.append("null )");
            }
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            if (defaultIcon) {
                return "org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            StringBuffer sb = new StringBuffer(100);
            if (this.bound) {
                sb.setLength(0);
                sb.append(TEXT_BOUND).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.constrained) {
                sb.setLength(0);
                sb.append(TEXT_CONSTRAINED).append(" ( true )");
                col.add(sb.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                sb.setLength(0);
                sb.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                sb.append(this.propertyEditorClass).append(" )");
                col.add(sb.toString());
            }
            return col;
        }

        void analyzeCustomizationString(String statement) {
            String n = this.getBracketedName();
            String stBound = new String(n + "." + TEXT_BOUND);
            String stConstrained = new String(n + "." + TEXT_CONSTRAINED);
            String stPropertyEditor = new String(n + "." + TEXT_PROPERTY_EDITOR);
            if (statement.indexOf(stBound) != -1) {
                this.setBound(true);
                return;
            }
            if (statement.indexOf(stConstrained) != -1) {
                this.setConstrained(true);
                return;
            }
            int peIndex = statement.indexOf(stPropertyEditor);
            if (peIndex != -1) {
                String paramString = statement.substring(peIndex + stPropertyEditor.length());
                String[] params = BiAnalyser.getParameters(paramString);
                if (params.length > 0) {
                    this.setPropertyEditorClass(params[0]);
                }
                return;
            }
        }

        void analyzeCreationString(String statement) {
            String[] params = BiAnalyser.getParameters(statement);
            if (params.length == 4 && this.mode == 1) {
                if (params[2].equals("null")) {
                    this.mode = 4;
                } else if (params[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }
    }

    public static class Descriptor
    extends BiFeature {
        ClassElement element;
        private String varName;
        private ClassElement ce;
        String customizer;

        Descriptor(ClassElement ce) {
            super(ce);
            this.element = ce;
            this.ce = ce;
        }

        String getCreationString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("new BeanDescriptor  ( ");
            sb.append(this.getBeanName() + ".class , ");
            sb.append(String.valueOf(this.getCustomizer()) + " )");
            return sb.toString();
        }

        String getIconBase(boolean defaultIcon) {
            return "org/netbeans/modules/beans/resources/bifDescriptor";
        }

        Collection getCustomizationStrings() {
            Collection col = super.getCustomizationStrings();
            StringBuffer sb = new StringBuffer(100);
            return col;
        }

        void analyzeCustomizationString(String statement) {
        }

        void analyzeCreationString(String statement) {
            int beg = statement.indexOf(44);
            int end = statement.lastIndexOf(41);
            if (beg != -1 && end != -1 && ++beg < end) {
                this.setCustomizer(statement.substring(beg, end));
            } else {
                this.setCustomizer(null);
            }
        }

        String getBracketedName() {
            return this.getName();
        }

        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String customizer) {
            this.customizer = customizer;
        }

        public boolean isIncluded() {
            return true;
        }

        public String getBeanName() {
            return this.element.getName().getName();
        }
    }
}

