/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.beans.beaninfo.BiIconEditor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

class BiIconEditor
extends PropertyEditorSupport {
    private static final String BEAN_ICONEDITOR_HELP = "beans.icon";
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$beans$beaninfo$BiIconEditor == null ? (class$org$netbeans$modules$beans$beaninfo$BiIconEditor = BiIconEditor.class$("org.netbeans.modules.beans.beaninfo.BiIconEditor")) : class$org$netbeans$modules$beans$beaninfo$BiIconEditor));
    static /* synthetic */ Class class$org$netbeans$modules$beans$beaninfo$BiIconEditor;

    public static boolean isImage(String s) {
        return (s = s.toLowerCase()).endsWith(".jpg") || s.endsWith(".gif") || s.endsWith(".jpeg") || s.endsWith(".jpe") || s.equals("jpg") || s.equals("gif") || s.equals("jpeg") || s.equals("jpe");
    }

    public String getSourceName() {
        if (this.getValue() instanceof BiImageIcon) {
            return ((BiImageIcon)this.getValue()).name;
        }
        return null;
    }

    public String getAsText() {
        Object val = this.getValue();
        if (val == null) {
            return "null";
        }
        if (val instanceof BiImageIcon) {
            BiImageIcon ii = (BiImageIcon)val;
            return ii.name;
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    private BiImageIcon iconFromText(String string) throws IllegalArgumentException {
        BiImageIcon ii;
        try {
            if (string.length() == 0 || string.equals("null")) {
                ii = null;
            } else {
                URL url = Repository.getDefault().findResource(string).getURL();
                ii = new BiImageIcon(url);
                ii.name = string;
            }
        }
        catch (Throwable e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            throw new IllegalArgumentException(e.toString());
        }
        return ii;
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        JRadioButton rbClasspath;
        JRadioButton rbNoPicture;
        JTextField tfName;
        JButton bSelect;
        JScrollPane spImage;
        static final long serialVersionUID = -6904264999063788703L;

        IconPanel() {
            this.setLayout(new BorderLayout(6, 6));
            this.setBorder(new EmptyBorder(6, 6, 6, 6));
            this.getAccessibleContext().setAccessibleName(bundle.getString("ACS_IconPanelA11yName"));
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_IconPanelA11yDesc"));
            JPanel p = new JPanel(new BorderLayout(3, 3));
            JPanel p1 = new JPanel(new BorderLayout());
            p1.setBorder(new TitledBorder(new EtchedBorder(), bundle.getString("CTL_ImageSourceType")));
            JPanel p2 = new JPanel();
            p2.setBorder(new EmptyBorder(0, 3, 0, 3));
            GridBagLayout l = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p2.setLayout(l);
            c.anchor = 17;
            this.rbClasspath = new JRadioButton(bundle.getString("CTL_Classpath"));
            p2.add(this.rbClasspath);
            this.rbClasspath.setToolTipText(bundle.getString("ACS_ClasspathA11yDesc"));
            this.rbClasspath.setMnemonic(bundle.getString("CTL_Classpath_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbClasspath, c);
            JLabel lab = new JLabel(bundle.getString("CTL_ClasspathExample"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ClasspathExampleA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            this.rbNoPicture = new JRadioButton(bundle.getString("CTL_NoPicture"));
            p2.add(this.rbNoPicture);
            this.rbNoPicture.setToolTipText(bundle.getString("ACS_NoPictureA11yDesc"));
            this.rbNoPicture.setMnemonic(bundle.getString("CTL_NoPicture_Mnemonic").charAt(0));
            c.gridwidth = 1;
            l.setConstraints(this.rbNoPicture, c);
            lab = new JLabel(bundle.getString("CTL_Null"));
            p2.add(lab);
            lab.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_NullA11yDesc"));
            c.gridwidth = 0;
            l.setConstraints(lab, c);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbClasspath);
            bg.add(this.rbNoPicture);
            this.rbClasspath.setSelected(true);
            p1.add((Component)p2, "West");
            p.add((Component)p1, "North");
            p1 = new JPanel(new BorderLayout(6, 6));
            JLabel nameLabel = new JLabel(bundle.getString("CTL_ImageSourceName"));
            nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_ImageSourceNameA11yDesc"));
            nameLabel.setDisplayedMnemonic(bundle.getString("CTL_ImageSourceName_Mnemonic").charAt(0));
            p1.add((Component)nameLabel, "West");
            this.tfName = new JTextField();
            p1.add((Component)this.tfName, "Center");
            nameLabel.setLabelFor(this.tfName);
            this.tfName.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameTextFieldA11yName"));
            this.tfName.setToolTipText(bundle.getString("ACS_ImageSourceNameTextFieldA11yDesc"));
            this.bSelect = new JButton("...");
            p1.add((Component)this.bSelect, "East");
            this.bSelect.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yName"));
            this.bSelect.setToolTipText(bundle.getString("ACS_ImageSourceNameBrowseButtonA11yDesc"));
            this.bSelect.setEnabled(false);
            p.add((Component)p1, "South");
            this.add((Component)p, "North");
            this.spImage = new JScrollPane(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }
            };
            this.add((Component)this.spImage, "Center");
            this.tfName.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.setValue();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.bSelect.setEnabled(true);
                    this.this$1.tfName.setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.bSelect.setEnabled(false);
                    this.this$1.tfName.setEnabled(false);
                    IconPanel.access$000(this.this$1).setValue(null);
                    this.this$1.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(this){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    if (this.this$1.rbClasspath.isSelected()) {
                        String name;
                        Node ds = RepositoryNodeFactory.getDefault().repository(new DataFilter(this){
                            private final /* synthetic */ 5 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public boolean acceptDataObject(DataObject obj) {
                                if (obj instanceof DataFolder) {
                                    return !obj.getPrimaryFile().isReadOnly() || obj.getPrimaryFile().getParent() != null;
                                }
                                return BiIconEditor.isImage(obj.getPrimaryFile().getExt());
                            }
                        });
                        try {
                            DataObject d = (DataObject)NodeOperation.getDefault().select(bundle.getString("CTL_OpenDialogName"), bundle.getString("CTL_FileSystemName"), RepositoryNodeFactory.getDefault().repository(DataFilter.ALL), new NodeAcceptor(this){
                                static /* synthetic */ Class class$org$openide$loaders$DataFolder;
                                private final /* synthetic */ 5 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public boolean acceptNodes(Node[] nodes) {
                                    if (nodes == null || nodes.length != 1) {
                                        return false;
                                    }
                                    return nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 7.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == null;
                                }

                                static /* synthetic */ Class class$(String x0) {
                                    try {
                                        return Class.forName(x0);
                                    }
                                    catch (ClassNotFoundException x1) {
                                        throw new NoClassDefFoundError(x1.getMessage());
                                    }
                                }
                            }, null)[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 5.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                            name = d.getPrimaryFile().getPackageNameExt('/', '.');
                        }
                        catch (UserCancelException ex) {
                            return;
                        }
                        this.this$1.tfName.setText("/" + name);
                        this.this$1.setValue();
                    }
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
            this.updateIcon();
            HelpCtx.setHelpIDString((JComponent)this, (String)BiIconEditor.BEAN_ICONEDITOR_HELP);
            Icon i = (Icon)BiIconEditor.this.getValue();
            if (i == null) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            if (!(i instanceof BiImageIcon)) {
                return;
            }
            this.rbClasspath.setSelected(true);
            this.bSelect.setEnabled(true);
            this.tfName.setText(((BiImageIcon)i).name);
        }

        void updateIcon() {
            Icon i = (Icon)BiIconEditor.this.getValue();
            this.spImage.setViewportView(i == null ? new JLabel() : new JLabel(i));
            this.validate();
        }

        void setValue() {
            String val = this.tfName.getText();
            val.trim();
            if ("".equals(val)) {
                BiIconEditor.this.setValue(null);
                return;
            }
            try {
                BiIconEditor.this.setValue(BiIconEditor.this.iconFromText(val));
            }
            catch (IllegalArgumentException ee) {
                ErrorManager.getDefault().notify(1, (Throwable)ee);
            }
            this.updateIcon();
        }

        public Object getPropertyValue() throws IllegalStateException {
            BiImageIcon ii = null;
            String s = this.tfName.getText().trim();
            try {
                if (this.rbClasspath.isSelected() && s.length() != 0) {
                    FileObject f = Repository.getDefault().findResource(s);
                    try {
                        ii = new BiImageIcon(f.getURL());
                        ii.name = s;
                    }
                    catch (Throwable t) {
                        MessageFormat message = new MessageFormat(bundle.getString("CTL_Icon_not_exists"));
                        Object[] form = new Object[]{s};
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message.format(form), 0));
                    }
                }
            }
            catch (Exception e) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    e.printStackTrace();
                }
                throw new IllegalStateException(e.toString());
            }
            BiIconEditor.this.setValue(ii);
            return ii;
        }

        static /* synthetic */ BiIconEditor access$000(IconPanel x0) {
            return x0.BiIconEditor.this;
        }
    }

    public static class BiImageIcon
    extends ImageIcon
    implements Externalizable {
        static final long serialVersionUID = 7018807466471349466L;
        String name;

        public BiImageIcon() {
        }

        BiImageIcon(URL url) {
            super(url);
        }

        BiImageIcon(String file) {
            super(file);
        }

        String getName() {
            return this.name;
        }

        public void writeExternal(ObjectOutput oo) throws IOException {
            oo.writeObject(this.name);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            ImageIcon ii = null;
            ii = new ImageIcon(Repository.getDefault().findResource(this.name).getURL());
            this.setImage(ii.getImage());
        }
    }
}

