/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.actions;

import java.io.IOException;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.actions.CSSDisplayer;
import org.netbeans.modules.css.actions.Util;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CookieAction;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.flute.parser.Parser;

public class CheckStyleAction
extends CookieAction
implements ErrorHandler,
DocumentHandler {
    private static final long serialVersionUID = -6638807099960633338L;
    private CSSObject csso;
    private CSSDisplayer disp;
    private boolean failed;
    private int warnings;
    static /* synthetic */ Class class$org$netbeans$modules$css$CSSObject;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public int mode() {
        return 8;
    }

    public Class[] cookieClasses() {
        return new Class[]{class$org$netbeans$modules$css$CSSObject == null ? (class$org$netbeans$modules$css$CSSObject = CheckStyleAction.class$("org.netbeans.modules.css.CSSObject")) : class$org$netbeans$modules$css$CSSObject};
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length != 1) {
            return;
        }
        if (nodes[0] == null) {
            return;
        }
        this.failed = false;
        this.warnings = 0;
        this.disp = new CSSDisplayer();
        Parser parser = new Parser();
        parser.setErrorHandler(this);
        parser.setDocumentHandler(this);
        int i = 0;
        while (i < nodes.length) {
            this.csso = (CSSObject)nodes[i].getCookie(class$org$netbeans$modules$css$CSSObject == null ? CheckStyleAction.class$("org.netbeans.modules.css.CSSObject") : class$org$netbeans$modules$css$CSSObject);
            if (this.csso != null) {
                try {
                    SaveCookie cake = (SaveCookie)this.csso.getCookie(class$org$openide$cookies$SaveCookie == null ? CheckStyleAction.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                    if (cake != null) {
                        cake.save();
                    }
                    String uri = this.csso.getPrimaryFile().getURL().toExternalForm();
                    parser.parseStyleSheet(uri);
                }
                catch (IOException ex) {
                    this.failed = true;
                }
                catch (CSSParseException ex) {
                    this.failed = true;
                }
            }
            ++i;
        }
        if (this.failed || this.warnings > 0) {
            this.disp.moveToFront();
        }
        StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("TEXT_PART_CSS_checking") + this.getStatus() + ".");
    }

    private String getStatus() {
        return this.failed ? Util.THIS.getString("TEXT_PART_failed") : (this.warnings > 1 ? Util.THIS.getString("TEXT_PART_finished_with_warnings") : Util.THIS.getString("TEXT_PART_finished"));
    }

    public String getName() {
        return Util.THIS.getString("NAME_check_CSS");
    }

    protected String iconResource() {
        return "org/netbeans/modules/css/resources/checkStyleAction.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public void warning(CSSParseException exception) throws CSSException {
        this.disp.display((DataObject)this.csso, exception);
        ++this.warnings;
    }

    public void error(CSSParseException exception) throws CSSException {
        this.disp.display((DataObject)this.csso, exception);
        this.failed = true;
    }

    public void fatalError(CSSParseException exception) throws CSSException {
        this.disp.display((DataObject)this.csso, exception);
        this.failed = true;
    }

    public void startDocument(InputSource source) throws CSSException {
    }

    public void endDocument(InputSource source) throws CSSException {
    }

    public void comment(String text) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
    }

    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
    }

    public void startMedia(SACMediaList media) throws CSSException {
    }

    public void endMedia(SACMediaList media) throws CSSException {
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
    }

    public void startFontFace() throws CSSException {
    }

    public void endFontFace() throws CSSException {
    }

    public void startSelector(SelectorList selectors) throws CSSException {
    }

    public void endSelector(SelectorList selectors) throws CSSException {
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

