/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroDialogSupport;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;

public class ActionFactory {
    private ActionFactory() {
    }

    public static class AnnotationsCyclingAction
    extends BaseAction {
        public AnnotationsCyclingAction() {
            super("annotations-cycling");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument(target);
                    int caretLine = Utilities.getLineOffset(doc, caret.getDot());
                    AnnotationDesc aDesc = doc.getAnnotations().activateNextAnnotation(caretLine);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ToggleLineNumbersAction
    extends BaseAction {
        static final long serialVersionUID = -3502499718130556526L;
        private JCheckBoxMenuItem item = null;

        public ToggleLineNumbersAction() {
            super("toggle-line-numbers");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.toggleLineNumbers();
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            if (this.item != null) {
                return this.item;
            }
            this.item = new JCheckBoxMenuItem(LocaleSupport.getString("line-numbers-menuitem"), this.isLineNumbersVisible());
            this.item.addItemListener(new ItemListener(this){
                private final /* synthetic */ ToggleLineNumbersAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void itemStateChanged(ItemEvent e) {
                    this.this$0.actionPerformed(null, null);
                }
            });
            return this.item;
        }

        protected boolean isLineNumbersVisible() {
            return false;
        }

        protected void toggleLineNumbers() {
        }
    }

    public static class GenerateGutterPopupAction
    extends BaseAction {
        static final long serialVersionUID = -3502499718130556525L;

        public GenerateGutterPopupAction() {
            super("generate-gutter-popup");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            EditorUI ui = Utilities.getEditorUI(target);
            try {
                return ui.getDocument().getAnnotations().createMenu(Utilities.getKit(target), Utilities.getLineOffset(ui.getDocument(), target.getCaret().getDot()));
            }
            catch (BadLocationException ex) {
                return null;
            }
        }
    }

    public static class InsertDateTimeAction
    extends BaseAction {
        static final long serialVersionUID = 2865619897402L;

        public InsertDateTimeAction() {
            super("insert-date-time", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    SimpleDateFormat formatter = new SimpleDateFormat();
                    Date currentTime = new Date();
                    String dateString = formatter.format(currentTime);
                    doc.insertString(caret.getDot(), dateString, null);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ScrollDownAction
    extends BaseAction {
        public ScrollDownAction() {
            super("scroll-down");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y -= editorUI.getLineHeight();
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class ScrollUpAction
    extends BaseAction {
        public ScrollUpAction() {
            super("scroll-up");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Rectangle bounds = editorUI.getExtentBounds();
                bounds.y += editorUI.getLineHeight();
                editorUI.scrollRectToVisible(bounds, 2);
            }
        }
    }

    public static class JumpListPrevComponentAction
    extends BaseAction {
        static final long serialVersionUID = 2032230534727849525L;

        public JumpListPrevComponentAction() {
            super("jump-list-prev-component");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrevComponent(target);
            }
        }
    }

    public static class JumpListNextComponentAction
    extends BaseAction {
        static final long serialVersionUID = -2059070050865876892L;

        public JumpListNextComponentAction() {
            super("jump-list-next-component");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNextComponent(target);
            }
        }
    }

    public static class JumpListPrevAction
    extends BaseAction {
        static final long serialVersionUID = 7174907031986424265L;

        public JumpListPrevAction() {
            super("jump-list-prev");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_previous");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpPrev(target);
            }
        }
    }

    public static class JumpListNextAction
    extends BaseAction {
        static final long serialVersionUID = 6891721278404990446L;

        public JumpListNextAction() {
            super("jump-list-next");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/edit_next");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                JumpList.jumpNext(target);
            }
        }
    }

    public static class SelectNextParameterAction
    extends BaseAction {
        static final long serialVersionUID = 8045372985336370934L;

        public SelectNextParameterAction() {
            super("select-next-parameter", 34);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                int dotPos = caret.getDot();
                int selectStartPos = -1;
                try {
                    int selectEndPos;
                    if (dotPos > 0 && doc.getChars(dotPos - 1, 1)[0] == ',') {
                        selectStartPos = dotPos;
                    }
                    if (dotPos < doc.getLength()) {
                        char dotChar = doc.getChars(dotPos, 1)[0];
                        if (dotChar == ',') {
                            selectStartPos = dotPos + 1;
                        } else if (dotChar == ')') {
                            caret.setDot(dotPos + 1);
                        }
                    }
                    if (selectStartPos >= 0 && (selectEndPos = doc.find(new FinderFactory.CharArrayFwdFinder(new char[]{',', ')'}), selectStartPos, -1)) >= 0) {
                        target.select(selectStartPos, selectEndPos);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class SelectIdentifierAction
    extends BaseAction {
        static final long serialVersionUID = -7288216961333147873L;

        public SelectIdentifierAction() {
            super("select-identifier", 2);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    if (caret.isSelectionVisible()) {
                        caret.setSelectionVisible(false);
                    } else {
                        int[] block = Utilities.getIdentifierBlock((BaseDocument)target.getDocument(), caret.getDot());
                        if (block != null) {
                            caret.setDot(block[0]);
                            caret.moveDot(block[1]);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class LastNonWhiteAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = 4503533041729712917L;

        public LastNonWhiteAction(String nm, boolean select) {
            super(nm, 30);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowLastNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        if (this.select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class FirstNonWhiteAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5888439539790901158L;

        public FirstNonWhiteAction(String nm, boolean select) {
            super(nm, 30);
            this.select = select;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int pos = Utilities.getRowFirstNonWhite((BaseDocument)target.getDocument(), caret.getDot());
                    if (pos >= 0) {
                        if (this.select) {
                            caret.moveDot(pos);
                        } else {
                            caret.setDot(pos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class FormatAction
    extends BaseAction {
        static final long serialVersionUID = -7666172828961171865L;
        static /* synthetic */ Class class$org$netbeans$editor$ActionFactory$FormatAction;

        public FormatAction() {
            super("format", 14);
            this.putValue("helpID", (class$org$netbeans$editor$ActionFactory$FormatAction == null ? (class$org$netbeans$editor$ActionFactory$FormatAction = FormatAction.class$("org.netbeans.editor.ActionFactory$FormatAction")) : class$org$netbeans$editor$ActionFactory$FormatAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block14: {
                if (target != null) {
                    if (!target.isEditable() || !target.isEnabled()) {
                        target.getToolkit().beep();
                        return;
                    }
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
                    doc.atomicLock();
                    try {
                        block13: {
                            try {
                                Position endPosition;
                                int startPos;
                                int caretLine = Utilities.getLineOffset(doc, caret.getDot());
                                if (caret.isSelectionVisible()) {
                                    startPos = target.getSelectionStart();
                                    endPosition = doc.createPosition(target.getSelectionEnd());
                                } else {
                                    startPos = 0;
                                    endPosition = doc.createPosition(doc.getLength());
                                }
                                int pos = startPos;
                                if (gdoc != null) {
                                    pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                                }
                                while (pos < endPosition.getOffset()) {
                                    int stopPos = endPosition.getOffset();
                                    if (gdoc != null && (stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1) {
                                        stopPos = endPosition.getOffset();
                                    }
                                    int reformattedLen = doc.getFormatter().reformat(doc, pos, stopPos);
                                    pos += reformattedLen;
                                    if (gdoc == null) continue;
                                    pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
                                }
                                pos = Utilities.getRowStartFromLineOffset(doc, caretLine);
                                if (pos < 0) break block13;
                                caret.setDot(pos);
                            }
                            catch (GuardedException e) {
                                target.getToolkit().beep();
                                Object var13_15 = null;
                                doc.atomicUnlock();
                                break block14;
                            }
                            catch (BadLocationException e) {
                                if (System.getProperty("netbeans.debug.exceptions") != null) {
                                    e.printStackTrace();
                                }
                                Object var13_16 = null;
                                doc.atomicUnlock();
                            }
                        }
                        Object var13_14 = null;
                        doc.atomicUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        doc.atomicUnlock();
                        throw throwable;
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class AdjustCaretAction
    extends BaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 3223383913531191066L;

        public AdjustCaretAction(String name, int percentFromWindowTop) {
            super(name);
            this.percentFromWindowTop = percentFromWindowTop;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustCaret(this.percentFromWindowTop);
            }
        }
    }

    public static class AdjustWindowAction
    extends BaseAction {
        int percentFromWindowTop;
        static final long serialVersionUID = 8864278998999643292L;

        public AdjustWindowAction(String name, int percentFromWindowTop) {
            super(name);
            this.percentFromWindowTop = percentFromWindowTop;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Utilities.getEditorUI(target).adjustWindow(this.percentFromWindowTop);
            }
        }
    }

    public static class ShiftLineAction
    extends BaseAction {
        boolean right;
        static final long serialVersionUID = -5124732597493699582L;

        public ShiftLineAction(String name, boolean right) {
            super(name, 10);
            this.right = right;
            this.putValue("IconResource", right ? "org/netbeans/modules/editor/resources/shift_right" : "org/netbeans/modules/editor/resources/shift_left");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = Utilities.getDocument(target);
                    if (caret.isSelectionVisible()) {
                        doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), this.right ? 1 : -1);
                    } else {
                        doc.getFormatter().shiftLine(doc, caret.getDot(), this.right);
                    }
                }
                catch (GuardedException e) {
                    target.getToolkit().beep();
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class WordMatchAction
    extends BaseAction {
        private boolean direction;
        static final long serialVersionUID = 595571114685133170L;

        public WordMatchAction(String name, boolean direction) {
            super(name, 14);
            this.direction = direction;
            this.putValue("IconResource", direction ? "org/netbeans/modules/editor/resources/match_next" : "org/netbeans/modules/editor/resources/match_previous");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = Utilities.getEditorUI(target);
                Caret caret = target.getCaret();
                BaseDocument doc = Utilities.getDocument(target);
                if (caret.isSelectionVisible()) {
                    target.replaceSelection(null);
                }
                int dotPos = caret.getDot();
                String s = editorUI.getWordMatch().getMatchWord(dotPos, this.direction);
                String prevWord = editorUI.getWordMatch().getPreviousWord();
                if (s != null) {
                    doc.atomicLock();
                    try {
                        try {
                            int pos = dotPos;
                            if (prevWord != null && prevWord.length() > 0) {
                                doc.remove(pos -= prevWord.length(), prevWord.length());
                            }
                            doc.insertString(pos, s, null);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                            Object var11_12 = null;
                            doc.atomicUnlock();
                        }
                        Object var11_11 = null;
                        doc.atomicUnlock();
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        doc.atomicUnlock();
                        throw throwable;
                    }
                }
            }
        }
    }

    public static class RedoAction
    extends BaseAction {
        static final long serialVersionUID = 6048125996333769202L;

        public RedoAction() {
            super("redo", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.redo();
                }
                catch (CannotRedoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class UndoAction
    extends BaseAction {
        static final long serialVersionUID = 8628586205035497612L;

        public UndoAction() {
            super("undo", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (!target.isEditable() || !target.isEnabled()) {
                target.getToolkit().beep();
                return;
            }
            Document doc = target.getDocument();
            UndoableEdit undoMgr = (UndoableEdit)doc.getProperty("undo-manager");
            if (target != null && undoMgr != null) {
                try {
                    undoMgr.undo();
                }
                catch (CannotUndoException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleHighlightSearchAction
    extends BaseAction {
        static final long serialVersionUID = 4603809175771743200L;

        public ToggleHighlightSearchAction() {
            super("toggle-highlight-search", 32);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/toggle_search");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Boolean cur = (Boolean)FindSupport.getFindSupport().getFindProperty("find-highlight-search");
                cur = cur == null || cur == false ? Boolean.TRUE : Boolean.FALSE;
                FindSupport.getFindSupport().putFindProperty("find-highlight-search", cur);
            }
        }
    }

    public static class FindSelectionAction
    extends BaseAction {
        static final long serialVersionUID = -5601618936504699565L;

        public FindSelectionAction() {
            super("find-selection");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_selection");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                FindSupport findSupport = FindSupport.getFindSupport();
                Caret caret = target.getCaret();
                int dotPos = caret.getDot();
                HashMap<String, Object> props = new HashMap<String, Object>(findSupport.getFindProperties());
                String searchWord = null;
                boolean revert = false;
                if (caret.isSelectionVisible()) {
                    searchWord = target.getSelectedText();
                    revert = !Boolean.FALSE.equals(props.put("find-whole-words", Boolean.FALSE));
                } else {
                    try {
                        searchWord = Utilities.getIdentifier((BaseDocument)target.getDocument(), dotPos);
                        revert = !Boolean.TRUE.equals(props.put("find-whole-words", Boolean.TRUE));
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
                if (searchWord != null) {
                    int n = searchWord.indexOf(10);
                    if (n >= 0) {
                        searchWord = searchWord.substring(0, n);
                    }
                    props.put("find-what", searchWord);
                    if (revert) {
                        HashMap<String, Boolean> revertMap = new HashMap<String, Boolean>();
                        revertMap.put("find-whole-words", Boolean.TRUE);
                        props.put("revert-map", revertMap);
                    }
                    findSupport.putFindProperties(props);
                    findSupport.find(null, false);
                }
            }
        }
    }

    public static class FindPreviousAction
    extends BaseAction {
        static final long serialVersionUID = -43746947902694926L;

        public FindPreviousAction() {
            super("find-previous", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_previous");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                FindSupport.getFindSupport().find(null, true);
            }
        }
    }

    public static class FindNextAction
    extends BaseAction {
        static final long serialVersionUID = 6878814427731642684L;

        public FindNextAction() {
            super("find-next", 30);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/find_next");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                FindSupport.getFindSupport().find(null, false);
            }
        }
    }

    public static class ChangeCaseAction
    extends BaseAction {
        int changeCaseMode;
        static final long serialVersionUID = 5680212865619897402L;

        public ChangeCaseAction(String name, int changeCaseMode) {
            super(name, 30);
            this.changeCaseMode = changeCaseMode;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    if (caret.isSelectionVisible()) {
                        int startPos = target.getSelectionStart();
                        int endPos = target.getSelectionEnd();
                        Utilities.changeCase(doc, startPos, endPos - startPos, this.changeCaseMode);
                        caret.setSelectionVisible(false);
                        caret.setDot(endPos);
                    } else {
                        int dotPos = caret.getDot();
                        Utilities.changeCase(doc, dotPos, 1, this.changeCaseMode);
                        caret.setDot(dotPos + 1);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class AbbrevResetAction
    extends BaseAction {
        static final long serialVersionUID = -2807497346060448395L;

        public AbbrevResetAction() {
            super("abbrev-reset", 4);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }
    }

    public static class AbbrevExpandAction
    extends BaseAction {
        static final long serialVersionUID = -2124569510083544403L;

        public AbbrevExpandAction() {
            super("abbrev-expand", 26);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                EditorUI editorUI = ((BaseTextUI)target.getUI()).getEditorUI();
                try {
                    editorUI.getAbbrev().checkAndExpand(evt);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class StopMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StopMacroRecordingAction() {
            super("stop-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/macro_stop");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                String macro = this.stopRecording(target);
                if (macro == null) {
                    target.getToolkit().beep();
                } else {
                    BaseKit kit = Utilities.getKit(target);
                    MacroDialogSupport support = new MacroDialogSupport(kit.getClass());
                    support.setBody(macro);
                    support.showMacroDialog();
                }
            }
        }
    }

    public static class StartMacroRecordingAction
    extends BaseAction {
        static final long serialVersionUID = 1L;

        public StartMacroRecordingAction() {
            super("start-macro-recording", 64);
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/macro_start");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && !this.startRecording(target)) {
                target.getToolkit().beep();
            }
        }
    }

    public static class RunMacroAction
    extends BaseAction {
        static final long serialVersionUID = 1L;
        static HashSet runningActions = new HashSet();
        private String macroName;

        public RunMacroAction(String name) {
            super("macro-" + name);
            this.macroName = name;
        }

        protected void error(JTextComponent target, String messageKey) {
            Utilities.setStatusText(target, LocaleSupport.getString(messageKey, "Error in macro: " + messageKey));
            Toolkit.getDefaultToolkit().beep();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block20: {
                block19: {
                    block24: {
                        block23: {
                            block22: {
                                if (!RunMacroAction.runningActions.add(this.macroName)) {
                                    this.error(target, "loop");
                                    return;
                                }
                                if (target == null) {
                                    return;
                                }
                                kit = Utilities.getKit(target);
                                if (kit == null) {
                                    return;
                                }
                                macroMap = (Map)Settings.getValue(kit.getClass(), "macro-map");
                                commandString = (String)macroMap.get(this.macroName);
                                if (commandString == null) {
                                    this.error(target, "macro-not-found");
                                    RunMacroAction.runningActions.remove(this.macroName);
                                    return;
                                }
                                actionName = new StringBuffer();
                                command = commandString.toCharArray();
                                len = command.length;
                                doc = (BaseDocument)target.getDocument();
                                try {
                                    doc.atomicLock();
                                    i = 0;
lbl23:
                                    // 2 sources

                                    while (true) {
                                        if (i >= len) {
                                            break block19;
                                        }
                                        if (Character.isWhitespace(command[i])) break block20;
                                        if (command[i] != '\"') {
                                            block21: {
                                                actionName.setLength(0);
                                                while (true) {
                                                    if (i >= len || Character.isWhitespace(command[i])) {
                                                        a = kit.getActionByName(actionName.toString());
                                                        if (a == null) break block21;
                                                        fakeEvt = new ActionEvent(target, 0, "");
                                                        if (!(a instanceof BaseAction)) break;
                                                        ((BaseAction)a).updateComponent(target);
                                                        ((BaseAction)a).actionPerformed(fakeEvt, target);
                                                        break block20;
                                                    }
                                                    if ((ch = command[i++]) == '\\') {
                                                        if (i >= len) {
                                                            this.error(target, "macro-malformed");
                                                            break block22;
                                                        }
                                                        if ((ch = command[i++]) != '\\' && !Character.isWhitespace(ch)) {
                                                            this.error(target, "macro-malformed");
                                                            break block23;
                                                        }
                                                    }
                                                    actionName.append(ch);
                                                }
                                                a.actionPerformed(fakeEvt);
                                                break block20;
                                            }
                                            this.error(target, "macro-unknown-action");
                                            break block24;
                                        }
                                        ** GOTO lbl115
                                        break;
                                    }
                                }
                                catch (Throwable var14_23) {
                                    var15_22 = null;
                                    doc.atomicUnlock();
                                    RunMacroAction.runningActions.remove(this.macroName);
                                    throw var14_23;
                                }
                            }
                            var15_18 = null;
                            doc.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                        var15_19 = null;
                        doc.atomicUnlock();
                        RunMacroAction.runningActions.remove(this.macroName);
                        return;
                    }
                    var15_20 = null;
                    doc.atomicUnlock();
                    RunMacroAction.runningActions.remove(this.macroName);
                    return;
                }
                var15_21 = null;
                doc.atomicUnlock();
                RunMacroAction.runningActions.remove(this.macroName);
                return;
lbl-1000:
                // 1 sources

                {
                    ch = command[i];
                    if (ch == '\\') {
                        if (++i >= len) {
                            this.error(target, "macro-malformed");
                            var15_16 = null;
                            doc.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                        ch = command[i];
                        if (ch != '\"' && ch != '\\') {
                            this.error(target, "macro-malformed");
                            var15_17 = null;
                            doc.atomicUnlock();
                            RunMacroAction.runningActions.remove(this.macroName);
                            return;
                        }
                    }
                    if ((a = target.getKeymap().getDefaultAction()) == null) continue;
                    newEvt = new ActionEvent(target, 0, new String(new char[]{ch}));
                    if (a instanceof BaseAction) {
                        ((BaseAction)a).updateComponent(target);
                        ((BaseAction)a).actionPerformed(newEvt, target);
                        continue;
                    }
                    a.actionPerformed(newEvt);
lbl115:
                    // 4 sources

                    ** while (++i < len && command[i] != '\"')
                }
            }
            ++i;
            ** while (true)
        }
    }

    public static class GotoNextBookmarkAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -5169554640178645108L;

        public GotoNextBookmarkAction(String nm, boolean select) {
            super("bookmark-next", 30);
            this.select = select;
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/next_bookmark");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dotPos = doc.getNextBookmark(caret.getDot(), true);
                    if (dotPos >= 0) {
                        if (this.select) {
                            caret.moveDot(dotPos);
                        } else {
                            caret.setDot(dotPos);
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleBookmarkAction
    extends BaseAction {
        static final long serialVersionUID = -8438899482709646741L;

        public ToggleBookmarkAction() {
            super("bookmark-toggle");
            this.putValue("IconResource", "org/netbeans/modules/editor/resources/toggle_bookmark");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    doc.toggleBookmark(caret.getDot());
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleTypingModeAction
    extends BaseAction {
        static final long serialVersionUID = -2431132686507799723L;

        public ToggleTypingModeAction() {
            super("toggle-typing-mode");
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                EditorUI editorUI = Utilities.getEditorUI(target);
                Boolean overwriteMode = (Boolean)editorUI.getProperty("overwriteMode");
                overwriteMode = overwriteMode == null || overwriteMode == false ? Boolean.TRUE : Boolean.FALSE;
                editorUI.putProperty("overwriteMode", overwriteMode);
            }
        }
    }

    public static class RemoveSelectionAction
    extends BaseAction {
        static final long serialVersionUID = -1419424594746686573L;
        static /* synthetic */ Class class$org$netbeans$editor$ActionFactory$RemoveSelectionAction;

        public RemoveSelectionAction() {
            super("remove-selection", 30);
            this.putValue("helpID", (class$org$netbeans$editor$ActionFactory$RemoveSelectionAction == null ? (class$org$netbeans$editor$ActionFactory$RemoveSelectionAction = RemoveSelectionAction.class$("org.netbeans.editor.ActionFactory$RemoveSelectionAction")) : class$org$netbeans$editor$ActionFactory$RemoveSelectionAction).getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                target.replaceSelection(null);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class RemoveLineAction
    extends BaseAction {
        static final long serialVersionUID = -536315497241419877L;

        public RemoveLineAction() {
            super("remove-line", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                try {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(target, dotPos);
                    int eolPos = Utilities.getRowEnd(target, dotPos);
                    eolPos = Math.min(eolPos + 1, doc.getLength());
                    doc.remove(bolPos, eolPos - bolPos);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveLineBeginAction
    extends BaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveLineBeginAction() {
            super("remove-line-begin", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                try {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(doc, dotPos);
                    if (dotPos == bolPos) {
                        if (dotPos > 0) {
                            doc.remove(dotPos - 1, 1);
                        }
                    } else {
                        char[] chars = doc.getChars(bolPos, dotPos - bolPos);
                        if (Analyzer.isWhitespace(chars, 0, chars.length)) {
                            doc.remove(bolPos, dotPos - bolPos);
                        } else {
                            int firstNW = Utilities.getRowFirstNonWhite(doc, bolPos);
                            if (firstNW >= 0 && firstNW < dotPos) {
                                doc.remove(firstNW, dotPos - firstNW);
                            }
                        }
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveWordAction
    extends BaseAction {
        static final long serialVersionUID = 9193117196412195554L;

        public RemoveWordAction() {
            super("remove-word", 30);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                try {
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int dotPos = caret.getDot();
                    int bolPos = Utilities.getRowStart(doc, dotPos);
                    int wsPos = Utilities.getPreviousWord(target, dotPos);
                    wsPos = dotPos == bolPos ? wsPos : Math.max(bolPos, wsPos);
                    doc.remove(wsPos, dotPos - wsPos);
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class RemoveTabAction
    extends BaseAction {
        static final long serialVersionUID = -1537748600593395706L;

        public RemoveTabAction() {
            super("remove-tab", 22);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                if (caret.isSelectionVisible()) {
                    try {
                        doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), -1);
                    }
                    catch (GuardedException e) {
                        target.getToolkit().beep();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        int startOffset = Utilities.getRowStart(doc, caret.getDot());
                        int firstNW = Utilities.getRowFirstNonWhite(doc, caret.getDot());
                        int endOffset = Utilities.getRowEnd(doc, caret.getDot());
                        if (firstNW == -1 || firstNW >= caret.getDot()) {
                            doc.getFormatter().changeBlockIndent(doc, startOffset, endOffset, -1);
                        }
                    }
                    catch (GuardedException e) {
                        target.getToolkit().beep();
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

