/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Settings;

public class AnnotationType {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_VISIBLE = "visible";
    public static final String PROP_GLYPH_URL = "glyph";
    public static final String PROP_HIGHLIGHT_COLOR = "highlight";
    public static final String PROP_FOREGROUND_COLOR = "foreground";
    public static final String PROP_WAVEUNDERLINE_COLOR = "waveunderline";
    public static final String PROP_WHOLE_LINE = "wholeline";
    public static final String PROP_CONTENT_TYPE = "contenttype";
    public static final String PROP_ACTIONS = "actions";
    public static final String PROP_TOOLTIP_TEXT = "tooltipText";
    public static final String PROP_INHERIT_FOREGROUND_COLOR = "inheritForegroundColor";
    public static final String PROP_USE_HIGHLIGHT_COLOR = "useHighlightColor";
    public static final String PROP_USE_WAVEUNDERLINE_COLOR = "useWaveUnderlineColor";
    public static final String PROP_COMBINATIONS = "combinations";
    public static final String PROP_COMBINATION_ORDER = "combinationOrder";
    public static final String PROP_COMBINATION_MINIMUM_OPTIONALS = "combinationMinimumOptionals";
    public static final String PROP_FILE = "file";
    public static final String PROP_LOCALIZING_BUNDLE = "bundle";
    public static final String PROP_DESCRIPTION_KEY = "desciptionKey";
    public static final String PROP_ACTIONS_FOLDER = "actionsFolder";
    public static final String PROP_COMBINATION_TOOLTIP_TEXT_KEY = "tooltipTextKey";
    private Map properties = new HashMap(20);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Image img = null;
    private Coloring col;

    public URL getGlyph() {
        URL u = (URL)this.getProp(PROP_GLYPH_URL);
        if (u == null) {
            u = AnnotationTypes.getDefaultGlyphURL();
        }
        return u;
    }

    public void setGlyph(URL glyph) {
        this.putProp(PROP_GLYPH_URL, glyph);
    }

    public Image getGlyphImage() {
        if (this.img == null) {
            this.img = Toolkit.getDefaultToolkit().getImage(this.getGlyph());
        }
        return this.img;
    }

    public boolean isDefaultGlyph() {
        return this.getProp(PROP_GLYPH_URL) == null;
    }

    public Color getHighlight() {
        return (Color)this.getProp(PROP_HIGHLIGHT_COLOR);
    }

    public void setHighlight(Color highlight) {
        this.col = null;
        this.putProp(PROP_HIGHLIGHT_COLOR, highlight);
        this.firePropertyChange(PROP_HIGHLIGHT_COLOR, null, null);
        this.processChange();
    }

    public boolean isUseHighlightColor() {
        Boolean b = (Boolean)this.getProp(PROP_USE_HIGHLIGHT_COLOR);
        if (b == null) {
            return true;
        }
        return b;
    }

    public void setUseHighlightColor(boolean use) {
        if (this.isUseHighlightColor() != use) {
            this.col = null;
            this.putProp(PROP_USE_HIGHLIGHT_COLOR, use ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_USE_HIGHLIGHT_COLOR, null, null);
            this.processChange();
        }
    }

    public Color getForegroundColor() {
        return (Color)this.getProp(PROP_FOREGROUND_COLOR);
    }

    public void setForegroundColor(Color foregroundColor) {
        this.col = null;
        this.putProp(PROP_FOREGROUND_COLOR, foregroundColor);
        this.firePropertyChange(PROP_FOREGROUND_COLOR, null, null);
        this.processChange();
    }

    public boolean isInheritForegroundColor() {
        Boolean b = (Boolean)this.getProp(PROP_INHERIT_FOREGROUND_COLOR);
        if (b == null) {
            return true;
        }
        return b;
    }

    public void setInheritForegroundColor(boolean inherit) {
        if (this.isInheritForegroundColor() != inherit) {
            this.col = null;
            this.putProp(PROP_INHERIT_FOREGROUND_COLOR, inherit ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_INHERIT_FOREGROUND_COLOR, null, null);
            this.processChange();
        }
    }

    public Color getWaveUnderlineColor() {
        return (Color)this.getProp(PROP_WAVEUNDERLINE_COLOR);
    }

    public void setWaveUnderlineColor(Color waveunderline) {
        this.col = null;
        this.putProp(PROP_WAVEUNDERLINE_COLOR, waveunderline);
        this.firePropertyChange(PROP_WAVEUNDERLINE_COLOR, null, null);
        this.processChange();
    }

    public boolean isUseWaveUnderlineColor() {
        Boolean b = (Boolean)this.getProp(PROP_USE_WAVEUNDERLINE_COLOR);
        if (b == null) {
            return true;
        }
        return b;
    }

    public void setUseWaveUnderlineColor(boolean use) {
        if (this.isUseWaveUnderlineColor() != use) {
            this.col = null;
            this.putProp(PROP_USE_WAVEUNDERLINE_COLOR, use ? Boolean.TRUE : Boolean.FALSE);
            this.firePropertyChange(PROP_USE_WAVEUNDERLINE_COLOR, null, null);
            this.processChange();
        }
    }

    private void processChange() {
        if (this.getProp(PROP_FILE) == null) {
            return;
        }
        Settings.touchValue(null, null);
        AnnotationTypes.getTypes().saveType(this);
    }

    public Coloring getColoring() {
        if (this.col == null) {
            this.col = new Coloring(null, 7, this.isInheritForegroundColor() ? null : this.getForegroundColor(), this.isUseHighlightColor() ? this.getHighlight() : null, null, null, this.isUseWaveUnderlineColor() ? this.getWaveUnderlineColor() : null);
        }
        return this.col;
    }

    public Action[] getActions() {
        return (Action[])this.getProp(PROP_ACTIONS);
    }

    public void setActions(Action[] actions) {
        this.putProp(PROP_ACTIONS, actions);
    }

    public CombinationMember[] getCombinations() {
        return (CombinationMember[])this.getProp(PROP_COMBINATIONS);
    }

    public void setCombinations(CombinationMember[] combs) {
        this.putProp(PROP_COMBINATIONS, combs);
    }

    public String getName() {
        return (String)this.getProp(PROP_NAME);
    }

    public void setName(String name) {
        this.putProp(PROP_NAME, name);
    }

    public String getDescription() {
        String desc = (String)this.getProp(PROP_DESCRIPTION);
        if (desc == null) {
            String localizer = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String key = (String)this.getProp(PROP_DESCRIPTION_KEY);
            ResourceBundle bundle = ImplementationProvider.getDefault().getResourceBundle(localizer);
            desc = bundle.getString(key);
            this.setDescription(desc);
        }
        return desc;
    }

    public void setDescription(String name) {
        this.putProp(PROP_DESCRIPTION, name);
    }

    public String getTooltipText() {
        String text = (String)this.getProp(PROP_TOOLTIP_TEXT);
        if (text == null) {
            String localizer = (String)this.getProp(PROP_LOCALIZING_BUNDLE);
            String key = (String)this.getProp(PROP_COMBINATION_TOOLTIP_TEXT_KEY);
            ResourceBundle bundle = ImplementationProvider.getDefault().getResourceBundle(localizer);
            text = bundle.getString(key);
            this.setTooltipText(text);
        }
        return text;
    }

    public void setTooltipText(String text) {
        this.putProp(PROP_TOOLTIP_TEXT, text);
    }

    public int getCombinationOrder() {
        if (this.getProp(PROP_COMBINATION_ORDER) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_ORDER);
    }

    public void setCombinationOrder(int order) {
        this.putProp(PROP_COMBINATION_ORDER, new Integer(order));
    }

    public void setCombinationOrder(String ord) {
        int order;
        try {
            order = Integer.parseInt(ord);
        }
        catch (NumberFormatException ex) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
            }
            return;
        }
        this.putProp(PROP_COMBINATION_ORDER, new Integer(order));
    }

    public int getMinimumOptionals() {
        if (this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS) == null) {
            return 0;
        }
        return (Integer)this.getProp(PROP_COMBINATION_MINIMUM_OPTIONALS);
    }

    public void setMinimumOptionals(int min) {
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(min));
    }

    public void setMinimumOptionals(String m) {
        int min;
        try {
            min = Integer.parseInt(m);
        }
        catch (NumberFormatException ex) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
            }
            return;
        }
        this.putProp(PROP_COMBINATION_MINIMUM_OPTIONALS, new Integer(min));
    }

    public boolean isVisible() {
        Boolean b = (Boolean)this.getProp(PROP_VISIBLE);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void setVisible(boolean vis) {
        this.putProp(PROP_VISIBLE, vis ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setVisible(String vis) {
        this.putProp(PROP_VISIBLE, Boolean.valueOf(vis));
    }

    public boolean isWholeLine() {
        Boolean b = (Boolean)this.getProp(PROP_WHOLE_LINE);
        if (b == null) {
            return true;
        }
        return b;
    }

    public void setWholeLine(boolean wl) {
        this.putProp(PROP_WHOLE_LINE, wl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setWholeLine(String wl) {
        this.putProp(PROP_WHOLE_LINE, Boolean.valueOf(wl));
    }

    public String getContentType() {
        return (String)this.getProp(PROP_CONTENT_TYPE);
    }

    public void setContentType(String ct) {
        this.putProp(PROP_CONTENT_TYPE, ct);
    }

    public Object getProp(String prop) {
        return this.properties.get(prop);
    }

    public void putProp(Object key, Object value) {
        if (value == null) {
            this.properties.remove(key);
            return;
        }
        this.properties.put(key, value);
    }

    public String toString() {
        return "AnnotationType: name='" + this.getName() + "', description='" + this.getDescription() + "', visible=" + this.isVisible() + ", wholeline=" + this.isWholeLine() + ", glyph=" + this.getGlyph() + ", highlight=" + this.getHighlight() + ", foreground=" + this.getForegroundColor() + "', inheritForeground=" + this.isInheritForegroundColor() + ", contenttype=" + this.getContentType();
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.support.firePropertyChange(propertyName, oldValue, newValue);
    }

    public static final class CombinationMember {
        private String type;
        private boolean absorbAll;
        private boolean optional;
        private int minimumCount;

        public CombinationMember(String type, boolean absorbAll, boolean optional, int minimumCount) {
            this.type = type;
            this.absorbAll = absorbAll;
            this.optional = optional;
            this.minimumCount = minimumCount;
        }

        public CombinationMember(String type, boolean absorbAll, boolean optional, String minimumCount) {
            this.type = type;
            this.absorbAll = absorbAll;
            this.optional = optional;
            if (minimumCount != null && minimumCount.length() > 0) {
                try {
                    this.minimumCount = Integer.parseInt(minimumCount);
                }
                catch (NumberFormatException ex) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        ex.printStackTrace();
                    }
                    this.minimumCount = 0;
                }
            } else {
                this.minimumCount = 0;
            }
        }

        public String getName() {
            return this.type;
        }

        public boolean isAbsorbAll() {
            return this.absorbAll;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int getMinimumCount() {
            return this.minimumCount;
        }
    }
}

