/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.AdjustFinder;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.AtomicLockDocument;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Bookmarks;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.DocumentContent;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.LeafElement;
import org.netbeans.editor.LineRootElement;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TextBatchProcessor;
import org.netbeans.editor.Utilities;

public class BaseDocument
extends AbstractDocument
implements SettingsChangeListener,
AtomicLockDocument {
    public static final String ID_PROP = "id";
    public static final String READ_LINE_SEPARATOR_PROP = "__EndOfLine__";
    public static final String WRITE_LINE_SEPARATOR_PROP = "write-line-separator";
    public static final String FILE_NAME_PROP = "file-name";
    public static final String WRAP_SEARCH_MARK_PROP = "wrap-search-mark";
    public static final String UNDO_MANAGER_PROP = "undo-manager";
    public static final String KIT_CLASS_PROP = "kit-class";
    public static final String STRING_FINDER_PROP = "string-finder";
    public static final String STRING_BWD_FINDER_PROP = "string-bwd-finder";
    public static final String BLOCKS_FINDER_PROP = "blocks-finder";
    public static final String LINE_LIMIT_PROP = "line-limit";
    public static final String LINE_BATCH_SIZE = "line-batch-size";
    public static final String LS_CR = "\r";
    public static final String LS_LF = "\n";
    public static final String LS_CRLF = "\r\n";
    private static final int MAX_READ_THREADS = 10;
    private static final String WRITE_LOCK_MISSING = "extWriteUnlock() without extWriteLock()";
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.document");
    private static final boolean debugStack = Boolean.getBoolean("netbeans.debug.editor.document.stack");
    private int tabSize = SettingsDefaults.defaultTabSize;
    private Integer shiftWidth;
    private int writeDepth;
    private int atomicDepth;
    protected boolean inited;
    protected boolean modified;
    protected EventListenerList listenerList = new EventListenerList();
    PropertyChangeListener findSupportListener;
    protected BaseElement defaultRootElem;
    private SyntaxSupport syntaxSupport;
    private DrawLayerList drawLayerList = new DrawLayerList();
    private MarkChain bookmarkChain;
    boolean undoMergeReset;
    Class kitClass;
    private AtomicCompoundEdit atomicEdits;
    private Acceptor identifierAcceptor;
    private Acceptor whitespaceAcceptor;
    private ArrayList syntaxList = new ArrayList();
    private ArrayList posList = new ArrayList();
    private ArrayList posFreeList = new ArrayList();
    protected LineRootElement lineRootElement;
    UndoableEdit lastModifyUndoEdit;
    private Annotations annotations;
    private Bookmarks bookmarks;
    private boolean composedText = false;
    final Map marks = new HashMap();
    final MarkVector marksStorage = new MarkVector();
    private FinderFactory.VisColPosFwdFinder visColPosFwdFinder;
    private FinderFactory.PosVisColFwdFinder posVisColFwdFinder;
    private AtomicLockEvent atomicLockEventInstance = new AtomicLockEvent(this);
    static /* synthetic */ Class class$org$netbeans$editor$GapStart;
    static /* synthetic */ Class class$org$netbeans$editor$AtomicLockListener;

    public BaseDocument(Class kitClass, boolean addToRegistry) {
        super(new DocumentContent());
        this.kitClass = kitClass;
        this.getDocumentContent().setBaseDocument(this);
        this.setDocumentProperties(new LazyPropertyMap(this.getDocumentProperties()));
        this.putProperty(class$org$netbeans$editor$GapStart == null ? (class$org$netbeans$editor$GapStart = BaseDocument.class$("org.netbeans.editor.GapStart")) : class$org$netbeans$editor$GapStart, this.getDocumentContent());
        this.lineRootElement = new LineRootElement(this);
        this.settingsChange(null);
        Settings.addSettingsChangeListener(this);
        this.putProperty(READ_LINE_SEPARATOR_PROP, Analyzer.getPlatformLS());
        this.bookmarkChain = new MarkChain(this, "bookmark-layer");
        this.addLayer(new DrawLayerFactory.SyntaxLayer(), 1000);
        this.addLayer(new DrawLayerFactory.HighlightSearchLayer(), 9000);
        this.addLayer(new DrawLayerFactory.BookmarkLayer(), 2000);
        BaseKit kit = BaseKit.getKit(kitClass);
        if (kit != null) {
            kit.initDocument(this);
        }
        if (addToRegistry) {
            Registry.addDocument(this);
        }
        this.findSupportListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BaseDocument.this.findSupportChange(evt);
            }
        };
        FindSupport.getFindSupport().addPropertyChangeListener(this.findSupportListener);
        this.findSupportChange(null);
    }

    private DocumentContent getDocumentContent() {
        return (DocumentContent)this.getContent();
    }

    public CharSeq getText() {
        return this.getDocumentContent();
    }

    private void findSupportChange(PropertyChangeEvent evt) {
        this.putProperty(STRING_FINDER_PROP, null);
        this.putProperty(STRING_BWD_FINDER_PROP, null);
        this.putProperty(BLOCKS_FINDER_PROP, null);
        DrawLayerFactory.HighlightSearchLayer hsl = (DrawLayerFactory.HighlightSearchLayer)this.findLayer("highlight-search-layer");
        Boolean b = (Boolean)FindSupport.getFindSupport().getPropertyNoInit("find-highlight-search");
        hsl.setEnabled(b != null ? b : false);
        this.fireChangedUpdate(this.createDocumentEvent(0, this.getLength(), DocumentEvent.EventType.CHANGE));
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Object shw;
        String settingName;
        String string = settingName = evt != null ? evt.getSettingName() : null;
        if (settingName == null || "tab-size".equals(settingName)) {
            this.tabSize = SettingsUtil.getPositiveInteger(this.kitClass, "tab-size", SettingsDefaults.defaultTabSize);
        }
        if ((settingName == null || "indent-shift-width".equals(settingName)) && (shw = Settings.getValue(this.kitClass, "indent-shift-width")) instanceof Integer) {
            this.shiftWidth = (Integer)shw;
        }
        if (settingName == null || "read-buffer-size".equals(settingName)) {
            int readBufferSize = SettingsUtil.getPositiveInteger(this.kitClass, "read-buffer-size", SettingsDefaults.defaultReadBufferSize);
            this.putProperty("read-buffer-size", new Integer(readBufferSize));
        }
        if (settingName == null || "write-buffer-size".equals(settingName)) {
            int writeBufferSize = SettingsUtil.getPositiveInteger(this.kitClass, "write-buffer-size", SettingsDefaults.defaultWriteBufferSize);
            this.putProperty("write-buffer-size", new Integer(writeBufferSize));
        }
        if (settingName == null || "mark-distance".equals(settingName)) {
            int markDistance = SettingsUtil.getPositiveInteger(this.kitClass, "mark-distance", SettingsDefaults.defaultMarkDistance);
            this.putProperty("mark-distance", new Integer(markDistance));
        }
        if (settingName == null || "max-mark-distance".equals(settingName)) {
            int maxMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "max-mark-distance", SettingsDefaults.defaultMaxMarkDistance);
            this.putProperty("max-mark-distance", new Integer(maxMarkDistance));
        }
        if (settingName == null || "min-mark-distance".equals(settingName)) {
            int minMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "min-mark-distance", SettingsDefaults.defaultMinMarkDistance);
            this.putProperty("min-mark-distance", new Integer(minMarkDistance));
        }
        if (settingName == null || "read-mark-distance".equals(settingName)) {
            int readMarkDistance = SettingsUtil.getPositiveInteger(this.kitClass, "read-mark-distance", SettingsDefaults.defaultReadMarkDistance);
            this.putProperty("read-mark-distance", new Integer(readMarkDistance));
        }
        if (settingName == null || "syntax-update-batch-size".equals(settingName)) {
            int syntaxUpdateBatchSize = SettingsUtil.getPositiveInteger(this.kitClass, "syntax-update-batch-size", SettingsDefaults.defaultSyntaxUpdateBatchSize);
            this.putProperty("syntax-update-batch-size", new Integer(syntaxUpdateBatchSize));
        }
        if (settingName == null || LINE_BATCH_SIZE.equals(settingName)) {
            int lineBatchSize = SettingsUtil.getPositiveInteger(this.kitClass, LINE_BATCH_SIZE, SettingsDefaults.defaultLineBatchSize);
            this.putProperty(LINE_BATCH_SIZE, new Integer(lineBatchSize));
        }
        if (settingName == null || "identifier-acceptor".equals(settingName)) {
            this.identifierAcceptor = SettingsUtil.getAcceptor(this.kitClass, "identifier-acceptor", AcceptorFactory.LETTER_DIGIT);
        }
        if (settingName == null || "whitespace-acceptor".equals(settingName)) {
            this.whitespaceAcceptor = SettingsUtil.getAcceptor(this.kitClass, "whitespace-acceptor", AcceptorFactory.WHITESPACE);
        }
        boolean stopOnEOL = SettingsUtil.getBoolean(this.kitClass, "word-move-newline-stop", true);
        if (settingName == null || "next-word-finder".equals(settingName)) {
            this.putProperty("next-word-finder", SettingsUtil.getValue(this.kitClass, "next-word-finder", new FinderFactory.NextWordFwdFinder(this, stopOnEOL, false)));
        }
        if (settingName == null || "previous-word-finder".equals(settingName)) {
            this.putProperty("previous-word-finder", SettingsUtil.getValue(this.kitClass, "previous-word-finder", new FinderFactory.PreviousWordBwdFinder(this, stopOnEOL, false)));
        }
    }

    Syntax getFreeSyntax() {
        ArrayList arrayList = this.syntaxList;
        synchronized (arrayList) {
            int cnt = this.syntaxList.size();
            Syntax syntax = cnt > 0 ? (Syntax)this.syntaxList.remove(cnt - 1) : BaseKit.getKit(this.kitClass).createSyntax(this);
            return syntax;
        }
    }

    void releaseSyntax(Syntax syntax) {
        ArrayList arrayList = this.syntaxList;
        synchronized (arrayList) {
            this.syntaxList.add(syntax);
        }
    }

    public Formatter getFormatter() {
        return Formatter.getFormatter(this.kitClass);
    }

    public SyntaxSupport getSyntaxSupport() {
        if (this.syntaxSupport == null) {
            this.syntaxSupport = BaseKit.getKit(this.kitClass).createSyntaxSupport(this);
        }
        return this.syntaxSupport;
    }

    /*
     * Unable to fully structure code
     */
    public int processText(TextBatchProcessor tbp, int startPos, int endPos) throws BadLocationException {
        block4: {
            if (endPos == -1) {
                endPos = this.getLength();
            }
            batchLineCnt = (Integer)this.getProperty("line-batch-size");
            batchStart = startPos;
            ret = -1;
            if (startPos >= endPos) ** GOTO lbl19
            while (ret < 0 && batchStart < endPos) {
                batchEnd = Math.min(Utilities.getRowStart(this, batchStart, batchLineCnt), endPos);
                if (batchEnd == -1) {
                    batchEnd = endPos;
                }
                ret = tbp.processTextBatch(this, batchStart, batchEnd, batchEnd == endPos);
                batchLineCnt *= 2;
                batchStart = batchEnd;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                ret = tbp.processTextBatch(this, batchStart, batchEnd, (batchEnd = Math.max(Utilities.getRowStart(this, batchStart, -batchLineCnt), endPos)) == endPos);
                batchLineCnt *= 2;
                batchStart = batchEnd;
lbl19:
                // 2 sources

                ** while (ret < 0 && batchStart > endPos)
            }
        }
        return ret;
    }

    public boolean isIdentifierPart(char ch) {
        return this.identifierAcceptor.accept(ch);
    }

    public boolean isWhitespace(char ch) {
        return this.whitespaceAcceptor.accept(ch);
    }

    int storePosition(int pos) throws BadLocationException {
        int ind;
        MultiMark mark = this.getDocumentContent().createBiasMark(pos, Position.Bias.Forward);
        if (this.posFreeList.size() > 0) {
            ind = (Integer)this.posFreeList.remove(this.posFreeList.size() - 1);
            this.posList.set(ind, mark);
        } else {
            ind = this.posList.size();
            this.posList.add(mark);
        }
        return ind;
    }

    int getStoredPosition(int posID) {
        if (posID < 0 || posID >= this.posList.size()) {
            return -1;
        }
        MultiMark mark = (MultiMark)this.posList.get(posID);
        return mark != null ? mark.getOffset() : -1;
    }

    void removeStoredPosition(int posID) {
        if (posID >= 0 || posID < this.posList.size()) {
            Mark mark = (Mark)this.posList.get(posID);
            this.posList.set(posID, null);
            this.posFreeList.add(new Integer(posID));
            try {
                mark.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
    }

    public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
        if (text == null || text.length() == 0) {
            return;
        }
        if (offset < 0 || offset > this.getLength()) {
            throw new BadLocationException("Wrong insert position", offset);
        }
        text = Analyzer.convertLSToLF(text);
        this.extWriteLock();
        try {
            boolean isComposedText;
            this.preInsertCheck(offset, text, a);
            UndoableEdit edit = this.getContent().insertString(offset, text);
            if (debug) {
                System.err.println("BaseDocument.insertString(): doc=" + this + (this.modified ? "" : " - first modification") + ", offset=" + offset + ", text='" + text + "'");
            }
            if (debugStack) {
                Thread.dumpStack();
            }
            BaseDocumentEvent evt = this.createDocumentEvent(offset, text.length(), DocumentEvent.EventType.INSERT);
            if (edit != null) {
                evt.addEdit(edit);
                this.lastModifyUndoEdit = edit;
            }
            this.modified = true;
            if (this.atomicDepth > 0) {
                if (this.atomicEdits == null) {
                    this.atomicEdits = new AtomicCompoundEdit();
                }
                this.atomicEdits.addEdit(evt);
            }
            this.insertUpdate(evt, a);
            evt.end();
            this.fireInsertUpdate(evt);
            boolean bl = isComposedText = a != null && a.isDefined(StyleConstants.ComposedTextAttribute);
            if (this.composedText && !isComposedText) {
                this.composedText = false;
            }
            if (!this.composedText && isComposedText) {
                this.composedText = true;
            }
            if (this.atomicDepth == 0 && !isComposedText) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, evt));
            }
            Object var8_7 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public void remove(int offset, int len) throws BadLocationException {
        if (len > 0) {
            this.extWriteLock();
            try {
                int docLen = this.getLength();
                if (offset < 0 || offset > docLen) {
                    throw new BadLocationException("Wrong remove position", offset);
                }
                if (offset + len > docLen) {
                    throw new BadLocationException("End offset of removed text " + (offset + len) + " > getLength()=" + docLen, offset + len);
                }
                this.preRemoveCheck(offset, len);
                BaseDocumentEvent evt = this.createDocumentEvent(offset, len, DocumentEvent.EventType.REMOVE);
                this.removeUpdate(evt);
                UndoableEdit edit = this.getContent().remove(offset, len);
                if (edit != null) {
                    evt.addEdit(edit);
                    this.lastModifyUndoEdit = edit;
                }
                if (debug) {
                    System.err.println("BaseDocument.remove(): doc=" + this + ", offset=" + offset + ", len=" + len);
                }
                if (debugStack) {
                    Thread.dumpStack();
                }
                if (this.atomicDepth > 0) {
                    if (this.atomicEdits == null) {
                        this.atomicEdits = new AtomicCompoundEdit();
                    }
                    this.atomicEdits.addEdit(evt);
                }
                this.postRemoveUpdate(evt);
                evt.end();
                this.fireRemoveUpdate(evt);
                if (this.atomicDepth == 0 && !this.composedText) {
                    this.fireUndoableEditUpdate(new UndoableEditEvent(this, evt));
                }
                Object var7_6 = null;
                this.extWriteUnlock();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.extWriteUnlock();
                throw throwable;
            }
        }
    }

    protected void preInsertCheck(int offset, String text, AttributeSet a) throws BadLocationException {
    }

    protected void preRemoveCheck(int offset, int len) throws BadLocationException {
    }

    public String getText(int[] block) throws BadLocationException {
        return this.getText(block[0], block[1] - block[0]);
    }

    public char[] getChars(int pos, int len) throws BadLocationException {
        char[] chars = new char[len];
        this.getChars(pos, chars, 0, len);
        return chars;
    }

    public char[] getChars(int[] block) throws BadLocationException {
        return this.getChars(block[0], block[1] - block[0]);
    }

    public void getChars(int pos, char[] ret, int offset, int len) throws BadLocationException {
        DocumentUtilities.copyText(this, pos, pos + len, ret, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int find(Finder finder, int startPos, int limitPos) throws BadLocationException {
        int n;
        int docLen = this.getLength();
        if (limitPos == -1) {
            limitPos = docLen;
        }
        if (startPos == -1) {
            startPos = docLen;
        }
        if (finder instanceof AdjustFinder) {
            boolean voidSearch;
            if (startPos == limitPos) {
                finder.reset();
                return -1;
            }
            boolean forwardAdjustedSearch = startPos < limitPos;
            startPos = ((AdjustFinder)finder).adjustStartPos(this, startPos);
            limitPos = ((AdjustFinder)finder).adjustLimitPos(this, limitPos);
            boolean bl = forwardAdjustedSearch ? startPos >= limitPos : (voidSearch = startPos <= limitPos);
            if (voidSearch) {
                finder.reset();
                return -1;
            }
        }
        finder.reset();
        if (startPos == limitPos) {
            return -1;
        }
        Segment text = DocumentUtilities.SEGMENT_CACHE.getSegment();
        try {
            int pos;
            block17: {
                int p0;
                boolean fwdSearch;
                int gapStart = DocumentUtilities.getGapStart(this);
                if (gapStart == -1) {
                    throw new IllegalStateException("Cannot get gapStart");
                }
                pos = startPos;
                boolean bl = fwdSearch = startPos <= limitPos;
                if (fwdSearch) {
                    while (pos >= startPos && pos < limitPos) {
                        int p1;
                        if (pos < gapStart) {
                            p0 = startPos;
                            p1 = Math.min(gapStart, limitPos);
                        } else {
                            p0 = Math.max(gapStart, startPos);
                            p1 = limitPos;
                        }
                        this.getText(p0, p1 - p0, text);
                        pos = finder.find(p0 - text.offset, text.array, text.offset, text.offset + text.count, pos, limitPos);
                        if (!finder.isFound()) continue;
                        int n2 = pos;
                        Object var13_15 = null;
                        DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
                        return n2;
                    }
                } else {
                    --pos;
                    while (limitPos <= pos && pos <= startPos) {
                        int p1;
                        if (pos < gapStart) {
                            p0 = limitPos;
                            p1 = Math.min(gapStart, startPos);
                        } else {
                            p0 = Math.max(gapStart, limitPos);
                            p1 = startPos;
                        }
                        this.getText(p0, p1 - p0, text);
                        pos = finder.find(p0 - text.offset, text.array, text.offset, text.offset + text.count, pos, limitPos);
                        if (!finder.isFound()) continue;
                        break block17;
                    }
                }
                int n3 = -1;
                Object var13_17 = null;
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
                return n3;
            }
            n = pos;
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
            throw throwable;
        }
        Object var13_16 = null;
        DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
        return n;
    }

    public void repaintBlock(int startOffset, int endOffset) {
        BaseDocumentEvent evt = this.createDocumentEvent(startOffset, endOffset - startOffset, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(evt);
    }

    public void print(PrintContainer container) {
        this.readLock();
        try {
            try {
                EditorUI editorUI = BaseKit.getKit(this.kitClass).createPrintEditorUI(this);
                DrawGraphics.PrintDG printDG = new DrawGraphics.PrintDG(container);
                DrawEngine.getDrawEngine().draw(printDG, editorUI, 0, this.getLength(), 0, 0, Integer.MAX_VALUE);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                Object var5_6 = null;
                this.readUnlock();
            }
            Object var5_5 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public Position createPosition(int offset, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasPosition(offset, bias);
    }

    MultiMark createMark(int offset) throws BadLocationException {
        return this.getDocumentContent().createMark(offset);
    }

    MultiMark createBiasMark(int offset, Position.Bias bias) throws BadLocationException {
        return this.getDocumentContent().createBiasMark(offset, bias);
    }

    public Element[] getRootElements() {
        Element[] elems = new Element[]{this.getDefaultRootElement()};
        return elems;
    }

    public Element getDefaultRootElement() {
        if (this.defaultRootElem == null) {
            this.defaultRootElem = new LeafElement(this, null, null, 0, this.getLength(), false, false);
        }
        return this.defaultRootElem;
    }

    public void render(Runnable r) {
        this.readLock();
        try {
            r.run();
            Object var3_2 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public void runAtomic(Runnable r) {
        this.runAtomicAsUser(r);
    }

    public void runAtomicAsUser(Runnable r) {
        Object v1;
        block7: {
            boolean completed = false;
            this.atomicLock();
            try {
                r.run();
                completed = true;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var4_4 = null;
                try {
                    if (!completed) {
                        this.breakAtomicLock();
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var6_8 = v0;
                this.atomicUnlock();
                throw throwable;
            }
            try {
                if (!completed) {
                    this.breakAtomicLock();
                }
                v1 = null;
                break block7;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var6_7 = v1;
        this.atomicUnlock();
    }

    public void read(Reader reader, int pos) throws IOException, BadLocationException {
        this.extWriteLock();
        try {
            if (pos < 0 || pos > this.getLength()) {
                throw new BadLocationException("BaseDocument.read()", pos);
            }
            if (this.inited || this.modified) {
                Analyzer.read(this, reader, pos);
            } else {
                Analyzer.initialRead(this, reader, true);
                this.inited = true;
            }
            Object var4_3 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public void write(Writer writer, int pos, int len) throws IOException, BadLocationException {
        this.readLock();
        try {
            if (pos < 0 || pos + len > this.getLength()) {
                throw new BadLocationException("BaseDocument.write()", pos);
            }
            Analyzer.write(this, writer, pos, len);
            writer.flush();
            Object var5_4 = null;
            this.readUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readUnlock();
            throw throwable;
        }
    }

    public void invalidateSyntaxMarks() {
        this.extWriteLock();
        try {
            this.getLineRootElement().invalidateAllSyntaxStateInfos();
            this.repaintBlock(0, this.getLength());
            Object var2_1 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.extWriteUnlock();
            throw throwable;
        }
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public int getShiftWidth() {
        if (this.shiftWidth != null) {
            return this.shiftWidth;
        }
        return this.getFormatter().getSpacesPerTab();
    }

    public final Class getKitClass() {
        return this.kitClass;
    }

    public void resetUndoMerge() {
        this.undoMergeReset = true;
    }

    protected void fireChangedUpdate(DocumentEvent e) {
        super.fireChangedUpdate(e);
    }

    protected void fireInsertUpdate(DocumentEvent e) {
        super.fireInsertUpdate(e);
    }

    protected void fireRemoveUpdate(DocumentEvent e) {
        super.fireRemoveUpdate(e);
    }

    public final synchronized void extWriteLock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            super.writeLock();
        } else {
            ++this.writeDepth;
        }
    }

    public final synchronized void extWriteUnlock() {
        if (Thread.currentThread() != this.getCurrentWriter()) {
            throw new RuntimeException(WRITE_LOCK_MISSING);
        }
        if (this.writeDepth == 0) {
            super.writeUnlock();
        } else {
            --this.writeDepth;
        }
    }

    public final synchronized void atomicLock() {
        this.extWriteLock();
        ++this.atomicDepth;
        if (this.atomicDepth == 1) {
            this.fireAtomicLock(this.atomicLockEventInstance);
        }
    }

    public final synchronized void atomicUnlock() {
        this.atomicUnlockImpl(false);
    }

    public final synchronized void atomicUnlockImpl(boolean inUndoOrRedo) {
        this.extWriteUnlock();
        if (this.atomicDepth == 0) {
            throw new IllegalStateException("atomicUnlock() without atomicLock()");
        }
        if (--this.atomicDepth == 0) {
            this.fireAtomicUnlock(this.atomicLockEventInstance);
            if (!inUndoOrRedo && this.atomicEdits != null && this.atomicEdits.size() > 0) {
                this.atomicEdits.end();
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, this.atomicEdits));
                this.atomicEdits = null;
            }
        }
    }

    public final boolean isAtomicLock() {
        return this.atomicDepth > 0;
    }

    public final void breakAtomicLock() {
        if (this.atomicEdits != null && this.atomicEdits.size() > 0) {
            this.atomicEdits.end();
            this.atomicEdits.undo();
            this.atomicEdits = null;
        }
    }

    public void atomicUndo() {
        this.breakAtomicLock();
    }

    public void addAtomicLockListener(AtomicLockListener l) {
        this.listenerList.add(class$org$netbeans$editor$AtomicLockListener == null ? (class$org$netbeans$editor$AtomicLockListener = BaseDocument.class$("org.netbeans.editor.AtomicLockListener")) : class$org$netbeans$editor$AtomicLockListener, l);
    }

    public void removeAtomicLockListener(AtomicLockListener l) {
        this.listenerList.remove(class$org$netbeans$editor$AtomicLockListener == null ? (class$org$netbeans$editor$AtomicLockListener = BaseDocument.class$("org.netbeans.editor.AtomicLockListener")) : class$org$netbeans$editor$AtomicLockListener, l);
    }

    private void fireAtomicLock(AtomicLockEvent evt) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$netbeans$editor$AtomicLockListener == null ? (class$org$netbeans$editor$AtomicLockListener = BaseDocument.class$("org.netbeans.editor.AtomicLockListener")) : class$org$netbeans$editor$AtomicLockListener);
        int cnt = listeners.length;
        int i = 0;
        while (i < cnt) {
            ((AtomicLockListener)listeners[i]).atomicLock(evt);
            ++i;
        }
    }

    private void fireAtomicUnlock(AtomicLockEvent evt) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$netbeans$editor$AtomicLockListener == null ? (class$org$netbeans$editor$AtomicLockListener = BaseDocument.class$("org.netbeans.editor.AtomicLockListener")) : class$org$netbeans$editor$AtomicLockListener);
        int cnt = listeners.length;
        int i = 0;
        while (i < cnt) {
            ((AtomicLockListener)listeners[i]).atomicUnlock(evt);
            ++i;
        }
    }

    protected final int getAtomicDepth() {
        return this.atomicDepth;
    }

    protected BaseDocumentEvent createDocumentEvent(int pos, int length, DocumentEvent.EventType type) {
        return new BaseDocumentEvent(this, pos, length, type);
    }

    public boolean isModified() {
        return this.modified;
    }

    public DrawLayer findLayer(String layerName) {
        return this.drawLayerList.findLayer(layerName);
    }

    public boolean addLayer(DrawLayer layer, int visibility) {
        if (this.drawLayerList.add(layer, visibility)) {
            BaseDocumentEvent evt = this.createDocumentEvent(0, 0, DocumentEvent.EventType.CHANGE);
            evt.addEdit(new BaseDocumentEvent.DrawLayerChange(layer.getName(), visibility));
            this.fireChangedUpdate(evt);
            return true;
        }
        return false;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    public boolean toggleBookmark(int pos) throws BadLocationException {
        pos = Utilities.getRowStart(this, pos);
        boolean marked = this.bookmarkChain.toggleMark(pos);
        BaseDocumentEvent evt = this.createDocumentEvent(pos, 0, DocumentEvent.EventType.CHANGE);
        this.fireChangedUpdate(evt);
        return marked;
    }

    public int getNextBookmark(int pos, boolean wrap) throws BadLocationException {
        try {
            pos = Utilities.getRowStart(this, pos);
            int rel = this.bookmarkChain.compareMark(pos);
            MarkFactory.ChainDrawMark mark = this.bookmarkChain.getCurMark();
            if (rel <= 0) {
                if (mark != null) {
                    if (mark.next != null) {
                        return mark.next.getOffset();
                    }
                    return wrap && this.bookmarkChain.chain != null ? this.bookmarkChain.chain.getOffset() : -1;
                }
                return -1;
            }
            return mark.getOffset();
        }
        catch (InvalidMarkException e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    private LineRootElement getLineRootElement() {
        return this.lineRootElement;
    }

    public Element getParagraphElement(int pos) {
        return this.getLineRootElement().getElement(this.getLineRootElement().getElementIndex(pos));
    }

    public synchronized Annotations getAnnotations() {
        if (this.annotations == null) {
            this.annotations = new Annotations(this);
        }
        return this.annotations;
    }

    public synchronized Bookmarks getBookmarks() {
        if (this.bookmarks == null) {
            this.bookmarks = new Bookmarks();
        }
        return this.bookmarks;
    }

    void prepareSyntax(Segment text, Syntax syntax, int reqPos, int reqLen, boolean forceLastBuffer, boolean forceNotLastBuffer) throws BadLocationException {
        this.getLineRootElement().prepareSyntax(text, syntax, reqPos, reqLen, forceLastBuffer, forceNotLastBuffer);
    }

    int getTokenSafeOffset(int offset) {
        return this.getLineRootElement().getTokenSafeOffset(offset);
    }

    synchronized int getOffsetFromVisCol(int visCol, int startLinePos) throws BadLocationException {
        if (startLinePos < 0 || startLinePos >= this.getLength()) {
            throw new BadLocationException("Invalid start line offset", startLinePos);
        }
        if (visCol <= 0) {
            return startLinePos;
        }
        if (this.visColPosFwdFinder == null) {
            this.visColPosFwdFinder = new FinderFactory.VisColPosFwdFinder();
        }
        this.visColPosFwdFinder.setVisCol(visCol);
        this.visColPosFwdFinder.setTabSize(this.getTabSize());
        int pos = this.find(this.visColPosFwdFinder, startLinePos, -1);
        return pos != -1 ? pos : Utilities.getRowEnd(this, startLinePos);
    }

    synchronized int getVisColFromPos(int pos) throws BadLocationException {
        if (pos < 0 || pos > this.getLength()) {
            throw new BadLocationException("Invalid offset", pos);
        }
        if (this.posVisColFwdFinder == null) {
            this.posVisColFwdFinder = new FinderFactory.PosVisColFwdFinder();
        }
        int startLinePos = Utilities.getRowStart(this, pos);
        this.posVisColFwdFinder.setTabSize(this.getTabSize());
        this.find(this.posVisColFwdFinder, startLinePos, pos);
        return this.posVisColFwdFinder.getVisCol();
    }

    public String toString() {
        return super.toString() + ", kitClass=" + this.getKitClass() + ", docLen=" + this.getLength();
    }

    public String toStringDetail() {
        return this.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LazyPropertyMap
    extends Hashtable {
        LazyPropertyMap(Dictionary dict) {
            super(5);
            Enumeration en = dict.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                this.put(key, dict.get(key));
            }
        }

        public Object get(Object key) {
            Object val = super.get(key);
            if (val instanceof PropertyEvaluator) {
                val = ((PropertyEvaluator)val).getValue();
            }
            return val;
        }
    }

    public static interface PropertyEvaluator {
        public Object getValue();
    }

    class AtomicCompoundEdit
    extends CompoundEdit {
        AtomicCompoundEdit() {
        }

        public void undo() throws CannotUndoException {
            BaseDocument.this.atomicLock();
            try {
                super.undo();
                Object var2_1 = null;
                BaseDocument.this.atomicUnlockImpl(true);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                BaseDocument.this.atomicUnlockImpl(true);
                throw throwable;
            }
        }

        public void redo() throws CannotRedoException {
            BaseDocument.this.atomicLock();
            try {
                super.redo();
                Object var2_1 = null;
                BaseDocument.this.atomicUnlockImpl(true);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                BaseDocument.this.atomicUnlockImpl(true);
                throw throwable;
            }
        }

        public int size() {
            return this.edits.size();
        }
    }
}

