/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseElement;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseView;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.LeafView;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;

public class BaseTextUI
extends TextUI
implements ViewFactory,
PropertyChangeListener,
DocumentListener {
    private static final int MAX_SPAN = 0x7FFFFDFF;
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 200;
    private JTextComponent component;
    private EditorUI editorUI;
    int componentID = -1;
    private static final GetFocusedComponentAction gfcAction = new GetFocusedComponentAction();
    private RootView rootView = new RootView();
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$SwingUtilities;

    public static JTextComponent getFocusedComponent() {
        return gfcAction.getFocusedComponent2();
    }

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        if (oldDoc != null) {
            oldDoc.removeDocumentListener(this);
        }
        if (newDoc != null) {
            newDoc.addDocumentListener(this);
            Registry.activate(newDoc);
            ViewFactory f = this.rootView.getViewFactory();
            BaseKit kit = (BaseKit)this.getEditorKit(this.component);
            this.component.removeAll();
            Element elem = newDoc.getDefaultRootElement();
            View v = f.create(elem);
            this.rootView.setView(v);
            this.rootView.updateMainHeight();
            this.component.revalidate();
            Settings.KitAndValue[] kv = Settings.getValueHierarchy(kit.getClass(), "doc-install-action-name-list");
            int i = kv.length - 1;
            while (i >= 0) {
                List actList = (List)kv[i].value;
                if ((actList = kit.translateActionNameList(actList)) != null) {
                    Iterator iter = actList.iterator();
                    while (iter.hasNext()) {
                        Action a = (Action)iter.next();
                        a.actionPerformed(new ActionEvent(this.component, 1001, ""));
                    }
                }
                --i;
            }
        }
    }

    void updateHeight() {
        this.rootView.updateMainHeight();
    }

    public void installUI(JComponent c) {
        if (c instanceof JTextComponent) {
            this.component = (JTextComponent)c;
            this.getEditorUI().installUI(this.component);
            this.component.setOpaque(true);
            this.component.setAutoscrolls(true);
            this.component.addPropertyChangeListener(this);
            BaseKit kit = (BaseKit)this.getEditorKit(this.component);
            Caret caret = kit.createCaret();
            this.component.setCaretColor(Color.black);
            this.component.setCaret(caret);
            int br = SettingsUtil.getInteger(Utilities.getKitClass(this.component), "caret-blink-rate", (int)SettingsDefaults.defaultCaretBlinkRate);
            caret.setBlinkRate(br);
            BaseDocument doc = Utilities.getDocument(this.component);
            if (doc != null) {
                this.modelChanged(null, doc);
            }
            try {
                Class<?> inputMapClass = Class.forName("javax.swing.InputMap");
                if (inputMapClass != null) {
                    Method replaceUIInputMapMethod = (class$javax$swing$SwingUtilities == null ? (class$javax$swing$SwingUtilities = BaseTextUI.class$("javax.swing.SwingUtilities")) : class$javax$swing$SwingUtilities).getDeclaredMethod("replaceUIInputMap", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = BaseTextUI.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, Integer.TYPE, inputMapClass);
                    replaceUIInputMapMethod.invoke(null, c, new Integer(0), null);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            Registry.addComponent(this.component);
            Registry.activate(this.component);
            this.component.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    public void uninstallUI(JComponent c) {
        this.component.removePropertyChangeListener(this);
        this.component.getDocument().removeDocumentListener(this);
        this.rootView.setView(null);
        this.component.removeAll();
        this.component.setKeymap(null);
        this.component.setCaret(null);
        this.getEditorUI().uninstallUI(this.component);
        Registry.removeComponent(this.component);
        this.editorUI = null;
        this.component = null;
    }

    public void paint(Graphics g, JComponent c) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            BaseDocument doc = Utilities.getDocument(this.component);
            if (c == this.component && doc != null) {
                doc.readLock();
                try {
                    this.getEditorUI().paint(g);
                    Caret caret = this.component.getCaret();
                    if (caret != null) {
                        caret.paint(g);
                    }
                    if (this.getEditorUI().virtualSizeUpdated) {
                        this.preferenceChanged(true, true);
                    }
                    Object var6_5 = null;
                    doc.readUnlock();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    doc.readUnlock();
                    throw throwable;
                }
            }
        }
    }

    void paintRegion(Graphics g) {
        this.rootView.paint(g, null);
    }

    public Dimension getPreferredSize(JComponent c) {
        BaseDocument doc;
        Insets i = c.getInsets();
        Insets margin = this.getEditorUI().getTextMargin();
        Dimension d = c.getSize();
        BaseDocument baseDocument = doc = c instanceof JTextComponent ? Utilities.getDocument((JTextComponent)c) : null;
        if (doc != null) {
            doc.readLock();
        }
        try {
            if (d.width > i.left + i.right && d.height > i.top + i.bottom) {
                this.rootView.setSize(d.width - i.left - i.right, d.height - i.top - i.bottom);
            }
            d.width = (int)Math.min(this.rootView.getPreferredSpan(0) + (float)i.left + (float)i.right + (float)margin.left + (float)margin.right, 2.1474831E9f);
            d.height = (int)Math.min(this.rootView.getPreferredSpan(1) + (float)i.top + (float)i.bottom + (float)margin.top + (float)margin.bottom, 2.1474831E9f);
            Object var7_6 = null;
            if (doc != null) {
                doc.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (doc != null) {
                doc.readUnlock();
            }
            throw throwable;
        }
        return d;
    }

    public Dimension getMinimumSize(JComponent c) {
        BaseDocument doc;
        Insets i = c.getInsets();
        Insets margin = this.getEditorUI().getTextMargin();
        Dimension d = new Dimension();
        BaseDocument baseDocument = doc = c instanceof JTextComponent ? Utilities.getDocument((JTextComponent)c) : null;
        if (doc != null) {
            doc.readLock();
        }
        try {
            d.width = (int)this.rootView.getMinimumSpan(0) + i.left + i.right + margin.left + margin.right;
            d.height = (int)this.rootView.getMinimumSpan(1) + i.top + i.bottom + margin.top + margin.bottom;
            Object var7_6 = null;
            if (doc != null) {
                doc.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (doc != null) {
                doc.readUnlock();
            }
            throw throwable;
        }
        return d;
    }

    public Dimension getMaximumSize(JComponent c) {
        BaseDocument doc;
        Insets i = c.getInsets();
        Insets margin = this.getEditorUI().getTextMargin();
        Dimension d = new Dimension();
        BaseDocument baseDocument = doc = c instanceof JTextComponent ? Utilities.getDocument((JTextComponent)c) : null;
        if (doc != null) {
            doc.readLock();
        }
        try {
            d.width = (int)Math.min(this.rootView.getMaximumSpan(0) + (float)i.left + (float)i.right + (float)margin.left + (float)margin.right, 2.1474831E9f);
            d.height = (int)Math.min(this.rootView.getMaximumSpan(1) + (float)i.top + (float)i.bottom + (float)margin.top + (float)margin.bottom, 2.1474831E9f);
            Object var7_6 = null;
            if (doc != null) {
                doc.readUnlock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (doc != null) {
                doc.readUnlock();
            }
            throw throwable;
        }
        return d;
    }

    public void invalidateStartY() {
        this.rootView.invalidateStartY();
    }

    public Rectangle modelToView(JTextComponent c, int pos) throws BadLocationException {
        return (Rectangle)this.rootView.modelToView(pos, null, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent c, int pos, Position.Bias bias) throws BadLocationException {
        return (Rectangle)this.rootView.modelToView(pos, null, bias);
    }

    void modelToViewDG(int pos, DrawGraphics dg) throws BadLocationException {
        this.rootView.modelToViewDG(pos, dg);
    }

    public int getYFromPos(int pos) throws BadLocationException {
        return this.rootView.getYFromPos(pos);
    }

    public int getPosFromY(int y) throws BadLocationException {
        return this.rootView.getPosFromY(y);
    }

    public int getBaseX(int y) {
        return this.rootView.getBaseX(y);
    }

    public int viewToModel(JTextComponent c, Point pt) {
        return this.viewToModel(c, pt.x, pt.y);
    }

    public int viewToModel(JTextComponent c, int x, int y) {
        return this.rootView.viewToModel(x, y, null, null);
    }

    public int viewToModel(JTextComponent c, Point pt, Position.Bias[] biasReturn) {
        return this.rootView.viewToModel(pt.x, pt.y, null, biasReturn);
    }

    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.rootView.getNextVisualPositionFrom(pos, b, null, direction, biasRet);
    }

    public void damageRange(JTextComponent c, int p0, int p1) {
        this.damageRange(c, p0, p1, Position.Bias.Forward, Position.Bias.Backward);
    }

    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias p0Bias, Position.Bias p1Bias) {
        BaseDocument doc = Utilities.getDocument(this.component);
        if (t == this.component && doc != null) {
            doc.readLock();
            try {
                try {
                    Rectangle r = (Rectangle)this.rootView.modelToView(p0, p0Bias, p1, p1Bias, null);
                    this.component.repaint(r.x, r.y, r.width, r.height);
                }
                catch (BadLocationException e) {
                    Object var9_10 = null;
                    doc.readUnlock();
                }
                Object var9_9 = null;
                doc.readUnlock();
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                doc.readUnlock();
                throw throwable;
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent c) {
        JEditorPane pane = (JEditorPane)this.component;
        return pane.getEditorKit();
    }

    public View getRootView(JTextComponent c) {
        return this.rootView;
    }

    public EditorUI getEditorUI() {
        if (this.editorUI == null) {
            BaseKit kit = (BaseKit)this.getEditorKit(this.component);
            this.editorUI = kit.createEditorUI();
        }
        return this.editorUI;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument oldDoc = evt.getOldValue() instanceof BaseDocument ? (BaseDocument)evt.getOldValue() : null;
            BaseDocument newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            this.modelChanged(oldDoc, newDoc);
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        this.rootView.insertUpdate(evt, null, this.rootView.getViewFactory());
        if (((BaseDocumentEvent)evt).getLFCount() > 0) {
            if (this.getEditorUI().updateVirtualHeight(this.rootView.getHeight())) {
                this.preferenceChanged(true, true);
            }
            this.getEditorUI().checkLineLimit();
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        this.rootView.removeUpdate(evt, null, this.rootView.getViewFactory());
        if (((BaseDocumentEvent)evt).getLFCount() > 0 && this.getEditorUI().updateVirtualHeight(this.rootView.getHeight())) {
            this.preferenceChanged(true, true);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        if (evt instanceof BaseDocumentEvent) {
            BaseDocumentEvent bdevt = (BaseDocumentEvent)evt;
            BaseDocument doc = (BaseDocument)bdevt.getDocument();
            String layerName = bdevt.getDrawLayerName();
            if (layerName != null) {
                this.getEditorUI().addLayer(doc.findLayer(layerName), bdevt.getDrawLayerVisibility());
            } else {
                this.rootView.changedUpdate(evt, null, this.rootView.getViewFactory());
            }
        }
    }

    public View create(Element elem) {
        LeafView v = null;
        if (elem instanceof BaseElement) {
            v = new LeafView(elem);
        }
        return v;
    }

    public View create(Element elem, int p0, int p1) {
        return new LeafView(elem);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BaseTextUI();
    }

    public void preferenceChanged(boolean width, boolean height) {
        this.getEditorUI().virtualSizeUpdated = false;
        this.component.revalidate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GetFocusedComponentAction
    extends TextAction {
        private GetFocusedComponentAction() {
            super("get-focused-component");
        }

        public void actionPerformed(ActionEvent evt) {
        }

        JTextComponent getFocusedComponent2() {
            return super.getFocusedComponent();
        }
    }

    class RootView
    extends BaseView {
        BaseView view;

        RootView() {
            super(null);
        }

        void setView(View v) {
            if (v instanceof BaseView) {
                if (this.view != null) {
                    this.view.setParent(null);
                }
                this.view = (BaseView)v;
                if (this.view != null) {
                    this.view.setParent(this);
                }
            }
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int axis) {
            EditorUI editorUI = BaseTextUI.this.getEditorUI();
            switch (axis) {
                case 0: {
                    return Math.max(BaseTextUI.this.getEditorUI().virtualSize.width, 300);
                }
                case 1: {
                    return Math.max(BaseTextUI.this.getEditorUI().virtualSize.height, 200);
                }
            }
            return 0.0f;
        }

        public float getMinimumSpan(int axis) {
            return this.getPreferredSpan(axis);
        }

        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View child, boolean width, boolean height) {
            BaseTextUI.this.preferenceChanged(width, height);
        }

        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        public void paint(Graphics g, Shape allocation) {
            if (this.view != null) {
                this.view.paint(g, allocation);
            }
        }

        public void setParent(View parent) {
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n) {
            return this.view;
        }

        public Shape getChildAllocation(int index, Shape a) {
            return a;
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a, b);
            }
            return null;
        }

        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }
            return null;
        }

        public void modelToViewDG(int pos, DrawGraphics dg) throws BadLocationException {
            if (this.view != null) {
                this.view.modelToViewDG(pos, dg);
            }
        }

        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else if (biasRet != null) {
                    biasRet[0] = b;
                }
            }
            return pos;
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            if (this.view != null) {
                return this.view.viewToModel(x, y, a, b);
            }
            return -1;
        }

        protected int getYFromPos(int pos) throws BadLocationException {
            if (this.view != null) {
                return this.view.getYFromPos(pos);
            }
            return 0;
        }

        protected int getPosFromY(int y) {
            if (this.view != null) {
                return this.view.getPosFromY(y);
            }
            return -1;
        }

        protected int getBaseX(int y) {
            if (this.view != null) {
                return this.view.getBaseX(y);
            }
            return 0;
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.insertUpdate(e, a, f);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.removeUpdate(e, a, f);
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.changedUpdate(e, a, f);
            }
        }

        public Document getDocument() {
            return BaseTextUI.this.component.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BaseTextUI.this.component.getDocument().getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a) {
            return null;
        }

        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        public Container getContainer() {
            return BaseTextUI.this.component;
        }

        public ViewFactory getViewFactory() {
            EditorKit kit = BaseTextUI.this.getEditorKit(BaseTextUI.this.component);
            ViewFactory f = kit.getViewFactory();
            if (f != null) {
                return f;
            }
            return BaseTextUI.this;
        }

        protected int getStartY() {
            return BaseTextUI.this.getEditorUI().textMargin.top;
        }

        protected int getPaintAreas(Graphics g, int clipY, int clipHeight) {
            return 0;
        }

        protected void paintAreas(Graphics g, int clipY, int clipHeight, int paintAreas) {
        }

        protected int getViewStartY(BaseView view, int helperInd) {
            return this.getStartY();
        }

        protected void invalidateStartY() {
            if (this.view != null) {
                this.view.invalidateStartY();
            }
        }

        public int getHeight() {
            if (this.view != null) {
                return this.view.getHeight();
            }
            return 0;
        }

        public void updateMainHeight() {
            if (this.view != null) {
                this.view.updateMainHeight();
                EditorUI editorUI = BaseTextUI.this.getEditorUI();
                if (editorUI.updateVirtualHeight(this.getHeight())) {
                    BaseTextUI.this.preferenceChanged(true, true);
                }
            }
        }
    }
}

