/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.AbstractCollection;
import java.util.ArrayList;

public class Bookmarks {
    private ArrayList bookmarks = new ArrayList(15);

    private Bookmark getInternalBookmark(int line) {
        int i = 0;
        while (i < this.bookmarks.size() && ((Bookmark)this.bookmarks.get(i)).getLine() <= line) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() == line) {
                return (Bookmark)this.bookmarks.get(i);
            }
            ++i;
        }
        return null;
    }

    public Bookmark getBookmark(int line) {
        return this.getInternalBookmark(line);
    }

    public Bookmark getNextLineBookmark(int line) {
        int i = 0;
        while (i < this.bookmarks.size()) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() >= line) {
                return (Bookmark)this.bookmarks.get(i);
            }
            ++i;
        }
        return null;
    }

    public void putBookmark(Bookmark bookmark) {
        int line = bookmark.getLine();
        boolean inserted = false;
        int i = 0;
        while (i < this.bookmarks.size()) {
            if (((Bookmark)this.bookmarks.get(i)).getLine() > line) {
                this.bookmarks.add(i, bookmark);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.bookmarks.add(bookmark);
        }
    }

    public Bookmark removeBookmark(int line) {
        Bookmark bookmark = this.getInternalBookmark(line);
        if (bookmark == null) {
            return null;
        }
        ((AbstractCollection)this.bookmarks).remove(bookmark);
        return bookmark;
    }

    public void removeBookmark(Bookmark bookmark) {
        ((AbstractCollection)this.bookmarks).remove(bookmark);
    }

    public void removeAll() {
        int i = 0;
        while (i < this.bookmarks.size()) {
            ((Bookmark)this.bookmarks.get(i)).remove();
            ++i;
        }
        this.bookmarks = new ArrayList();
    }

    public static interface Bookmark {
        public int getLine();

        public void remove();
    }
}

