/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;

class DrawLayerList {
    private static final DrawLayer[] EMPTY = new DrawLayer[0];
    private DrawLayer[] layers = EMPTY;
    private final ArrayList visibilityList = new ArrayList();

    DrawLayerList() {
    }

    synchronized boolean add(DrawLayer layer, int visibility) {
        if (this.indexOf(layer.getName()) >= 0) {
            return false;
        }
        int indAdd = this.layers.length;
        int i = 0;
        while (i < this.layers.length) {
            if ((Integer)this.visibilityList.get(i) > visibility) {
                indAdd = i;
                break;
            }
            ++i;
        }
        ArrayList<DrawLayer> l = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
        l.add(indAdd, layer);
        this.layers = new DrawLayer[this.layers.length + 1];
        l.toArray(this.layers);
        this.visibilityList.add(indAdd, new Integer(visibility));
        return true;
    }

    synchronized void add(DrawLayerList l) {
        DrawLayer[] lta = l.layers;
        int i = 0;
        while (i < lta.length) {
            this.add(lta[i], (Integer)l.visibilityList.get(i));
            ++i;
        }
    }

    synchronized DrawLayer remove(String layerName) {
        int ind = this.indexOf(layerName);
        DrawLayer removed = null;
        if (ind >= 0) {
            removed = this.layers[ind];
            ArrayList<DrawLayer> l = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
            l.remove(ind);
            this.layers = new DrawLayer[this.layers.length - 1];
            l.toArray(this.layers);
            this.visibilityList.remove(ind);
        }
        return removed;
    }

    synchronized void remove(DrawLayerList l) {
        DrawLayer[] lta = l.layers;
        int i = 0;
        while (i < lta.length) {
            this.remove(lta[i].getName());
            ++i;
        }
    }

    synchronized DrawLayer findLayer(String layerName) {
        int ind = this.indexOf(layerName);
        return ind >= 0 ? this.layers[ind] : null;
    }

    synchronized DrawLayer[] currentLayers() {
        return (DrawLayer[])this.layers.clone();
    }

    private int indexOf(String layerName) {
        int i = 0;
        while (i < this.layers.length) {
            if (layerName.equals(this.layers[i].getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        switch (this.layers.length) {
            case 0: {
                return "No layers";
            }
            case 1: {
                return "Standalone " + this.layers[0];
            }
        }
        return "Layers:\n" + EditorDebug.debugArray(this.layers);
    }
}

