/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Abbrev;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerList;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.GlyphGutter;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WordMatch;

public class EditorUI
implements ChangeListener,
PropertyChangeListener,
SettingsChangeListener {
    public static final String OVERWRITE_MODE_PROPERTY = "overwriteMode";
    public static final String COMPONENT_PROPERTY = "component";
    public static final int SCROLL_DEFAULT = 0;
    public static final int SCROLL_MOVE = 1;
    public static final int SCROLL_SMALLEST = 2;
    public static final int SCROLL_FIND = 3;
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final Dimension NULL_DIMENSION = new Dimension(0, 0);
    private static final int STYLE_CNT = 4;
    private static final boolean debugUpdateLineHeight = Boolean.getBoolean("netbeans.debug.editor.updateLineHeight");
    private static final HashMap sharedColoringMaps = new HashMap(57);
    private static final SettingsChangeListener clearingListener = new SettingsChangeListener(){

        public void settingsChange(SettingsChangeEvent evt) {
            sharedColoringMaps.clear();
        }
    };
    private JTextComponent component;
    private JComponent extComponent;
    PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private BaseDocument printDoc;
    private DrawLayerList drawLayerList = new DrawLayerList();
    private Map coloringMap;
    private int lineHeight = 1;
    private float lineHeightCorrection = 1.0f;
    private int lineAscent;
    int defaultSpaceWidth = 1;
    private boolean fontsInited;
    private boolean fontsInitedPreferenceChanged;
    boolean highlightSearch;
    boolean lineNumberEnabled;
    boolean lineNumberVisibleSetting;
    boolean lineNumberVisible;
    int lineNumberWidth;
    int lineNumberDigitWidth;
    int lineNumberMaxDigitCount;
    Insets lineNumberMargin;
    Rectangle virtualSize = new Rectangle();
    int textLeftMarginWidth;
    Insets textMargin = NULL_INSETS;
    Insets scrollJumpInsets;
    Insets scrollFindInsets;
    boolean virtualSizeUpdated;
    private PropertyChangeListener settingsListener;
    Hashtable props = new Hashtable(11);
    boolean textLimitLineVisible;
    Color textLimitLineColor;
    int textLimitWidth;
    private Rectangle lastExtentBounds = new Rectangle();
    private Dimension componentSizeIncrement = new Dimension();
    private Abbrev abbrev;
    private WordMatch wordMatch;
    private Object componentLock;
    StatusBar statusBar;
    private FocusAdapter focusL;
    Map renderingHints;
    private GlyphGutter glyphGutter = null;
    private boolean disableLineNumbers = true;
    private JPanel glyphCorner;
    static /* synthetic */ Class class$org$netbeans$editor$Settings;
    static /* synthetic */ Class class$javax$swing$JViewport;
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;

    public EditorUI() {
        Settings.addSettingsChangeListener(this);
        this.focusL = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Registry.activate(EditorUI.this.getComponent());
                EditorUI.this.stateChanged(null);
            }
        };
    }

    public EditorUI(BaseDocument printDoc) {
        this.printDoc = printDoc;
        this.settingsChange(null);
        this.setLineNumberEnabled(true);
        this.updateLineNumberWidth(0);
        this.drawLayerList.add(printDoc.getDrawLayerList());
    }

    protected static Map getSharedColoringMap(Class kitClass) {
        Class clazz = class$org$netbeans$editor$Settings == null ? (class$org$netbeans$editor$Settings = EditorUI.class$("org.netbeans.editor.Settings")) : class$org$netbeans$editor$Settings;
        synchronized (clazz) {
            Map cm = (Map)sharedColoringMaps.get(kitClass);
            if (cm == null) {
                cm = SettingsUtil.getColoringMap(kitClass, false, true);
                if (cm.get("default") == null) {
                    cm.put("default", SettingsDefaults.defaultColoring);
                }
                sharedColoringMaps.put(kitClass, cm);
            }
            Map map = cm;
            return map;
        }
    }

    protected void installUI(JTextComponent c) {
        Object object = this.getComponentLock();
        synchronized (object) {
            BaseDocument doc;
            this.component = c;
            this.putProperty(COMPONENT_PROPERTY, c);
            this.component.addPropertyChangeListener(this);
            this.component.addFocusListener(this.focusL);
            Caret caret = this.component.getCaret();
            if (caret != null) {
                caret.addChangeListener(this);
            }
            if ((doc = this.getDocument()) != null) {
                this.modelChanged(null, doc);
            }
        }
        this.settingsChange(null);
        this.getDefaultColoring().apply(this.component);
    }

    protected void uninstallUI(JTextComponent c) {
        Object object = this.getComponentLock();
        synchronized (object) {
            BaseDocument doc;
            if (this.component != null) {
                Caret caret = this.component.getCaret();
                if (caret != null) {
                    caret.removeChangeListener(this);
                }
                this.component.removePropertyChangeListener(this);
                this.component.removeFocusListener(this.focusL);
            }
            if ((doc = this.getDocument()) != null) {
                this.modelChanged(doc, null);
            }
            this.component = null;
            this.putProperty(COMPONENT_PROPERTY, null);
            FontMetricsCache.clear();
        }
    }

    public Object getComponentLock() {
        if (this.componentLock == null) {
            this.componentLock = new ComponentLock();
        }
        return this.componentLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        BaseDocument doc;
        String settingName;
        if (this.component != null && Utilities.getKit(this.component) == null) {
            return;
        }
        Class kitClass = this.getKitClass();
        String string = settingName = evt != null ? evt.getSettingName() : null;
        if (settingName == null || "line-number-visible".equals(settingName) || "print-line-number-visible".equals(settingName)) {
            this.lineNumberVisibleSetting = SettingsUtil.getBoolean(kitClass, this.component != null ? "line-number-visible" : "print-line-number-visible", this.component != null ? SettingsDefaults.defaultLineNumberVisible : SettingsDefaults.defaultPrintLineNumberVisible);
            boolean bl = this.lineNumberVisible = this.lineNumberEnabled && this.lineNumberVisibleSetting;
            if (this.component == null) {
                this.disableLineNumbers = false;
            }
            if (this.disableLineNumbers) {
                this.lineNumberVisible = false;
            }
        }
        if ((doc = this.getDocument()) != null) {
            Object value;
            if (settingName == null || "line-number-margin".equals(settingName)) {
                value = Settings.getValue(kitClass, "line-number-margin");
                Insets insets = this.lineNumberMargin = value instanceof Insets ? (Insets)value : NULL_INSETS;
            }
            if (settingName == null || "text-left-margin-width".equals(settingName)) {
                this.textLeftMarginWidth = SettingsUtil.getInteger(kitClass, "text-left-margin-width", SettingsDefaults.defaultTextLeftMarginWidth);
            }
            if (settingName == null || "line-height-correction".equals(settingName)) {
                value = Settings.getValue(kitClass, "line-height-correction");
                if (!(value instanceof Float) || ((Float)value).floatValue() < 0.0f) {
                    value = SettingsDefaults.defaultLineHeightCorrection;
                }
                this.lineHeightCorrection = ((Float)value).floatValue();
            }
            if (settingName == null || "text-limit-line-visible".equals(settingName)) {
                this.textLimitLineVisible = SettingsUtil.getBoolean(kitClass, "text-limit-line-visible", SettingsDefaults.defaultTextLimitLineVisible);
            }
            if (settingName == null || "text-limit-line-color".equals(settingName)) {
                value = Settings.getValue(kitClass, "text-limit-line-color");
                Color color = this.textLimitLineColor = value instanceof Color ? (Color)value : SettingsDefaults.defaultTextLimitLineColor;
            }
            if (settingName == null || "text-limit-width".equals(settingName)) {
                this.textLimitWidth = SettingsUtil.getPositiveInteger(kitClass, "text-limit-width", SettingsDefaults.defaultTextLimitWidth);
            }
            if (this.component != null) {
                if (settingName == null || "scroll-jump-insets".equals(settingName)) {
                    value = Settings.getValue(kitClass, "scroll-jump-insets");
                    Insets insets = this.scrollJumpInsets = value instanceof Insets ? (Insets)value : NULL_INSETS;
                }
                if (settingName == null || "scroll-find-insets".equals(settingName)) {
                    value = Settings.getValue(kitClass, "scroll-find-insets");
                    Insets insets = this.scrollFindInsets = value instanceof Insets ? (Insets)value : NULL_INSETS;
                }
                if (settingName == null || "component-size-increment".equals(settingName)) {
                    value = Settings.getValue(kitClass, "component-size-increment");
                    Dimension dimension = this.componentSizeIncrement = value instanceof Dimension ? (Dimension)value : NULL_DIMENSION;
                }
                if (settingName == null || "rendering-hints".equals(settingName)) {
                    value = Settings.getValue(kitClass, "rendering-hints");
                    Map map = this.renderingHints = value instanceof Map ? (Map)value : null;
                }
                if (settingName == null || "caret-color-insert-mode".equals(settingName) || "caret-color-overwrite-mode".equals(settingName)) {
                    Color caretColor;
                    Boolean b = (Boolean)this.getProperty(OVERWRITE_MODE_PROPERTY);
                    if (b == null || !b.booleanValue()) {
                        Object value2 = Settings.getValue(kitClass, "caret-color-insert-mode");
                        caretColor = value2 instanceof Color ? (Color)value2 : SettingsDefaults.defaultCaretColorInsertMode;
                    } else {
                        Object value3 = Settings.getValue(kitClass, "caret-color-overwrite-mode");
                        Color color = caretColor = value3 instanceof Color ? (Color)value3 : SettingsDefaults.defaultCaretColorOvwerwriteMode;
                    }
                    if (caretColor != null) {
                        this.component.setCaretColor(caretColor);
                    }
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    this.component.setKeymap(Utilities.getKit(this.component).getKeymap());
                    BaseTextUI ui = (BaseTextUI)this.component.getUI();
                    ui.updateHeight();
                    this.component.repaint();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BaseKit kit;
                            JTextComponent c = EditorUI.this.component;
                            if (c != null && (kit = Utilities.getKit(c)) != null) {
                                c.setKeymap(kit.getKeymap());
                                BaseTextUI ui = (BaseTextUI)c.getUI();
                                if (ui != null) {
                                    ui.updateHeight();
                                    c.repaint();
                                }
                            }
                        }
                    });
                }
            }
        }
        this.coloringMap = null;
        this.fontsInitedPreferenceChanged = false;
        this.fontsInited = false;
    }

    public void stateChanged(ChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            private boolean isCaretGuarded() {
                JTextComponent c = EditorUI.this.component;
                BaseDocument bdoc = EditorUI.this.getDocument();
                boolean inGuardedBlock = false;
                if (bdoc instanceof GuardedDocument) {
                    GuardedDocument gdoc = (GuardedDocument)bdoc;
                    boolean selectionSpansGuardedSection = false;
                    int i = c.getSelectionStart();
                    while (i < c.getSelectionEnd()) {
                        if (gdoc.isPosGuarded(i)) {
                            selectionSpansGuardedSection = true;
                            break;
                        }
                        ++i;
                    }
                    inGuardedBlock = gdoc.isPosGuarded(c.getCaretPosition()) || selectionSpansGuardedSection;
                }
                return inGuardedBlock;
            }

            public void run() {
                BaseKit kit;
                JTextComponent c = EditorUI.this.component;
                if (c != null && (kit = Utilities.getKit(c)) != null) {
                    boolean isEditable = c.isEditable();
                    boolean selectionVisible = c.getCaret().isSelectionVisible();
                    boolean caretGuarded = this.isCaretGuarded();
                    Action a = kit.getActionByName("copy-to-clipboard");
                    if (a != null) {
                        a.setEnabled(selectionVisible);
                    }
                    if ((a = kit.getActionByName("cut-to-clipboard")) != null) {
                        a.setEnabled(selectionVisible && !caretGuarded && isEditable);
                    }
                    if ((a = kit.getActionByName("remove-selection")) != null) {
                        a.setEnabled(selectionVisible && !caretGuarded && isEditable);
                    }
                    if ((a = kit.getActionByName("paste-from-clipboard")) != null) {
                        a.setEnabled(!caretGuarded && isEditable);
                    }
                }
            }
        });
    }

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        if (oldDoc != null) {
            this.drawLayerList.remove(oldDoc.getDrawLayerList());
        }
        if (newDoc != null) {
            this.settingsChange(null);
            this.drawLayerList.add(newDoc.getDrawLayerList());
        }
        if (oldDoc != null) {
            oldDoc.getBookmarks().removeAll();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument oldDoc = evt.getOldValue() instanceof BaseDocument ? (BaseDocument)evt.getOldValue() : null;
            BaseDocument newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            this.modelChanged(oldDoc, newDoc);
        } else if ("margin".equals(propName)) {
            this.updateTextMargin();
        } else if ("caret".equals(propName)) {
            if (evt.getOldValue() instanceof Caret) {
                ((Caret)evt.getOldValue()).removeChangeListener(this);
            }
            if (evt.getNewValue() instanceof Caret) {
                ((Caret)evt.getNewValue()).addChangeListener(this);
            }
        } else if ("enabled".equals(propName) && !this.component.isEnabled()) {
            this.component.getCaret().setVisible(false);
        }
    }

    protected Map createColoringMap() {
        Map cm;
        if (this.component != null) {
            cm = EditorUI.getSharedColoringMap(this.getKitClass());
        } else {
            cm = SettingsUtil.getColoringMap(this.getKitClass(), this.component == null, true);
            if (cm.get("default") == null) {
                cm.put("default", SettingsDefaults.defaultColoring);
            }
        }
        return cm;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public int getLineAscent() {
        return this.lineAscent;
    }

    public Map getColoringMap() {
        if (this.coloringMap == null) {
            this.coloringMap = this.createColoringMap();
        }
        return this.coloringMap;
    }

    public Coloring getDefaultColoring() {
        return (Coloring)this.getColoringMap().get("default");
    }

    public Coloring getColoring(String coloringName) {
        return (Coloring)this.getColoringMap().get(coloringName);
    }

    private void updateLineHeight(Graphics g) {
        if (debugUpdateLineHeight) {
            System.err.println("EditorUI.updateLineHeight(): Computing lineHeight ...");
        }
        Map cm = this.getColoringMap();
        Iterator i = cm.entrySet().iterator();
        int maxHeight = 1;
        int maxAscent = 0;
        while (i.hasNext()) {
            FontMetrics fm;
            Font font;
            Map.Entry me = i.next();
            String coloringName = (String)me.getKey();
            Coloring c = (Coloring)me.getValue();
            if (c == null || (font = c.getFont()) == null || (c.getFontMode() & 4) == 0 || (fm = g.getFontMetrics(font)) == null) continue;
            if (debugUpdateLineHeight) {
                if (maxHeight < fm.getHeight()) {
                    System.err.println("Updating maxHeight from " + maxHeight + " to " + fm.getHeight() + ", coloringName=" + coloringName + ", font=" + font);
                }
                if (maxHeight < fm.getHeight()) {
                    System.err.println("Updating maxAscent from " + maxAscent + " to " + fm.getAscent() + ", coloringName=" + coloringName + ", font=" + font);
                }
            }
            maxHeight = Math.max(maxHeight, fm.getHeight());
            maxAscent = Math.max(maxAscent, fm.getAscent());
        }
        this.lineHeight = (int)((float)maxHeight * this.lineHeightCorrection);
        this.lineAscent = (int)((float)maxAscent * this.lineHeightCorrection);
    }

    boolean isFontsInited() {
        return this.fontsInited;
    }

    protected void update(Graphics g) {
        Class kitClass = Utilities.getKitClass(this.component);
        if (kitClass != null) {
            Object value = Settings.getValue(kitClass, "margin");
            Insets margin = value instanceof Insets ? (Insets)value : null;
            this.component.setMargin(margin);
        }
        this.getDefaultColoring().apply(this.component);
        if (this.renderingHints != null) {
            ((Graphics2D)g).setRenderingHints(this.renderingHints);
        }
        Coloring dc = this.getDefaultColoring();
        Coloring lnc = (Coloring)this.getColoringMap().get("line-number");
        if (lnc != null) {
            Font lnFont = lnc.getFont();
            if (lnFont == null) {
                lnFont = dc.getFont();
            }
            FontMetrics lnFM = g.getFontMetrics(lnFont);
            int maxWidth = 1;
            char[] digit = new char[1];
            int i = 0;
            while (i <= 9) {
                digit[0] = (char)(48 + i);
                maxWidth = Math.max(maxWidth, lnFM.charsWidth(digit, 0, 1));
                ++i;
            }
            this.lineNumberDigitWidth = maxWidth;
        }
        this.updateLineHeight(g);
        FontMetricsCache.Info fmcInfo = FontMetricsCache.getInfo(this.getDefaultColoring().getFont());
        this.defaultSpaceWidth = fmcInfo.getSpaceWidth(g);
        if (this.component != null) {
            ((BaseTextUI)this.component.getUI()).updateHeight();
            this.updateLineNumberWidth(0);
            this.checkLineLimit();
        }
        try {
            JViewport vp = this.getParentViewport();
            if (vp != null) {
                Method setScrollModeMethod = (class$javax$swing$JViewport == null ? (class$javax$swing$JViewport = EditorUI.class$("javax.swing.JViewport")) : class$javax$swing$JViewport).getDeclaredMethod("setScrollMode", Integer.TYPE);
                setScrollModeMethod.invoke((Object)vp, new Integer(0));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.isGlyphGutterVisible()) {
            this.glyphGutter.update();
            this.updateScrollPaneCornerColor();
        }
        this.updateVirtualHeight(0);
        this.fontsInitedPreferenceChanged = true;
        if (this.component != null) {
            ((BaseTextUI)this.component.getUI()).preferenceChanged(true, true);
        }
    }

    public final JTextComponent getComponent() {
        return this.component;
    }

    public final BaseDocument getDocument() {
        return this.component != null ? Utilities.getDocument(this.component) : this.printDoc;
    }

    private Class getKitClass() {
        return this.component != null ? Utilities.getKitClass(this.component) : (this.printDoc != null ? this.printDoc.getKitClass() : null);
    }

    public Object getProperty(Object key) {
        return this.props.get(key);
    }

    public void putProperty(Object key, Object value) {
        Object oldValue = value != null ? this.props.put(key, value) : this.props.remove(key);
        this.firePropertyChange(key.toString(), oldValue, value);
    }

    public JComponent getExtComponent() {
        if (this.extComponent == null && this.component != null) {
            this.extComponent = this.createExtComponent();
        }
        return this.extComponent;
    }

    protected JComponent createExtComponent() {
        this.setLineNumberEnabled(true);
        JPanel ec = new JPanel(new BorderLayout());
        ec.putClientProperty(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = EditorUI.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent, this.component);
        JScrollPane scroller = new JScrollPane(this.component);
        scroller.getViewport().setMinimumSize(new Dimension(4, 4));
        this.glyphGutter = new GlyphGutter(this);
        scroller.setRowHeaderView(this.glyphGutter);
        this.glyphCorner = new JPanel();
        this.updateScrollPaneCornerColor();
        scroller.setCorner("LOWER_LEFT_CORNER", this.glyphCorner);
        ec.add(scroller);
        ec.add((Component)this.getStatusBar().getPanel(), "South");
        return ec;
    }

    public boolean hasExtComponent() {
        return this.extComponent != null;
    }

    public Abbrev getAbbrev() {
        if (this.abbrev == null) {
            this.abbrev = new Abbrev(this, true, true);
        }
        return this.abbrev;
    }

    public WordMatch getWordMatch() {
        if (this.wordMatch == null) {
            this.wordMatch = new WordMatch(this);
        }
        return this.wordMatch;
    }

    public StatusBar getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new StatusBar(this);
        }
        return this.statusBar;
    }

    final DrawLayerList getDrawLayerList() {
        return this.drawLayerList;
    }

    public DrawLayer findLayer(String layerName) {
        return this.drawLayerList.findLayer(layerName);
    }

    public boolean addLayer(DrawLayer layer, int visibility) {
        return this.drawLayerList.add(layer, visibility);
    }

    public DrawLayer removeLayer(String layerName) {
        return this.drawLayerList.remove(layerName);
    }

    public void repaint(int startY) {
        this.repaint(startY, this.component.getHeight());
    }

    public void repaint(int startY, int height) {
        if (height <= 0) {
            return;
        }
        int width = Math.max(this.component.getWidth(), 0);
        startY = Math.max(startY, 0);
        this.component.repaint(0, startY, width, height);
    }

    public void repaintOffset(int pos) throws BadLocationException {
        this.repaintBlock(pos, pos);
    }

    public void repaintBlock(int startPos, int endPos) throws BadLocationException {
        block3: {
            BaseTextUI ui = (BaseTextUI)this.component.getUI();
            if (startPos > endPos) {
                int tmpPos = startPos;
                startPos = endPos;
                endPos = tmpPos;
            }
            try {
                int yFrom = ui.getYFromPos(startPos);
                int yTo = ui.getYFromPos(endPos);
                this.repaint(yFrom, yTo - yFrom + this.lineHeight);
            }
            catch (BadLocationException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                e.printStackTrace();
            }
        }
    }

    private JViewport getParentViewport() {
        Container pc = this.component.getParent();
        return pc instanceof JViewport ? (JViewport)pc : null;
    }

    public static Frame getParentFrame(Component c) {
        do {
            if (!((c = c.getParent()) instanceof Frame)) continue;
            return (Frame)c;
        } while (c != null);
        return null;
    }

    public boolean updateVirtualWidth(int width) {
        boolean updated = false;
        if (width > this.virtualSize.width) {
            int widthInc = this.componentSizeIncrement.width;
            widthInc = widthInc < 0 ? this.lastExtentBounds.width * -widthInc / 100 : widthInc * this.defaultSpaceWidth;
            this.virtualSize.width = width + widthInc;
            this.virtualSizeUpdated = true;
            updated = true;
        }
        return updated;
    }

    public boolean updateVirtualHeight(int height) {
        boolean updated = false;
        this.updateLineNumberWidth(0);
        if (height <= 0) {
            height = (int)this.component.getUI().getRootView(this.component).getPreferredSpan(1);
        }
        if (height != this.virtualSize.height) {
            this.virtualSize.height = height;
            this.virtualSizeUpdated = true;
            updated = true;
        }
        return updated;
    }

    public boolean isLineNumberEnabled() {
        return this.lineNumberEnabled;
    }

    public void setLineNumberEnabled(boolean lineNumberEnabled) {
        this.lineNumberEnabled = lineNumberEnabled;
        boolean bl = this.lineNumberVisible = lineNumberEnabled && this.lineNumberVisibleSetting;
        if (this.disableLineNumbers) {
            this.lineNumberVisible = false;
        }
    }

    public void updateLineNumberWidth(int maxDigitCount) {
        int oldWidth = this.lineNumberWidth;
        if (this.lineNumberVisible) {
            try {
                if (maxDigitCount <= 0) {
                    BaseDocument doc = this.getDocument();
                    int lineCnt = Utilities.getLineOffset(doc, doc.getLength()) + 1;
                    maxDigitCount = Integer.toString(lineCnt).length();
                }
                if (maxDigitCount > this.lineNumberMaxDigitCount) {
                    this.lineNumberMaxDigitCount = maxDigitCount;
                }
            }
            catch (BadLocationException e) {
                this.lineNumberMaxDigitCount = 1;
            }
            this.lineNumberWidth = this.lineNumberMaxDigitCount * this.lineNumberDigitWidth;
            if (this.lineNumberMargin != null) {
                this.lineNumberWidth += this.lineNumberMargin.left + this.lineNumberMargin.right;
            }
        } else {
            this.lineNumberWidth = 0;
        }
        this.updateTextMargin();
        if (oldWidth != this.lineNumberWidth && this.component != null) {
            this.component.repaint();
        }
    }

    void checkLineLimit() {
        FontMetrics fm;
        Integer lineLimit;
        BaseDocument doc = this.getDocument();
        if (doc != null && (lineLimit = (Integer)doc.getProperty("line-limit")) != null && this.component != null && (fm = ((Component)this.component).getFontMetrics(this.getDefaultColoring().getFont())) != null) {
            int charWidth = fm.stringWidth("A");
            this.updateVirtualWidth(charWidth * lineLimit + this.lineNumberWidth);
        }
    }

    public void updateTextMargin() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorUI.this.updateTextMargin();
                }
            });
        }
        Insets orig = this.textMargin;
        Insets cm = this.component != null ? this.component.getMargin() : null;
        int leftWidth = this.lineNumberWidth + this.textLeftMarginWidth;
        this.textMargin = cm != null ? new Insets(cm.top, cm.left + leftWidth, cm.bottom, cm.right) : new Insets(0, leftWidth, 0, 0);
        if (orig.top != this.textMargin.top || orig.bottom != this.textMargin.bottom) {
            ((BaseTextUI)this.component.getUI()).invalidateStartY();
        }
    }

    public Rectangle getExtentBounds() {
        return this.getExtentBounds(null);
    }

    public Rectangle getExtentBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        if (this.component != null) {
            JViewport port = this.getParentViewport();
            if (port != null) {
                Point p = port.getViewPosition();
                r.width = port.getWidth();
                r.height = port.getHeight();
                r.x = p.x;
                r.y = p.y;
            } else {
                r.setBounds(this.component.getVisibleRect());
            }
        }
        return r;
    }

    public Insets getTextMargin() {
        return this.textMargin;
    }

    public void scrollRectToVisible(final Rectangle r, final int scrollPolicy) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                EditorUI.this.scrollRectToVisibleFragile(r, scrollPolicy);
            }
        });
    }

    boolean scrollRectToVisibleFragile(Rectangle r, int scrollPolicy) {
        Insets margin = this.getTextMargin();
        Rectangle bounds = this.getExtentBounds();
        r = new Rectangle(r);
        r.x -= margin.left;
        r.y -= margin.top;
        bounds.width -= margin.left + margin.right;
        bounds.height -= margin.top + margin.bottom;
        return this.scrollRectToVisibleImpl(r, scrollPolicy, bounds);
    }

    private boolean scrollRectToVisibleImpl(Rectangle r, int scrollPolicy, Rectangle bounds) {
        if (bounds.width <= 0 || bounds.height <= 0) {
            return false;
        }
        if (scrollPolicy == 3) {
            int cnvFI = this.scrollFindInsets.left < 0 ? -bounds.width * this.scrollFindInsets.left / 100 : this.scrollFindInsets.left * this.defaultSpaceWidth;
            int nx = Math.max(r.x - cnvFI, 0);
            cnvFI = this.scrollFindInsets.right < 0 ? -bounds.width * this.scrollFindInsets.right / 100 : this.scrollFindInsets.right * this.defaultSpaceWidth;
            r.width += r.x - nx + cnvFI;
            r.x = nx;
            cnvFI = this.scrollFindInsets.top < 0 ? -bounds.height * this.scrollFindInsets.top / 100 : this.scrollFindInsets.top * this.lineHeight;
            int ny = Math.max(r.y - cnvFI, 0);
            cnvFI = this.scrollFindInsets.bottom < 0 ? -bounds.height * this.scrollFindInsets.bottom / 100 : this.scrollFindInsets.bottom * this.lineHeight;
            r.height += r.y - ny + cnvFI;
            r.y = ny;
            return this.scrollRectToVisibleImpl(r, 2, bounds);
        }
        if (r.x + r.width > this.virtualSize.width) {
            r.x = this.virtualSize.width - r.width;
            if (r.x < 0) {
                r.x = 0;
                r.width = this.virtualSize.width;
            }
            return this.scrollRectToVisibleImpl(r, scrollPolicy, bounds);
        }
        if (r.y + r.height > this.virtualSize.height) {
            r.y = this.virtualSize.height - r.height;
            if (r.y < 0) {
                r.y = 0;
                r.height = this.virtualSize.height;
            }
            return this.scrollRectToVisibleImpl(r, scrollPolicy, bounds);
        }
        if (r.width > bounds.width || r.height > bounds.height) {
            Rectangle caretRect = new Rectangle((Rectangle)((Object)this.component.getCaret()));
            if (caretRect.x >= r.x && caretRect.x + caretRect.width <= r.x + r.width && caretRect.y >= r.y && caretRect.y + caretRect.height <= r.y + r.height) {
                int overX = r.width - bounds.width;
                int overY = r.height - bounds.height;
                if (overX > 0) {
                    r.x -= overX * (caretRect.x - r.x) / r.width;
                }
                if (overY > 0) {
                    r.y -= overY * (caretRect.y - r.y) / r.height;
                }
            }
            r.height = bounds.height;
            r.width = bounds.width;
            return this.scrollRectToVisibleImpl(r, scrollPolicy, bounds);
        }
        int newX = bounds.x;
        int newY = bounds.y;
        boolean move = false;
        if (r.x < bounds.x) {
            move = true;
            switch (scrollPolicy) {
                case 1: {
                    newX = this.scrollJumpInsets.left < 0 ? bounds.width * -this.scrollJumpInsets.left / 100 : this.scrollJumpInsets.left * this.defaultSpaceWidth;
                    newX = Math.min(newX, bounds.x + bounds.width - (r.x + r.width));
                    newX = Math.max(r.x - newX, 0);
                    break;
                }
                default: {
                    newX = r.x;
                }
            }
            this.updateVirtualWidth(newX + bounds.width);
        } else if (r.x + r.width > bounds.x + bounds.width) {
            move = true;
            switch (scrollPolicy) {
                case 2: {
                    newX = r.x + r.width - bounds.width;
                    break;
                }
                default: {
                    newX = this.scrollJumpInsets.right < 0 ? bounds.width * -this.scrollJumpInsets.right / 100 : this.scrollJumpInsets.right * this.defaultSpaceWidth;
                    newX = Math.min(newX, bounds.width - r.width);
                    newX = r.x + r.width + newX - bounds.width;
                }
            }
            this.updateVirtualWidth(newX + bounds.width);
        }
        if (r.y < bounds.y) {
            move = true;
            switch (scrollPolicy) {
                case 1: {
                    newY = r.y;
                    newY -= this.scrollJumpInsets.top < 0 ? bounds.height * -this.scrollJumpInsets.top / 100 : this.scrollJumpInsets.top * this.lineHeight;
                    break;
                }
                case 2: {
                    newY = r.y;
                    break;
                }
                default: {
                    newY = r.y - (bounds.height - r.height) / 2;
                }
            }
            newY = Math.max(newY, 0);
        } else if (r.y + r.height > bounds.y + bounds.height) {
            move = true;
            switch (scrollPolicy) {
                case 1: {
                    newY = r.y + r.height - bounds.height;
                    newY += this.scrollJumpInsets.bottom < 0 ? bounds.height * -this.scrollJumpInsets.bottom / 100 : this.scrollJumpInsets.bottom * this.lineHeight;
                    break;
                }
                case 2: {
                    newY = r.y + r.height - bounds.height;
                    break;
                }
                default: {
                    newY = r.y - (bounds.height - r.height) / 2;
                }
            }
            newY = Math.max(newY, 0);
        }
        if (move) {
            this.setExtentPosition(newX, newY);
        }
        return move;
    }

    void setExtentPosition(int x, int y) {
        JViewport port = this.getParentViewport();
        if (port != null) {
            Point p = new Point(Math.max(x, 0), Math.max(y, 0));
            port.setViewPosition(p);
        }
    }

    public void adjustWindow(int caretPercentFromWindowTop) {
        final Rectangle bounds = this.getExtentBounds();
        if (this.component != null && this.component.getCaret() instanceof Rectangle) {
            Rectangle caretRect = (Rectangle)((Object)this.component.getCaret());
            bounds.y = caretRect.y - caretPercentFromWindowTop * bounds.height / 100 + caretPercentFromWindowTop * this.lineHeight / 100;
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    EditorUI.this.scrollRectToVisible(bounds, 2);
                }
            });
        }
    }

    public void adjustCaret(int percentFromWindowTop) {
        JTextComponent c = this.component;
        if (c != null) {
            Rectangle bounds = this.getExtentBounds();
            bounds.y += percentFromWindowTop * bounds.height / 100 - percentFromWindowTop * this.lineHeight / 100;
            try {
                int offset = ((BaseTextUI)c.getUI()).getPosFromY(bounds.y);
                if (offset >= 0) {
                    this.caretSetDot(offset, null, 2);
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
    }

    public void caretSetDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        if (this.component != null) {
            Caret caret = this.component.getCaret();
            if (caret instanceof BaseCaret) {
                ((BaseCaret)caret).setDot(offset, scrollRect, scrollPolicy);
            } else {
                caret.setDot(offset);
            }
        }
    }

    public void caretMoveDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        if (this.component != null) {
            Caret caret = this.component.getCaret();
            if (caret instanceof BaseCaret) {
                ((BaseCaret)caret).moveDot(offset, scrollRect, scrollPolicy);
            } else {
                caret.moveDot(offset);
            }
        }
    }

    protected void paint(Graphics g) {
        if (this.component != null) {
            if (this.fontsInitedPreferenceChanged) {
                this.fontsInitedPreferenceChanged = false;
                this.fontsInited = true;
                this.getExtentBounds(this.lastExtentBounds);
            }
            if (!this.fontsInited && g != null) {
                this.update(g);
            }
            ((BaseTextUI)this.component.getUI()).paintRegion(g);
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public boolean isGlyphGutterVisible() {
        return this.glyphGutter != null;
    }

    public GlyphGutter getGlyphGutter() {
        return this.glyphGutter;
    }

    protected void updateScrollPaneCornerColor() {
        Coloring lineColoring = (Coloring)this.getColoringMap().get("line-number");
        Coloring defaultColoring = this.getDefaultColoring();
        Color backgroundColor = lineColoring.getBackColor() != null ? lineColoring.getBackColor() : defaultColoring.getBackColor();
        this.glyphCorner.setBackground(backgroundColor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Settings.addSettingsChangeListener(clearingListener);
    }

    static class ComponentLock {
        ComponentLock() {
        }
    }
}

