/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.editor.GapObjectArray;
import org.netbeans.editor.ObjectArrayUtilities;

public abstract class GapBranchElement
implements Element {
    protected static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    private GapObjectArray children = new GapObjectArray();

    public int getElementCount() {
        return this.children.getItemCount();
    }

    public Element getElement(int index) {
        return (Element)this.children.getItem(index);
    }

    public void copyElements(int srcBegin, int srcEnd, Element[] dst, int dstBegin) {
        ObjectArrayUtilities.copyItems(this.children, srcBegin, srcEnd, dst, dstBegin);
    }

    public int getElementIndex(int offset) {
        int low = 0;
        int high = this.getElementCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int elemStartOffset = ((Element)this.children.getItem(mid)).getStartOffset();
            if (elemStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (elemStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(0, high);
    }

    public boolean isLeaf() {
        return false;
    }

    protected void replace(int index, int removeCount, Element[] addedElems) {
        this.children.replace(index, removeCount, addedElems);
    }

    public String toString() {
        return this.children.toString();
    }

    public abstract int getEndOffset();

    public abstract int getStartOffset();

    public abstract AttributeSet getAttributes();

    public abstract String getName();

    public abstract Element getParentElement();

    public abstract Document getDocument();

    protected class Undo
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private int index;
        private Element[] childrenAdded;
        private Element[] childrenRemoved;

        public Undo(int index, Element[] childrenRemoved, Element[] childrenAdded) {
            this.index = index;
            this.childrenRemoved = childrenRemoved;
            this.childrenAdded = childrenAdded;
        }

        public Element getElement() {
            return GapBranchElement.this;
        }

        public int getIndex() {
            return this.index;
        }

        public Element[] getChildrenRemoved() {
            return this.childrenRemoved;
        }

        public Element[] getChildrenAdded() {
            return this.childrenAdded;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            GapBranchElement.this.replace(this.index, this.childrenAdded.length, this.childrenRemoved);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            GapBranchElement.this.replace(this.index, this.childrenRemoved.length, this.childrenAdded);
        }
    }
}

