/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.AnnotationTypes;
import org.netbeans.editor.Annotations;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;

public class GlyphGutter
extends JComponent
implements Annotations.AnnotationsListener,
Accessible {
    private EditorUI editorUI;
    private BaseDocument doc;
    private Annotations annos;
    private Image gutterButton;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private int lineHeight;
    private boolean init;
    private int numberWidth;
    private static final int glyphWidth = 16;
    private static final int glyphButtonWidth = 9;
    private boolean showLineNumbers = true;
    private ImageObserver imgObserver = null;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private boolean drawOverLineNumbers = false;
    private int cachedCountOfAnnos = -1;
    private int cachedCountOfAnnosForLine = -1;
    private PropertyChangeListener annoTypesListener;

    public GlyphGutter(EditorUI editorUI) {
        this.editorUI = editorUI;
        this.init = false;
        this.doc = editorUI.getDocument();
        this.annos = this.doc.getAnnotations();
        this.annos.addAnnotationsListener(this);
        this.init();
        this.update();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        URL imageURL = null;
        try {
            imageURL = new URL("nbresloc:/org/netbeans/editor/resources/glyphbutton.gif");
        }
        catch (MalformedURLException ex) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                ex.printStackTrace();
            }
            return;
        }
        if (imageURL != null) {
            this.gutterButton = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        this.setToolTipText("");
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("ACSN_Glyph_Gutter"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_Glyph_Gutter"));
        GutterMouseListener gutterMouseListener = new GutterMouseListener();
        this.addMouseListener(gutterMouseListener);
        this.addMouseMotionListener(gutterMouseListener);
        this.imgObserver = new ImageObserver(){

            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                if ((infoflags & 0x20) == 32) {
                    GlyphGutter.this.repaint();
                    return true;
                }
                return true;
            }
        };
        this.annoTypesListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "glyphsOverLineNumbers" || evt.getPropertyName() == "showGlyphGutter") {
                    GlyphGutter.this.update();
                }
            }
        };
        AnnotationTypes.getTypes().addPropertyChangeListener(this.annoTypesListener);
    }

    public void update() {
        Coloring lineColoring = (Coloring)this.editorUI.getColoringMap().get("line-number");
        Coloring defaultColoring = this.editorUI.getDefaultColoring();
        if (lineColoring == null) {
            return;
        }
        this.backgroundColor = lineColoring.getBackColor() != null ? lineColoring.getBackColor() : defaultColoring.getBackColor();
        this.foreColor = lineColoring.getForeColor() != null ? lineColoring.getForeColor() : defaultColoring.getForeColor();
        this.font = lineColoring.getFont() != null ? lineColoring.getFont() : defaultColoring.getFont();
        this.lineHeight = this.editorUI.getLineHeight();
        this.showLineNumbers = this.editorUI.lineNumberVisibleSetting;
        this.drawOverLineNumbers = AnnotationTypes.getTypes().isGlyphsOverLineNumbers();
        this.init = true;
        this.highestLineNumber = this.getLineCount();
        this.repaint();
        this.resize();
    }

    protected void resize() {
        Dimension dim = new Dimension();
        dim.width = this.getWidthDimension();
        dim.height = this.getHeightDimension();
        dim.height += 300 * this.lineHeight;
        this.numberWidth = this.getLineNumberWidth();
        if (!this.showLineNumbers) {
            this.numberWidth = 0;
        }
        this.setPreferredSize(dim);
        this.revalidate();
    }

    protected int getLineCount() {
        int lineCnt;
        try {
            lineCnt = Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1;
        }
        catch (BadLocationException e) {
            lineCnt = 1;
        }
        return lineCnt;
    }

    protected int getDigitCount(int number) {
        return Integer.toString(number).length();
    }

    protected int getLineNumberWidth() {
        int newWidth = 0;
        Insets insets = this.editorUI.getLineNumberMargin();
        if (insets != null) {
            newWidth += insets.left + insets.right;
        }
        return newWidth += this.getDigitCount(this.highestLineNumber) * this.editorUI.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int newWidth = 0;
        if (this.annos.isGlyphColumn() || AnnotationTypes.getTypes().isShowGlyphGutter().booleanValue()) {
            newWidth += 16;
        }
        if (this.annos.isGlyphButtonColumn()) {
            newWidth += 9;
        }
        if (this.showLineNumbers) {
            int lineNumberWidth = this.getLineNumberWidth();
            if (this.drawOverLineNumbers) {
                if (lineNumberWidth > newWidth) {
                    newWidth = lineNumberWidth;
                }
            } else {
                newWidth += lineNumberWidth;
            }
        }
        return newWidth;
    }

    protected int getHeightDimension() {
        JTextComponent comp = this.editorUI.getComponent();
        if (comp == null) {
            return 0;
        }
        return this.highestLineNumber * this.lineHeight + (int)comp.getSize().getHeight();
    }

    public void paintComponent(Graphics g) {
        int line;
        super.paintComponent(g);
        if (!this.init) {
            return;
        }
        Rectangle drawHere = g.getClipBounds();
        g.setColor(this.backgroundColor);
        g.fillRect(drawHere.x, drawHere.y, drawHere.width, drawHere.height);
        g.setFont(this.font);
        g.setColor(this.foreColor);
        FontMetrics fm = FontMetricsCache.getFontMetrics(this.font, this);
        int rightMargin = 0;
        Insets margin = this.editorUI.getLineNumberMargin();
        if (margin != null) {
            rightMargin = margin.right;
        }
        if ((line = (int)((float)drawHere.y / (float)this.lineHeight)) > 0) {
            --line;
        }
        int y = line * this.lineHeight;
        int lineCount = Integer.MAX_VALUE;
        if (this.showLineNumbers) {
            lineCount = this.getLineCount();
            int lastLine = (int)((float)(drawHere.y + drawHere.height) / (float)this.lineHeight) + 1;
            if (lastLine > this.highestLineNumber) {
                int prevHighest = this.highestLineNumber;
                this.highestLineNumber = lastLine;
                if (this.getDigitCount(this.highestLineNumber) > this.getDigitCount(prevHighest)) {
                    this.resize();
                    return;
                }
            }
        }
        int lineWithAnno = this.annos.getNextLineWithAnnotation(line);
        while (y + this.lineHeight / 2 <= drawHere.y + drawHere.height) {
            if (this.showLineNumbers && (!this.drawOverLineNumbers || this.drawOverLineNumbers && line != lineWithAnno) && line < lineCount) {
                int lineNumberWidth = fm.stringWidth("" + (line + 1));
                g.drawString("" + (line + 1), this.numberWidth - lineNumberWidth - rightMargin, y + this.editorUI.getLineAscent());
            }
            if (line == lineWithAnno) {
                int count = this.annos.getNumberOfAnnotations(line);
                AnnotationDesc anno = this.annos.getActiveAnnotation(line);
                int xPos = this.numberWidth;
                if (this.drawOverLineNumbers) {
                    xPos = this.getWidth() - 16;
                    if (count > 1) {
                        xPos -= 9;
                    }
                }
                if (anno != null && (count != 1 || !anno.isDefaultGlyph()) && anno.getGlyph() != null && this.prepareImage(anno.getGlyph(), this.imgObserver)) {
                    g.drawImage(anno.getGlyph(), xPos, y + (this.lineHeight - anno.getGlyph().getHeight(null)) / 2 + 1, null);
                }
                if (count > 1 && anno.getGlyph() != null && this.prepareImage(this.gutterButton, this.imgObserver) && this.prepareImage(anno.getGlyph(), this.imgObserver)) {
                    g.drawImage(this.gutterButton, xPos + 16, y + (this.lineHeight - anno.getGlyph().getHeight(null)) / 2, null);
                }
                lineWithAnno = this.annos.getNextLineWithAnnotation(line + 1);
            }
            y += this.lineHeight;
            ++line;
        }
    }

    public void changedLine(int line) {
        if (!this.init) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        if (line > 0) {
            --line;
        }
        int y = line * this.lineHeight;
        this.repaint(0, y, (int)this.getSize().getWidth(), 3 * this.lineHeight);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.cachedCountOfAnnos = -1;
        try {
            int lineCnt = Utilities.getLineOffset(this.doc, this.doc.getLength()) + 1;
        }
        catch (BadLocationException e) {
            boolean lineCnt = true;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int count = this.getLineCount();
        if (count > this.highestLineNumber) {
            this.highestLineNumber = count;
        }
        Dimension dim = this.getPreferredSize();
        if (this.getWidthDimension() > dim.width || this.getHeightDimension() > dim.height) {
            this.resize();
        }
    }

    public String getToolTipText(MouseEvent e) {
        int line = (int)((float)e.getY() / (float)this.lineHeight);
        if (this.annos.getNumberOfAnnotations(line) == 0) {
            return null;
        }
        if (this.isMouseOverCycleButton(e) && this.annos.getNumberOfAnnotations(line) > 1) {
            return MessageFormat.format(LocaleSupport.getString("cycling-glyph_tooltip"), new Integer(this.annos.getNumberOfAnnotations(line)));
        }
        if (this.isMouseOverGlyph(e)) {
            return this.annos.getActiveAnnotation(line).getShortDescription();
        }
        return null;
    }

    private int getXPosOfGlyph(int line) {
        int xPos = this.numberWidth;
        if (this.drawOverLineNumbers) {
            xPos = this.getWidth() - 16;
            if (this.cachedCountOfAnnos == -1 || this.cachedCountOfAnnosForLine != line) {
                this.cachedCountOfAnnos = this.annos.getNumberOfAnnotations(line);
                this.cachedCountOfAnnosForLine = line;
            }
            if (this.cachedCountOfAnnos > 1) {
                xPos -= 9;
            }
        }
        return xPos;
    }

    private boolean isMouseOverGlyph(MouseEvent e) {
        int line = (int)((float)e.getY() / (float)this.lineHeight);
        return e.getX() >= this.getXPosOfGlyph(line) && e.getX() <= this.getXPosOfGlyph(line) + 16;
    }

    private boolean isMouseOverCycleButton(MouseEvent e) {
        int line = (int)((float)e.getY() / (float)this.lineHeight);
        return e.getX() >= this.getXPosOfGlyph(line) + 16 && e.getX() <= this.getXPosOfGlyph(line) + 16 + 9;
    }

    class GutterMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private int dragStartLine;
        private int dragEndLine;
        private int currentEndLine;
        private boolean selectForward;

        GutterMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 0x10) == 16) {
                if (GlyphGutter.this.isMouseOverCycleButton(e)) {
                    int line = (int)((float)e.getY() / (float)GlyphGutter.this.lineHeight);
                    GlyphGutter.this.annos.activateNextAnnotation(line);
                } else {
                    Action a = ImplementationProvider.getDefault().getToggleBreakpointAction();
                    if (a != null && a.isEnabled()) {
                        int line = (int)((float)e.getY() / (float)GlyphGutter.this.lineHeight);
                        int currentLine = -1;
                        try {
                            currentLine = Utilities.getLineOffset(GlyphGutter.this.doc, GlyphGutter.this.editorUI.getComponent().getCaret().getDot());
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                        if (line != currentLine) {
                            int offset = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, line);
                            JumpList.checkAddEntry();
                            GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                        }
                        a.actionPerformed(new ActionEvent(GlyphGutter.this.editorUI.getComponent(), 0, ""));
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int line = (int)((float)e.getY() / (float)GlyphGutter.this.lineHeight);
                int offset = GlyphGutter.this.annos.getActiveAnnotation(line) != null ? GlyphGutter.this.annos.getActiveAnnotation(line).getOffset() : Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, line);
                if (GlyphGutter.this.editorUI.getComponent().getCaret().getDot() != offset) {
                    JumpList.checkAddEntry();
                }
                GlyphGutter.this.editorUI.getComponent().getCaret().setDot(offset);
                JPopupMenu pm = GlyphGutter.this.annos.createPopupMenu(Utilities.getKit(GlyphGutter.this.editorUI.getComponent()), line);
                if (pm != null) {
                    pm.show(GlyphGutter.this, e.getX(), e.getY());
                }
                pm.addPopupMenuListener(new PopupMenuListener(this){
                    private final /* synthetic */ GutterMouseListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void popupMenuCanceled(PopupMenuEvent e2) {
                        GlyphGutter.access$400(GutterMouseListener.access$500(this.this$1)).getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                        GlyphGutter.access$400(GutterMouseListener.access$500(this.this$1)).getComponent().requestFocus();
                    }

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                    }
                });
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void updateSelection(boolean newSelection) {
            JTextComponent comp = Utilities.getLastActiveComponent();
            try {
                if (newSelection) {
                    this.selectForward = true;
                    int rowStart = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine);
                    if (rowStart < 0) {
                        rowStart = Utilities.getRowStart(GlyphGutter.this.doc, GlyphGutter.this.doc.getLength());
                        this.dragStartLine = Utilities.getLineOffset(GlyphGutter.this.doc, rowStart);
                    }
                    comp.setCaretPosition(rowStart);
                    int offSet = Utilities.getRowEnd(GlyphGutter.this.doc, rowStart);
                    if (offSet < GlyphGutter.this.doc.getLength()) {
                        ++offSet;
                    }
                    comp.moveCaretPosition(offSet);
                    this.currentEndLine = this.dragEndLine = this.dragStartLine;
                } else {
                    if (this.currentEndLine == this.dragEndLine) {
                        return;
                    }
                    if (this.dragEndLine < this.dragStartLine) {
                        int rowStart;
                        if (this.selectForward) {
                            int offSet = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine + 1);
                            if (offSet < 0) {
                                offSet = Utilities.getRowEnd(GlyphGutter.this.doc, Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            }
                            comp.setCaretPosition(offSet);
                            this.selectForward = false;
                        }
                        if ((rowStart = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine)) < 0) {
                            rowStart = 0;
                        }
                        comp.moveCaretPosition(rowStart);
                    } else {
                        int offSet;
                        if (!this.selectForward) {
                            comp.setCaretPosition(Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragStartLine));
                            this.selectForward = true;
                        }
                        if ((offSet = Utilities.getRowStartFromLineOffset(GlyphGutter.this.doc, this.dragEndLine + 1)) < 0) {
                            offSet = GlyphGutter.this.doc.getLength();
                        }
                        comp.moveCaretPosition(offSet);
                    }
                }
                this.currentEndLine = this.dragEndLine;
            }
            catch (BadLocationException ble) {
                System.err.println(ble);
            }
        }

        static /* synthetic */ GlyphGutter access$500(GutterMouseListener x0) {
            return x0.GlyphGutter.this;
        }
    }
}

