/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.GuardedDocumentEvent;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.editor.Utilities;

public class GuardedDocument
extends BaseDocument
implements StyledDocument {
    public static final String GUARDED_ATTRIBUTE = "guarded";
    public static final SimpleAttributeSet guardedSet = new SimpleAttributeSet();
    public static final SimpleAttributeSet unguardedSet = new SimpleAttributeSet();
    private static final boolean debugAtomic = Boolean.getBoolean("netbeans.debug.editor.atomic");
    private static final boolean debugAtomicStack = Boolean.getBoolean("netbeans.debug.editor.atomic.stack");
    public static final String FMT_GUARDED_INSERT_LOCALE = "FMT_guarded_insert";
    public static final String FMT_GUARDED_REMOVE_LOCALE = "FMT_guarded_remove";
    MarkBlockChain guardedBlockChain;
    boolean breakGuarded;
    boolean atomicAsUser;
    protected StyleContext styles;
    protected Hashtable stylesToLayers;
    protected String normalStyleName;

    public GuardedDocument(Class kitClass) {
        this(kitClass, true, new StyleContext());
    }

    public GuardedDocument(Class kitClass, boolean addToRegistry, StyleContext styles) {
        super(kitClass, addToRegistry);
        this.styles = styles;
        this.stylesToLayers = new Hashtable(5);
        this.addLayer(new DrawLayerFactory.GuardedLayer(), 1400);
        this.guardedBlockChain = new MarkBlockChain.LayerChain(this, "guarded-layer");
    }

    public MarkBlockChain getGuardedBlockChain() {
        return this.guardedBlockChain;
    }

    public boolean isPosGuarded(int pos) {
        int rel = this.guardedBlockChain.compareBlock(pos, pos) & 0xFFFFFFF3;
        return rel == 1057 || rel == 4129;
    }

    protected void preInsertCheck(int offset, String text, AttributeSet a) throws BadLocationException {
        super.preInsertCheck(offset, text, a);
        int rel = this.guardedBlockChain.compareBlock(offset, offset) & 0xFFFFFFF3;
        if (debugAtomic) {
            System.err.println("GuardedDocument.beforeInsertUpdate() atomicAsUser=" + this.atomicAsUser + ", breakGuarded=" + this.breakGuarded + ", inserting text='" + EditorDebug.debugString(text) + "' at offset=" + Utilities.debugPosition(this, offset));
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        if (!(text.length() <= 0 || (rel & 1) == 0 || rel == 2081 || text.charAt(text.length() - 1) == '\n' && rel == 1057 || this.breakGuarded && !this.atomicAsUser)) {
            throw new GuardedException(MessageFormat.format(LocaleSupport.getString(FMT_GUARDED_INSERT_LOCALE), new Integer(offset)), offset);
        }
    }

    protected void preRemoveCheck(int offset, int len) throws BadLocationException {
        int rel = this.guardedBlockChain.compareBlock(offset, offset + len);
        if (debugAtomic) {
            System.err.println("GuardedDocument.beforeRemoveUpdate() atomicAsUser=" + this.atomicAsUser + ", breakGuarded=" + this.breakGuarded + ", removing text='" + EditorDebug.debugChars(this.getChars(offset, len)) + "'at offset=" + Utilities.debugPosition(this, offset));
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        if (((rel & 1) != 0 || rel == 66 && offset != 0 && this.getChars(offset - 1, 1)[0] != '\n') && (!this.breakGuarded || this.atomicAsUser)) {
            throw new GuardedException(MessageFormat.format(LocaleSupport.getString(FMT_GUARDED_REMOVE_LOCALE), new Integer(offset)), offset);
        }
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
        if (((Boolean)s.getAttribute(GUARDED_ATTRIBUTE)).booleanValue()) {
            this.guardedBlockChain.addBlock(offset, offset + length, false);
            this.fireChangedUpdate(this.createDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE));
        }
        if (!((Boolean)s.getAttribute(GUARDED_ATTRIBUTE)).booleanValue()) {
            this.guardedBlockChain.removeBlock(offset, offset + length);
            this.fireChangedUpdate(this.createDocumentEvent(offset, length, DocumentEvent.EventType.CHANGE));
        }
    }

    public void runAtomic(Runnable r) {
        if (debugAtomic) {
            System.out.println("GuardedDocument.runAtomic() called");
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        boolean origBreakGuarded = this.breakGuarded;
        try {
            this.breakGuarded = true;
            super.runAtomicAsUser(r);
            Object var4_3 = null;
            this.breakGuarded = origBreakGuarded;
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomic() finished");
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.breakGuarded = origBreakGuarded;
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomic() finished");
            }
            throw throwable;
        }
    }

    public void runAtomicAsUser(Runnable r) {
        if (debugAtomic) {
            System.out.println("GuardedDocument.runAtomicAsUser() called");
            if (debugAtomicStack) {
                Thread.dumpStack();
            }
        }
        boolean origAtomicAsUser = this.atomicAsUser;
        try {
            this.atomicAsUser = true;
            super.runAtomicAsUser(r);
            Object var4_3 = null;
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomicAsUser() finished");
            }
            this.atomicAsUser = origAtomicAsUser;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (debugAtomic) {
                System.out.println("GuardedDocument.runAtomicAsUser() finished");
            }
            this.atomicAsUser = origAtomicAsUser;
            throw throwable;
        }
    }

    protected BaseDocumentEvent createDocumentEvent(int offset, int length, DocumentEvent.EventType type) {
        return new GuardedDocumentEvent(this, offset, length, type);
    }

    public Style addStyle(String styleName, Style parent) {
        String layerName = (String)this.stylesToLayers.get(styleName);
        if (layerName == null) {
            layerName = styleName;
            this.addStyleToLayerMapping(styleName, layerName);
        }
        Style style = this.styles.addStyle(styleName, parent);
        if (this.findLayer(layerName) == null) {
            try {
                this.extWriteLock();
                this.addStyledLayer(layerName, style);
                Object var6_5 = null;
                this.extWriteUnlock();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.extWriteUnlock();
                throw throwable;
            }
        }
        return style;
    }

    public void addStyleToLayerMapping(String styleName, String layerName) {
        this.stylesToLayers.put(styleName, layerName);
    }

    public void removeStyle(String styleName) {
        this.styles.removeStyle(styleName);
    }

    public Style getStyle(String styleName) {
        return this.styles.getStyle(styleName);
    }

    public void setNormalStyleName(String normalStyleName) {
        this.normalStyleName = normalStyleName;
    }

    public Enumeration getStyleNames() {
        return this.styles.getStyleNames();
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
    }

    public void setLogicalStyle(int pos, Style s) {
        try {
            block6: {
                try {
                    this.extWriteLock();
                    pos = Utilities.getRowStart(this, pos);
                    String layerName = (String)this.stylesToLayers.get(s.getName());
                    DrawLayer[] layerArray = this.getDrawLayerList().currentLayers();
                    int i = 0;
                    while (i < layerArray.length) {
                        if (layerArray[i] instanceof DrawLayerFactory.StyleLayer) {
                            ((DrawLayerFactory.StyleLayer)layerArray[i]).markChain.removeMark(pos);
                        }
                        ++i;
                    }
                    DrawLayerFactory.StyleLayer styleLayer = (DrawLayerFactory.StyleLayer)this.findLayer(layerName);
                    if (styleLayer == null) break block6;
                    styleLayer.markChain.addMark(pos);
                }
                catch (BadLocationException e) {
                    Object var8_9 = null;
                    this.extWriteUnlock();
                }
            }
            Object var8_8 = null;
            this.extWriteUnlock();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.extWriteUnlock();
            throw throwable;
        }
        this.fireChangedUpdate(this.createDocumentEvent(pos, 0, DocumentEvent.EventType.CHANGE));
    }

    public Style getLogicalStyle(int pos) {
        try {
            pos = Utilities.getRowStart(this, pos);
            DrawLayer[] layerArray = this.getDrawLayerList().currentLayers();
            int i = 0;
            while (i < layerArray.length) {
                DrawLayer layer = layerArray[i];
                if (layer instanceof DrawLayerFactory.StyleLayer && ((DrawLayerFactory.StyleLayer)layer).markChain.isMark(pos)) {
                    return ((DrawLayerFactory.StyleLayer)layer).style;
                }
                ++i;
            }
            return this.getStyle(this.normalStyleName);
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    public Element getCharacterElement(int pos) {
        return this.getParagraphElement(pos);
    }

    public Color getForeground(AttributeSet attr) {
        return null;
    }

    public Color getBackground(AttributeSet attr) {
        return null;
    }

    public Font getFont(AttributeSet attr) {
        return null;
    }

    protected DrawLayer addStyledLayer(String layerName, Style style) {
        if (layerName != null) {
            try {
                int indColon = layerName.indexOf(58);
                int layerVisibility = Integer.parseInt(layerName.substring(indColon + 1));
                DrawLayerFactory.StyleLayer layer = new DrawLayerFactory.StyleLayer(layerName, this, style);
                this.addLayer(layer, layerVisibility);
                return layer;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String toStringDetail() {
        return super.toStringDetail() + this.getDrawLayerList() + ",\nGUARDED blocks:\n" + this.guardedBlockChain;
    }

    static {
        guardedSet.addAttribute(GUARDED_ATTRIBUTE, Boolean.TRUE);
        unguardedSet.addAttribute(GUARDED_ATTRIBUTE, Boolean.FALSE);
    }
}

