/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;

public class JumpList {
    private static final int MAX_SIZE = 50;
    private static final int CHECK_COUNT = 10;
    private static Entry currentEntry;
    private static int checkCnt;

    public static void checkAddEntry() {
        JTextComponent c = Utilities.getLastActiveComponent();
        if (c != null) {
            JumpList.checkAddEntry(c, c.getCaret().getDot());
        }
    }

    public static void checkAddEntry(JTextComponent c) {
        JumpList.checkAddEntry(c, c.getCaret().getDot());
    }

    public static void checkAddEntry(JTextComponent c, int pos) {
        if (currentEntry == null || currentEntry.getComponent() != c || currentEntry.getPosition() != pos) {
            JumpList.addEntry(c, pos);
        }
    }

    public static void addEntry(JTextComponent c, int pos) {
        try {
            Entry e;
            currentEntry = e = new Entry(c, pos, currentEntry);
            if (++checkCnt >= 10) {
                JumpList.sizeCheck();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void jumpPrev(JTextComponent c) {
        int dotPos = c.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int entryPos = currentEntry.getPosition();
                JTextComponent entryComp = currentEntry.getComponent();
                if (entryComp != null && (entryComp != c || entryPos >= 0 && entryPos != dotPos) && currentEntry.setDot() || JumpList.currentEntry.prev == null) break;
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static void jumpNext(JTextComponent c) {
        int dotPos = c.getCaret().getDot();
        if (currentEntry != null) {
            while (true) {
                int entryPos = currentEntry.getPosition();
                JTextComponent entryComp = currentEntry.getComponent();
                if (entryComp != null && (entryComp != c || entryPos >= 0 && entryPos != dotPos) && currentEntry.setDot() || JumpList.currentEntry.next == null) break;
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    public static void jumpPrevComponent(JTextComponent c) {
        if (currentEntry != null) {
            JTextComponent entryComp;
            while (!((entryComp = currentEntry.getComponent()) != null && entryComp != c && currentEntry.setDot() || JumpList.currentEntry.prev == null)) {
                currentEntry = JumpList.currentEntry.prev;
            }
        }
    }

    public static void jumpNextComponent(JTextComponent c) {
        if (currentEntry != null) {
            JTextComponent entryComp;
            while (!((entryComp = currentEntry.getComponent()) != null && entryComp != c && currentEntry.setDot() || JumpList.currentEntry.next == null)) {
                currentEntry = JumpList.currentEntry.next;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String dump() {
        block5: {
            block3: {
                block4: {
                    sb = new StringBuffer();
                    i = 0;
                    e = JumpList.currentEntry;
                    if (e == null) break block3;
                    while (e.prev != null) {
                        e = e.prev;
                        --i;
                    }
                    break block4;
lbl10:
                    // 1 sources

                    while (true) {
                        comp = e.getComponent();
                        v0 = docStr = comp != null ? (String)comp.getDocument().getProperty("title") : "<Invalid document>";
                        if (docStr == null) {
                            docStr = "Untitled";
                        }
                        sb.append("[" + i++ + "]=" + docStr + ", " + e.getPosition() + "\n");
                        e = e.next;
                        break;
                    }
                }
                ** while (e != null)
lbl20:
                // 1 sources

                break block5;
            }
            sb.append("Empty list");
        }
        return sb.toString();
    }

    private static void sizeCheck() {
        int cnt = 50;
        Entry e = currentEntry;
        while (e != null && cnt > 0) {
            e = e.prev;
            --cnt;
        }
        if (e != null) {
            e.makeFirst();
        }
    }

    public static class Entry {
        private int componentID;
        private int posID;
        Entry prev;
        Entry next;

        Entry(JTextComponent component, int offset, Entry last) throws BadLocationException {
            this.componentID = Registry.getID(component);
            this.posID = ((BaseDocument)component.getDocument()).storePosition(offset);
            if (last != null) {
                last.next = this;
                this.prev = last;
            }
        }

        public int getPosition() {
            JTextComponent c = Registry.getComponent(this.componentID);
            int pos = -1;
            if (c != null) {
                pos = ((BaseDocument)c.getDocument()).getStoredPosition(this.posID);
            }
            return pos;
        }

        public JTextComponent getComponent() {
            return Registry.getComponent(this.componentID);
        }

        public boolean setDot() {
            JTextComponent c = this.getComponent();
            if (c != null) {
                int pos;
                if (Utilities.getLastActiveComponent() != c) {
                    Utilities.requestFocus(c);
                }
                if ((pos = this.getPosition()) >= 0 && pos <= c.getDocument().getLength()) {
                    c.getCaret().setDot(pos);
                    return true;
                }
            }
            return false;
        }

        void makeLast() {
            if (this.next != null) {
                this.next.prev = null;
                this.next = null;
            }
        }

        void makeFirst() {
            if (this.prev != null) {
                this.prev.next = null;
                this.prev = null;
            }
        }

        protected void finalize() throws Throwable {
            JTextComponent c = Registry.getComponent(this.componentID);
            if (c != null) {
                ((BaseDocument)c.getDocument()).removeStoredPosition(this.posID);
            }
            super.finalize();
        }
    }
}

