/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;

public class KeySequenceInputPanel
extends JPanel {
    public static String PROP_KEYSEQUENCE = "keySequence";
    private Vector strokes = new Vector();
    private StringBuffer text = new StringBuffer();
    private JLabel keySequenceLabel;
    private JTextArea collisionLabel;
    private JTextField keySequenceInputField;

    public KeySequenceInputPanel() {
        this.initComponents();
        this.keySequenceLabel.setDisplayedMnemonic(LocaleSupport.getString("LBL_KSIP_Sequence_Mnemonic").charAt(0));
        this.keySequenceInputField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_LBL_KSIP_Sequence"));
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString("MSP_AddTitle"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_KSIP"));
    }

    public void clear() {
        this.strokes.clear();
        this.text.setLength(0);
        this.keySequenceInputField.setText(this.text.toString());
        this.firePropertyChange(PROP_KEYSEQUENCE, null, null);
    }

    public void setInfoText(String s) {
        this.collisionLabel.setText(s + ' ');
    }

    public KeyStroke[] getKeySequence() {
        return this.strokes.toArray(new KeyStroke[0]);
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim.width < 400) {
            dim.width = 400;
        }
        return dim;
    }

    public void requestFocus() {
        this.keySequenceInputField.requestFocus();
    }

    private void initComponents() {
        this.keySequenceLabel = new JLabel();
        this.keySequenceInputField = new JTextField();
        this.collisionLabel = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        this.keySequenceLabel.setText(LocaleSupport.getString("LBL_KSIP_Sequence"));
        this.keySequenceLabel.setBorder(new EmptyBorder(new Insets(0, 0, 0, 8)));
        this.keySequenceLabel.setLabelFor(this.keySequenceInputField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.keySequenceLabel, gridBagConstraints);
        this.keySequenceInputField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyTyped(evt);
            }

            public void keyPressed(KeyEvent evt) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                KeySequenceInputPanel.this.keySequenceInputFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.keySequenceInputField, gridBagConstraints);
        this.collisionLabel.setLineWrap(true);
        this.collisionLabel.setEditable(false);
        this.collisionLabel.setRows(2);
        this.collisionLabel.setForeground(Color.red);
        this.collisionLabel.setBackground(this.getBackground());
        this.collisionLabel.setDisabledTextColor(Color.red);
        this.collisionLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.collisionLabel, gridBagConstraints);
    }

    private void keySequenceInputFieldKeyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void keySequenceInputFieldKeyReleased(KeyEvent evt) {
        evt.consume();
        this.keySequenceInputField.setText(this.text.toString());
    }

    private void keySequenceInputFieldKeyPressed(KeyEvent evt) {
        evt.consume();
        String modif = KeyEvent.getKeyModifiersText(evt.getModifiers());
        if (this.isModifier(evt.getKeyCode())) {
            this.keySequenceInputField.setText(this.text.toString() + modif + '+');
        } else {
            KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(evt);
            this.strokes.add(stroke);
            this.text.append(Utilities.keyStrokeToString(stroke));
            this.text.append(' ');
            this.keySequenceInputField.setText(this.text.toString());
            this.firePropertyChange(PROP_KEYSEQUENCE, null, null);
        }
    }

    private boolean isModifier(int keyCode) {
        return keyCode == 18 || keyCode == 65406 || keyCode == 17 || keyCode == 16 || keyCode == 157;
    }
}

