/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.undo.UndoableEdit;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CharSeq;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.GapBranchElement;
import org.netbeans.editor.LineElement;
import org.netbeans.editor.ObjectArrayUtilities;
import org.netbeans.editor.Syntax;

final class LineRootElement
extends GapBranchElement {
    private static final String NAME = "paragraphRoot";
    private BaseDocument doc;
    private ArrayList addedLines = new ArrayList();

    LineRootElement(BaseDocument doc) {
        this.doc = doc;
        this.replace(0, 0, new Element[]{new LineElement(this, 0, null)});
    }

    public Element getElement(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid line index=" + index + " < 0");
        }
        int elementCount = this.getElementCount();
        if (index >= elementCount) {
            throw new IndexOutOfBoundsException("Invalid line index=" + index + " >= lineCount=" + elementCount);
        }
        return super.getElement(index);
    }

    UndoableEdit insertUpdate(int offset, int length) {
        int startOffset = offset;
        offset += length;
        LineElement lastCreatedLine = null;
        CharSeq docText = this.doc.getText();
        while (--offset >= startOffset) {
            if (docText.charAt(offset) != '\n') continue;
            lastCreatedLine = new LineElement(this, offset + 1, lastCreatedLine);
            this.addedLines.add(lastCreatedLine);
        }
        if (lastCreatedLine != null) {
            Object[] linesAdded = new Element[this.addedLines.size()];
            this.addedLines.toArray(linesAdded);
            this.addedLines.clear();
            ObjectArrayUtilities.reverse(linesAdded);
            int index = this.getElementIndex(startOffset) + 1;
            this.replace(index, 0, (Element[])linesAdded);
            return new GapBranchElement.Undo(index, GapBranchElement.EMPTY_ELEMENT_ARRAY, (Element[])linesAdded);
        }
        return null;
    }

    UndoableEdit removeUpdate(int offset, int length) {
        int endOffset = offset + length;
        CharSeq docText = this.doc.getText();
        while (offset < endOffset) {
            if (docText.charAt(offset) == '\n') {
                int index = this.getElementIndex(offset + 1);
                LineElement lineElem = this.getLineElement(index);
                int removeCount = 0;
                do {
                    ++removeCount;
                } while ((lineElem = lineElem.getNext()) != null && lineElem.getStartOffset() <= endOffset);
                Element[] linesRemoved = new Element[removeCount];
                this.copyElements(index, index + removeCount, linesRemoved, 0);
                this.replace(index, linesRemoved.length, GapBranchElement.EMPTY_ELEMENT_ARRAY);
                return new GapBranchElement.Undo(index, linesRemoved, GapBranchElement.EMPTY_ELEMENT_ARRAY);
            }
            ++offset;
        }
        return null;
    }

    protected void replace(int index, int removeCount, Element[] addedElems) {
        if (removeCount > 0) {
            LineElement lastRemoved = this.getLineElement(index + removeCount - 1);
            if (index > 0) {
                this.getLineElement(index - 1).setNext(lastRemoved.getNext());
            }
            lastRemoved.setNext(null);
        }
        super.replace(index, removeCount, addedElems);
        if (addedElems.length > 0) {
            if (index > 0) {
                LineElement firstAdded = (LineElement)addedElems[0];
                ((LineElement)this.getElement(index - 1)).setNext(firstAdded);
            }
            int firstAfterAddedIndex = index + addedElems.length - removeCount;
            ((LineElement)addedElems[addedElems.length - 1]).setNext(firstAfterAddedIndex < this.getElementCount() ? this.getLineElement(firstAfterAddedIndex) : null);
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public Element getParentElement() {
        return null;
    }

    public String getName() {
        return NAME;
    }

    public AttributeSet getAttributes() {
        return StyleContext.getDefaultStyleContext().getEmptySet();
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this.doc.getLength() + 1;
    }

    public int getElementIndex(int offset) {
        if (offset == 0) {
            return 0;
        }
        return super.getElementIndex(offset);
    }

    void invalidateAllSyntaxStateInfos() {
        int elemCount = this.getElementCount();
        int i = elemCount - 1;
        while (i >= 0) {
            LineElement line = this.getValidLineElement(i);
            line.clearSyntaxStateInfo();
            --i;
        }
    }

    void prepareSyntax(Segment text, Syntax syntax, int reqPos, int reqLen, boolean forceLastBuffer, boolean forceNotLastBuffer) throws BadLocationException {
        int preScan;
        if (reqPos < 0 || reqLen < 0 || reqPos + reqLen > this.doc.getLength()) {
            throw new BadLocationException("reqPos=" + reqPos + ", reqLen=" + reqLen + ", doc.getLength()=" + this.doc.getLength(), -1);
        }
        int reqPosLineIndex = this.getElementIndex(reqPos);
        LineElement reqPosLineElem = this.getValidSyntaxStateInfoLineElement(reqPosLineIndex);
        int lineStartOffset = reqPosLineElem.getStartOffset();
        Syntax.StateInfo stateInfo = reqPosLineElem.getSyntaxStateInfo();
        if (reqPosLineIndex > 0) {
            preScan = stateInfo.getPreScan();
        } else {
            preScan = 0;
            if (stateInfo != null) {
                throw new IllegalStateException("stateInfo=" + stateInfo);
            }
        }
        int intraLineLength = reqPos - lineStartOffset;
        this.doc.getText(lineStartOffset - preScan, preScan + intraLineLength + reqLen, text);
        text.offset += preScan;
        text.count -= preScan;
        syntax.load(stateInfo, text.array, text.offset, intraLineLength, false, reqPos);
        while (syntax.nextToken() != null) {
        }
        text.offset += intraLineLength;
        text.count -= intraLineLength;
        boolean forceLB = forceNotLastBuffer ? false : forceLastBuffer || reqPos + reqLen >= this.getDocument().getLength();
        syntax.relocate(text.array, text.offset, text.count, forceLB, reqPos + reqLen);
    }

    private LineElement getValidSyntaxStateInfoLineElement(int lineIndex) throws BadLocationException {
        LineElement lineElem = this.getValidLineElement(lineIndex);
        Syntax.StateInfo stateInfo = lineElem.getSyntaxStateInfo();
        if (lineIndex > 0 && stateInfo == null) {
            int validLineIndex = lineIndex - 1;
            LineElement validLineElem = null;
            while (validLineIndex > 0) {
                validLineElem = this.getValidLineElement(validLineIndex);
                stateInfo = validLineElem.getSyntaxStateInfo();
                if (stateInfo != null) break;
                --validLineIndex;
            }
            Segment text = DocumentUtilities.SEGMENT_CACHE.getSegment();
            try {
                Syntax syntax = this.doc.getFreeSyntax();
                try {
                    int lineElemOffset = lineElem.getStartOffset();
                    int validLineOffset = 0;
                    int preScan = 0;
                    if (validLineIndex > 0) {
                        validLineOffset = validLineElem.getStartOffset();
                        preScan = stateInfo.getPreScan();
                    } else {
                        stateInfo = null;
                    }
                    this.doc.getText(validLineOffset - preScan, lineElemOffset - validLineOffset + preScan, text);
                    text.offset += preScan;
                    text.count -= preScan;
                    syntax.load(stateInfo, text.array, text.offset, text.count, false, lineElemOffset);
                    int textEndOffset = text.offset + text.count;
                    do {
                        validLineElem = this.getValidLineElement(++validLineIndex);
                        validLineOffset = validLineElem.getStartOffset();
                        syntax.relocate(text.array, syntax.getOffset(), textEndOffset - syntax.getOffset(), false, validLineOffset);
                        while (syntax.nextToken() != null) {
                        }
                        validLineElem.updateSyntaxStateInfo(syntax);
                    } while (validLineIndex != lineIndex);
                    Object var13_12 = null;
                    this.doc.releaseSyntax(syntax);
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    this.doc.releaseSyntax(syntax);
                    throw throwable;
                }
                Object var15_15 = null;
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
                throw throwable;
            }
        }
        return lineElem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int fixSyntaxStateInfos(int offset, int length) {
        int n;
        Segment text;
        block18: {
            int n2;
            block17: {
                if (offset < 0) {
                    throw new IllegalStateException("offset=" + offset);
                }
                int lineIndex = this.getElementIndex(offset);
                int addedLinesCount = length > 0 ? this.getElementIndex(offset + length) - lineIndex : 0;
                LineElement lineElem = this.getValidLineElement(lineIndex);
                text = DocumentUtilities.SEGMENT_CACHE.getSegment();
                try {
                    try {
                        Syntax syntax;
                        block15: {
                            block16: {
                                int n3;
                                block14: {
                                    syntax = this.doc.getFreeSyntax();
                                    try {
                                        int docLastLineIndex = this.getElementCount() - 1;
                                        if (lineIndex == docLastLineIndex) {
                                            if (lineIndex == 0 && lineElem.getSyntaxStateInfo() != null) {
                                                lineElem.clearSyntaxStateInfo();
                                            }
                                            n3 = this.doc.getLength();
                                            Object var18_12 = null;
                                            this.doc.releaseSyntax(syntax);
                                            break block14;
                                        }
                                        int maybeMatchLineIndex = Math.min(lineIndex + addedLinesCount + 1, docLastLineIndex);
                                        Syntax.StateInfo stateInfo = null;
                                        int lineStartOffset = 0;
                                        int preScan = 0;
                                        if (lineIndex > 0) {
                                            stateInfo = lineElem.getSyntaxStateInfo();
                                            preScan = stateInfo.getPreScan();
                                            lineStartOffset = lineElem.getStartOffset();
                                        }
                                        LineElement nextLineElem = this.getValidLineElement(++lineIndex);
                                        int nextLineStartOffset = nextLineElem.getStartOffset();
                                        this.doc.getText(lineStartOffset - preScan, nextLineStartOffset - lineStartOffset + preScan, text);
                                        text.offset += preScan;
                                        text.count -= preScan;
                                        syntax.load(stateInfo, text.array, text.offset, text.count, false, nextLineStartOffset);
                                        int lineCount = this.getElementCount();
                                        while (true) {
                                            if (syntax.nextToken() != null) {
                                                continue;
                                            }
                                            if (lineIndex >= maybeMatchLineIndex && (stateInfo = nextLineElem.getSyntaxStateInfo()) != null && syntax.compareState(stateInfo) == 0) {
                                                n = lineStartOffset;
                                                break block15;
                                            }
                                            nextLineElem.updateSyntaxStateInfo(syntax);
                                            if (++lineIndex >= lineCount) {
                                                n2 = this.doc.getLength();
                                                break block16;
                                            }
                                            lineElem = nextLineElem;
                                            lineStartOffset = nextLineStartOffset;
                                            nextLineElem = this.getValidLineElement(lineIndex);
                                            nextLineStartOffset = nextLineElem.getStartOffset();
                                            preScan = syntax.getPreScan();
                                            this.doc.getText(lineStartOffset - preScan, nextLineStartOffset - lineStartOffset + preScan, text);
                                            text.offset += preScan;
                                            text.count -= preScan;
                                            syntax.relocate(text.array, text.offset, text.count, false, nextLineStartOffset);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var18_15 = null;
                                        this.doc.releaseSyntax(syntax);
                                        throw throwable;
                                    }
                                }
                                Object var20_16 = null;
                                DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
                                return n3;
                            }
                            Object var18_13 = null;
                            this.doc.releaseSyntax(syntax);
                            break block17;
                        }
                        Object var18_14 = null;
                        this.doc.releaseSyntax(syntax);
                        break block18;
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e.toString());
                    }
                }
                catch (Throwable throwable) {
                    Object var20_19 = null;
                    DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
                    throw throwable;
                }
            }
            Object var20_17 = null;
            DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
            return n2;
        }
        Object var20_18 = null;
        DocumentUtilities.SEGMENT_CACHE.releaseSegment(text);
        return n;
    }

    private LineElement getLineElement(int index) {
        return (LineElement)this.getElement(index);
    }

    private LineElement getValidLineElement(int lineIndex) {
        if (lineIndex < 0 || lineIndex >= this.getElementCount()) {
            throw new IllegalArgumentException("lineIndex=" + lineIndex + ", lineCount=" + this.getElementCount());
        }
        return this.getLineElement(lineIndex);
    }

    int getTokenSafeOffset(int offset) {
        if (offset == 0) {
            return offset;
        }
        try {
            int lineIndex = this.getElementIndex(offset);
            LineElement lineElem = this.getValidSyntaxStateInfoLineElement(lineIndex);
            int lineStartOffset = lineElem.getStartOffset();
            Syntax.StateInfo stateInfo = lineElem.getSyntaxStateInfo();
            if (offset == lineStartOffset && stateInfo.getPreScan() == 0) {
                return offset;
            }
            int lineCount = this.getElementCount();
            while (++lineIndex < lineCount) {
                lineElem = this.getValidSyntaxStateInfoLineElement(lineIndex);
                lineStartOffset = lineElem.getStartOffset();
                if (lineStartOffset - (stateInfo = lineElem.getSyntaxStateInfo()).getPreScan() < offset) continue;
                return lineStartOffset;
            }
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.toString());
        }
        return this.doc.getLength();
    }
}

