/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.MissingResourceException;

public class LocaleSupport {
    private static final String NULL_STRING = new String();
    private static final HashMap cache = new HashMap(503);
    private static Localizer[] localizers = new Localizer[0];

    public static void addLocalizer(Localizer localizer) {
        ArrayList<Localizer> ll = new ArrayList<Localizer>(Arrays.asList(localizers));
        ll.add(localizer);
        Localizer[] la = new Localizer[ll.size()];
        ll.toArray(la);
        localizers = la;
        cache.clear();
    }

    public static void removeLocalizer(Localizer localizer) {
        ArrayList<Localizer> ll = new ArrayList<Localizer>(Arrays.asList(localizers));
        ((AbstractCollection)ll).remove(localizer);
        Localizer[] la = new Localizer[ll.size()];
        ll.toArray(la);
        localizers = la;
        cache.clear();
    }

    public static synchronized String getString(String key) {
        String ret = (String)cache.get(key);
        if (ret == null) {
            int i = localizers.length - 1;
            while (i >= 0) {
                try {
                    ret = localizers[i].getString(key);
                }
                catch (MissingResourceException e) {
                    ret = null;
                }
                if (ret != null) break;
                --i;
            }
            if (ret == null) {
                ret = NULL_STRING;
            }
            cache.put(key, ret);
        }
        return ret != NULL_STRING ? ret : null;
    }

    public static String getString(String key, String defaultValue) {
        String ret = LocaleSupport.getString(key);
        return ret != null ? ret : defaultValue;
    }

    public static char getChar(String key, char defaultValue) {
        String value = LocaleSupport.getString(key);
        if (value == null || value.length() < 1) {
            return defaultValue;
        }
        return value.charAt(0);
    }

    public static interface Localizer {
        public String getString(String var1);
    }
}

