/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.MacroSavePanel;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;

public class MacroDialogSupport
implements ActionListener {
    JButton okButton;
    JButton cancelButton;
    MacroSavePanel panel;
    Dialog macroDialog;
    Class kitClass;

    public MacroDialogSupport(Class kitClass) {
        this.kitClass = kitClass;
        this.panel = new MacroSavePanel(kitClass);
        this.okButton = new JButton(LocaleSupport.getString("MDS_ok"));
        this.cancelButton = new JButton(LocaleSupport.getString("MDS_cancel"));
        this.okButton.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MDS_ok"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_MDS_cancel"));
    }

    public void setBody(String body) {
        this.panel.setBody(body);
    }

    public void showMacroDialog() {
        this.macroDialog = DialogSupport.createDialog(LocaleSupport.getString("MDS_title"), this.panel, true, new JButton[]{this.okButton, this.cancelButton}, false, 0, 1, this);
        this.macroDialog.pack();
        this.panel.popupNotify();
        this.macroDialog.requestFocus();
        this.macroDialog.show();
    }

    private List getKBList() {
        Settings.KitAndValue[] kav = Settings.getValueHierarchy(this.kitClass, "key-bindings");
        List<MultiKeyBinding> kbList = null;
        int i = 0;
        while (i < kav.length) {
            if (kav[i].kitClass == this.kitClass) {
                kbList = (List)kav[i].value;
            }
            ++i;
        }
        if (kbList == null) {
            kbList = new ArrayList();
        }
        int cnt = kbList.size();
        int i2 = 0;
        while (i2 < cnt) {
            Object o = kbList.get(i2);
            if (!(o instanceof MultiKeyBinding) && o != null) {
                JTextComponent.KeyBinding b = (JTextComponent.KeyBinding)o;
                kbList.set(i2, new MultiKeyBinding(b.key, b.actionName));
            }
            ++i2;
        }
        return new ArrayList(kbList);
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.okButton) {
            Map macroMap = (Map)Settings.getValue(this.kitClass, "macro-map");
            HashMap<String, String> newMap = new HashMap<String, String>(macroMap);
            newMap.put(this.panel.getName(), this.panel.getBody());
            Settings.setValue(this.kitClass, "macro-map", newMap);
            List listBindings = this.panel.getKeySequences();
            if (listBindings.size() > 0) {
                List keybindings = this.getKBList();
                String actionName = new String("macro-" + this.panel.getName());
                int i = 0;
                while (i < listBindings.size()) {
                    KeyStroke[] keyStrokes = (KeyStroke[])listBindings.get(i);
                    MultiKeyBinding multiKey = new MultiKeyBinding(keyStrokes, actionName);
                    keybindings.add(multiKey);
                    ++i;
                }
                Settings.setValue(this.kitClass, "key-bindings", keybindings);
            }
        }
        ((Component)this.macroDialog).setVisible(false);
        this.macroDialog.dispose();
    }
}

