/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;

public class MarkChain {
    protected MarkFactory.ChainDrawMark chain;
    protected MarkFactory.ChainDrawMark curMark;
    protected BaseDocument doc;
    protected String layerName;
    private MarkFactory.ChainDrawMark recentlyAddedMark;

    public MarkChain(BaseDocument doc, String layerName) {
        this.doc = doc;
        this.layerName = layerName;
    }

    public final MarkFactory.ChainDrawMark getChain() {
        return this.chain;
    }

    public final MarkFactory.ChainDrawMark getCurMark() {
        return this.curMark;
    }

    /*
     * WARNING - void declaration
     */
    public int compareMark(int pos) {
        try {
            int rel;
            if (this.curMark == null) {
                this.curMark = this.chain;
                if (this.curMark == null) {
                    return -1;
                }
            }
            boolean after = false;
            boolean before = false;
            while ((rel = this.curMark.compare(pos)) != 0) {
                void var2_4;
                if (var2_4 > 0) {
                    if (before) {
                        return (int)var2_4;
                    }
                    if (this.curMark.prev != null) {
                        after = true;
                        this.curMark = this.curMark.prev;
                        continue;
                    }
                    return (int)var2_4;
                }
                if (after) {
                    return (int)var2_4;
                }
                if (this.curMark.next != null) {
                    before = true;
                    this.curMark = this.curMark.next;
                    continue;
                }
                return (int)var2_4;
            }
            return 0;
        }
        catch (InvalidMarkException e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                e.printStackTrace();
            }
            return -1;
        }
    }

    protected MarkFactory.ChainDrawMark createAndInsertNewMark(int pos) throws BadLocationException {
        MarkFactory.ChainDrawMark mark;
        block2: {
            mark = this.createMark();
            try {
                mark.insert(this.doc, pos);
            }
            catch (InvalidMarkException e) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                e.printStackTrace();
            }
        }
        return mark;
    }

    protected MarkFactory.ChainDrawMark createMark() {
        MarkFactory.ChainDrawMark mark = new MarkFactory.ChainDrawMark(this.layerName, null, Position.Bias.Backward);
        mark.activateLayer = true;
        return mark;
    }

    public boolean addMark(int pos) throws BadLocationException {
        int rel = this.compareMark(pos);
        if (rel == 0) {
            this.recentlyAddedMark = this.curMark;
            return false;
        }
        if (rel > 0) {
            MarkFactory.ChainDrawMark mark;
            this.recentlyAddedMark = mark = this.createAndInsertNewMark(pos);
            if (this.curMark != null) {
                if (this.curMark == this.chain) {
                    this.chain = this.curMark.insertChain(mark);
                } else {
                    this.curMark.insertChain(mark);
                }
            } else {
                this.chain = mark;
            }
        } else {
            MarkFactory.ChainDrawMark mark;
            this.recentlyAddedMark = mark = this.createAndInsertNewMark(pos);
            if (this.curMark != null) {
                if (this.curMark.next != null) {
                    this.curMark.next.insertChain(mark);
                } else {
                    this.curMark.setNextChain(mark);
                }
            } else {
                this.chain = mark;
            }
        }
        return true;
    }

    public MarkFactory.ChainDrawMark getAddedMark() {
        return this.recentlyAddedMark;
    }

    public boolean removeMark(int pos) {
        int rel = this.compareMark(pos);
        if (rel == 0) {
            boolean first = this.curMark == this.chain;
            this.curMark = this.curMark.removeChain();
            if (first) {
                this.chain = this.curMark;
            }
            return true;
        }
        return false;
    }

    public boolean isMark(int pos) {
        return this.compareMark(pos) == 0;
    }

    public boolean toggleMark(int pos) throws BadLocationException {
        int rel = this.compareMark(pos);
        if (rel == 0) {
            this.removeMark(pos);
            return false;
        }
        this.addMark(pos);
        return true;
    }

    public String toString() {
        return "MarkChain: curMark=" + this.curMark + ", mark chain: " + (this.chain != null ? "\n" + this.chain.toStringChain() : "Empty");
    }
}

