/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import javax.swing.text.Position;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;

public class MarkFactory {
    private MarkFactory() {
    }

    static class CaretMark
    extends DrawMark {
        CaretMark() {
            super("caret-layer", null);
        }
    }

    public static class ChainDrawMark
    extends DrawMark {
        protected ChainDrawMark next;
        protected ChainDrawMark prev;

        public ChainDrawMark(String layerName, EditorUI editorUI) {
            this(layerName, editorUI, Position.Bias.Forward);
        }

        public ChainDrawMark(String layerName, EditorUI editorUI, Position.Bias bias) {
            super(layerName, editorUI, bias);
        }

        public final ChainDrawMark getNext() {
            return this.next;
        }

        public final void setNext(ChainDrawMark mark) {
            this.next = mark;
        }

        public void setNextChain(ChainDrawMark mark) {
            this.next = mark;
            if (mark != null) {
                mark.prev = this;
            }
        }

        public final ChainDrawMark getPrev() {
            return this.prev;
        }

        public final void setPrev(ChainDrawMark mark) {
            this.prev = mark;
        }

        public void setPrevChain(ChainDrawMark mark) {
            this.prev = mark;
            if (mark != null) {
                mark.next = this;
            }
        }

        public ChainDrawMark insertChain(ChainDrawMark mark) {
            ChainDrawMark thisPrev;
            mark.prev = thisPrev = this.prev;
            mark.next = this;
            if (thisPrev != null) {
                thisPrev.next = mark;
            }
            this.prev = mark;
            return mark;
        }

        public ChainDrawMark removeChain() {
            ChainDrawMark thisNext = this.next;
            ChainDrawMark thisPrev = this.prev;
            if (thisPrev != null) {
                thisPrev.next = thisNext;
                this.prev = null;
            }
            if (thisNext != null) {
                thisNext.prev = thisPrev;
                this.next = null;
            }
            try {
                this.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
            return thisNext;
        }

        public String toStringChain() {
            return this.toString() + (this.next != null ? "\n" + this.next.toStringChain() : "");
        }

        public String toString() {
            return super.toString() + ", " + (this.prev != null ? (this.next != null ? "chain member" : "last member") : (this.next != null ? "first member" : "standalone member"));
        }
    }

    public static class DrawMark
    extends ContextMark {
        protected boolean activateLayer;
        String layerName;
        WeakReference editorUIRef;

        public DrawMark(String layerName, EditorUI editorUI) {
            this(layerName, editorUI, Position.Bias.Forward);
        }

        public DrawMark(String layerName, EditorUI editorUI, Position.Bias bias) {
            super(bias, false);
            this.layerName = layerName;
            this.setEditorUI(editorUI);
        }

        public boolean isDocumentMark() {
            return this.editorUIRef == null;
        }

        public EditorUI getEditorUI() {
            if (this.editorUIRef != null) {
                return (EditorUI)this.editorUIRef.get();
            }
            return null;
        }

        public void setEditorUI(EditorUI editorUI) {
            this.editorUIRef = editorUI != null ? new WeakReference<EditorUI>(editorUI) : null;
        }

        public boolean isValidUI() {
            return this.editorUIRef == null || this.editorUIRef.get() != null;
        }

        public void setActivateLayer(boolean activateLayer) {
            this.activateLayer = activateLayer;
        }

        public boolean getActivateLayer() {
            return this.activateLayer;
        }

        public boolean removeInvalid() {
            if (!this.isValidUI() && this.isValid()) {
                try {
                    this.remove();
                }
                catch (InvalidMarkException e) {
                    throw new IllegalStateException(e.toString());
                }
                return true;
            }
            return false;
        }

        public String toString() {
            try {
                return "pos=" + this.getOffset() + ", line=" + this.getLine();
            }
            catch (InvalidMarkException e) {
                return "mark not valid";
            }
        }
    }

    public static class ContextMark
    extends Mark {
        boolean stayBOL;

        public ContextMark(boolean stayBOL) {
            this(false, stayBOL);
        }

        public ContextMark(boolean insertAfter, boolean stayBOL) {
            this(insertAfter ? Position.Bias.Backward : Position.Bias.Forward, stayBOL);
        }

        public ContextMark(Position.Bias bias, boolean stayBOL) {
            super(bias);
            this.stayBOL = stayBOL;
        }
    }

    public static class SyntaxMark
    extends Mark {
        private Syntax.StateInfo stateInfo;
        private TokenItem tokenItem;

        public Syntax.StateInfo getStateInfo() {
            return this.stateInfo;
        }

        public void updateStateInfo(Syntax syntax) {
            if (this.stateInfo == null) {
                this.stateInfo = syntax.createStateInfo();
            }
            syntax.storeState(this.stateInfo);
        }

        void setStateInfo(Syntax.StateInfo stateInfo) {
            this.stateInfo = stateInfo;
        }

        public TokenItem getTokenItem() {
            return this.tokenItem;
        }

        void setTokenItem(TokenItem tokenItem) {
            this.tokenItem = tokenItem;
        }

        protected void removeUpdateAction(int pos, int len) {
            try {
                this.remove();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
    }
}

