/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.Position;
import org.netbeans.editor.MarkVector;

final class MultiMark {
    static final int BACKWARD_BIAS = 1;
    static final int VALID = 2;
    static final int REMOVED = 4;
    static final int COMPATIBLE = 8;
    static final int ZERO = 16;
    int rawOffset;
    int flags;
    MarkVector markVector;

    MultiMark(MarkVector markVector, int offset) {
        this(markVector, offset, offset != 0 ? 8 : 25);
    }

    MultiMark(MarkVector markVector, int offset, Position.Bias bias) {
        this(markVector, offset, bias == Position.Bias.Backward ? 1 : 0);
    }

    private MultiMark(MarkVector markVector, int offset, int flags) {
        this.markVector = markVector;
        this.rawOffset = offset;
        this.flags = flags;
    }

    public Position.Bias getBias() {
        return (this.flags & 1) != 0 ? Position.Bias.Backward : Position.Bias.Forward;
    }

    public int getOffset() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                int n = (this.flags & 0x10) == 0 ? this.markVector.getOffset(this.rawOffset) : 0;
                return n;
            }
            throw new IllegalStateException();
        }
    }

    public void dispose() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                this.flags &= 0xFFFFFFFD;
            } else {
                throw new IllegalStateException();
            }
            this.markVector.notifyMarkDisposed();
        }
    }

    public boolean isValid() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            boolean bl = (this.flags & 2) != 0;
            return bl;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                sb.append("offset=" + this.getOffset());
            } else {
                sb.append("removed");
            }
            sb.append(", bias=");
            sb.append(this.getBias());
            String string = sb.toString();
            return string;
        }
    }

    public String toStringDetail() {
        StringBuffer sb = new StringBuffer();
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            sb.append(System.identityHashCode(this));
            sb.append(" (");
            sb.append(this.rawOffset);
            sb.append(" -> ");
            if ((this.flags & 2) != 0) {
                sb.append(this.getOffset());
            } else {
                sb.append('X');
                sb.append(this.markVector.getOffset(this.rawOffset));
                sb.append('X');
            }
            sb.append(", ");
            sb.append((this.flags & 1) != 0 ? (char)'B' : 'F');
            if ((this.flags & 2) != 0) {
                sb.append('V');
            }
            if ((this.flags & 4) != 0) {
                sb.append('R');
            }
            if ((this.flags & 8) != 0) {
                sb.append('C');
            }
            if ((this.flags & 0x10) != 0) {
                sb.append('Z');
            }
            sb.append(')');
            String string = sb.toString();
            return string;
        }
    }
}

