/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;

public class Registry {
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList compAct;
    private static final WeakEventListenerList listenerList;
    private static int consolidateCounter;
    static /* synthetic */ Class class$org$netbeans$editor$SettingsChangeListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$netbeans$editor$Registry;

    public static void addChangeListener(ChangeListener l) {
        listenerList.add(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Registry.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, l);
    }

    public static void removeChangeListener(SettingsChangeListener l) {
        listenerList.remove(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Registry.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, l);
    }

    public static synchronized int getID(BaseDocument doc) {
        Integer i = Registry.getIDInteger(doc);
        return i != null ? i : -1;
    }

    public static synchronized int getID(JTextComponent c) {
        return Registry.getIDImpl(c);
    }

    public static synchronized BaseDocument getDocument(int docID) {
        if (docID < 0 || docID >= docRefsCount) {
            return null;
        }
        WeakReference wr = docRefs[docID];
        return wr != null ? (BaseDocument)wr.get() : null;
    }

    public static synchronized JTextComponent getComponent(int compID) {
        if (compID < 0 || compID >= compRefsCount) {
            return null;
        }
        WeakReference wr = compRefs[compID];
        return wr != null ? (JTextComponent)wr.get() : null;
    }

    public static synchronized int addDocument(BaseDocument doc) {
        Integer docID = Registry.getIDInteger(doc);
        if (docID != null) {
            return docID;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = Registry.realloc(docRefs);
        }
        Registry.docRefs[Registry.docRefsCount] = new WeakReference<BaseDocument>(doc);
        doc.putProperty("id", new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent c) {
        int compID = Registry.getIDImpl(c);
        if (compID != -1) {
            return compID;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = Registry.realloc(compRefs);
        }
        Registry.compRefs[Registry.compRefsCount] = new WeakReference<JTextComponent>(c);
        ((BaseTextUI)c.getUI()).componentID = compRefsCount;
        return compRefsCount++;
    }

    public static synchronized int removeComponent(JTextComponent c) {
        int compID = Registry.getIDImpl(c);
        if (compID != -1) {
            Registry.compRefs[compID] = null;
            int i = compAct.size() - 1;
            while (i >= 0) {
                if ((Integer)compAct.get(i) == compID) {
                    compAct.remove(i);
                    break;
                }
                --i;
            }
        }
        return compID;
    }

    public static synchronized void activate(JTextComponent c) {
        Document doc;
        boolean activated = false;
        int compID = Registry.getIDImpl(c);
        if (compID == -1) {
            return;
        }
        int actSize = compAct.size();
        int ind = 0;
        while (ind < actSize) {
            int id = (Integer)compAct.get(ind);
            if (id == compID) {
                if (ind == 0) break;
                compAct.add(0, compAct.remove(ind));
                activated = true;
                break;
            }
            ++ind;
        }
        if (ind == actSize) {
            compAct.add(0, new Integer(compID));
            activated = true;
        }
        if ((doc = c.getDocument()) instanceof BaseDocument && Registry.doActivate((BaseDocument)doc)) {
            activated = true;
        }
        if (activated) {
            Registry.fireChange();
        }
    }

    public static synchronized void activate(BaseDocument doc) {
        if (Registry.doActivate(doc)) {
            Registry.fireChange();
        }
    }

    public static synchronized BaseDocument getMostActiveDocument() {
        return Registry.getValidDoc(0, true);
    }

    public static synchronized BaseDocument getLeastActiveDocument() {
        int lastInd = docAct.size() - 1;
        return Registry.getValidDoc(lastInd, false);
    }

    public static BaseDocument getLessActiveDocument(BaseDocument doc) {
        return Registry.getLessActiveDocument(Registry.getID(doc));
    }

    public static synchronized BaseDocument getLessActiveDocument(int docID) {
        return Registry.getNextActiveDoc(docID, true);
    }

    public static BaseDocument getMoreActiveDocument(BaseDocument doc) {
        return Registry.getMoreActiveDocument(Registry.getID(doc));
    }

    public static synchronized BaseDocument getMoreActiveDocument(int docID) {
        return Registry.getNextActiveDoc(docID, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        Registry.consolidate();
        ArrayList docList = new ArrayList();
        int actSize = docAct.size();
        int i = 0;
        while (i < actSize) {
            Object doc;
            int ind = (Integer)docAct.get(i);
            WeakReference wr = docRefs[ind];
            if (wr != null && (doc = wr.get()) != null) {
                docList.add(doc);
            }
            ++i;
        }
        return ((AbstractList)docList).iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return Registry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int lastInd = compAct.size() - 1;
        return Registry.getValidComp(lastInd, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent c) {
        return Registry.getLessActiveComponent(Registry.getID(c));
    }

    public static synchronized JTextComponent getLessActiveComponent(int compID) {
        return Registry.getNextActiveComp(compID, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent c) {
        return Registry.getMoreActiveComponent(Registry.getID(c));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int compID) {
        return Registry.getNextActiveComp(compID, false);
    }

    public static synchronized Iterator getComponentIterator() {
        Registry.consolidate();
        ArrayList compList = new ArrayList();
        int actSize = compAct.size();
        int i = 0;
        while (i < actSize) {
            Object comp;
            int ind = (Integer)compAct.get(i);
            WeakReference wr = compRefs[ind];
            if (wr != null && (comp = wr.get()) != null) {
                compList.add(comp);
            }
            ++i;
        }
        return ((AbstractList)compList).iterator();
    }

    private static WeakReference[] realloc(WeakReference[] refs) {
        WeakReference[] tmp = new WeakReference[refs.length * 2 + 4];
        System.arraycopy(refs, 0, tmp, 0, refs.length);
        return tmp;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            consolidateCounter = 0;
            int i = docAct.size() - 1;
            while (i >= 0) {
                int ind = (Integer)docAct.get(i);
                WeakReference wr = docRefs[ind];
                if (wr != null && wr.get() == null) {
                    docAct.remove(i);
                    Registry.docRefs[ind] = null;
                }
                --i;
            }
            int i2 = compAct.size() - 1;
            while (i2 >= 0) {
                int ind = (Integer)compAct.get(i2);
                WeakReference wr = compRefs[ind];
                if (wr != null && wr.get() == null) {
                    compAct.remove(i2);
                    Registry.compRefs[ind] = null;
                }
                --i2;
            }
        }
    }

    private static int getIDImpl(JTextComponent c) {
        if (c == null) {
            return -1;
        }
        return ((BaseTextUI)c.getUI()).componentID;
    }

    private static Integer getIDInteger(BaseDocument doc) {
        if (doc == null) {
            return null;
        }
        return (Integer)doc.getProperty("id");
    }

    private static boolean doActivate(BaseDocument doc) {
        Integer docIDInteger = Registry.getIDInteger(doc);
        if (docIDInteger == null) {
            return false;
        }
        int docID = docIDInteger != null ? docIDInteger : -1;
        int size = docAct.size();
        int ind = 0;
        while (ind < size) {
            int id = (Integer)docAct.get(ind);
            if (id == docID) {
                if (ind == 0) {
                    return false;
                }
                docAct.add(0, docAct.remove(ind));
                return true;
            }
            ++ind;
        }
        docAct.add(0, docIDInteger);
        return true;
    }

    private static BaseDocument getValidDoc(int ind, boolean forward) {
        Registry.consolidate();
        int actSize = docAct.size();
        while (ind >= 0 && ind < actSize) {
            BaseDocument doc;
            int docID = (Integer)docAct.get(ind);
            WeakReference wr = docRefs[docID];
            BaseDocument baseDocument = doc = wr != null ? (BaseDocument)wr.get() : null;
            if (doc != null) {
                return doc;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static BaseDocument getNextActiveDoc(int docID, boolean forward) {
        Registry.consolidate();
        int actSize = docAct.size();
        int ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if ((Integer)docAct.get(ind) == docID) {
                return Registry.getValidDoc(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int ind, boolean forward) {
        Registry.consolidate();
        int actSize = compAct.size();
        while (ind >= 0 && ind < actSize) {
            JTextComponent c;
            int compID = (Integer)compAct.get(ind);
            WeakReference wr = compRefs[compID];
            JTextComponent jTextComponent = c = wr != null ? (JTextComponent)wr.get() : null;
            if (c != null) {
                return c;
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int compID, boolean forward) {
        int actSize = compAct.size();
        int ind = forward ? 0 : actSize - 1;
        while (ind >= 0 && ind < actSize) {
            if ((Integer)compAct.get(ind) == compID) {
                return Registry.getValidComp(ind += forward ? 1 : -1, forward);
            }
            ind += forward ? 1 : -1;
        }
        return null;
    }

    private static void fireChange() {
        ChangeListener[] listeners = (ChangeListener[])listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Registry.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        ChangeEvent evt = new ChangeEvent(class$org$netbeans$editor$Registry == null ? (class$org$netbeans$editor$Registry = Registry.class$("org.netbeans.editor.Registry")) : class$org$netbeans$editor$Registry);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(evt);
            ++i;
        }
    }

    public static synchronized String registryToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Document References:\n");
        int i = 0;
        while (i < docRefsCount) {
            WeakReference wr = docRefs[i];
            sb.append("docRefs[" + i + "]=" + (wr != null ? wr.get() : "null") + "\n");
            ++i;
        }
        sb.append("Component References:\n");
        int i2 = 0;
        while (i2 < compRefsCount) {
            WeakReference wr = compRefs[i2];
            sb.append("compRefs[" + i2 + "]=" + (wr != null ? wr.get() : "null") + "\n");
            ++i2;
        }
        sb.append("\nActive Document Indexes:\n");
        int i3 = 0;
        while (i3 < docAct.size()) {
            sb.append(docAct.get(i3));
            if (i3 != docAct.size() - 1) {
                sb.append(", ");
            }
            ++i3;
        }
        sb.append("\nActive Component Indexes:\n");
        int i4 = 0;
        while (i4 < compAct.size()) {
            sb.append(compAct.get(i4));
            if (i4 != compAct.size() - 1) {
                sb.append(", ");
            }
            ++i4;
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        listenerList = new WeakEventListenerList();
    }
}

