/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;

public interface TokenItem {
    public TokenID getTokenID();

    public TokenContextPath getTokenContextPath();

    public int getOffset();

    public String getImage();

    public TokenItem getNext();

    public TokenItem getPrevious();

    public static class FilterItem
    implements TokenItem {
        protected TokenItem delegate;

        public FilterItem(TokenItem delegate) {
            this.delegate = delegate;
        }

        public TokenID getTokenID() {
            return this.delegate.getTokenID();
        }

        public TokenContextPath getTokenContextPath() {
            return this.delegate.getTokenContextPath();
        }

        public int getOffset() {
            return this.delegate.getOffset();
        }

        public String getImage() {
            return this.delegate.getImage();
        }

        public TokenItem getNext() {
            return this.delegate.getNext();
        }

        public TokenItem getPrevious() {
            return this.delegate.getPrevious();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static abstract class AbstractItem
    implements TokenItem {
        private TokenID tokenID;
        private TokenContextPath tokenContextPath;
        private String image;
        private int offset;

        public AbstractItem(TokenID tokenID, TokenContextPath tokenContextPath, int offset, String image) {
            this.tokenID = tokenID;
            this.tokenContextPath = tokenContextPath;
            this.offset = offset;
            this.image = image;
        }

        public TokenID getTokenID() {
            return this.tokenID;
        }

        public TokenContextPath getTokenContextPath() {
            return this.tokenContextPath;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getImage() {
            return this.image;
        }

        public String toString() {
            return "'" + EditorDebug.debugString(this.getImage()) + "', tokenID=" + this.getTokenID() + ", tcp=" + this.getTokenContextPath() + ", offset=" + this.getOffset();
        }

        public abstract TokenItem getPrevious();

        public abstract TokenItem getNext();
    }
}

